/*
** Copyright (C) by Intratek Computing, 1994-1995. All rights reserved.
*/

/*
** FILE: fsar.c
** PURPOSE: File(based) Search And Replace
**
** Performs a global search-and-replace on a specified file. Outputs results
** to file fsar.out; does not alter original file.
**
** ERROR CODE: 0, no change to file; 1, changes occured; 2, error
*/

#include <stdio.h>
#include <stdlib.h>
#include "sml.h"
#include "smltools.h"

#define  LINE_SIZE 256

int main(int argc, char *argv[])
{
        char str[LINE_SIZE + 1];  /* current line being read from in  */
        FILE *in;                 /* file being read (argv[1])        */
        FILE *out;                /* file stream for fsar.out         */
        long cnt;                 /* line count for debug output      */
        int  c;                   /* character read from file         */
        int  i;                   /* current character in array       */
        char flag;                /* was file changed?                */

        sml_init();

        /*
        ** You  will  notice  that  fsar  does  not  contain  extensive error
        ** checking;  it's a small/fast tool.. nothing else.
        */

        if ( argc != 5 )
        {
                puts("USAGE: fsar search-string replace-string sensitivity");
                puts("");
                puts("Sensitivity: s = case-sen; i = case-isen");
                printf("Note: %d character-per-line limit\n", LINE_SIZE - 1);
                puts("");
                puts("Output file: fsar.out");
                puts("");

                exit(2);
        }
        else
        {
                puts("Performing search and replace,");
                puts("");
                printf("FILE          : %s\n", argv[1]);
                printf("SEARCH  STRING: %s\n", argv[2]);
                printf("REPLACE STRING: %s\n", argv[3]);
                printf("SEARCH TYPE   : %s\n", (*argv[4] != 'i'? "sensitive" :
                                                           "insensitive"));
                puts("");
                puts("Please wait...");
                puts("");
        }

        if ( (in = fopen(argv[1], "r")) == NULL )
        {
                perror("");
                exit(2);
        }
        if ( (out = fopen("fsar.out", "w")) == NULL )
        {
                fclose(in);

                perror("");
                exit(2);
        }

        i = 0;     /* preset array counter to beginning of array */
        cnt = 1;   /* preset line counter to line 1              */
        flag = 0;  /* preset flag to no changes made             */

        while ( 1 )
        {
                c = getc(in);

                /*
                ** If EOLN or EOF, perform search-and-replace, write out
                ** to file, then either continue on next line, or exit.
                */

                if ( c == EOF || c == '\n' )
                {
                        str[i] = '\0';       /* somewhat mandatory */

                        /*
                        ** SML in action, which is called by SMLTools.
                        */

                        if ( *argv[4] == 'i' )
                        {
                                if ( sar(str, argv[2], argv[3], SML_ISEN) != NULL )
                                        flag = 1;
                        }
                        else
                        {
                                if ( sar(str, argv[2], argv[3], SML_SEN) != NULL )
                                        flag = 1;
                        }

                        fputs(str, out);

                        if ( c != EOF )
                        {
                                fputc('\n', out);

                                i = 0;
                                cnt++;
                        }

                }
                else
                {
                        if ( i == LINE_SIZE - 1 )
                        {
                                puts("Character limit reached..");
                                puts("");
                                printf("LINE: %ld\n", cnt + 1);
                                puts("");

                                exit(2);
                        }
                        else
                                str[i++] = (char) c;
                }

                if ( c == EOF )
                        break;
        }

        fclose(in);
        fclose(out);

        if ( flag )
                return (1);     /* fsar.out is different from argv[1] */
        else
                return (0);     /* no changes were produced           */
}
