#define LINT_ARGS
 
/*This is the source code to SimADD.  SimADD is a utility to add funding*/
/*to your SimCity cities!  If you want you can use this code to build   */
/*a utility of your own, I really don't mind.  But if you use the source*/
/*and charge for your product, please register SimADD!  Thanks again for*/
/*using this software.  Copyright 1995 Ecco Entertainmnet/Martin R. Bowling*/
/*And one last note please give us credit if you use the sources!       */                                             



#define LEVEL          1.00
#define CHAR_PERIOD    '.'
#define STR_PERIOD     "."
#define I_O_EXTENSION   "CTY"
#define BAK_EXTENSION   "BAK"
#define PGM_NAME       "SimADD"
#define ASKED_FOR_HELP '?'
#define DEF_DOLLARS    50000L
#define MAX_DOLLARS  5000000L
#define RW             "rb+"      /* Open all files in BINARY!!          */
#define WRITE          "wb"       /* Else 0x00 character cause problems! */

#include <math.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <sys\stat.h>

typedef struct {        /* City File Structure! */
        char Unused1[2];
        char CityName[28];
        char Unused2[3078];
        long Treasury;
        char Unused3[28918];
} CITY ;

void help(void) {
     system("cls");
     printf("\n");
     printf("Hi! Welcome to %s, level %5.2f\n",PGM_NAME, LEVEL);
     printf("Where SimCity mayors can get the extra money they need for all those expensive\n");
     printf("SimCity development projects.\n\n");
     printf("SimADD was written by:  Martin R. Bowling\n");
     printf("Look for additions to SimADD soon\n");
     printf("\n");
     printf("To Invoke :\n");
     printf("    %s <Name-Of-City> <$$$>\n",PGM_NAME);
     printf("Where\n\n");
     printf("<Name-Of-City>  = the NAME of the city save file you wish to change.\n");
     printf("                  (without the *.CTY extension!)\n\n");
     printf("$$$             = the amount of money you want to ADD to your treasury.\n");
     printf("                  This amount must be an integer.\n");
     printf("                  The *default* value is $ %8ld!\n",DEF_DOLLARS);
     printf("                  The *MAX*     value is $ %8ld!\n",MAX_DOLLARS);
     printf("If you type\n");
     printf("       '%s BOSTON 25000'\n",PGM_NAME);
     printf("your BOSTON city file will have $25,000 added to it's treasury.\n\n");
     printf("No arguments or a question mark ('?') gets you this help text.\n\n");
     printf("Hit any key to continue...");
     getch();
     return;
  }

CITY City ;

main(argc, argv)
   int argc;
   char *argv[];
{
    FILE *IOFile, *BakFile ;
    char FileIn[80], FileOut[80], FileBak[80], temp[80];
    char *p, *x, t ;
    long Amount ;
    struct stat Stats ;
    size_t AmountToRead, AmountRead, AmountWritten ;

   /* If NO args, or first character of first arg = '?', then show help! */
   if ( (1==argc) || (ASKED_FOR_HELP == argv[1][0]) ) {
       help();
       exit(0);
   }

   system("cls");

   /* If 1 arg, that should be the NAME of the city to use !               */
   /* User MAY have placed in a PATH, keep it ...                          */
   /* Or put in an extension (".CTY")  --- which should be supplied        */
   /* if the user does NOT supply it !                                     */

   strcpy(temp,argv[1]);    /* Get 1st argument!                           */
   strupr(temp);            /* Switch to upper case                        */

   /* Find 1st '.' in string, if any */
   p = strrchr(temp,CHAR_PERIOD);
   if (NULL != p) {
       /* If there IS a file extension being used, remove it               */
       *p = (char) NULL ;  /* Place a NULL terminator AT the PERIOD       */
   }
   /* Now add in the extensions to the names used for the file I/O         */
   /* Result : ANY filename passing thru this code gets its file           */
   /*          extension changed to CTY (or BAK)                           */

   strcpy(FileIn, temp);   strcat(FileIn , STR_PERIOD); strcat(FileIn , I_O_EXTENSION);
   strcpy(FileOut, temp);  strcat(FileOut, STR_PERIOD); strcat(FileOut, I_O_EXTENSION);
   strcpy(FileBak, temp);  strcat(FileBak, STR_PERIOD); strcat(FileBak, BAK_EXTENSION);

   /* Now check 2nd argument, if any : the amount to add!                  */

   if (argc >= 3) { /* Grab 2nd argument as amount to add */
       Amount  = (long) atol(argv[2]) ;
       Amount  = (Amount < 0) ? -Amount : Amount ;
   } else {
       /* No second argument, use DEF_DOLLARS */
       Amount = DEF_DOLLARS ;
   }
   /* Set of MAX dollars if TOO big! */
   Amount = (Amount > MAX_DOLLARS) ? MAX_DOLLARS : Amount ;

   /* Open all files for I/O */
   IOFile  = fopen(FileIn ,RW   );
   BakFile = fopen(FileBak,WRITE);

   /* One or more of the files couldn't be opened for I/O */
   if ( (NULL == IOFile) ) {
       printf("\n");
       printf("Sorry! Could not open city file %s for I/O, program ends!\n",FileIn);
       printf("Are you sure it's spelled right ?\n");
       printf("Did you forget to specify the drive and/or path ?\n");
       exit(1);
   }
   if ( NULL == BakFile ) {
       printf("\n");
       printf("Sorry! Could not open city BACKUP file %s for Output, program ends!\n",FileBak);
       exit(2);
   }

   /* 0 specified as the amount to add; why bother ? */
   if (0L == Amount) {
       printf("\n");
       printf("Amount to add is 0 !\n");
       printf("You supplied a TRUE 0 (or bad data) in the 2nd argument!\n");
       printf("There's no point in continuing and adding 0 to the treasury!\n");
       exit(3);
  }

  /* OK, now set Old & New Citys to 0 */
  memset(&City,0,sizeof(CITY));

  /* Ok, now READ old city into City :  */
  /* But, first, get stats on the file */
  if (fstat(fileno(IOFile), &Stats)) {
       /* Some delightful error concerning STATS ! Abort ! */
       perror("Sorry! Fatal Error gaining info on Input City File ! Program Aborts!\n");
       exit(4);
  }
  AmountToRead = Stats.st_size ;

  /* Set File Pointer to BEGINNING of file ! */
  fseek(IOFile, 0L, SEEK_SET);

  printf("Reading %u bytes from file %s...",AmountToRead,FileIn);
  AmountRead = read(fileno(IOFile), &City, AmountToRead);
  if ( (0 > AmountRead) || (AmountRead != AmountToRead) ) {
     /* Couldn't Read the Input File, for some reason ! */
     printf("\n of bytes read = %u\n",AmountRead);
     perror("Sorry! Fatal Error Reading Input City File ! Program Aborts!\n");
     exit(5);
  }
  printf("Done!\n");

  /* Ok, Now Write BACKUP File! */
  printf("Writing %u bytes to   file %s...",AmountToRead,FileBak);
  AmountWritten = write(fileno(BakFile), &City, AmountToRead);
  if ( (0 > AmountWritten) || (AmountWritten != AmountToRead) ) {
     /* Couldn't Write the Backup File, for some reason ! */
     printf("\n# of bytes Written = %u\n",AmountWritten);
     perror("Sorry! Fatal Error Writing Backup City File ! Program Aborts!\n");
     exit(6);
  }
  printf("Done!\n");

  /* Ok, now print out city name and Treasury Amount */
  printf("City Name, from file %s, is %s !\n",FileIn,City.CityName);
  x = (char *) &City.Treasury;

  /* As it turns out, the TREASURY amount is *almost* a long : but with */
  /* all the bytes in the proper (human-type) order : NOT the required  */
  /* INTEL format that's needed for the program to READ it!             */
  /* All 4 bytes MUST be reversed !                                     */
  t = x[3] ;  x[3] = x[0];  x[0] = t ;
  t = x[2] ;  x[2] = x[1];  x[1] = t ;

  printf("Treasury is     $ %ld\n",City.Treasury);
  City.Treasury += Amount ;

  printf("$ %ld added to Treasury!\n",Amount);
  printf("Treasury is now $ %ld\n",City.Treasury);

  /* All 4 bytes MUST be reversed (again!)                              */
  t = x[3] ;  x[3] = x[0];  x[0] = t ;
  t = x[2] ;  x[2] = x[1];  x[1] = t ;

  fseek(IOFile, 0L, SEEK_SET); /* Go to beginning of file !             */
  printf("Writing %u bytes to file %s...",AmountToRead,FileIn);
  AmountWritten = write(fileno(IOFile), &City, AmountToRead);
  if ( (0 > AmountWritten) || (AmountWritten != AmountWritten) ) {
     /* Couldn't Write the new File, for some reason ! */
     printf("\n# of bytes Written = %u\n",AmountWritten);
     perror("Sorry! Fatal Error Writing NEW City File ! Program Aborts!\n");
     exit(7);
  }
  printf("Done !\n");
  fcloseall();
  return(0);
}
