#include <process.h>

#include "bt.h"
#include "btrieve.hpp"
#include "btop.h"


BOOL checkfiltervalue(char op[3],short val);


BOOL checkfilter(char *key,char op[3],char *value)
   {
   short result;
   result = (short)strcmp(key,value);
   return checkfiltervalue(op,result);
   }


BOOL checkfilter(short *key,char op[3],short value )
   {
   return checkfiltervalue(op,*key-value);
   }

BOOL checkfilter(double *key,char op[3],double value)
   {
   short result;
   if (*key-value==0)
      result = 0;

   if (*key-value >0)
      result = 1;

   if (*key-value <0)
      result = -1;

   return checkfiltervalue(op,result);
   }

BOOL checkfilter(long *key,char op[3],long value)
   {
   short result;
   if (*key-value ==0)
      result = 0;

   if (*key-value >0)
      result = 1;

   if (*key-value <0)
      result = -1;


   return checkfiltervalue(op,result);
   }




BOOL checkfiltervalue(char op[3],short result)
   {
   switch(op[0])
      {
      case '=':if (result == 0)
            return TRUE;
          return FALSE;

      case '>':if (op[1]=='=')
            if (result >=0)
               return TRUE;
         if (result >0)
            return TRUE;
          return FALSE;

      case '<':if (op[1]=='=')
            if (result <=0)
               return TRUE;
            if (result <0)
               return TRUE;
             return FALSE;

      default :return FALSE;
      }
   }






// ************** Filter String ***********************************
BOOL Databasefile::GetFirstFilter(char op[3],char *value)
   {
   return this->Find(op,value);
   }


BOOL Databasefile::GetNextFilter(char op[3],char *value)
   {
   if (op[0]=='<')
       this->GetPrevious();
   else
       this->GetNext();

   if (this->btstr.result ==0)
      return checkfilter((char *)btstr.Keybuffer,op,value);
   return FALSE;
   }


BOOL Databasefile::GetPreviousFilter(char op[3],char *value)
   {
   if (op[0]=='>')
       this->GetPrevious();
   else
       this->GetNext();

   if (this->btstr.result ==0)
      if (checkfilter((char *)btstr.Keybuffer,op,value)== FALSE)
         return GetFirstFilter(op,value);
   return FALSE;
   }




// ************** Filter LONG ***********************************
BOOL Databasefile::GetFirstFilter(char op[3],long value)
   {
   return this->Find(op,value);
   }


BOOL Databasefile::GetNextFilter(char op[3],long value)
   {
   if (op[0]=='<')
       this->GetPrevious();
   else
       this->GetNext();

   if (this->btstr.result ==0)
      return checkfilter((long *)btstr.Keybuffer,op,value);
   return FALSE;
   }


BOOL Databasefile::GetPreviousFilter(char op[3],long value)
   {
   if (op[0]=='>')
       this->GetPrevious();
   else
       this->GetNext();

   if (this->btstr.result ==0)
      if (checkfilter((long *)btstr.Keybuffer,op,value)== FALSE)
         return GetFirstFilter(op,value);
   return FALSE;
   }




// ************** Filter short ***********************************
BOOL Databasefile::GetFirstFilter(char op[3],short value)
   {
   return this->Find(op,value);
   }


BOOL Databasefile::GetNextFilter(char op[3],short value)
   {
   if (op[0]=='<')
       this->GetPrevious();
   else
       this->GetNext();

   if (this->btstr.result ==0)
      return checkfilter((short *)btstr.Keybuffer,op,value);
   return FALSE;
   }


BOOL Databasefile::GetPreviousFilter(char op[3],short value)
   {
   if (op[0]=='>')
       this->GetPrevious();
   else
       this->GetNext();

   if (this->btstr.result ==0)
      if (checkfilter((short *)btstr.Keybuffer,op,value)== FALSE)
         return GetFirstFilter(op,value);
   return FALSE;
   }



// ************** Filter double ***********************************
BOOL Databasefile::GetFirstFilter(char op[3],double value)
   {
   return this->Find(op,value);
   }


BOOL Databasefile::GetNextFilter(char op[3],double value)
   {
   if (op[0]=='<')
       this->GetPrevious();
   else
       this->GetNext();

   if (this->btstr.result ==0)
      return checkfilter((double *)btstr.Keybuffer,op,value);
   return FALSE;
   }


BOOL Databasefile::GetPreviousFilter(char op[3],double value)
   {
   if (op[0]=='>')
       this->GetPrevious();
   else
       this->GetNext();

   if (this->btstr.result ==0)
      if (checkfilter((double *)btstr.Keybuffer,op,value)== FALSE)
         return GetFirstFilter(op,value);
   return FALSE;
   }


