                     MEMBER('DEMO.clw')           ! This is a MEMBER module


BrowseBeginning      PROCEDURE

!--------------------------------------------------------------------------------------------------!
! Declarations                                                                                     !
!--------------------------------------------------------------------------------------------------!
LocalRequest         LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG
Search               STRING(40)
TypeDsp              STRING(7)
WinWidth             LONG                                  ! Save Window Width for Resizing
WinHeight            LONG                                  ! Save Window Height for Resizing

hBrowse              BYTE                                  !Handle to Identify the Browse List
BrowseQueue          QUEUE,PRE(BQ)                         !Queue Used by List when Browsing Records
Name                   LIKE(RCP:Name)                      !  Queue Display field
Code                   LIKE(RCP:Code)                      !  Queue Display field
TypeDsp                LIKE(TypeDsp)                       !  Queue Display field
Position               STRING(255)                         !  Queue POSITION information
                     END                                   !End Queue Declaration

Screen               WINDOW('Beginning Browse Exercise'),AT(,,195,163),CENTER,HLP('~BeginningExample'),STATUS,SYSTEM,GRAY,MAX,RESIZE,MDI
                       LIST,AT(4,18,186,89),MSG('Browsing Records'),ALRT(CtrlEnter),ALRT(InsertKey),ALRT(DeleteKey),USE(?List),IMM,HVSCROLL,VCR,FORMAT('80L(1)|_~Name~@S20@24L(1)|_~Code~@S5@28L(1)|_~Type~@s7@'),FROM(BrowseQueue)
                       PROMPT('Search:'),AT(5,4,25,10),USE(?Search:Prompt)
                       ENTRY(@S40),AT(32,4,80,10),MSG('Enter Search Criteria'),USE(Search)
                       BUTTON('Close'),AT(151,4,40,10),USE(?Close)
                       BUTTON('Select'),AT(151,110,40,10),USE(?Select)
                       PROMPT('&Recipe#:'),AT(8,133,,),USE(?RCP:RecipeNo:Prompt)
                       ENTRY(@N_5),AT(42,132,,),USE(RCP:RecipeNo),READONLY
                       PROMPT('&Name:'),AT(15,148,,),USE(?RCP:Name:Prompt)
                       ENTRY(@S20),AT(42,147,,),USE(RCP:Name),READONLY
                       BUTTON('Insert'),AT(4,110,40,10),USE(?Insert)
                       BUTTON('Change'),AT(53,110,40,10),USE(?Change)
                       BUTTON('Delete'),AT(101,110,40,10),USE(?Delete)
                     END

!--------------------------------------------------------------------------------------------------!
! Code Section                                                                                     !
!--------------------------------------------------------------------------------------------------!
  CODE

  LocalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)

  IF LocalRequest <> SelectRecord THEN TypeFilter = '123'.
  IF RECIPE::Used = 0
    CheckOpen(RECIPE,1)
  END
  RECIPE::Used += 1

  OPEN(Screen)                                             !Open the Window
  Screen{PROP:Imm} = 0                                     !Disable Posting of Initial Resize Event
  WinWidth = Screen{PROP:Width}                            !Save Current Window Width
  WinHeight = Screen{PROP:Height}                          !Save Current Window Height
  INIRestoreWindow('BrowseBeginning','PTDEMO.INI')         !Restore Window Position and Size
  TC_ResizeWin(?List,WinWidth,WinHeight)                   !Reset Window Size
  WinWidth = Screen{PROP:Width}                            !Save Current Window Width
  WinHeight = Screen{PROP:Height}                          !Save Current Window Height
  Screen{PROP:Imm} = 1                                     !Allow Resize Events to be Posted

  IF LocalRequest = SelectRecord                           !If Calling Procedure as a Lookup
    ENABLE(?Select)                                        !  Enable the Select Button
  ELSE                                                     !Otherwise
    DISABLE(?Select)                                       !  Disable the Select Button
  END                                                      !End If

  ACCEPT                                                   !Begin Processing Event Loop
                                                           !
    CASE EVENT()                                           !Process Events for the Window
    OF EVENT:OpenWindow
      WindowOpened = True
      DO BrowseList                                        !Fill Browse Area
      SELECT(FIRSTFIELD())
    OF EVENT:GainFocus
      DO BrowseList                                        !Fill Browse Area
    OF EVENT:Sized
      TC_ResizeWin(?List,WinWidth,WinHeight)               !Reset Window Size
      WinWidth = Screen{PROP:Width}                        !Save Current Window Width
      WinHeight = Screen{PROP:Height}                      !Save Current Window Height
      TC:BRW:Rows[hBrowse] = ?List{PROP:Items}             !Reset Number of Rows in List Box
      TC:BRW:Action[hBrowse] = 0                           !Tell Browse to start redisplay with a search by key
      IF TC:BRW:CurItem[hBrowse] > TC:BRW:Rows[hBrowse]    !If the Current Line Item Not Visible
        GET(BrowseQueue,TC:BRW:CurItem[hBrowse])           !  Reread Current Record Position
        REGET(RECIPE,BQ:Position)                          !  Load the Record
        TC:BRW:SetToKey[hBrowse] = 1                       !  Set Redisplay to start with current record
        FREE(BrowseQueue)                                  !  Clear the List Box Before Redisplay
        DISPLAY(?List)                                     !  Force List Box to Redisplay
      ELSE                                                 !Otherwise
        TC:BRW:SetToItem[hBrowse] = 1                      !  Set Redisplay to start with selected item
      END                                                  !End If
      DO BrowseList                                        !Fill Browse Area
    END                                                    !End Events for Window

    CASE FIELD()                                           !Process Events for Controls
    OF ?List                              
      IF EVENT() = EVENT:AlertKey                          !If Alert Key Pressed
        CASE KEYCODE()                                     !  Process Alert Keys
        ELSE                                               !  On Other Keys Process Skip Search
          IF (INRANGE(KEYCODE(),Key0,ZKey) OR |            !    If Key is a lower case 0-Z Key
             INRANGE(KEYCODE(),Shift0,ShiftZ))             !    or it's a upper case 0-Z Key
            RCP:Name = CHR(KEYCODE())                      !      Move character into locator
            TC:BRW:Action[hBrowse] = 0                     !      Tell Browse to Redisplay
            TC:BRW:SetToKey[hBrowse] = 1                   !      Redisplay after searching by key
          END                                              !    End If
        END                                                !  End Case
      END                                                  !End If
      DO BrowseList                                        !Fill Browse Area
    OF ?Search                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        RCP:Name = Search                                  !Fill Search key
        Search = ''                                        !Clear Search Input Field
        DISPLAY(?Search)                                   !
        TC:BRW:Action[hBrowse]   = 0                       !Tell Browse to Redisplay
        TC:BRW:SetToKey[hBrowse] = 1                       !Redisplay after searching by key
        SELECT(?List)                                      !Reselect Main List Box
      END                                    
    OF ?Close                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END                                    
    OF ?Select                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        GET(BrowseQueue,TC:BRW:CurItem[hBrowse])           !  Reread Current Record Position
        REGET(RECIPE,BQ:Position)                          !  Load the Record
        LocalResponse = RequestCompleted                   !  Lookup was completed
        POST(Event:CloseWindow)                            !  Return Selected Record to Caller
      END                                    
    OF ?Insert                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        POST(TCEVENT:InsertRecord,?List)                   !Send Insert Message to List Box
      END                                    
    OF ?Change                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        POST(TCEVENT:ChangeRecord,?List)                   !Send Change Message to List Box
      END                                    
    OF ?Delete                              
      CASE EVENT()                           
      OF EVENT:Accepted                 
        POST(TCEVENT:DeleteRecord,?List)                   !Send Delete Message to List Box
      END                                    
    END                                                    !End Events for Controls
  END                                                      !End Event Loop
                                                           !
  DO WrapUp                                                !Cleanup and Exit the Procedure



!--------------------------------------------------------------------------------------------------!
! BrowseList Routine                                                                               !
!                                                                                                  !
! This routine calls the browser to do a page-loaded display from a file.                          !
!--------------------------------------------------------------------------------------------------!
BrowseList           ROUTINE

  IF NOT WindowOpened THEN EXIT.                           !If Window Not Open Exit Browse.
                                                           !
  IF NOT hBrowse                                           !If Browse Not Initialized
    hBrowse = TC_InitBrowse(?List,THREAD())                !  Initialize Browse Processing for List Box
    IF LocalRequest = SelectRecord                         !  If Browse Procedure Called as a Lookup
      TC:BRW:SelectRecord[hBrowse] = True                  !    Set Double Click to Select Record
    END                                                    !  End If
  END                                                      !End If
                                                           !
  LOOP                                                     !Process File Browse Loop
    TC_Browse(hBrowse              ,|                      !  Browse Handle
              RECIPE               ,|                      !  File Name
              RCP:RECORD           ,|                      !  Record Area
              RCP:Key_Name         ,|                      !  Key Order for Display
              BrowseQueue          ,|                      !  Queue Name for List
              BQ:Position          )                       !  Record Position in Key Order

    CASE TC:BRW:Action[hBrowse]                            !Process Browse Actions
    OF TCACTION:FillQueue                                  !Fill List Queue Action
      IF NOT(INSTRING(RCP:Type,TypeFilter,1))              !If Filter Condition Not Met
        TC:BRW:SkipRecord[hBrowse] = 1                     !  Tell Browse to Skip Record
        CYCLE                                              !  No need to fill the Queue
      END                                                  !End If
      CASE RCP:Type
      OF 1
        TypeDsp = 'Main'
      OF 2
        TypeDsp = 'Side'
      OF 3
        TypeDsp = 'Dessert'
      END
      BQ:Name = RCP:Name                                   !  Move Data to Queue
      BQ:Code = RCP:Code                                   !  Move Data to Queue
      BQ:TypeDsp = TypeDsp                                 !  Move Data to Queue
                                                           !
    OF TCACTION:InsertRecord                               !Insert Record Action
      GET(RECIPE,0)                                        !  Clear Pending Record
      CLEAR(RCP:RECORD)                                    !  Clear Record Area
      GlobalRequest = InsertRecord                         !  Tell Form To Insert Record
      UpdateRecipe                                         !  Insert Record
      IF GlobalResponse = RequestCompleted                 !  If Record Added
        TC:BRW:Action[hBrowse] = 0                         !    Tell Browse to Redisplay
        TC:BRW:SetToPosition[hBrowse] = 1                  !    Record at the Current Positon
      END                                                  !  End If
                                                           !
    OF TCACTION:ChangeRecord                               !Change Record Action
      GlobalRequest = ChangeRecord                         !  Tell Form To Change Record
      UpdateRecipe                                         !  Change Record
      IF GlobalResponse = RequestCompleted                 !  If Record Added
        TC:BRW:Action[hBrowse] = 0                         !    Tell Browse to Redisplay
        TC:BRW:SetToPosition[hBrowse] = 1                  !    Record at the Current Positon
      END                                                  !  End If
                                                           !
    OF TCACTION:DeleteRecord                               !Delete Record Action
      TC:BRW:AbortDel[hBrowse] = 1                         !  Tell Browse Not To Handle Delete
      GlobalRequest = DeleteRecord                         !  Tell Form To Delete Record
      UpdateRecipe                                         !  Delete Record
      IF GlobalResponse = RequestCompleted                 !  If Record Deleted
        TC:BRW:Action[hBrowse] = 0                         !    Tell Browse to Redisplay
        TC:BRW:SetToItem[hBrowse] = 1                      !    Record at the Current Item
      END                                                  !  End If
                                                           !
    OF TCACTION:SelectRecord                               !Select Record Action
      LocalResponse = RequestCompleted                     !  Lookup was completed
      POST(Event:CloseWindow)                              !  Return Selected Record to Caller
                                                           !
    OF TCACTION:ExitBrowse                                 !Exit Browse Action
      BREAK                                                !  
    END                                                    !End Process Browse Actions
  END                                                      !End Process File Browse Loop
                                                           !
  IF RECORDS(BrowseQueue)                                  !If Records Available for Display
    GET(BrowseQueue,TC:BRW:CurItem[hBrowse])               !  Load Positon of Record From Queue
    REGET(RCP:Key_Name,BQ:Position)                        !  Reread Record for HOT Display
  END                                                      !End If
  DISPLAY()                                                !Display All Fields



!--------------------------------------------------------------------------------------------------!
! WrapUp Routine                                                                                   !
!                                                                                                  !
! End of procedure cleanup and exit.                                                               !
!--------------------------------------------------------------------------------------------------!
WrapUp             ROUTINE

  RECIPE::Used -= 1
  IF RECIPE::Used = 0 THEN CLOSE(RECIPE).

  IF WindowOpened
    INISaveWindow('BrowseBeginning','PTDEMO.INI')
    CLOSE(Screen)
  END

  TC_EndBrowse(hBrowse)                                    !Terminate Browse
  FREE(BrowseQueue)                                        !Release Memory use by Browse Queue

  GlobalResponse = LocalResponse
  RETURN




