/*---------------------------------------
   EMF15.C -- Enhanced Metafile Demo #15
              (c) Charles Petzold, 1994
  ---------------------------------------*/

#include <windows.h>
#include <math.h>

#define TWO_PI (2 * 3.14159)

char szClass [] = "EMF15" ;
char szTitle [] = "EMF15: Enhanced Metafile Demo #15" ;

void CreateRoutine (HWND hwnd)
     {
     }

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     ENHMETAHEADER emh ;
     HENHMETAFILE  hemf ;
     int           cxImage, cyImage ;
     RECT          rect ;
     XFORM         xform ;

     SetMapMode (hdc, MM_HIMETRIC) ;

     SetViewportOrgEx (hdc, cxArea / 2, cyArea / 2, NULL) ;

     hemf = GetEnhMetaFile ("emf12.emf") ;

     GetEnhMetaFileHeader (hemf, sizeof (emh), &emh) ;

     cxImage = emh.rclFrame.right - emh.rclFrame.left ;
     cyImage = emh.rclFrame.bottom - emh.rclFrame.top ;

     rect.left   = - cxImage / 2 ;
     rect.top    =   cyImage / 2 ;
     rect.right  =   cxImage / 2 ;
     rect.bottom = - cyImage / 2 ;

     SetGraphicsMode (hdc, GM_ADVANCED) ;

     xform.eM11 = (FLOAT)  cos (TWO_PI / 8) ;
     xform.eM12 = (FLOAT)  sin (TWO_PI / 8) ;
     xform.eM21 = (FLOAT) -sin (TWO_PI / 8) ;
     xform.eM22 = (FLOAT)  cos (TWO_PI / 8) ;
     xform.eDx  = (FLOAT)  0 ;
     xform.eDy  = (FLOAT)  0 ;

     SetWorldTransform (hdc, &xform) ;

     PlayEnhMetaFile (hdc, hemf, &rect) ;

     DeleteEnhMetaFile (hemf) ;
     }
