' ManyThng.BAS -- This is my attempt at a variable screen saver
'   It is based on an example in "Learn Programming and Visual Basic 2.0"
'   by John Socha and Sybex Inc., (highly recommended)

' first written 4-15-93 Bruce McLean
'
Option Explicit

'
' These variables support saving the maximum number of lines
' in the CONTROL.INI file, which is where the Windows 3.1
' screen savers save setup information.
'
Global MaxLines As Integer      ' Lines to show before CLS
Global RepeatCount As Integer   ' # of lines the same color
Global MaxChangeMinutes As Single   ' minutes to go before changing color
Global MaxCums As Integer      ' total number of lines before clearing screen
Global BitmapsDir As String ' place to look for bitmaps
Global CycleBitmapsDir As String ' place to look for bitmaps for palette cycling
Global BmpSeconds As Integer ' seconds between bitmaps on slide show
Global RandomFlag As Integer ' non-zero means pick saver at random, else go in sequence
Global StartSaver As Integer ' zero means pick 1st saver at random, else start with saver the corresponds to value
Global ErrorTrace As Integer ' flag to log data for error tracing
Global LowMemoryFlag As Integer 'set this to run special low memory mode
Global TestMode As Integer 'this mode is for debugging code
Global Passwd As String 'where master password is stored
Global Const Scramble = "soDSM" 'to scramble password
Global PasswdScram As String 'scrambled password
Global TotalNumColors As Long 'place to store number of colors display can handle
Global PaletteHandle As Integer
Global FastPaletteCycleFlag As Integer

Global Const iniName = "CONTROL.INI"
Global Const secName = "Screen Saver.Many Things"
Global Const keyName = "MaxLines"
Global Const RepeatName = "RepeatCount"
Global Const ChangeMinutesName = "MaxChangeMinutes"
Global Const MaxCumsName = "MaxCumLines"
Global Const BmpsDirName = "BitmapsDir"
Global Const CycleBmpsDirName = "CycleBitmapsDir"
Global Const BmpSecondsName = "BmpSeconds"
Global Const RandomFlagName = "RandomFlag"
Global Const LowMemoryFlagName = "LowMemoryFlag"
Global Const StartSaverName = "StartSaver"
Global Const ErrorTraceName = "ErrorTrace"
Global Const PasswordName = "Password"
Global Const PriorityBaseName = "Priority"
Global Const FastPaletteCycleName = "FastPaletteCycle"

Global Const NUMCHARS = 25
    
' windows defines
Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

'Polygon routine that draws any arbitray polygon using fill, etc.
Type POINTAPI
    X As Integer
    Y As Integer
End Type

' paint type
Type PAINTSTRUCT     '32 Bytes
    hDC As Integer
    fErase As Integer
    rcPaint As RECT
    fRestore As Integer
    fIncUpdate As Integer
    rgbReserved As String * 16
End Type

Global Const PALENTRIES = 256

'   This is similar to the LOGPALLETTE defined in
'   APIDECS.BAS, however instead of using a buffer, we
'   create a 64 entry palette for our use.

Type PALETTEENTRY    '4 Bytes
    peRed As String * 1
    peGreen As String * 1
    peBlue As String * 1
    peFlags As String * 1
End Type

Type LOGPALETTE
	palVersion As Integer
	palNumEntries As Integer
	palPalEntry(PALENTRIES) As PALETTEENTRY
End Type

Global Pal As LOGPALETTE

'Many things DLL routines used:
Declare Function ManyDibAlloc Lib "mnythdll.dll" (ByVal Wdth As Integer, ByVal Hght As Integer) As Long
Declare Function ManyDibFree Lib "mnythdll.dll" () As Integer
Declare Function ManyDibGet Lib "mnythdll.dll" () As Long
Declare Function ManyDibGetData Lib "mnythdll.dll" () As Long
Declare Function ManyDibLoad Lib "mnythdll.dll" (ByVal FileName As String, Wdth As Integer, Hght As Integer) As Long
Declare Function ManyGifLoad Lib "mnythdll.dll" (ByVal FileName As String, Wdth As Integer, Hght As Integer) As Long
Declare Function ManyDibInit Lib "mnythdll.dll" () As Long
Declare Sub ManyDibModPalette Lib "mnythdll.dll" (ByVal red As Integer, ByVal green As Integer, ByVal blue As Integer)
Declare Sub ManyDibCyclePalette Lib "mnythdll.dll" (ByVal StepSize As Integer, ByVal LowValue As Integer, ByVal HighValue As Integer)
Declare Sub ManyLoadLogPal Lib "mnythdll.dll" (Pal As LOGPALETTE, ByVal Start As Integer, ByVal size As Integer, ByVal Flags As Integer)
Declare Function ManyDIBWrite Lib "mnythdll.dll" (ByVal FileName As String) As Integer


' Windows API Routines used:
Declare Function ShowCursor Lib "USER" (ByVal fShow As Integer) As Integer
Declare Sub BitBlt Lib "GDI" (ByVal DestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal BWidth As Integer, ByVal BHeight As Integer, ByVal SourceDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal Constant As Long)
Declare Function StretchBlt Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal nSrcWidth As Integer, ByVal nSrcHeight As Integer, ByVal dwRop As Long) As Integer
Declare Function CopyRect Lib "User" (lpDestRect As RECT, lpSourceRect As RECT) As Integer
Declare Function CreateDC Lib "GDI" (ByVal Driver As Any, ByVal Dev As Any, ByVal O As Any, ByVal Init As Any) As Integer
Declare Sub DrawIcon Lib "User" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal hIcon As Integer)
Declare Function GetCursor Lib "User" () As Integer
Declare Sub GetCursorPos Lib "User" (lpPNT As Integer)
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function LockResource Lib "Kernel" (ByVal hRes As Integer) As Long
Declare Sub UnlockResource Lib "Kernel" Alias "GlobalUnlock" (ByVal hRes As Integer)
Declare Sub FloodFill Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal color As Long)
Declare Function Polygon Lib "GDI" (ByVal hDC As Integer, lpPoints As POINTAPI, ByVal nCount As Integer) As Integer
Declare Function SetPolyFillMode Lib "GDI" (ByVal hDC As Integer, ByVal nPolyFillMode As Integer) As Integer
Declare Function GetNearestColor Lib "GDI" (ByVal hDC As Integer, ByVal crColor As Long) As Long
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function SetSysModalWindow Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function SystemParametersInfo Lib "User" (ByVal uAction%, ByVal uParam%, lpvParam As Any, ByVal fuWinIni%) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC%, ByVal hObject%) As Integer
Declare Function CreateCompatibleDC Lib "GDI" (ByVal hDC%) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal hDC%) As Integer
Declare Function StretchDIBits% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal dX%, ByVal dY%, ByVal SrcX%, ByVal SrcY%, ByVal wSrcWidth%, ByVal wSrcHeight%, ByVal lpBits As Long, ByVal lpBitsInfo As Long, ByVal wUsage%, ByVal dwRop&)
Declare Function SetStretchBltMode% Lib "GDI" (ByVal hDC%, ByVal nStretchMode%)
Declare Function BeginPaint% Lib "User" (ByVal hWnd%, lpPaint As PAINTSTRUCT)
Declare Sub EndPaint Lib "User" (ByVal hWnd%, lpPaint As PAINTSTRUCT)
Declare Function SetDIBitsToDevice% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal dX%, ByVal dY%, ByVal SrcX%, ByVal SrcY%, ByVal Scan%, ByVal NumScans%, ByVal Bits As Long, ByVal BitsInfo As Long, ByVal wUsage%)
Declare Function DeleteObject% Lib "GDI" (ByVal hObject%)
Declare Function SendMessageByNum& Lib "User" Alias "SendMessage" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, ByVal lParam&)
Declare Function OpenClipboard% Lib "User" (ByVal hWnd%)
Declare Function SetClipboardData% Lib "User" (ByVal wFormat%, ByVal hMem%)
Declare Function CloseClipboard% Lib "User" ()
Declare Sub AnimatePalette Lib "GDI" (ByVal hPalette%, ByVal wStartIndex%, ByVal wNumEntries%, lpPaletteColors As PALETTEENTRY)
Declare Function CreatePalette% Lib "GDI" (lpLogPalette As LOGPALETTE)
Declare Function SelectPalette% Lib "User" (ByVal hDC%, ByVal hPalette%, ByVal bForceBackground%)
Declare Function RealizePalette% Lib "User" (ByVal hDC%)
Declare Function DeleteObject% Lib "GDI" (ByVal hObject%)
Declare Function SetSystemPaletteUse% Lib "GDI" (ByVal hDC%, ByVal wUsage%)
Declare Function GetFreeSystemResources% Lib "User" (ByVal fuSysResource%)
Declare Function GetFreeSpace& Lib "Kernel" (ByVal wFlags%)
Declare Function SetPaletteEntries% Lib "GDI" (ByVal hPalette%, ByVal wStartIndex%, ByVal wNumEntries%, lpPaletteEntries As PALETTEENTRY)
Declare Sub GetKeyboardStateBystring Lib "User" Alias "GetKeyboardState" (ByVal lpKeyState$)
Declare Function ToAsciiBystring Lib "Keyboard" Alias "ToAscii" (ByVal wVirtKey%, ByVal wScanCode%, ByVal lpKeyState$, lpChar&, ByVal wFlags%) As Integer
Declare Function MapVirtualKey Lib "Keyboard" (ByVal wCode%, ByVal wMapType%) As Integer
Declare Function VkKeyScan Lib "Keyboard" (ByVal cChar%) As Integer

'routines for reading profile data in 'CONTROL.INI'
Declare Function GetPrivateProfileInt Lib "KERNEL" (ByVal lpszSectionName As String, ByVal lpszKeyName As String, ByVal nDefault As Integer, ByVal lpszFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "KERNEL" (ByVal lpszSectionName As String, ByVal lpszKeyName As String, ByVal nString As String, ByVal lpszFileName As String) As Integer


' variables and constants to be used for screen capture
Global ScrnWidth As Integer, ScrnHeight As Integer
Dim RECT(3) As Integer

Global Const PI = 3.141592654

'Device Parameters for GetDeviceCaps()
Global Const DRIVERVERSION = 0  '  Device driver version
Global Const TECHNOLOGY = 2 '  Device classification
Global Const HORZSIZE = 4   '  Horizontal size in millimeters
Global Const VERTSIZE = 6   '  Vertical size in millimeters
Global Const HORZRES = 8    '  Horizontal width in pixels
Global Const VERTRES = 10   '  Vertical width in pixels
Global Const BITSPIXEL = 12 '  Number of bits per pixel
Global Const PLANES = 14    '  Number of planes
Global Const NUMBRUSHES = 16    '  Number of brushes the device has
Global Const NUMPENS = 18   '  Number of pens the device has
Global Const NUMMARKERS = 20    '  Number of markers the device has
Global Const NUMFONTS = 22  '  Number of fonts the device has
Global Const NumColors = 24 '  Number of colors the device supports
Global Const PDEVICESIZE = 26   '  Size required for device descriptor
Global Const CURVECAPS = 28 '  Curve capabilities
Global Const LINECAPS = 30  '  Line capabilities
Global Const POLYGONALCAPS = 32 '  Polygonal capabilities
Global Const TEXTCAPS = 34  '  Text capabilities
Global Const CLIPCAPS = 36  '  Clipping capabilities
Global Const RASTERCAPS = 38    '  Bitblt capabilities
Global Const ASPECTX = 40   '  Length of the X leg
Global Const ASPECTY = 42   '  Length of the Y leg
Global Const ASPECTXY = 44  '  Length of the hypotenuse

Global Const LOGPIXELSX = 88    '  Logical pixels/inch in X
Global Const LOGPIXELSY = 90    '  Logical pixels/inch in Y

Global Const SIZEPALETTE = 104  '  Number of entries in physical palette
Global Const NUMRESERVED = 106  '  Number of reserved entries in palette
Global Const COLORRES = 108 '  Actual color resolution

Global Const SPI_SETSCREENSAVEACTIVE = 17

Global Const PC_RESERVED = &H1
Global Const PC_EXPLICIT = &H2
Global Const PC_NOCOLLAPSE = &H4
Global Const DIB_RGB_COLORS = 0
Global Const DIB_PAL_COLORS = 1
Global Const SYSPAL_STATIC = 1
Global Const SYSPAL_NOSTATIC = 2
Global Const CF_TEXT = 1
Global Const CF_BITMAP = 2
Global Const CF_METAFILEPICT = 3
Global Const CF_SYLK = 4
Global Const CF_DIF = 5
Global Const CF_TIFF = 6
Global Const CF_OEMTEXT = 7
Global Const CF_DIB = 8
Global Const CF_PALETTE = 9
Global Const CF_OWNERDISPLAY = &H80
Global Const CF_DSPTEXT = &H81
Global Const CF_DSPBITMAP = &H82
Global Const CF_DSPMETAFILEPICT = &H83
Global Const CF_PRIVATEFIRST = &H200
Global Const CF_PRIVATELAST = &H2FF

' This is a message used within Visual Basic to retrieve
' the handle of a palette
Global Const VBM_GETPALETTE% = &H101C

'' GetFreeSystemResources constants
Global Const GFSR_SYSTEMRESOURCES = 0
Global Const GFSR_GDIRESOURCES = 1
Global Const GFSR_USERRESOURCES = 2

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Key Codes for keyup and keydown
Global Const KEY_LBUTTON = &H1
Global Const KEY_RBUTTON = &H2
Global Const KEY_CANCEL = &H3
Global Const KEY_MBUTTON = &H4    ' NOT contiguous with L & RBUTTON
Global Const KEY_BACK = &H8
Global Const KEY_TAB = &H9
Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
Global Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
Global Const KEY_MENU = &H12
Global Const KEY_PAUSE = &H13
Global Const KEY_CAPITAL = &H14
Global Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
Global Const KEY_END = &H23
Global Const KEY_HOME = &H24
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28
Global Const KEY_SELECT = &H29
Global Const KEY_PRINT = &H2A
Global Const KEY_EXECUTE = &H2B
Global Const KEY_SNAPSHOT = &H2C
Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
Global Const KEY_HELP = &H2F

' KEY_A thru KEY_Z are the same as their ASCII equivalents: 'A' thru 'Z'
' KEY_0 thru KEY_9 are the same as their ASCII equivalents: '0' thru '9'

Global Const KEY_NUMPAD0 = &H60
Global Const KEY_NUMPAD1 = &H61
Global Const KEY_NUMPAD2 = &H62
Global Const KEY_NUMPAD3 = &H63
Global Const KEY_NUMPAD4 = &H64
Global Const KEY_NUMPAD5 = &H65
Global Const KEY_NUMPAD6 = &H66
Global Const KEY_NUMPAD7 = &H67
Global Const KEY_NUMPAD8 = &H68
Global Const KEY_NUMPAD9 = &H69
Global Const KEY_MULTIPLY = &H6A
Global Const KEY_ADD = &H6B
Global Const KEY_SEPARATOR = &H6C
Global Const KEY_SUBTRACT = &H6D
Global Const KEY_DECIMAL = &H6E
Global Const KEY_DIVIDE = &H6F
Global Const KEY_F1 = &H70
Global Const KEY_F2 = &H71
Global Const KEY_F3 = &H72
Global Const KEY_F4 = &H73
Global Const KEY_F5 = &H74
Global Const KEY_F6 = &H75
Global Const KEY_F7 = &H76
Global Const KEY_F8 = &H77
Global Const KEY_F9 = &H78
Global Const KEY_F10 = &H79
Global Const KEY_F11 = &H7A
Global Const KEY_F12 = &H7B
Global Const KEY_F13 = &H7C
Global Const KEY_F14 = &H7D
Global Const KEY_F15 = &H7E
Global Const KEY_F16 = &H7F

Sub decode ()
  
  Dim i As Integer
  Dim code As Integer
  Dim code2 As Integer
  Dim j As Integer

  Passwd = ""

  If PasswdScram = "" Then 'if no password, then done
    Exit Sub
  End If

  j = Len(Scramble)

  For i = 1 To Len(PasswdScram) Step 2

    code = (Asc("z") - Asc(Mid$(PasswdScram, i, 1))) * 16 + (Asc(Mid$(PasswdScram, i + 1, 1)) - Asc("a"))
    code2 = Asc(Mid$(Scramble, (((i + 1) / 2) Mod j) + 1, 1))
    code = code Xor code2
    Passwd = Passwd + Chr$(code)

  Next i
    
  

End Sub

Sub Delay (t As Long)
' wait for t seconds before returning

  Dim CurrentTime As Long, LastTime As Long, EndTime As Long

  LastTime = Timer
  EndTime = LastTime + t

  Do
    DoEvents
    CurrentTime = Timer
    If (CurrentTime > EndTime) Or (LastTime > CurrentTime) Then Exit Sub
  Loop

End Sub

Sub encode ()

  Dim i As Integer
  Dim code As Integer
  Dim code2 As Integer
  Dim j As Integer

  PasswdScram = ""

  If Passwd = "" Then 'if no password, then no scramble
    Exit Sub
  End If

  j = Len(Scramble)

  For i = 1 To Len(Passwd)

    code = Asc(Mid$(Passwd, i, 1))
    code2 = Asc(Mid$(Scramble, (i Mod j) + 1, 1))
    code = code Xor code2

    PasswdScram = PasswdScram + Chr$(Asc("z") - (code \ 16)) + Chr$(Asc("a") + (code Mod 16))

  Next i
    

End Sub

Sub EndScrnSave ()
    Dim i As Integer

    ShowMouse                   ' Make mouse pointer visible again
    LogFile ("ManyThng done"), 1  ' make log

    'tell windows to enable screen savers
    i = SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, True, 0, 0)
    End                         ' And exit
End Sub

Function GetNextExtension (BitmapsDir As String, Ext1 As String, Ext2 As String, Ext3 As String) As String

  Dim i As Integer, File As String, StartSpec As String, temp As String

  i = 0 'count number of attempts
  Do
    StartSpec = Ext1
    i = i + 1' count attempts

    If StartSpec = "" Then
      File = ""
    Else
      On Error GoTo 999
      File = Dir$(RTrim$(BitmapsDir) + "\*." + StartSpec)
      On Error GoTo 0
    End If

    'now rotate extension for next time
    temp = Ext1: Ext1 = Ext2: Ext2 = Ext3: Ext3 = temp

  Loop While File = "" And i < 3

  GetNextExtension = File
  Exit Function

999 'directory path does not exist
  On Error GoTo 0
  File = ""
  Resume Next

End Function

Function GetNextFile (BitmapsDir As String, NewSequence As Integer, Ext1 As String, Ext2 As String, Ext3 As String) As String
  'get next file using file extensions Ext1 to 3
  Static Ex1 As String, Ex2 As String, Ex3 As String
  Dim File As String

  'start new series
  If NewSequence Then
    Ex1 = Ext1
    Ex2 = Ext2
    Ex3 = Ext3

    File = GetNextExtension(BitmapsDir, Ex1, Ex2, Ex3)
  Else
    File = Dir$ 'get next in series
    If File = "" Then ' if none available, get next
      File = GetNextExtension(BitmapsDir, Ex1, Ex2, Ex3)
    End If
  End If

  If File <> "" Then
    File = RTrim$(BitmapsDir) + "\" + File
  End If

  GetNextFile = File

End Function

Sub HideMouse ()
    While ShowCursor(False) >= 0
    Wend
End Sub

Function Int2Str (i As Integer) As String

  Int2Str = RTrim$(LTrim$(Str$(i)))

End Function

Sub LogFile (A As String, StoreResources As Integer)

  Dim i As Integer, l As Long

  'to enable logging comment out next line
  If Not ErrorTrace Then
    Exit Sub
  End If

  Open "c:\manythng.log" For Append Access Write As #1
  Print #1, Date; "  "; Time; " "; A;

  'see if we want to save resources
  If StoreResources Then

    i = GetFreeSystemResources(GFSR_SYSTEMRESOURCES)
    Print #1, "; System="; i;
    i = GetFreeSystemResources(GFSR_GDIRESOURCES)
    Print #1, "%; GDI="; i;
    i = GetFreeSystemResources(GFSR_USERRESOURCES)
    Print #1, "%; User="; i;
    l = GetFreeSpace(0)
    Print #1, "%; Free="; l
  Else
    Print #1,
  End If

  Close #1

End Sub

Sub main ()
    
    Dim i As Integer
    Dim DC As Integer
    Dim temp As String
    Dim temp2 As String * 128

    'see if error tracing is enabled
    ' to enable, edit "control.ini" in windows directory
    ' in section "[Screen Saver.Many Things]"
    ' add line:  "ErrorTrace=ON"
    ' to disable delete line
    i = GetPrivateProfileString(secName, ErrorTraceName, "OFF", temp2, 125, iniName)
    ErrorTrace = False ' default state
    If UCase$(Left$(temp2, 2)) = "ON" Then
      ErrorTrace = True ' default state
    End If

    LogFile (Chr$(13) + Chr$(10) + "-----------------" + Chr$(13) + Chr$(10) + "Starting ManyThng"), 1

    ' check if first instance of program so we can be sure that only one is running
    If App.PrevInstance Then
      LogFile ("Previous Instance of ManyThng"), 0
      EndScrnSave
    End If

    ' first capture screen into Form 'Original' for later use
    DC = CreateDC("DISPLAY", 0&, 0&, 0&)
    ScrnWidth = GetDeviceCaps(DC, HORZRES)
    ScrnHeight = GetDeviceCaps(DC, VERTRES)
    BitBlt Original.hDC, 0, 0, ScrnWidth, ScrnHeight, DC, 0, 0, &HCC0020
    i = DeleteDC(DC)

    '
    ' This next lines of code get numbers from the CONTROL.INI
    ' file in your Windows directory.
    '
    MaxLines = GetPrivateProfileInt(secName, keyName, 80, iniName)
    RepeatCount = GetPrivateProfileInt(secName, RepeatName, 15, iniName)
    i = GetPrivateProfileString(secName, ChangeMinutesName, "1", temp2, 125, iniName)
    MaxChangeMinutes = Val(temp2)
    MaxCums = GetPrivateProfileInt(secName, MaxCumsName, 400, iniName)
    BmpSeconds = GetPrivateProfileInt(secName, BmpSecondsName, 5, iniName)
    RandomFlag = GetPrivateProfileInt(secName, RandomFlagName, 1, iniName)
    FastPaletteCycleFlag = GetPrivateProfileInt(secName, FastPaletteCycleName, 1, iniName)
    StartSaver = GetPrivateProfileInt(secName, StartSaverName, 0, iniName)
    LowMemoryFlag = GetPrivateProfileInt(secName, LowMemoryFlagName, 0, iniName)
    i = GetPrivateProfileString(secName, PasswordName, "", temp2, 125, iniName)
    i = InStr(temp2, Chr$(0))
    PasswdScram = Left$(temp2, i - 1)
    Call decode

    ' get bitmaps directory
    i = GetPrivateProfileString(secName, BmpsDirName, "c:\windows", temp2, 125, iniName)
    BitmapsDir = ""
    For i = 1 To Len(temp2)' remove trailing whatevers from dir
      temp = Mid$(temp2, i, 1)
      If Asc(temp) <= 32 Or Asc(temp) > 126 Then GoTo done
      BitmapsDir = BitmapsDir + temp
    Next i
done:

    ' get palette cycling bitmaps directory
    i = GetPrivateProfileString(secName, CycleBmpsDirName, "c:\windows\cycle", temp2, 125, iniName)
    CycleBitmapsDir = ""
    For i = 1 To Len(temp2)' remove trailing whatevers from dir
      temp = Mid$(temp2, i, 1)
      If Asc(temp) <= 32 Or Asc(temp) > 126 Then GoTo done2
      CycleBitmapsDir = CycleBitmapsDir + temp
    Next i
done2:
    
      
    'look for test mode, used when debugging in VisBasic
    If InStr(Command$, "/t") Then
      TestMode = 1
    Else
      TestMode = 0
    End If

    'see if starting saver selected
    i = InStr(Command$, "/i=")
    If i <> 0 Then
      StartSaver = Val(Mid$(Command$, i + 3, 2))
    End If

    ' Check to see if we should blank the screen, or display
    ' the Setup dialog box.
    '
    If InStr(Command$, "/c") Then
	LogFile ("Configuring ManyThng"), 0
	SetupForm.Show 1
    ElseIf InStr(Command$, "/s") Then
	LogFile ("Running ManyThng"), 0
	ManyThings.Show
    End If

    '
    ' Wait until there are no forms visible, then quit.
    '
    While DoEvents() > 0        ' Loop until no forms visible
    Wend
    
End Sub

Sub ShowMouse ()
    While ShowCursor(True) < 0
    Wend
End Sub

