@echo OFF
::*********************************************************************
::*** WINRUN.BAT - DOS utility to work with the CEnvi WINSlave         ***
::*** ver.1     utility to run Windows commands from a DOS session. ***
::*********************************************************************

IF "%1"=="" GOTO INSTRUCTIONS
IF "%1"=="/?" GOTO INSTRUCTIONS
GOTO HAVE_PARMS

:INSTRUCTIONS
ECHO 
ECHO WINRUN.BAT - EXECUTE WINDOWS COMMAND FROM A DOS SESSION
ECHO 
ECHO SYNTAX: WIN [WAIT] Command [parameters]
ECHO 
ECHO Where:
ECHO   WAIT - Wait for command to finish
ECHO   Command - Any Windows command
ECHO   parameters - Parameters to pass to the Windows command
ECHO 
ECHO Examples: WIN MYAPP.EXE NOTEPAD C:\AUTOEXEC.BAT
ECHO           WIN WAIT NOTEPAD C:\AUTOEXEC.BAT
ECHO 
ECHO NOTE: WINRUN.CMM must be running to use WINRUN.BAT.  These two
ECHO       programs will communicate via the WINRUN.TMP file in
ECHO       the directory specified by your TMP environment variable.
ECHO       In your case this will be %TMP%\WINRUN.TMP.
ECHO 
GOTO WINBAT_FINI

:HAVE_PARMS
IF NOT (%TMP%)==() GOTO HAVE_TMP
ECHO 
ECHO The TMP environment variable must be set before running
ECHO Windows to use WINRUN.BAT and WINRUN.CMM
ECHO 
GOTO WINBAT_FINI

:HAVE_TMP
IF NOT EXIST %TMP%\WINRUN.TMP GOTO NOT_ALREADY_RUNNING
ECHO 
ECHO The file %TMP%\WINRUN.TMP already exists, which
ECHO indicates that another WINRUN.BAT session is already executed. Can
ECHO only execute 1 WINRUN.BAT ECHO at a time.
ECHO 
GOTO WINBAT_FINI

:NOT_ALREADY_RUNNING
REM SAVE CURRENT DIRECTORY AND COMMAND TO WINRUN FILE
cd > %TMP%\WINRUN.TMP
echo %1 %2 %3 %4 %5 %6 %7 %8 %9>> %TMP%\WINRUN.TMP
IF EXIST %TMP%\WINRUN.TMP GOTO FILE_CREATED_OK
ECHO 
ECHO Error creating the %TMP%\WINRUN.TMP file.
ECHO 
GOTO WINBAT_FINI

:FILE_CREATED_OK
REM TURN OFF ARCHIVE ATTRIBUTE AS MESSAGE TO SAY ITS DONE BEING WRITTEN
ATTRIB -A %TMP%\WINRUN.TMP

REM WAIT FOR WINRUN.TMP FILE TO NO LONGER EXIST
:WAIT_FOR_FILE_TO_GO_AWAY
IF EXIST %TMP%\WINRUN.TMP GOTO WAIT_FOR_FILE_TO_GO_AWAY

:WINBAT_FINI
