#!/usr/local/bin/perl -w
#
# evap - essentially identical to the C version of sample!
#        Same as sample.pl except we get our command line
#        parameters from the associative array %Options.
#        Also gets its PDT and MM data from the same files
#        used by the C sample programs.
     
#use EvaP;
require "src/EvaP.pm";

open IN, "<pdt/sample_pdt";
@PDT = <IN>;
close IN;

open IN, "<mm/sample.mm";
@MM = <IN>;
close IN;
@MM = grep @_ = s/\n$//, @MM;

EvaP(\@PDT, \@MM);		# evaluate parameters
print "\nProgram name:\n  $Options{'help'}\n\n";

if (defined $Options{'verbose'}) {print "\nverbose = $Options{'verbose'}\n";}
print "command = \"$Options{'command'}\"\n";
print "scale_factor  = $Options{'scale_factor'}\n";
print "millisecond_update_interval = $Options{'millisecond_update_interval'}\n";
print "ignore_output_file_column_one = $Options{'ignore_output_file_column_one'}\n";
print "output = $Options{'output'}\n";
print "queue = $Options{'queue'}\n";
print "destination = $Options{'destination'}\n";
print "'list of' tty = \"", join('", "', @{$Options{'tty'}}), "\"\n";

print "\nFile names:\n  ", join(' ', @ARGV), "\n" if @ARGV;
