#!/usr/local/bin/perl

# `sample_application' shows how to embed Evaluate Parameters into your application.

#use EvaP;
require "src/EvaP.pm";

sub setup_for_evap;

sub setup_for_evap { 

    # Simply read the PDT and MM files and initialize the evap variables for the specified package.

    my ($command) = @_;
    my $pkg = (caller)[0];

    open IN, "<pdt/${command}_pdt";
    eval "\@${pkg}::${command}_proc_PDT = <IN>;";                        # initialize Parameter Description Table
    close IN;
    open IN, "<mm/${command}.mm";
    eval "\@${pkg}::${command}_proc_MM = grep( \$@ = s/\n\$//, <IN> );"; # initialize Message Module
    close IN;

} # end setup_for_evap

# `sample_application' command processors follow, in alphabetical order.
 
sub exi_proc {

    package exi_pkg;		# qualify %Options

    main::setup_for_evap "exi" unless defined @exi_proc_PDT;
    if (main::EvaP(\@exi_proc_PDT, \@exi_proc_MM) != 1) {return;}

    print STDOUT "Have a nice day!\n";
    exit 0;

} # end exi_proc

sub samc_proc {

    package samc_pkg;		# qualify %Options

    main::setup_for_evap "samc" unless defined @samc_proc_PDT;
    $EvaP::evap_Help_Hooks{'P_HHUOFL'} = " [Color_List]\n";
    $EvaP::evap_Help_Hooks{'P_HHBOFL'} = "\nA Color_List is optionally required by this command.\n\n";
    if (main::EvaP(\@samc_proc_PDT, \@samc_proc_MM) != 1) {return;}

    print STDOUT "In sub samc_proc, value of option `id' = `$Options{'id'}'.\n";
    foreach $color (@ARGV) {
        print STDOUT "  color = $color\n";
    }

} # end samc_proc

# Main.

setup_for_evap "sama";
EvaP(\@sama_proc_PDT, \@sama_proc_MM); # Evaluate Parameters for `sample_application'

# Let Evaluate Parameters process all user input for the application, even calling the actual command processors.

$I = 'sama_input_handle';
open $I, "$Options{'input'}";
%ACT =  ("exit|exi" => "exi_proc", "sample_command|samc" => "samc_proc"); # Application Commands Table

EvaP_PAC("sama>", $I, %ACT);	# Process Application Commands

close $I;
exit 0;
