
/* `sample_application' shows how to embed Evaluate Parameters into your application. */

#include <stdio.h>
#include "../src/evap.h"
#include "../pdt/sama_pdt_out"  /* sample_application's PDT/MM declarations */
#include "../pdt/exi_pdt_out"   /* qualified PDT/MM declarations for the `exit' command */
#include "../pdt/samc_pdt_out"  /* qualified PDT/MM declarations for the `sample_command' command */

int exi_proc(int argc, char *argv[]);   /* `exit' processor  */
int samc_proc(int argc, char * argv[]);	/* `sample_command' processor */

/* `sample_application' command processors follow, in alphabetical order. */

int exi_proc(int argc, char *argv[])
{

  if ( evap( &argc, &argv, exi_pkg_pdt, NULL, exi_pkg_pvt ) != 0 ) { return( 0 ); }

  fprintf( stdout, "Have a nice day!\n" );
  exit( 0 );

}

int samc_proc(int argc, char *argv[])
{

  int c;

  evap_Help_Hooks[P_HHUOFL] = " [Color_List]\n";
  evap_Help_Hooks[P_HHBOFL] = "\nA Color_List is optionally required by this command.\n";
  if ( evap( &argc, &argv, samc_pkg_pdt, NULL, samc_pkg_pvt ) != 0 ) { return( 0 ); }

  fprintf( stdout, "In sub samc_proc, value of option `id' = `%s'.\n", samc_pkg_pvt[samc_pkg_P_id].value.string_value );
  c = argc;
  while ( c-- > 1 ) {
    fprintf( stdout, "  color = %s\n", argv[argc-c] );
  }

  return( 0 );

}

/* Main. */

int main (int argc, char *argv[])

{

  FILE *I;
  evap_Application_Command ACT[] = {{"exit", "exi", exi_proc}, {"sample_command", "samc", samc_proc},
				      {NULL, NULL, NULL}}; /* Application Commands Table */

  evap( &argc, &argv, pdt, NULL, pvt );	/* Evaluate Parameters for `sample_application' */

  /* Let Evaluate Parameters process all user input for the application, even calling the actual command processors. */
  
  if ( pvt[P_input].specified ) {
    if ( (I=fopen( pvt[P_input].value.file_value, "r" )) == NULL ) {
      fprintf( stderr, "Cannot open input file %s!\n", pvt[P_input].value.file_value );
      exit( 1 );
    }
  } else { I = stdin; }

  evap_pac( "sama>", I, ACT ); /* Process Application Commands */

  fclose( I );
  exit( 0 );

} /* end main */
