/* PROGRAM add_message_modules

Stephen O. Lidie.  July 1991.
Lehigh University Computing Center
Bethlehem, PA  18015
(610)758-3982
Stephen.O.Lidie@CDC1.CC.Lehigh.EDU
lusol@Lehigh.EDU

Copyright (C) 1991 - 1995 by Stephen O. Lidie and Lehigh University.
			 All rights reserved.

Command Source:  /usr/local/bin/add_message_modules

Message Module Name:  addmm.mm

add_message_modules, add_message_module, addmm

	Adds message modules to an `ar' message module archive file.

	  Example:
	
	    addmm -mml my_mm_library my.mm

        This example adds the contents of the file my.mm to a personal
        message module archive file my_mm_library.

	If the archive library file is not specified it defaults to the
        installation message module library.

          Example:

            addmm message_module/*.mm

        This example adds all the message modules in the message_module
        catalog to the installation message module library.

	To examine a sample Message Module try this:

	  ar p /usr/local/lib/libevapmm.a sample.mm | more

Parameters:

-help, ?, usage_help, full_help: Display Command Information

	Display information about this command, which includes
	a command description with examples, plus a synopsis of
	the command line parameters.  If you specify -full_help
	rather than -help complete parameter help is displayed
	if it's available.

-message_module_library, mml: file = D_ADDMM_MML, /usr/local/lib/libevapmm.a

	Specifies the path name of the `ar' archive library to hold
	the text of the indicated message modules.

	Message modules contain informative text about the command
	they describe as well as parameter help data.

 file(s) required by this command

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "./evap.h"
#include "../pdt/addmm_pdt_out"

int main(int argc, char *argv[]);

int main (int argc, char *argv[])
{

  char   c[1024+12];		/* ar command line */
  int    i;

  evap(&argc, &argv, pdt, NULL, pvt);

  sprintf(c, "ar rcv %s", pvt[P_message_module_library].value.file_value);

  for (i = 1; i < argc; i++) {
    strcat(c, " ");
    strcat(c, argv[i]);
  } /* forend */

  system(c);

  sprintf(c, "ranlib %s", pvt[P_message_module_library].value.file_value);
  system( c );

  exit(0);

} /* end add_message_modules */
