



proc Insert {text args} {

	# Insert text into a Text widget and apply one or more tags to that text.

	set start [.usage_help.t index insert]
	.usage_help.t insert insert $text
	foreach tag [.usage_help.t tag names $start] {
		.usage_help.t tag remove $tag $start insert
	}
	foreach i $args {
		.usage_help.t tag add $i $start insert
	}
}




proc Move_Help_Window {} {

	set mark [ lindex [ selection get ] 0 ]
	regsub -all " " "$mark" "_" mark
	.usage_help.t yview "mark_usage_help_${mark}"

}




proc Display_Usage { version } {

	# Open a Toplevel widget and insert some fanciful help text.

	global gentkp_highlight

	if { [ winfo exists .usage_help ] } {
		return
	}
	toplevel .usage_help
	wm title .usage_help "Usage"
	wm iconname .usage_help "Usage"
	frame .usage_help.menus
	frame .usage_help.f
	frame .usage_help.l -bd 5
	text .usage_help.t -relief raised -bd 1 -yscrollcommand ".usage_help.s set" -setgrid true -height 36 -font fixed
	scrollbar .usage_help.s -relief flat -command ".usage_help.t yview"
	menubutton .usage_help.menus.file -text File -menu .usage_help.menus.file.m -underline 0
	menu .usage_help.menus.file.m
	.usage_help.menus.file.m add command -label "Save Help Text As ..." -command "Save_Window .usage_help.t" -underline 0
	.usage_help.menus.file.m add command -label "Pipe Help Text To ..." -command "Pipe_Window .usage_help.t" -underline 0
	.usage_help.menus.file.m add separator
	.usage_help.menus.file.m add command -label Close -underline 0 -command "destroy .usage_help"

	scrollbar .usage_help.l.scroll -relief sunken -command ".usage_help.l.list yview"
	listbox .usage_help.l.list -relief sunken  -setgrid 1 -yscroll ".usage_help.l.scroll set" \
		-selectbackground $gentkp_highlight
	label .usage_help.l.label -text "Table of Contents"
	pack .usage_help.l.label -in .usage_help.l -side top -fill x
	pack .usage_help.l.list -in .usage_help.l -side left -fill y
	pack .usage_help.l.scroll -in .usage_help.l -side right -fill y
	.usage_help.l.list insert end "Introduction"
	.usage_help.l.list insert end "Quick Start"
	.usage_help.l.list insert end "Unix Command Syntax"
	.usage_help.l.list insert end "  The Problem"
	.usage_help.l.list insert end "  A Solution"
	.usage_help.l.list insert end "Parameter Types"
	.usage_help.l.list insert end "  String"
	.usage_help.l.list insert end "  Integer"
	.usage_help.l.list insert end "  Real"
	.usage_help.l.list insert end "  File"
	.usage_help.l.list insert end "  Key"
	.usage_help.l.list insert end "  Boolean"
	.usage_help.l.list insert end "  Switch"
	.usage_help.l.list insert end "  Name"
	.usage_help.l.list insert end "  Application"
	.usage_help.l.list insert end "Lists"
	.usage_help.l.list insert end "The `Do It' Button"
	.usage_help.l.list insert end "Windows"
	.usage_help.l.list insert end "  Main Window"
	.usage_help.l.list insert end "    Main File Menu"
	.usage_help.l.list insert end "    Main Edit Menu"
	.usage_help.l.list insert end "    Main Help Menu"
	.usage_help.l.list insert end "  Output Window"
	.usage_help.l.list insert end "    Output File Menu"
	.usage_help.l.list insert end "  Help Window"
	.usage_help.l.list insert end "    Help File Menu"
	.usage_help.l.list insert end "Revision History"
	.usage_help.l.list insert end "Credits"
	tk_listboxSingleSelect .usage_help.l.list

	bind .usage_help.l.list <Double-1> "Move_Help_Window"

	pack .usage_help.menus.file -side left
	pack .usage_help.menus -side top -fill x -expand yes
	pack .usage_help.l -side right -fill y
	pack .usage_help.f -side left -expand yes -fill both
	pack .usage_help.s -in .usage_help.f -side right -fill y
	pack .usage_help.t -in .usage_help.f -expand yes -fill both

	.usage_help.t tag configure bold -font -Adobe-Courier-Bold-O-Normal-*-120-*
	.usage_help.t tag configure big -font -Adobe-Courier-Bold-R-Normal-*-140-*
	.usage_help.t tag configure verybig -font -Adobe-Helvetica-Bold-R-Normal-*-240-*
	if {[tk colormodel .usage_help] == "color"} {
		.usage_help.t tag configure color1 -background #eed5b7
		.usage_help.t tag configure color2 -foreground blue
		.usage_help.t tag configure raised -background #eed5b7 -relief raised \
			-borderwidth 1
		.usage_help.t tag configure sunken -background #eed5b7 -relief sunken \
			-borderwidth 1
	} else {
		.usage_help.t tag configure color1 -background black -foreground white
		.usage_help.t tag configure color2 -background black -foreground white
		.usage_help.t tag configure raised -background white -relief raised \
			-borderwidth 1
		.usage_help.t tag configure sunken -background white -relief sunken \
			-borderwidth 1
	}
	.usage_help.t tag configure bgstipple -background black -borderwidth 0 \
		-bgstipple gray25
	.usage_help.t tag configure fgstipple -fgstipple gray50
	.usage_help.t tag configure underline -underline on

####### New section #######

	Insert \
{

                       Introduction

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_Introduction "$start"
	Insert \
{You are interacting with an X11 Motif Graphical User Interface for a typical
Unix program.  Although unimportant to you, this program uses as its command
line interface the function }
        Insert "Evaluate Parameters" color2
	Insert \
{, which makes the creation of
this GUI possible.  By filling out a `form' and pushing `buttons' you can
easily run this Unix program, avoiding most if not all of the pitfalls that
Unix throws at you!

This program is brought to you courtesy of }
	Insert \
{generate_tk_program, Tcl, Tk and
Evaluate Parameters} color2
	Insert "."

####### New section #######

	Insert \
{

                       Quick Start

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_Quick_Start "$start"
	Insert \
{In 25 words or less:  fill in the blanks, push the required buttons and click
on `Do It'.  That's really all there is to it.

Some parameters }
	Insert "require" bold
	Insert \
{ a value:  for parameters with an Entry box the value
`$required' is displayed; for parameters with Radio or Check buttons none of
the buttons are highlighted, so you must click on at least one.

Scroll through the window containing the command's help text to see what
information the programmer has provided for you.

If the parameter is a list you may enter multiple space-separated items.

At the bottom of the main window is a box that displays the Unix command.  As
parameter values are entered you can watch the command update in realtime.

An output window opens to capture the command's standard output and
standard error, which you can view, save to a file or send to a command
pipeline.}

####### New section #######

	Insert \
{

                   Unix Command Syntax

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_Unix_Command_Syntax "$start"
	Insert \
{Generally, Unix commands consist of cryptic command line parameters whose
meanings and functions are nearly impossible to determine.  Because there are
no conventions in the Unix world for naming command line parameters and
parsing the command line, the user interface changes from program to program.}

####### New section #######

	Insert \
{

                       The Problem

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___The_Problem "$start"
	Insert \
{For example, typical Unix programs expect either standalone switches or
parameters, preceeded by a `-',  with the value of non-switch parameters to
follow immediately.  Sometimes an optional list of file names is expected:

	}
	Insert "cc" bold
	Insert \
{ -O -o my_prog.exe -L/usr/local/lib -levap my_prog.c

Notice that some parameters like }
	Insert "-o" bold
	Insert \
{ must have a space between them and their
value, but other parameters line }
	Insert "-L" bold
	Insert { and }
	Insert "-l" bold
	Insert \
{ cannot have a space.

As another example take the }
	Insert "tar" bold
	Insert \
{ command, where command line options are bundled
together after the `-' and values follow in a one-to-one correspondence:

	}
	Insert "tar" bold
	Insert \
{ -cvf my_tar.tar *

Some Unix developers go so far as to dispense with the dash as a parameter
indicator and disallow it entirely, as in the }
	Insert "ar" bold
	Insert \
{ command:

	}
	Insert "ar" bold
	Insert \
{ rcv my_archive.a *.o

So as you can see, the only thing consistent about command line parsing in Unix
is its inconsistency :-).

To further complicate matters there is no regularity in command usage
information - some commands provide it and some do not.  If you're lucky enough
to see usage information it always varies from program to program.}

####### New section #######

	Insert \
{

                        A Solution

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___A_Solution "$start"
	Insert \
{All these considerations spurred the developement of }
	Insert "Evaluate Parameters" color2
	Insert \
{ for
Unix.

There are C, Perl and Tcl implementations which provide for a simple and
consistent user interface, type-check parameter values and provide three
levels of command and parameter help.  Because there is so much consistency
it was possible to write a new program called }
	Insert "generate_tk_program" color2
	Insert \
{ that could
create a Graphical User Interface like this one for }
	Insert "any" bold
	Insert \
{ program using
}
	Insert "Evaluate Parameters" color2
	Insert \
{ to parse its command line.  What you are seeing and using
is a GUI front-end that was generated }
	Insert "automatically" bold
	Insert \
{ by }
	Insert "generate_tk_program" color2
	Insert "!"

####### New section #######

	Insert \
{

                       Parameter Types

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_Parameter_Types "$start"
	Insert \
{All values that you enter for command line parameters must be of the
appropriate type.  For instance, if a parameter expects an integer you must
supply a positive or negative number.  The following types are supported:

	}
	Insert "s" underline color2
	Insert "tring "
	Insert "i" underline color2
	Insert "nteger "
	Insert "r" underline color2
	Insert "eal "
	Insert "f" underline color2
	Insert "ile "
	Insert "k" underline color2
	Insert "ey "
	Insert "b" underline color2
	Insert "oolean "
	Insert "sw" underline color2
	Insert "itch "
	Insert "n" underline color2
	Insert "ame "
	Insert "a" underline color2
	Insert "pplication"
	Insert \
{

Do you really care what type of value a command line parameter expects?  Well,
yes!  If the program wants a number and you give it letters you will be yelled
at.

If you look at the main window, to the right of the names of the command line
parameters and to the left of where you specify their values, you see some
coded information in parentheses, like:

	(s )
	(i )
	(r )
	(sw)

This one-letter code corresponds to the first letter of the parameter's type,
except for }
	Insert "sw" underline color2
	Insert "itch"
	Insert \
{ parameters which use the first two letters to distinguish
them from }
	Insert "s" underline color2
	Insert \
{tring parameters.

If you see the letter `l' following a type code you know that the parameter can
be a list, which means that multiple value can be specified.  For more details
on lists, see the section }
	Insert "Lists" bold
	Insert " which follows."

####### New section #######

	Insert \
{

                           String

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___String "$start"
	Insert "A "
	Insert "string" bold
	Insert \
{ parameter is a list of characters, which may include whitespace,
enclosed in either single or double quotes.  You specify value(s) by typing
in the Entry box.

	"Hello world!"
	'Hello World!'}

####### New section #######

	Insert \
{

                           Integer
  
} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Integer "$start"
	Insert "An "
	Insert "integer" bold
	Insert \
{ parameter is a list of digts, with an optional leading sign.  You
specify value(s) by typing in the Entry box.

	945
	-23}

####### New section #######

	Insert \
{

                            Real

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Real "$start"
	Insert "A "
	Insert "real" bold
	Insert \
{ parameter is a list of digits, with an optional leading sign, possibly
a decimal point, and an optional trailing exponent.  You specify value(s) by
typing in the Entry box.

	-0.345
	+1.1e-7}

####### New section #######

	Insert \
{

                            File

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___File "$start"
	Insert "A "
	Insert "file" bold
	Insert \
{ parameter is a Unix file name.  You specify value(s) by typing in the
Entry box.

	my_file
	/home/lusol/.profile}

####### New section #######

	Insert \
{

                            Key

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Key "$start"
	Insert "A "
	Insert "key" bold
	Insert \
{ parameter can be given only certain value(s) that the programmer has
allowed.  You specify value(s) by pushing a Radiobutton or, in the case of a
list, one or more Checkbuttons.}

####### New section #######

	Insert \
{

                           Boolean

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Boolean "$start"
	Insert "A "
	Insert "boolean" bold
	Insert \
{ parameter can be in one of two states:  on or off.  You specify
value(s) by pushing a Radiobutton or, in the case of a list, typing in the
Entry box.

	TRUE or YES or ON or 1
	FALSE or NO or OFF or 0}

####### New section #######

	Insert \
{

                           Switch

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Switch "$start"
	Insert "A "
	Insert "switch" bold
	Insert " parameter can be in one of two states:  on or off.  If the "
	Insert "switch" bold
	Insert \
{ is
specified on the command line it is 1, otherwise it is 0.  You specify a value
by pushing a Radiobutton.

	-verbose}

####### New section #######

	Insert \
{

                            Name

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Name "$start"
	Insert "A "
	Insert "name" bold
	Insert " parameter is similar to a "
	Insert "string" bold
	Insert \
{ except that embedded whitespace is not
permitted, therefore bounding quotes are not required.  You specify value(s) by
typing in the Entry box.

	NoQuotesRequired}

####### New section #######

	Insert \
{

                        Application

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Application "$start"
	Insert "An "
	Insert "application" bold
	Insert \
{ parameter is special in that no type checking is performed.
The interpretation of this parameter is application specific.  You will rarely
see this parameter type.  You specify value(s) by typing in the Entry box.

	"A special type, application specific!"}

####### New section #######

	Insert \
{

                           Lists

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_Lists "$start"
	Insert "Except for "
	Insert "switches" bold
	Insert \
{, all parameter types can be lists, which simply means that
multiple values can be supplied to the program.  You can tell if a parameter
can take a list by inspecting the type-code field in the main window - the
letter `l' indicates a list parameter.

For most types you can simply enter your values separated by spaces, but don't
forget to quote }
	Insert "strings" bold
	Insert \
{.  A list of }
	Insert "keys" bold
	Insert { is specified by pushing one or more
Checkbuttons.}

####### New section #######

	Insert \
{

                       The `Do It' Button

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_The_`Do_It'_Button "$start"
	Insert "After you are through customizing parameter values, click on "
	Insert "Do It" bold
	Insert \
{ to start
command execution.  The button changes to }
	Insert "Working ..." bold
	Insert { and an Output window
opens.

If you are lucky and the Tk installer has incorporated the extension known as
}
	Insert "AddInput" bold
	Insert " the button now changes to "
	Insert "Cancel" bold
	Insert " and begins blinking."
	Insert {  This means
that you can abort the command at any time.

If you are not so lucky and the button remains }
	Insert "Working ..." bold
	Insert \
{ you must either
wait for the Unix command to complete or abort this Motif application
via a Control/C!}

####### New section #######

	Insert \
{

                          Windows

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_Windows "$start"
	Insert \
{This section describes this application's Toplevel windows.  The Main window
is already open, you are using the Help window now, and there is an Output
window which may or may not be open at this time.}

####### New section #######

	Insert \
{

                        Main Window

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Main_Window "$start"
	Insert \
{The Main window is the one you use most often.  It contains the main controls
for this Motif application which allow you to enter or change command parameter
values, view help information, execute the Unix command and exit this Motif
application.  All these actions are performed by pulling down menus or pushing
the }
	Insert "Do It" bold
	Insert " button.  The menus are described below."

####### New section #######

	Insert \
{

                       Main File Menu

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_____Main_File_Menu "$start"
	Insert "The Main window "
	Insert "File" bold
	Insert \
{ menu contains these selections:
}
	Insert {
	Open ...
} bold
	Insert \
{		If the Unix program expects a trailing File Name you
		use this selection to browse your directory tree for
		the desired file.  After a selection is made the file
		name is appended to the generated Unix command.  If
		you are using a color monitor the Entry box is
		highlighted.  Of course, you can type this file name
		in the Entry box manually.
}
	Insert {
	Quit
} bold
	Insert \
{		Make this selection to quit the Motif application.
}

####### New section #######

	Insert \
{

                       Main Edit Menu

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_____Main_Edit_Menu "$start"
	Insert "The Main window "
	Insert "Edit" bold
	Insert \
{ menu contains this selection:
}
	Insert {
	Undo All
} bold
	Insert \
{		Make this selection to reset all parameter values
		to their default values.
}

####### New section #######

	Insert \
{

                       Main Help Menu

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_____Main_Help_Menu "$start"
	Insert "The Main window "
	Insert "Help" bold
	Insert \
{ menu contains these selections:
}
	Insert {
	About
} bold
	Insert \
{		This selection tells you a little bit about the Unix
		program, and gives me some credit!  (-:
}
	Insert {
	Usage
} bold
	Insert \
{		This selction opens the Help window which you are
		currently using.
}

####### New section #######

	Insert \
{

                      Output Window

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Output_Window "$start"
	Insert \
{The Output window holds standard output and standard error resulting from the
execution of the Unix command.  After clicking on the }
	Insert "Do It" bold
	Insert \
{ button this window
appears.
}

####### New section #######

	Insert \
{

                     Output File Menu

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_____Output_File_Menu "$start"
	Insert "The Output window "
	Insert "File" bold
	Insert \
{ menu contains these selections:
}
	Insert {
	Save As ...
} bold
	Insert \
{		Use this selection to save the contents of the
		Output window to a file.
}
	Insert {
	Pipe To ...
} bold
	Insert \
{		Use this selection to write the contents of the
		Output window to a command pipeline.  You might
		print or mail the window contents using this
		feature.
}
	Insert {
	Close
} bold
	Insert \
{		Make this selection to close the Output window.
}

####### New section #######

	Insert \
{

                       Help Window

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help___Help_Window "$start"
	Insert \
{The Help window is in use at this very momment.  Hopefully all the information
that you need to run this Motif application and execute the Unix command can be
found here.  If not, or you have further suggestions or comments, please send
mail to me, Stephen O. Lidie, at this email address:

}
	Insert \
{	lusol@Lehigh.EDU

} color2

####### New section #######

	Insert \
{

                      Help File Menu

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_____Help_File_Menu "$start"
	Insert "The Help window "
	Insert "File" bold
	Insert \
{ menu contains these selections:
}
	Insert {
	Save Help Text As ...
} bold
	Insert \
{		Use this selection to save the contents of the
		Help window to a file.
}
	Insert {
	Pipe Help Text To ...
} bold
	Insert \
{		Use this selection to write the contents of the
		Help window to a command pipeline.  You might
		print or mail the window contents using this
		feature.
}
	Insert {
	Close
} bold
	Insert \
{		Make this selection to close the Help window.
}

####### New section #######

	Insert \
{

                      Revision History

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_Revision_History "$start"
	Insert "This is version $version of "
	Insert "generate_tk_program" color2
	Insert \
", that corresponds to version $version of\n"
	Insert "Evaluate Parameters for C, Perl and Tcl." color2
	Insert \
{

94/04/14, version 2.1
  . Use fixed font rather than 7x13.
  . Relax regular expression search for trailing file_list in support of
    Help Hooks.

93/11/03, version 2.0
  . Original release.
}

####### New section #######

	Insert \
{

                          Credits

} big
	set start  [ expr [ .usage_help.t index insert ] - 3 ]
	.usage_help.t mark set mark_usage_help_Credits "$start"
	Insert "John Ousterhout, University of California at Berkeley.  ouster@cs.berkeley.edu"
	Insert \
{
	For writing }
	Insert "Tcl and Tk" color2
	Insert \
{, marvelous products that make creating
	X11 Motif applications a piece of cake.  I would never have
	attempted this using Xlib and Xt.

Stephen O. Lidie, Lehigh University.  lusol@Lehigh.edu
	For writing }
	Insert "Evaluate Parameters" color2
	Insert ", "
	Insert "generate_tk_program" color2
        Insert {, and
	}
        Insert "their friends "
        Insert "generate_man_page" color2
        Insert ", "
        Insert "add_message_modules" color2
        Insert {,
        }
        Insert "display_command_information" color2
        Insert " and "
        Insert "generate_pdt" color2
	Insert "."

	.usage_help.t configure -state disabled
}	    
