#!/usr/local/bin/wish -f


proc print_list { p } {

    global opt_$p 
    puts -nonewline "'list of' $p = \"[join [set opt_$p] {", "}]\"\n"

}


source "src/evap.tcl"

set IN [open "SOL/QA/qa_pdt.c" "r"]
set PDT [read $IN]
close $IN;

set IN [open "SOL/QA/sample.mm" "r"]
set MM [read $IN]
close $IN;

set PDT [split $PDT \n]
set MM [string trimright $MM \n]
set MM [split $MM \n]

evap $PDT $MM

puts -nonewline "\nProgram name:\n  $options(help)\n"

if { [info exists options(verbose)] } { puts -nonewline "\nverbose = $options(verbose)\n" }

puts -nonewline "\ncommand = \"$options(command)\"\n"
print_list command2

puts -nonewline "\nscale_factor = $options(scale_factor)\n"
print_list scale_factor2

puts -nonewline "\nmillisecond_update_interval = $options(millisecond_update_interval)\n"
print_list millisecond_update_interval2

puts -nonewline "\nignore_output_file_column_one = $options(ignore_output_file_column_one)\n"
print_list ignore_output_file_column_one2

puts -nonewline "\noutput = $options(output)\n"
print_list output2

puts -nonewline "\nqueue = $options(queue)\n"
print_list queue2

puts -nonewline "\ndestination = $options(destination)\n"
print_list destination2

puts -nonewline "\ntty = $options(tty)\n"
print_list tty2

if { $argc > 0 } {
    puts -nonewline "\nFile names:\n  [join $argv { }]\n"
}

exit 0
