//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//



/*
    moles 
             zorilkey.c                                           
   

	Incept : 28Aug92 moles 
	Mod:
	
*/

#include <stdlib.h>
#include <bios.h>

#include "zorilkey.h"

int newwave=1;

int z_keypress(void)
{
	int key;

	if (_bios_keybrd(_KEYBRD_READY)==0)
			return Z_NOKEY;

	// Lets get ALL the keypresses at once, remembering the last one
	while (_bios_keybrd(_KEYBRD_READY))
		key = _bios_keybrd(_KEYBRD_READ);

	
	switch((key&0x00ff)) {
		case 'L':
		case 'l':
			return Z_LOCK;
		case 'X':
		case 'x':
			return Z_ESC;
		case 'm':
		case 'M':
			return Z_MASSAGE;
		case ' ':
			return Z_SPACE;
		case 'd':
		case 'D':
			return Z_DISPLAY;
		case 't':
		case 'T':
			return Z_TABLE;
		case 'p':
		case 'P':
			return Z_PALETTE;
		case 'f':
		case 'F':
			return Z_FLAME;
		case 'w':
		case 'W':
			return Z_WAVE;
		case '+':
		case '=':
			return Z_SAMPLE_UP;
		case '.':
		case '>':
			return Z_NOISE_UP;
		case '-':
		case '_':
			return Z_SAMPLE_DN;
		case ',':
		case '<':
			return Z_NOISE_DN;
		case '?':
		case '/':
			return Z_HELP;
		case '*':
			return Z_STEREO;

		case 'C':
		case 'c':
			return Z_CD;

		case 0:
		default:
			switch (key) {
				case ALT_A:
					newwave=0; return Z_NEWWAVE;
					break;
				case ALT_B:
					newwave=1; return Z_NEWWAVE;
					break;
				case ALT_C:
					newwave=2; return Z_NEWWAVE;
					break;
				case ALT_D:
					newwave=3; return Z_NEWWAVE;
					break;
				case ALT_E:
					newwave=4; return Z_NEWWAVE;
					break;
				case ALT_F:
					newwave=5; return Z_NEWWAVE;
					break;
				case ALT_G:
					newwave=6; return Z_NEWWAVE;
					break;
				case ALT_H:
					newwave=7; return Z_NEWWAVE;
					break;
				case ALT_I:
					newwave=8; return Z_NEWWAVE;
					break;
				case ALT_J:
					newwave=9; return Z_NEWWAVE;
					break;
				case ALT_K:
					newwave=10; return Z_NEWWAVE;
					break;
				case ALT_L:
					newwave=11; return Z_NEWWAVE;
					break;
				case ALT_M:
					newwave=12; return Z_NEWWAVE;
					break;
				case ALT_N:
					newwave=13; return Z_NEWWAVE;
					break;
				case ALT_O:
					newwave=14; return Z_NEWWAVE;
					break;
				case ALT_P:
					newwave=15; return Z_NEWWAVE;
					break;
				case ALT_Q:
					newwave=16; return Z_NEWWAVE;
					break;
				case ALT_R:
					newwave=17; return Z_NEWWAVE;
					break;
				case ALT_S:
					newwave=18; return Z_NEWWAVE;
					break;
				case ALT_T:
					newwave=19; return Z_NEWWAVE;
					break;
				case ALT_U:
					newwave=20; return Z_NEWWAVE;
					break;
				case ALT_V:
					newwave=21; return Z_NEWWAVE;
					break;
				case ALT_W:
					newwave=22; return Z_NEWWAVE;
					break;
				case ALT_X:
					newwave=23; return Z_NEWWAVE;
					break;
				case ALT_Y:
					newwave=24; return Z_NEWWAVE;
					break;
				case ALT_Z:
					newwave=25; return Z_NEWWAVE;
					break;
				case SHFT_FN1:
				case FN1:
					return Z_HELP;
				case ESC:
					return Z_ESC;
				default:
					return Z_NOKEY;
			}
			break;
	}
	return Z_NOKEY; // never gets here
}
