
/**************************************************************************
                VCNVT.C

 Note : This file is for the voice file conversion from ZyXEL.

 Usage : VCNVT  M  sfile dfile
                ^    ^     ^
                |    |     +--- Destination file path and name
                |    |
                |    +--- Source file path and name
                |
                +--- convert mode, 0 -> to SB format
                                   1 -> to 2 Bit ADPCM
                                   2 -> to 3 Bit ADPCM
                                   3 -> to 4 Bit ADPCM
                                   4 -> to 3 Bit NEW
                                   

 Modified by Lin Chinru, Jun. 30, 1994. For the file format compatability
        with ZUTIL and VoiceConnect program. The ZyXEL voice file is defined
        as : 16 bytes header and followed by the compressed voice data.

    Ŀ
     Record ID      Field ID    name    length  pos   remark           
    Ĵ
     header         title       TITLE   5        0    "ZyXEL"          
     offset:0                           1        5    2                
                    Version             2        6                     
                    reserved            2        8                     
                    Compressed          2       10   0:CELP            
                                                     1:2-Bit Normal    
                                                     2:3-Bit Normal    
                                                     3:4-Bit Normal    
                                                     5:2-Bit Resync    
                                                     6:3-Bit Resync    
                                                     7:4-Bit Resync    
                                                     8:New 3-Bit Normal
                                                     C:New 3-Bit Resync
                    reserved            4       12                     
                                                                  
                                FH      16                             
    Ĵ
     voc data         The data format of the following data is for         
                      ZyXEL Voice Compression Scheme.                      
    Ĵ
      Note : 1. The compressed code identifies the voice data type,         
                In normal mode, the voice data <DLE> is stored as a single  
                   byte, no resync codes is included.                       
                In Resync mode, the voice data <DLE> is stored twice and    
                   the resync code is included.                             
             2. General rule is : bit 0 - 1 are used to identify the        
                                       compression scheme.                  
                                  bit 2 is used to indicate the resync.     
                                  bit 3 is reserved for optional compression
                                       scheme.                              
                                                                            
    

 Modified by Lin Chinru, Sep. 22, 1994. "Fix the problem of 3, 4-Bit Convert"
 Modified by Lin Chinru, Jun. 2, 1994.  "For the Firmware > 6.13 "
        Add : New 3Bit ADPCM. (AT+VSM=30 for ZyXEL U modem.)
              4Bit ADPCM. (AT+VSM=4 for ZyXEL U modem.)
        support : .VOC Ver 1.2
                  ADPCM to ADPCM conversion.
 Modified by Lin Chinru, Apr. 10, 1994. " For the Firmware > 6.12 "
 Created by Lin Chinru, Jan. 5, 1993.  R&D Dep., ZyXEL Comm. Corp.
 Copyright 1994, ZyXEL Communications Corporation
 **************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#define SoundBlaster    0
#define Bit2AdPcm       1
#define Bit3AdPcm       2
#define Bit4AdPcm       3
#define Bit3AdNew       4

void Coded(char) ;
void FromADPCM(void) ;
void ToAdpcm(int) ;
void Quit(int,char *) ;
void Adaptive1(char) ;
void Adaptive2(char) ;


char    Rcnt, CompBit, SourType, DestType ;
FILE    *SourFh, *DestFh ;

int     Rdata, EstMax1, Delta1, EstMax2, Delta2, Data, Pack, Idata ;
long    BlkCnt ;
int     MaxTbl1[8] = { 0x3556, 0x3556, 0x399A, 0x3A9F,\
                       0x4200, 0x4D14, 0x6607, 0x6607 } ;
int     MaxTbl2[8] = { 0x3556, 0x3556, 0x399A, 0x3A9F,\
                       0x4200, 0x4D14, 0x6607, 0x6607 } ;

char    SbitTbl[6] = { 0x00, 0x02, 0x04, 0x08, 0x04, 0x08 } ;
char    ShftTbl[6] = { 0x00, 0x06, 0x05, 0x04, 0x05, 0x04 } ;
char    PackTbl[6] = { 0x00, 0x02, 0x03, 0x04, 0x03, 0x04 } ;

char    HeadBuf0[32] ;

/* ------------------------------------------------- */
/* Reserved buffers for the ZyXEL ADPCM file header  */
/* ------------------------------------------------- */
char    ZheadBuf1[16] = { 'Z','y','X','E','L',2,0,0,0,0,0,0,0,0,0,0 } ;

/* ------------------------------------------ */
/* Reserved buffers for the .VOC file header  */
/* ------------------------------------------ */
char    VheadBuf1[32] = { 'C','r','e','a','t','i','v','e',' ',\
                          'V','o','i','c','e',' ','F','i','l','e',\
                          0x1a,0x1a,0,0x0a,1,0x29,0x11,\
                          1,0x82,0x70,0,0x98,0 } ;
char    VheadBuf2[4]  = { 2, 0x80, 0x70, 0 } ;


/**************************************************************************


**************************************************************************/
void main(int argc, char *argv[])
{
        /* ---------- Open file and check for legality -------------- */
        if ( argc!=4 )
                Quit(0,"") ;
        if ( (SourFh=fopen(argv[2],"rb")) == NULL )
                Quit(1,argv[1]) ;
        if ( (DestFh=fopen(argv[3],"wb")) == NULL )
                Quit(1,argv[2]) ;

        /* ------------------ */
        /* Initial parameters */
        /* ------------------ */
        Idata   = 0 ;
        Rcnt    = 8 ;
        Rdata   = 0 ;
        Delta1  = 5 ;
        EstMax1 = 0 ;
        Delta2  = 5 ;
        EstMax2 = 0 ;
        BlkCnt  = 0x7080 ;

        /* -------------------------------- */
        if ( (DestType = *argv[1] - '0') == 4 )
                ZheadBuf1[10] = 8 ;
        else
                ZheadBuf1[10] = DestType ;
        if ( DestType == Bit2AdPcm )    {
                MaxTbl2[0] = 0x3800 ;
                MaxTbl2[1] = 0x5600 ;
        }
        else if ( DestType == Bit3AdPcm || DestType == Bit3AdNew )  {
                MaxTbl2[0] = 0x399A ;
                MaxTbl2[1] = 0x3A9F ;
                MaxTbl2[2] = 0x4D14 ;
                MaxTbl2[3] = 0x6607 ;
        }
        if ( DestType )
                fwrite( ZheadBuf1, sizeof(char), 16, DestFh) ;
        else
                fwrite( VheadBuf1, sizeof(char), 32, DestFh) ;
        /* -------------------------------- */
        /*  Check the Source File Format    */
        /* -------------------------------- */
        fread( HeadBuf0, sizeof(char), 16, SourFh) ;

        if ( strncmp( HeadBuf0, ZheadBuf1, 6) || HeadBuf0[10]==0 )     {

                /* ------------------------------------ */
                /*   .VOC -> ZyXEL ADPCM conversion     */
                /* ------------------------------------ */
                fread( HeadBuf0+16, sizeof(char), 10, SourFh) ;
                if ( strncmp( HeadBuf0, VheadBuf1, 22) )
                        Quit(2,argv[2]) ;
                SourType = SoundBlaster ;
                /* Pack = 0->not accepted, 1->read sampling rate
                    2->read data, others->bypass          */
                while ( (Pack=getc(SourFh)) && (Pack!=EOF) ) {
                    BlkCnt = 0 ;
                    /* Read the block length */
                    fread( &BlkCnt, sizeof(int), 1, SourFh) ;
                    BlkCnt = BlkCnt + 65536*(long)getc(SourFh) ;
                    /* Read the sampling rate, 9600 is required */
                    if ( Pack == 1 )        {
                        if ( (Data=getc(SourFh))<147 ||
                            Data>157 || getc(SourFh) )
                                Quit(2,argv[2]) ;
                            BlkCnt -= 2 ;
                    }
                    else if ( Pack == 9 )        {
                        /* Read the sampling rate */
                        fread( &Rdata, sizeof(int), 1, SourFh) ;
                        fread( &Rdata, sizeof(int), 1, SourFh) ;
                        /* Read the bits per second */
                        getc(SourFh) ;
                        /* Read the Mono or Stereo */
                        getc(SourFh) ;
                        /* Read the compression */
                        fread( &Rdata, sizeof(int), 1, SourFh) ;
                        if ( Rdata )
                                Quit(2,argv[2]) ;
                        getc(SourFh) ;
                        getc(SourFh) ;
                        getc(SourFh) ;
                        getc(SourFh) ;
                        BlkCnt -= 12 ;
                    }
                    while ( BlkCnt-- )      {
                        if ( (Data = getc(SourFh)) == EOF )
                            break ;
                        if ( Pack <= 2 || Pack==9 )
                            ToAdpcm( ((Data-128)<<6) + 32 ) ;
                    }
                    if ( Data == EOF )
                            break ;
                }
        }
        else    {
                /* ---------------------------------------- */
                /*  ZyXEL ADPCM -> ADPCM or .VOC conversion */
                /* ---------------------------------------- */
                if ( (SourType = HeadBuf0[10]) == 8 )
                        SourType = Bit3AdNew ;
                FromADPCM() ;
        }
        fclose(SourFh) ;
        fclose(DestFh) ;
}

/**************************************************************************
        FromADPCM()

    ZyXEL ADPCM -> ADPCM or .VOC conversion

 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void FromADPCM(void)
{

    if ( SourType == Bit2AdPcm )    {
        MaxTbl1[0] = 0x3800 ;
        MaxTbl1[1] = 0x5600 ;
    }
    else if ( SourType == Bit3AdPcm || SourType == Bit3AdNew )  {
        MaxTbl1[0] = 0x399A ;
        MaxTbl1[1] = 0x3A9F ;
        MaxTbl1[2] = 0x4D14 ;
        MaxTbl1[3] = 0x6607 ;
    }
    while ( (Data=getc(SourFh)) != EOF )    {
        if ( SourType == Bit2AdPcm )    {
            Coded((Data>>6)&0x03) ;   /* XX-- ---- */
            Coded((Data>>4)&0x03) ;   /* --XX ---- */
            Coded((Data>>2)&0x03) ;   /* ---- XX-- */
            Coded(Data&0x03) ;        /* ---- --XX */
        }
        else if ( SourType == Bit3AdPcm )       {
            Coded((Data>>5)&0x07) ; /* XXX- ---- */
            Coded((Data>>2)&0x07) ; /* ---X XX-- */
            Pack = (Data<<1)&0x06 ;
            Data = getc(SourFh) ;
            Coded(Pack|((Data>>7)&0x01)) ;
            Coded((Data>>4)&0x07) ; /* -XXX ---- */
            Coded((Data>>1)&0x07) ; /* ---- XXX- */
            Pack = (Data<<2)&0x04 ;
            Data = getc(SourFh) ;
            Coded(Pack|((Data>>6)&0x03)) ;
            Coded((Data>>3)&0x07) ; /* --XX X--- */
            Coded(Data&0x07) ;      /* ---- -XXX */
        }
        else if ( SourType == Bit3AdNew )       {
            while ( !(Data&0x80) )      {
                if ( (Data=getc(SourFh)) == EOF )
                        break ;
            }
            Coded((Data>>4)&0x07) ; /* -XXX ---- */
            Coded((Data>>1)&0x07) ; /* ---- XXX- */
            Pack = (Data<<2)&0x04 ;
            Data = getc(SourFh) ;
            Coded(Pack|((Data>>6)&0x03)) ;
            Coded((Data>>3)&0x07) ; /* --XX X--- */
            Coded(Data&0x07) ;    /* ---- -XXX */
        }
        else if ( SourType == Bit4AdPcm ) {
            Coded((Data>>4)&0x0F) ; /* XXXX ---- */
            Coded(Data&0x0F) ;      /* ---- XXXX */
        }
    }
    if ( DestType == SoundBlaster )     {
        while ( BlkCnt-- )
            putc( 0x7f, DestFh) ;
        putc( 0, DestFh) ;
    }

}

/**************************************************************************
        Coded()



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void Coded(char Vdata)
{
int     Wdata ;
char    TmpData ;

        if ( SourType == Bit4AdPcm && !Vdata )
                Delta1 = 4 ;

        Adaptive1((char)Vdata) ;

        if ( EstMax1 > 8191 )
                Wdata = 8191 ;
        else if ( EstMax1 < -8192 )
                Wdata = -8192 ;
        else
                Wdata = EstMax1 ;

        if ( DestType == SoundBlaster )     {
                putc( ((Wdata>>6)+128)&0xff, DestFh ) ;
                if ( !(--BlkCnt) )      {
                        fwrite( VheadBuf2, sizeof(char), 4, DestFh) ;
                        BlkCnt  = 0x7080 ;
                }
        }
        else
                ToAdpcm(Wdata) ;
}

/**************************************************************************
        Adaptive1(DataBit)



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void Adaptive1(char DataBit)
{
int     TmpMax ;
char    TmpData, SignBit ;
long    TmpDelta ;
long    t0 ;

        /* the leakeage */
        t0 = (long)EstMax1 ;
        t0 *= 4093 ;
        t0 += 2048 ;
        t0 /= 4096 ;
        EstMax1 = (int)t0 ;

        SignBit = DataBit & SbitTbl[SourType] ;
        DataBit &= ~SbitTbl[SourType] ;
        if ( (Delta1&1) && !SignBit )
                ++EstMax1 ;

        /* ------------------- */
        /* Calculate the Delta */
        /* ------------------- */
        TmpDelta = Delta1 ;
        TmpDelta *= MaxTbl1[DataBit] ;
        TmpDelta += 8192 ;
        TmpDelta >>= 14 ;

        /* -------------------- */
        /* Calculate the EstMax */
        /* -------------------- */
        TmpMax  = (Delta1>>1) ;
        while ( DataBit-- )
                TmpMax += Delta1 ;
        if ( SignBit )
                EstMax1 -= TmpMax ;
        else
                EstMax1 += TmpMax ;

        Delta1 = (int)TmpDelta ;
}


/**************************************************************************
        ToAdpcm()



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void ToAdpcm(int Edata)
{
char    TmpCompBit, DataBit, TmpData ;


        DataBit = 0 ;
        Rdata   &= 0xff00 ;
        
        /* Check for the waveform data and quantize this data */
        if ( Edata -= EstMax2 )  {
                TmpCompBit = SbitTbl[DestType] ;
                /* ----------------------------------------------------- */
                /* If the data is negative, set flag and change the sign */
                /* ----------------------------------------------------- */
                if ( Edata < 0 ) {
                        Edata = -Edata ;
                        DataBit = TmpCompBit ;
                }
                /* --------------------------------------------------- */
                /* Quantize the waveform data, delta value is adaptive */
                /* --------------------------------------------------- */
                while ( ((Edata-=Delta2)>0) && --TmpCompBit )
                        DataBit += 1 ;
        }
        /* ---------------------------- */
        /* Rdata is the compressed data */
        /* ---------------------------- */
        if ( (DestType==Bit4AdPcm) && ((DataBit&0x0f)==0) )
                DataBit = 0x08 ;
        Rdata |= ( DataBit << ShftTbl[DestType] ) ;
        /* ------------------------------------------------------ */
        /* check if the compressed data can be pack into one byte */
        /* ------------------------------------------------------ */
        TmpCompBit = PackTbl[DestType] ;
        if ( DestType == Bit3AdNew )  {
                if ( ++Idata == 1 )     {
                        Rdata |= 0x100 ;
                        Rcnt = 7 ;
                }
                else if ( Idata == 5 )
                        Idata = 0 ;
        }
        while ( TmpCompBit-- )     {
                Rdata  <<= 1 ;
                if ( !(--Rcnt) )    {
                        putc(Rdata>>8,DestFh) ;
                        Rcnt = 8 ;
                }
        }
        /* -------------------------------------- */
        /* Adaptive the Delta and Estimat Maximum */
        /* -------------------------------------- */
        Adaptive2(DataBit) ;
}

/**************************************************************************
        Adaptive2(DataBit)



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void Adaptive2(char DataBit)
{
int     TmpMax ;
char    TmpData, SignBit ;
long    TmpDelta ;
long    t0 ;

        /* the leakeage */
        t0 = (long)EstMax2 ;
        t0 *= 4093 ;
        t0 += 2048 ;
        t0 /= 4096 ;
        EstMax2 = (int)t0 ;

        SignBit = DataBit & SbitTbl[DestType] ;
        DataBit &= ~SbitTbl[DestType] ;
        if ( (Delta2&1) && !SignBit )
                ++EstMax2 ;

        /* ------------------- */
        /* Calculate the Delta */
        /* ------------------- */
        TmpDelta = Delta2 ;
        TmpDelta *= MaxTbl2[DataBit] ;
        TmpDelta += 8192 ;
        TmpDelta >>= 14 ;

        /* -------------------- */
        /* Calculate the EstMax */
        /* -------------------- */
        TmpMax  = (Delta2>>1) ;
        while ( DataBit-- )
                TmpMax += Delta2 ;
        if ( SignBit )
                EstMax2 -= TmpMax ;
        else
                EstMax2 += TmpMax ;

        Delta2 = (int)TmpDelta ;
}


/**************************************************************************
        Quit()



 Copyright 1992, ZyXEL Communications Corporation
 ************************************************************************/
void Quit(int Num, char *MsgStr)
{
if ( Num == 0 ) {
    printf("Usage : VCNVT M sfile dfile.\n");
    printf("              ^   ^     ^\n");
    printf("              |   |     +--- Destination file path and name.\n");
    printf("              |   |\n");
    printf("              |   +--- Source file path and name.\n");
    printf("              |\n");
    printf("              +--- convert mode, 0 -> to SB format.\n");
    printf("                                 1 -> to 2 Bit ADPCM.\n");
    printf("                                 2 -> to 3 Bit ADPCM.\n");
    printf("                                 3 -> to 4 Bit ADPCM.\n");
    printf("                                 4 -> to 3 Bit NEW.\n");
}
    else if ( Num == 1 )
        printf("Can't open %s\n", MsgStr) ;
    else if ( Num == 2 )
        printf("File format error on %s\n", MsgStr) ;
    exit(1) ;
}
