 '
 ' Process ESC
 '

 DEFINT A-Z

'$INCLUDE: 'PROCESS.BI'
'$INCLUDE: 'TERM_IO.BI'
'$INCLUDE: 'PCL4B.BI'
'$INCLUDE: 'XYMODEM.BI'

CONST FALSE = 0, TRUE = NOT FALSE
CONST NAK = &H15

DIM SHARED ThePort
DIM SHARED Protocol$
DIM SHARED OneKflag
DIM SHARED NCGbyte
DIM SHARED BatchFlag
DIM SHARED BaudRate$

SUB InitProcess(BYVAL ThePort,Baud$)
  Port = ThePort
  BaudRate$ = Baud$
  Protocol$ = "X"
  OneKflag = FALSE
  NCGbyte = NAK
  BatchFlag = FALSE
END SUB

SUB ShowStatus
  P$ = STR$(1+ThePort)
  StatusMsg$ = "COM" + RIGHT$(P$,LEN(P$)-1) + " " + BaudRate$ + " " + Protocol$ + " ESC for menu"
  CALL WriteMsg(StatusMsg$, 45)
END SUB

FUNCTION Process
  PROCESS = FALSE
  GetNameMsg$ = "Enter filename: "
  'quit if user types ESC
  IF TRUE THEN
    CALL WriteMsg("Q)uit P)rotocol S)end R)eceive: ", 1)
    CALL ReadMsg(ResultMsg$, 32, 1)
    C$ = UCASE$(LEFT$(ResultMsg$, 1))
    SELECT CASE C$
      CASE "Q"   'QUIT
        PRINT
        PRINT ("TERMINATING: User pressed <ESC>")
        RetCode = SioDone(ThePort)
        PROCESS = TRUE
        EXIT FUNCTION
      CASE "P"   'PROTOCOL
        CALL WriteMsg("X)modem Y)modem ymodem-G): ", 1)
        CALL ReadMsg(ResultMsg$, 35, 1)
        P$ = UCASE$(LEFT$(ResultMsg$, 1))
        SELECT CASE P$
          CASE "X"  'XMODEM
            Protocol$ = "X"
            OneKflag = FALSE
            NCGbyte = NAK
            BatchFlag = FALSE
            CALL WriteMsg("Protocol = XMODEM", 1)
          CASE "Y"  'YMODEM
            Protocol$ = "Y"
            OneKflag = TRUE
            NCGbyte = ASC("C")
            BatchFlag = TRUE
            CALL WriteMsg("Protocol = YMODEM", 1)
          CASE "G"  'YMODEM-G
            Protocol$ = "G"
            OneKflag = TRUE
            NCGbyte = ASC("G")
            BatchFlag = TRUE
            CALL WriteMsg("Protocol = YMODEM-G", 1)
        END SELECT
        CALL ShowStatus
        'StatusMsg$ = "COM" + STR$(ThePort) + " " + Prococol$ + "  ESC for menu"
        'CALL WriteMsg(StatusMsg$, 40)
      CASE "R"  'Receive
        Filename$ = ""
        IF BatchFlag THEN
          Flag = YmodemRx(ThePort, Filename$, NCGbyte)
        ELSE
          Flag = XmodemRx(ThePort, Filename$, NCGbyte)
        END IF
      CASE "S"  'Send
        Filename$ = ""
        IF BatchFlag THEN
          Flag = YmodemTx(ThePort, Filename$, OneKflag)
        ELSE
          Flag = XmodemTx(ThePort, Filename$, OneKflag)
        END IF
      CASE ELSE
        CALL WriteMsg("Bad response", 1)
     END SELECT
   END IF
 END FUNCTION
