'
'  MODEM_IO.BAS
'

'$INCLUDE: 'MODEM_IO.BI'
'$INCLUDE: 'PCL4B.BI'

CONST FALSE = 0
CONST TRUE = NOT FALSE

' echos incoming to screen

' send string to modem & get echo

' wait for Text$

' enter command state
' NOTE: assumes escape char = '+' & guard time = 1 sec

' hangup phone (in command state)

' wait for continuous quiet (no incoming serial data)

 FUNCTION BreakTest()
 ' User BREAK ?
 IF SioBrkKey() OR SioKeyPress() THEN
   PRINT "User BREAK"
   BreakTest = TRUE
   EXIT FUNCTION
 END IF
 BreakTest = FALSE
 END FUNCTION

 FUNCTION ModemCmdState(BYVAL Port)
 ' delay a bit over 1 second
 rc = SioDelay(25)
 ' send Escape Code exactly 3 times
 FOR I = 1 TO 3
   rc = SioPutc(Port, ASC("+"))
   rc = SioDelay(5)
 NEXT I
 ' delay again
 rc = SioDelay(25)
 END FUNCTION

 FUNCTION ModemEcho(BYVAL Port, BYVAL Echo)
 Time& = SioTimer&()
 DO WHILE SioTimer&() < Time& + Echo
   rc = SioGetc(Port, 1)
   IF rc >= 0 THEN rc = SioCrtWrite(rc)
 LOOP
 END FUNCTION

 FUNCTION ModemHangup(BYVAL Port)
 ' enter command state
 rc = ModemCmdState(Port)
 ' hangup !
 rc = ModemSendTo(Port, 4, "!AT!")
 rc = ModemEcho(Port, 10)
 rc = ModemSendTo(Port, 4, "ATH0!")
 END FUNCTION

FUNCTION ModemQuiet(BYVAL Port, BYVAL Tics)
 ' set up
 CharTime& = SioTimer&()
 DO
   ' User BREAK ?
   IF BreakTest() THEN
      ModemQuiet = FALSE
      EXIT FUNCTION
   END IF
   ' wait for next character
   Code = SioGetc(Port, 1)
   IF Code < -1 THEN
      ModemQuiet = FALSE
      EXIT FUNCTION
   END IF
   IF Code >= 0 THEN
      CharTime& = SioTimer&()
      rc = SioCrtWrite(Code)
   ELSE
      ' =-1, timed out
      IF SioTimer&() >= CharTime& + Tics THEN
         ModemQuiet = TRUE
         EXIT FUNCTION
      END IF
   END IF
 LOOP
 END FUNCTION

 FUNCTION ModemSendTo(BYVAL Port, BYVAL Pace, Text$)
 FOR I = 1 TO LEN(Text$)
   ' User BREAK ?
   IF BreakTest() THEN
     ModemSendTo = FALSE
     EXIT FUNCTION
   END IF
   ' delay <Pace> tics
   IF Pace > 0 THEN rc = ModemEcho(Port, Pace)
   ' fetch character
   c$ = MID$(Text$, I, 1)
   SELECT CASE c$
     CASE "!"
       ' replace ! with carriage return
       c$ = CHR$(13)
     CASE "~"
       ' delay 1/2 second
       rc = SioDelay(10)
       c$ = " "
     CASE " "
       ' delay 1/4 second
       rc = SioDelay(5)
       c$ = " "
   END SELECT
   ' transmit
   rc = SioPutc(Port, ASC(c$))
 NEXT I
 ModemSendTo = TRUE
 END FUNCTION

 FUNCTION ModemWaitFor(BYVAL Port, BYVAL Tics, BYVAL CaseFlag, Text$)
 Length = LEN(Text$)
 ' wait for string
 Time& = SioTimer&()
 First = 1
 DO WHILE SioTimer&() < Time& + Tics
   ' User BREAK ?
   IF BreakTest() THEN
     ModemWaitFor = FALSE
     EXIT FUNCTION
   END IF
   ' wait for next character
   Code = SioGetc(Port, 1)
   IF Code < -1 THEN
     ModemWaitFor = FALSE
     EXIT FUNCTION
   END IF
   IF Code >= 0 THEN
     ' echo char
     rc = SioCrtWrite(Code)
     ' prepare chars
     c1$ = MID$(Text$, First, 1)
     First = First + 1
     c2$ = CHR$(Code)
     ' case sensitive ?
     IF NOT CaseFlag THEN
       c1$ = UCASE$(c1$)
       c2$ = UCASE$(c2$)
     END IF
     ' does char match ?
     '''PRINT "[";c1$;"|";c2$;"]"
     IF c1$ = c2$ THEN
       IF First > Length THEN
         ModemWaitFor = TRUE
         EXIT FUNCTION
       END IF
     ELSE
       'start over again
       First = 1
     END IF
   END IF
 LOOP
 ModemWaitFor = FALSE
 END FUNCTION

                                                                