/*

@echo off
cls
echo.
echo This INSTALL routine requires OS/2 REXX support installed.
echo Run Selective Installation from the OS/2 Setup Folder to
echo install REXX support before attempting to run this CMD file.
pause
exit

        *---------------------------------------------------------*
        |                                                         |
        | INSTALL.CMD -- Install procedure for Super Virtual Disk |
        |                (c) Copyright 1994 Albert J. Shan        |
        |                All Rights Reserved                      |
        |                                                         |
        *---------------------------------------------------------*
*/

'@echo off'

BootDrive       = ''
InstallPath     = ''
ItemChecked.1   = ' '
ItemChecked.2   = ' '
ItemChecked.3   = ' '
ItemChecked.4   = ' '
InstallList.0   = 'INSTALL.CMD'
InstallList.1   = 'SVDISK.SYS'
InstallList.2   = 'SVDC.EXE'
InstallList.3   = 'PMSVDC.EXE'
InstallList.4   = 'HFORMAT.EXE'
InstallList.5   = 'HMOUNT.EXE'
InstallList.6   = 'REREGSVD.EXE'
InstallList.7   = 'XDFSVD.EXE'
InstallList.8   = 'KWIKTOOL.MSG'
InstallList.9   = 'SVDISK.MSG'
InstallList.10  = 'PMSVDC.MSG'
InstallList.11  = 'HFORMAT.MSG'
InstallList.12  = 'HMOUNT.MSG'
InstallList.13  = 'XDFSVD.MSG'
InstallList.14  = 'KWIKTOOL.GER'
InstallList.15  = 'SVDISK.GER'
InstallList.16  = 'PMSVDC.GER'
InstallList.17  = 'HFORMAT.GER'
InstallList.18  = 'HMOUNT.GER'
InstallList.19  = 'XDFSVD.GER'
InstallList.20  = 'SVDISK.DOC'
InstallList.21  = 'SVDISK.HST'
InstallList.22  = 'LICENSE.DOC'
InstallList.23  = 'WARRANTY.DOC'
InstallList.24  = 'ORDER.FRM'
InstallList.25  = 'README'
InstallList.26  = ''
MessageFile.0   = 'PMSVDC'
MessageFile.1   = 'KWIKTOOL'
MessageFile.2   = 'SVDISK'
MessageFile.3   = 'HFORMAT'
MessageFile.4   = 'HMOUNT'
MessageFile.5   = 'XDFSVD'
MessageFile.6   = ''
CopyrightLine1  = 'Install procedure for Super Virtual Disk V1.16'
CopyrightLine2  = '(c) Copyright 1994 Albert J. Shan'
CopyrightLine3  = 'All Rights Reserved'

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* Check to make sure all the distribution files are found */
i = 0
do while InstallList.i \= ''
  call SysFileTree InstallList.i, 'tmp', 'F'
  if tmp.0 = 0 then do
    say
    say 'Cannot locate one of the distribution files.'
    say 'Please make sure INSTALL.CMD is run from the'
    say 'directory or drive where the distribution'
    say 'files can be found.'
    exit
  end
  i = i + 1
end

AvailDrives = SysDriveMap('C:', 'LOCAL')

/* Get boot drive letter */
done = 0
do while \ done
  call ShowCopyright
  say '  Please enter the drive letter for your OS/2 boot drive.'
  call charout, '  Press the letter for the drive or ESC to quit: '
  do forever
    k = translate(SysGetKey('NOECHO'))
    if k = D2C(27) then
      call InstallEnd
    else do
      k = k||':'
      if pos(k, AvailDrives) = 0 then
        call beep 1760, 50
      else do
        call SysFileTree k||'\Config.Sys', 'tmp', 'F'
        if tmp.0 = 0 then do
          say
          say
          say 'Cannot locate "'k'\Config.Sys"'
          call PressAnyKey
          leave
        end
        else do
          BootDrive = k
          done = 1
          leave
        end
      end
    end
  end
end

/* Check to see if Config.sys contains SVDISK.SYS.  If so, grab the path
   where SVDISK.SYS is installed at. */
do until lines(BootDrive||'\Config.sys') = 0
  parse value linein(BootDrive||'\Config.sys') with ConfigLine
  position = pos('SVDISK.SYS', strip(translate(ConfigLine)))
  if position > 0 & substr(strip(translate(ConfigLine)), 1, 7) = 'DEVICE=' then do
    InstallPath = substr(strip(ConfigLine), 8, position - 9)
    if length(InstallPath) = 1 then
      InstallPath = InstallPath||'\'
  end
end
call lineout BootDrive||'\Config.sys'

/* main selection loop */
do forever
  call ShowCopyright
  say 'Select one of the following:'
  say
  say '  ['||ItemChecked.1||'] 1. Install Super Virtual Disk'
  say '  ['||ItemChecked.2||'] 2. Language (message files) selection'
  say '  ['||ItemChecked.3||'] 3. Create PM SVDisk Control object on the Desktop'
  say '  ['||ItemChecked.4||'] 4. Transfer registration info from a registered copy of SVDisk'
  say
  say '  ESC to quit'
  say
  call charout, 'Press 1, 2, 3, 4 or ESC: '
  do forever
    k = translate(SysGetKey('NOECHO'))
    if k = '0' | k = D2C(27) then
      call InstallEnd
    else do
      if k = '1' then do
        call InstallFiles
        leave
      end
      if k = '2' then do
        call SelectLanguage
        leave
      end
      if k = '3' then do
        call CreatePMSVDiskObject
        leave
      end
      if k = '4' then do
        call UpgradeRegSVD
        leave
      end
    end
    call beep 1760, 50
  end
end

/* Main install routine */
InstallFiles:
  /* If CONFIG.SYS contains SVDISK.SYS, prompt for upgrade */
  if InstallPath \= '' then do
    call ShowCopyright
    say 'An existing copy of SVDisk is found in '||InstallPath
    say 'If this is a registered copy, you can use it to upgrade'
    say 'the Shareware version into the registered version.'
    say
    call charout, 'Proceed with upgrade? (Y/N) '
    do forever
      k = translate(SysGetKey('NOECHO'))
      if k = 'N' then
        leave
      if k = 'Y' then do
        call UpgradeRegSVD
        leave
      end
      call beep 1760, 50
    end
  end

  /* Query new installation path */
  do forever
    call ShowCopyright
    call charout, '  Super Virtual Disk will be installed into '
    if InstallPath \= '' then
      say InstallPath
    else say BootDrive||'\SVDisk'
    say
    say 'Press Enter to accept, or type in a new path where'
    say 'you want to install SVDisk.'
    NewPath = GetPath(NewPath)
    if NewPath = '' then do
      if InstallPath = '' then
        NewPath = BootDrive||'\SVDisk'
      else
        NewPath = InstallPath
    end
    error = SysMkDir(NewPath)
    if error \= 5 & error > 0 then do
      say 'Unable to create subdirectory.'
      call PressAnyKey
    end
    else
      leave
  end
  /* Confirm on install */
  if NewPath \= '' then do
    say
    say '  The new install path is: '||NewPath
  end
  say
  call charout, 'Proceed with install? (Y/N) '
  do forever
    k = translate(SysGetKey('NOECHO'))
    if k = 'N' then
      return
    if k = 'Y' then do
      say
      leave
    end
    call beep 1760, 50
  end

  InstallPath = NewPath
  call CopyFiles
  call UpdateConfig
  call SelectLanguage
  call ShowCopyright
  call charout, 'Create/update Desktop object for controlling SVDisk? (Y/N) '
  do forever
    k = translate(SysGetKey('NOECHO'))
    if k = 'N' then
      return
    if k = 'Y' then
      leave
    call beep 1760, 50
  end
  call CreatePMSVDiskObject
  return


/* Language selection */
SelectLanguage:
  call QueryInstallPath
  call ShowCopyright
  say '  You have 2 choices for language selection.  You can select'
  say '  English messages or German messages.'
  say
  say '  NOTE: make sure NONE of the SVDisk executable files are'
  say '        running before making a selection.'
  say
  say '  Press E for English messages'
  say '        G for German messages'
  say '        ESC to quit'
  error = 0
  i = 0
  do forever
    k = translate(SysGetKey('NOECHO'))
    if k = D2C(27) then return
    if k = 'E' then do
      EXT1 = '.GER'
      EXT2 = '.ENG'
      leave
    end
    if k = 'G' then do
      EXT1 = '.ENG'
      EXT2 = '.GER'
      leave
    end
    call beep 1760, 50
  end
  do until MessageFile.i = ''
    ren InstallPath||'\'||MessageFile.i||'.MSG' MessageFile.i||EXT1 '> nul 2>nul'
    if rc \=0 then
      error = error + 1
    ren InstallPath||'\'||MessageFile.i||EXT2 MessageFile.i||'.MSG' '> nul 2>nul'
    if rc \=0 then
      error = error + 1
    i = i + 1
  end
  if error > 0 & error \= i*2 then do
    say
    say 'The language selection may not be successful.  Some'
    say 'message files may be in use by one of the SVDisk'
    say 'executable programs.  Please exit all SVDisk executable'
    say 'programs, and make the language selection again.'
    call PressAnyKey
   end
   else
     ItemChecked.2 = 'X'
  return


/* Create PM SVDisk control on Desktop */
CreatePMSVDiskObject:
  call ShowCopyright
  call QueryInstallPath
  say
  if SysCreateObject('WPProgram', 'SVDisk Control', '<WP_DESKTOP>',,
       'OBJECTID=<PMSVDC>;EXENAME='||InstallPath||'\PMSVDC.EXE;'||,
       'STARTUPDIR='||InstallPath||';PROGTYPE=PM;', 'U') then do
    say 'Object created successfully.'
    ItemChecked.3 = 'X'
  end
  else
    say 'Failed to create object on the Desktop.'
  call PressAnyKey
  return


/* Upgrade older registered version of SVDisk to this version */
UpgradeRegSVD:
  call ShowCopyright
  reregsvd InstallPath
  if rc = 0 then do
    say
    say 'Upgrade was successful.  Please proceed with files install.'
    ItemChecked.4 = 'X'
  end
  call PressAnyKey
  return


/* Show copyright notice */
ShowCopyright:
  call SysCls
  say
  say
  say CopyrightLine1
  say CopyrightLine2
  say CopyrightLine3
  say
  say
  return


/* Wait for a key press */
PressAnyKey:
  call charout, 'Press any key to continue...'
  call SysGetKey 'NOECHO'
  return


/* Get path from user */
GetPath:
  call charout, '> '
  parse pull APath
  len = length(APath)
  if len > 0 then
    if substr(APath, len, 1) = '\' then
      APath = substr(APath, 1, len-1)
  return APath


/* Query installation path if not already set */
QueryInstallPath:
  if InstallPath = '' then do
    call ShowCopyright
    say 'Enter the path where SVDisk is installed.'
    InstallPath = GetPath(InstallPath)
  end
  return


/* Copy distribution files to the install path */
CopyFiles:
  call ShowCopyright
  /* Remove *.ENG, *.GER files */
  i = 0
  do until MessageFile.i = ''
    del InstallPath||'\'||MessageFile.i||'.ENG' '> nul 2>nul'
    del InstallPath||'\'||MessageFile.i||'.GER' '> nul 2>nul'
    i = i + 1
  end
  i = 0
  do until InstallList.i = ''
    say '  Copying '||substr(InstallList.i, 1, 12, ' ')||' to '||InstallPath
    copy InstallList.i InstallPath '> nul 2>nul'
    if rc \= 0 then do
      say
      say 'Unable to copy '||InstallList.i||' to '||InstallPath
      say 'The file may be missing or the disk may be full.'
      exit
    end
    i = i + 1
  end
  return


/* Append InstallPath to end of PATH=/DPATH= if not already in it */
AppendInstallPath:
  position = pos(translate(InstallPath), translate(ConfigLine))
  if position = 0 then do
    len = length(ConfigLine)
    if substr(ConfigLine, len, 1) = ';' then
      return substr(ConfigLine, 1, len)||InstallPath
    else
      return substr(ConfigLine, 1, len)||';'||InstallPath
  end
  return ConfigLine


/* Update CONFIG.SYS for path/dpath */
UpdateConfig:
  FoundDevice = 0
  call ShowCopyright
  call charout, 'Updating '||BootDrive||'\Config.sys ... '
  call linein BootDrive||'\Config.sys', 1, 0
  NewConfig = SysTempFileName(BootDrive||'\Config.???')
  do until lines(BootDrive||'\Config.sys') = 0
    parse value linein(BootDrive||'\Config.sys') with ConfigLine
    if substr(strip(translate(ConfigLine)), 1, 9) = 'SET PATH=' then
      ConfigLine = AppendInstallPath(ConfigLine)
    if substr(strip(translate(ConfigLine)), 1, 10) = 'SET DPATH=' then
      ConfigLine = AppendInstallPath(ConfigLine)
    position = pos('SVDISK.SYS', strip(translate(ConfigLine)))
    if position > 0 & substr(strip(translate(ConfigLine)), 1, 7) = 'DEVICE=' then do
      ConfigLine = substr(strip(ConfigLine), 1, 7)||InstallPath||,
                   '\'||substr(ConfigLine, position, length(strip(ConfigLine))-position+1)
      FoundDevice = 1
    end
    position = pos('SVDC.EXE', strip(translate(ConfigLine)))
    if position > 0 & substr(strip(translate(ConfigLine)), 1, 5) = 'CALL=' then
        ConfigLine = substr(strip(ConfigLine), 1, 5)||InstallPath||,
                     '\'||substr(ConfigLine, position, length(strip(ConfigLine))-position+1)
    call lineout NewConfig, ConfigLine
  end
  /* Did we process any SVDISK.SYS?  If not, add a 1.44MB VFloppy by default */
  if FoundDevice = 0 then do
    call lineout NewConfig, 'DEVICE='||InstallPath||'\SVDisk.sys'
    len = length(AvailDrives)
    SVDiskDrive = D2C(C2D(substr(AvailDrives, len-1, 1))+1)||':'
    call lineout NewConfig, 'CALL='||InstallPath||'\SVDC.EXE /i '||,
         SVDiskDrive
  end
  call lineout NewConfig
  call lineout BootDrive||'\Config.sys'
  del BootDrive||'\Config.svd' '> nul 2>nul'
  ren BootDrive||'\Config.sys' 'Config.svd' '> nul 2>nul'
  ren NewConfig 'Config.sys' '> nul 2>nul'
  if rc = 0 then do
    say 'success.'
    ItemChecked.1 = 'X'
    if FoundDevice = 0 then do
      say
      say 'SVDisk is being installed as '||SVDiskDrive
      say
    end
  end
  else
    say 'failed.'
  call PressAnyKey
  return


InstallEnd:
  call SysCls
  say
  say
  say 'Super Virtual Disk INSTALL ended.'
  if ItemChecked.1 = 'X' then do
    say
    say 'Config.sys has been updated.  Please shutdown and reboot'
    say 'for the new changes to take effect.'
  end
  exit

