/* Roids 2.3 installation program */

  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'	/* Make REXX functions available */
  Call SysLoadFuncs

  Parse Arg InstallDir     					/* Command line parameter */
  Signal On Halt Name ErrorHandler       			/* Error handler */

  Call SysCls
  Say
  Say
  Say " Roids 2.3 Installation "
  Say " ---------------------- "

  If InstallDir=" " Then Do					/* If no path is given, get one from the user */
    Say
    Say " Please specify the name of the subdirectory to"
    Say " which you would like to install Roids, hit <Enter>"
    Say " to use the current directory, or type 'Q'<Enter>"
    Say " to quit."
    Say
    Say " For Example:	C:\OS2\ROIDS<Enter>"
    Say
    Say " Please specify:"					/* Prompt for input */

    Parse Value SysCurPos() with Row Col
    Col=Col+17
    Row=Row-1
    Call SysCurPos Row, Col
    Pull InstallDir
    If (InstallDir="Q")|(InstallDir="q") Then Exit		/* Quit if they hit 'Q' */
  End

  Say								/* Give a nice blank line */

  CurrentDir = directory()					/* Find the current directory */
  
  If (InstallDir=" ") Then InstallDir=CurrentDir		/* Set to the current directory if none given */

   If (CurrentDir\=directory(InstallDir)) Then Do                /* If installing to different dir, do copying bit */
    Command = '@CD 'directory(CurrentDir)			/* Switch back to installation dir */
    Command

    Call SysFileTree InstallDir, FileDirectory, 'D'		/* Search for new directory */

    If FileDirectory.0='0' Then Do				/* If not found, create it */
      Say " Now creating directory "InstallDir" . . ."
      rc=SysMkDir(InstallDir)
      If rc\=0 Then Do
	Say
	Say " UURGH! Sorry, the desired directory couldn't be created,"
	Say " probably because you specified an invalid directory name"
	Say " or the destination disk is write-protected.  Please re-run"
        Say " this command file and try again."
	Exit
      End
    End

    Say " Now copying files to "InstallDir" . . ."          			/* Now copy files */
    Call FileCopy 'INSTALL.CMD', InstallDir
    Call FileCopy 'ROIDS.EXE', InstallDir
    Call FileCopy 'ROIDS.HLP', InstallDir
    Call FileCopy 'README.TXT', InstallDir
    Call FileCopy '*.WAV', InstallDir
  End

  Say " Now creating/updating WPS program object . . ."			/* Now create/update the Desktop object*/                                       

  LastChar = substr(InstallDir,length(InstallDir),1)			/* See if directory terminates in a \ */

  If LastChar = "\" Then SetupString="EXENAME="InstallDir"ROIDS.EXE;STARTUPDIR="InstallDir
  Else SetupString="EXENAME="InstallDir"\ROIDS.EXE;STARTUPDIR="InstallDir

  rc=SysCreateObject("WPProgram","Roids 2.3","<WP_DESKTOP>",SetupString,UPDATE)
  If rc=0 Then Do
    Say
    Say " HUUURK! Sorry, couldn't create the Roids program object." 
    Exit  
  End

  Say " Now you get to read the README.TXT file . . ."

  Command='@E README.TXT'					/* Look at the README.TXT */
  Command

  Say
  Say " Hooray!  Roids 2.3 has been installed successfully!"

  Exit


/******* FileCopy procedure */

  FileCopy: Arg FileName, Destination
    
    Command='@Copy 'FileName' 'Destination' >NUL'
    Command
    If rc\=0 Then Do						/* Error copying file */
      Say
      Say " AAAGH! Error copying files. This is probably because"
      Say " the destination disk is write protected (a CD-ROM, for"
      Say " example) or a file is missing.  Please make sure that"
      Say " this program can find all the files listed in the"
      Say " README.TXT file and ensure that the destination disk"
      Say " isn't write protected, and try again."
      Exit
    End
    Return


/******* ErrorHandler procedure */

  ErrorHandler:

    Call SysCls
    Say " EEEEEH! Unknown error! - aborting installation . . ."
  Exit

