/********************************************************************
 *** WinSpawn.cmd - Command line use of the WinSpawn() routine to ***
 *** ver.2          spawn Windows commands from OS/2 to a Windows ***
 ***                session running WinSpawn.cmm using CEnvi for  ***
 ***                Windows.                                      ***
 ********************************************************************/

'@echo OFF'
VALUE(WINSPAWN_CMD,ARG(1),'OS2ENVIRONMENT')
'CEnvi.exe %0.cmd %1 %2 %3'
'SET WINSPAWN_CMD='
SIGNAL CENVI_EXIT

#include <WinSpawn.lib>

main(argc,argv)
{
   if ( argc < 3 ) {
      Instructions();
      exit(EXIT_FAILURE);
   }

   PipeName = argv[1];
   Command = WINSPAWN_CMD + 1 + strlen(PipeName);
   if ( !stricmp(Command,"EXIT") ) {
      WinSpawn(PipeName,WIN_SPAWN_EXIT,NULL);
   } else {
      if ( !strnicmp(Command,"WAIT",4) ) {
         Wait = True;
         Command += 5;
      } else {
         Wait = False;
      }
      WinSpawn(PipeName,Wait ? WIN_SPAWN_WAIT : WIN_SPAWN, Command);
   }
}

Instructions()
{
   puts("\a")
   puts("WinSpawn.cmd - Pass spawn command to Windows session's WinSpawn.cmm")
   puts("")
   puts("USAGE: WinSpawn <PipeSpec> <Command>")
   puts("")
   puts("WHERE: PipeSpec: unique name that CEnvi for Windows WinSpawn.cmm uses")
   puts("       Command: Any Spawn() command passed on to windows.  If command is")
   puts("                EXIT then simple end the WinSpawn.cmm session.  If the")
   puts("                first parameter is WAIT then waits for spawn command to")
   puts("                finish.")
   puts("")
   puts("EXAMPLES:")
   puts("   WinSpawn Foo clock.exe")
   puts("   WinSpawn Foo CEnvi #include \"WinTools.lib\" ShowWindow(\"Clock\",SW_MINIMIZE)")
   puts("")
   puts("NOTE: You must already have started WinSpawn.cmm in a Windows session with")
   puts("      a unique PIPESPEC name, such as:")
   puts("        start /WIN C:\\CEnviW\\CEnvi.exe C:\\CENVI2\\WinSpawn.cmm FOO 2000")
}

CENVI_EXIT:

