@echo OFF
REM *****************************************************
REM *** ShutDown.cmd - Shutdown or reboot the system. ***
REM *** ver.10                                        ***
REM *****************************************************

CEnvi %0.cmd %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO CENVI_EXIT

// Build the following list of processes that should not be killed
IMMORTAL_PROCESSES = {
      "PMSHELL",     // PM and WPS
      "HARDERR",     // OS/2 nasty error manager
      "FATMGR"       // stacker process
};

#define BOOTDOS_FLAG_FILE

main(argc,argv)
{
   ShutProcedure = NULL;
   ExtraArgs = "";
   StartCommand = "START \"Automated CEnvi ShutDown\" /N /WIN";  // default method for starting
   if ( argc == 2) {
      if ( !strcmpi(argv[1],"OFF") ) {
         ShutProcedure = "TurnOffSystem";
         ExtraArgs = argv[0];
      } else if ( !strcmpi(argv[1],"NICE") ) {
         ShutProcedure = "WinShutdownSystem";
         StartCommand = "CMD.EXE /C DETACH";
      } else if ( !strcmpi(argv[1],"REBOOT") ) {
         ShutProcedure = "RebootSystem";
      } else if ( !strcmpi(argv[1],"BOOTDOS") ) {
         ShutProcedure = "BootViaDualBoot";
      }
   } else if ( 2 < argc  &&  !strcmpi(argv[1],"SETBOOT") ) {
      ShutProcedure = "BootByCommand";
      // Build ExtraArgs to pass to SETBOOT
      ExtraArgs = "SETBOOT";
      for ( i = 2; i < argc; i++ ) {
         strcat(ExtraArgs," ");
         strcat(ExtraArgs,argv[i]);
      }
   }
   if ( NULL == ShutProcedure )
      Instructions();

   // turn off and flush lazy cache
   system("cache /LAZY:OFF"); suspend(2000);

   // start the shutdown or reboot code detached. Extra CMD.EXE /C is
   // added in case using 4OS2.
   system("%s CEnvi #include '%s,,,/*RESIDENT*/,:CENVI_EXIT' %s(`%s`)",
          StartCommand,argv[0],ShutProcedure,ExtraArgs);

   return EXIT_SUCCESS;
}

Instructions()
{
   printf("\a\n")
   puts(`ShutDown - Save desktop and shutdown or reboot`)
   puts(``)
   puts(`USAGE: ShutDown [ OFF | REBOOT | NICE | BOOTDOS | SETBOOT <SetbootArgs>]`)
   puts(``)
   puts(`Where: OFF: Force all windows and applications to close and shutdown for`)
   puts(`            power to be turned off or to wait for ctrl-alt-del.`)
   puts(`       REBOOT: Force all windows and applications to close and shutdown,`)
   puts(`               and then automatically reboot the system.`)
   puts(`       NICE: Standard shutdown, but do not force applications closed. You`)
   puts(`             will be asked to shutdown running applications.`)
   puts(`       BOOTDOS: Reboot via "BOOT /DOS" if using dual-boot`)
   puts(`       SETBOOT <SetBootArgs>: Reboot via SETBOOT if you have boot manager.`)
   puts(``)
   puts(`Note: All options except NICE attempt to save all new settings and close`)
   puts(`      windows or shut applications through various stages of severity.  These`)
   puts(`      options will not, for example, select File/Save from an editors menus`)
   puts(`      before terminating the editor.  If you have specific methods for closing`)
   puts(`      applications before shutting down, then call those before SHUTDOWN.`)
   puts(``)
   puts(`Examples: ShutDown REBOOT`)
   puts(`          ShutDown OFF`)
   puts(`          ShutDown BOOTDOS`)
   puts(`          ShutDown SETBOOT /IBA:DOS`)
   exit(EXIT_FAILURE);
}

/*RESIDENT*/

#include <WinMsg.lib>
#include <WinTools.lib>
#include <KeyPush.lib>

ForceEverythingToEnd()
{
   SaveAllWindows();    suspend(5000);
   CloseAllWindows();   suspend(5000);
   QuitAllWindows();    suspend(5000);
   KillAllProcesses();  suspend(5000);
}

PostToAllWindows(pMsg,pParam1,pParam2)
{  // send to all windows except for this one
   lEnum = WinBeginEnumWindows(HWND_DESKTOP);
   while ( lChild = WinGetNextWindow(lEnum) ) {
      if ( lChild != Info().WinHandle )
         WinPostMsg(lChild,pMsg,pParam1,pParam2,False);
   }
   WinEndEnumWindows(lEnum);
}

SaveAllWindows()  // Post WM_SAVEAPPLICATION to all windows
{
   printf("Send WM_SAVEAPPLICATION to all windows...");
   #define WM_SAVEAPPLICATION 0x003e
   PostToAllWindows(WM_SAVEAPPLICATION,0,0);
   printf("\b\b\b\n");
}

CloseAllWindows()  // Post WM_CLOSE to all windows
{
   printf("Send WM_CLOSE to all windows...");
   #define WM_CLOSE  0x0029
   PostToAllWindows(WM_CLOSE,0,0);
   printf("\b\b\b\n");
}

QuitAllWindows()  // Post WM_QUIT to any remaining windows
{
   printf("Send WM_QUIT to all windows...");
   #define WM_QUIT   0x002a
   PostToAllWindows(WM_QUIT,0,0);
   printf("\b\b\b\n");
}

KillAllProcesses()  // Kill any remaining processes, except for a
{                 // select few (including this one)
   ImmortalCount = 1 + GetArraySpan(IMMORTAL_PROCESSES);

   PList = ProcessList();
   for ( i = 0; i < GetArraySpan(PList); i++ ) {
      ProcessName = SplitFileName(PList[i].name).name;
      printf("Process: %s - ",ProcessName);

      // don't kill if it is this process
      if ( PList[i].id == Info().Process ) {
         printf("don't kill myself\n");
         continue;
      }

      // don't kill if this is one of the IMMORTAL_PROCESSES
      for ( j = 0; j < ImmortalCount; j++ ) {
         ProcessName = SplitFileName(PList[i].name).name;
         if ( !stricmp(ProcessName,IMMORTAL_PROCESSES[j]) )
            break;
      }
      if ( j < ImmortalCount ) {
         printf("don't kill immortal process\n");
         continue;
      }

      #define DKP_PROCESSTREE    0  // kill process and all descendents, if created by this process
      #define DKP_PROCESS        1  // kill any process even if not created by this process
      #define ORD_DOS32KILLPROCESS  235
      DynamicLink("doscalls",ORD_DOS32KILLPROCESS,BIT32,CDECL,DKP_PROCESS,PList[i].id)
      printf("killed\n");
   }
}

TurnOffSystem(ShutdownScriptName)   // brutal shutdown
{
   ForceEverythingToEnd();
   printf("CMD.EXE /C DETACH CEnvi #include '%s,,,/*RESIDENT*/,:CENVI_EXIT' WinShutdownSystem()\n",
          ShutdownScriptName);
   system("CMD.EXE /C DETACH CEnvi #include '%s,,,/*RESIDENT*/,:CENVI_EXIT' WinShutdownSystem()",
          ShutdownScriptName);
}

WinShutdownSystem()  // Execute the WinShutdownSystem() function
{
   suspend(3000);
   // Get Msg Queue of this window
   #define ORD_WIN32QUERYWINDOWULONG   843
   #define QWL_HMQ   (-4)
   MsgQueue = DynamicLink("PMWIN",ORD_WIN32QUERYWINDOWULONG,BIT32,CDECL,
                          Info().WinHandle,QWL_HMQ);

   // Call WinShutdownSystem()
   #define  ORD_WIN32SHUTDOWNSYSTEM 149
   DynamicLink("PMWP",ORD_WIN32SHUTDOWNSYSTEM,BIT32,CDECL,
               Info().hab,MsgQueue);
}

RebootSystem() // mimick ctrl-alt-del reboot
{
   ForceEverythingToEnd();
   suspend(8000);
   printf("Rebooting...");
   #define ORD_DOS32OPEN   273
   #define FILE_NORMAL     0x0000
   #define FILE_OPEN       0x0001
   #define OPEN_SHARE_DENYNONE      0x0040
   #define OPEN_ACCESS_READWRITE    0x0002
   if ( !DynamicLink("doscalls",ORD_DOS32OPEN,BIT32,CDECL,
                     "\\DEV\\DOS$",FileHandle,ActionTaken,0,
                     FILE_NORMAL,FILE_OPEN,
                     OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE,0) ) {

      // Send call to DosShutdown to clear all buffers
      #define ORD_DOS32SHUTDOWN  415
      //DynamicLink("doscalls",ORD_DOS32SHUTDOWN,BIT32,CDECL,0);

      // send reboot command to device
      #define ORD_DOS32DEVIOCTL     284
      #define CATEGORY_DOSSYS       0xD5
      #define FUNCTION_REBOOT       0xAB
      DynamicLink("doscalls",ORD_DOS32DEVIOCTL,BIT32,CDECL,
                  FileHandle,CATEGORY_DOSSYS,FUNCTION_REBOOT,
                  NULL,0,NULL,NULL,0,NULL);
   }
}

BootByCommand(BootCommand)
{
   ForceEverythingToEnd();
   suspend(8000);
   printf("%s\n",BootCommand);
   system(BootCommand);
}

BootViaDualBoot()
{
   ForceEverythingToEnd();
   suspend(8000);
   puts(`Start "BOOT /DOS"`);
   system(`start "BOOT /DOS" /N /F /WIN BOOT /DOS`);
   suspend(5000);
   puts(`Send "Y" to "BOOT /DOS"`);
   system(`TextWin "BOOT /DOS" Y\r`);
}

:CENVI_EXIT
IF NOT ERRORLEVEL 1 EXIT
