EXTPROC CEnvi
//************************************************************************
//*** Session.cmd - Allow to start any type of session at any location ***
//*** ver.7         with any title and position.  Etc...  This could   ***
//***               be used in place of OS/2's START command.  And it  ***
//***               runs much quicker if you /BIND it.                 ***
//************************************************************************

// This is a list of Default DOS settings, change to what you like.  If
// left commented out then will retain system default.  Any values set
// here will be overwritten by value input at command line.  For those
// options where many text strings are avaialable, remove comments from
// ONE AND ONLY ONE of the choices

MyDefaultDOSSettings = {
   //"COM_DIRECT_ACCESS=0",  // 0 or 1
   //"COM_HOLD=0",           // 0 or 1
   //"COM_RECEIVE_BUFFER_FLUSH="   // select one of the following
      //"ALL",
      //"RECEIVE DATA INTERRUPT ENABLE",
      //"SWITCH TO FOREGROUND",
      //"NONE",
   //"COM_SELECT="
      //" ALL",
      //"COM1",
      //"COM2",
      //"COM3",
      //"COM4",
      //"NONE",
   //"DOS_AUTOEXEC=C:\\AUTOEXEC.BAT",
   "DOS_BACKGROUND_EXECUTION=1", // 0 or 1
   //"DOS_BREAK=1", // 0 or 1
   //"DOS_DEVICE=SIZE=0  C:\\OS2\\MDOS\\ANSI.SYS",
   //"DOS_FCBS=16",
   //"DOS_FCBS_KEEP=8",
   //"DOS_FILES=75",
   //"DOS_HIGH=0",  // 0 or 1
   //"DOS_LASTDRIVE=Z",
   //"DOS_RMSIZE=640",
   //"DOS_SHELL=C:\\OS2\\MDOS\\COMMAND.COM C:\\OS2\\MDOS",
   //"DOS_UMB=0",   // 0 or 1
   "DOS_VERSION=DCJSS02.EXE,3,40,255"
      "\nDFIA0MOD.SYS,3,40,255"
      "\nDXMA0MOD.SYS,3,40,255"
      "\nEXCEL.EXE,10,10,4"
      "\nIBMCACHE.COM,3,40,255"
      "\nIBMCACHE.SYS,3,40,255"
      "\nISAM.EXE,3,40,255"
      "\nISAM2.EXE,3,40,255"
      "\nISQL.EXE,3,40,255"
      "\nMSD.EXE,5,00,255"
      "\nNET3.COM,3,40,255"
      "\nNETX.COM,4,00,255"
      "\nNETX.EXE,5,00,255"
      "\nPSCPG.COM,3,40,255"
      "\nSAF.EXE,3,40,255"
      "\nWIN200.BIN,10,10,4",
   //"DPMI_DOS_API="   // select one of the following
      //"AUTO",
      //"ENABLED",
      //"DISABLED",
   //"DPMI_MEMORY_LIMIT=4",
   //"DPMI_NETWORK_BUFF_SIZE=8",
   //"EMS_FRAME_LOCATION="
      //"AUTO",
      //"NONE",
      //"C000",
      //"C400",
      //"C800",
      //"CC00",
      //"D000",
      //"D400",
      //"D800",
      //"DC00",
      //"8000",
      //"8400",
      //"8800",
      //"8C00",
      //"9000",
   //"EMS_HIGH_OS_MAP_REGION=0",
   //"EMS_LOW_OS_MAP_REGION=384",
   //"EMS_MEMORY_LIMIT=2048",
   //"HW_NOSOUND=0",      // 0 or 1
   //"HW_ROM_TO_RAM=0",   // 0 or 1
   //"HW_TIMER=0",        // 0 or 1
   //"IDLE_SECONDS=0",
   //"IDLE_SENSITIVITY=75",
   //"INT_DURING_IO=0",   // 0 or 1
   //"KBD_ALTHOME_BYPASS=0", // 0 or 1
   //"KBD_BUFFER_EXTEND=1",  // 0 or 1
   "KBD_CTRL_BYPASS="   // select one of the following
      "NONE",
      //"ALT_ESC",
      //"CTRL_ESC",
   //"KBD_RATE_LOCK=0",   // 0 or 1
   //"MEM_EXCLUDE_REGIONS=",
   //"MEM_INCLUDE_REGIONS=",
   //"MOUSE_EXCLUSIVE_ACCESS=0",   // 0 or 1
   //"NETWARE_RESOURCES=" // select one of the following
      //"PRIVATE",
      //"GLOBAL ",
      //"NONE   ",
   //"PRINT_SEPARATE_OUTPUT=1",    // 0 or 1
   //"PRINT_TIMEOUT=15",
   //"VIDEO_8514A_XGA_IOTRAP=1",   // 0 or 1
   //"VIDEO_FASTPASTE=0",          // 0 or 1
   //"VIDEO_MODE_RESTRICTION="  // select one of the following
      //"NONE         ",
      //"CGA            ",
      //"MONO           ",
   //"VIDEO_ONDEMAND_MEMORY=1",    // 0 or 1
   //"VIDEO_RETRACE_EMULATION=1",  // 0 or 1
   //"VIDEO_ROM_EMULATION=1",      // 0 or 1
   //"VIDEO_SWITCH_NOTIFICATION=0",// 0 or 1
   //"VIDEO_WINDOW_REFRESH=1",
   //"XMS_HANDLES=32",
   //"XMS_MEMORY_LIMIT=2048",
   //"XMS_MINIMUM_HMA=0",
};

#define WINDOWS_EXECUTABLE    "WINOS2.COM"
#define DEFAULT_WINDOWS_PROG  "PROGMAN.EXE"
#define INTERVAL_BETWEEN_LOOKS   1000  // how long to wait between checking if
                                       // window exists yet
#define MAXIMUM_LOOKS_FOR_WINDOW 25    // after looking 25 times for window,
                                       // then give up
#define WAIT_INTERVAL            1500  // how many milliseconds (approx.) to
                                       // wait between checking if session has
                                       // ended; if /WAIT specified

// To start Full-screen window, must define where to locate CEnvi
// for windows and also define a file name to pass the information in.
//#define CENVI_FOR_WINDOWS     `E:\Nombas\CEnvi\Win\CEnvi.exe`
//#define CENVIW_COMMAND_FILE   `E:\TEMP\_FS_WIN.CMM`


#include <OptParms.lib>    // for parsing command-line parameters
#include <Profile.lib>     // for getting and setting font size or objects
#include <PMdll.lib>       // used by WinTools.lib
#include <WinTools.lib>    // adjust window size and position

main(argc,argv)
{
   if ( argc == 1
     || OptionalParameter(argc,argv,"?")
     || OptionalParameter(argc,argv,"help")
     || OptionalParameter(argc,argv,"h") ) {
      Instructions();
      success = False;
   } else {
      ParseInputParameters(argc,argv);

      if ( !ObjectSupplied ) {
         if ( Windows && FullScreen && BackGround )
            BuildCEnviForWindowsCode();
         StartData = BuildStartData();
      }

      if ( Background )
         RememberActiveWindow = GetActiveWindow();

      if ( SetFont ) {
         GetCharacterFont(SaveWidth,SaveHeight);
         SetCharacterFont(FontX,FontY);
      }

      if ( LocateTitle )
         OldWindowList = BuildWindowList();
      else
         OldSwitchList = WinQuerySwitchList(Info().hab);

      success = ObjectSupplied ? StartObject() : StartSession(StartData);

      if ( SetFont ) {
         if ( ObjectSupplied )
            suspend(750); // objects sometimes need a little extra time to get going
         SetCharacterFont(SaveWidth,SaveHeight);
      }

      if ( success ) {

         if ( Windows && FullScreen && BackGround )
            WaitForCEnviForWindowsToEnd();

         if ( MustWait || Background || WantBig || Maximized
           || Minimized || Restored || ForeGround || WantSetSize
           || WantSetPosition || Hidden || TitleSupplied ) {

            if ( PreDelay )  suspend(PreDelay);

            if ( !(WinHandle = LocateTitle
                             ? FindNewWindowTitle(OldWindowList)
                             : FindNewSwitchWindowHandle(OldSwitchList,SwitchHandle)) ) {
               printf("\n\aUnable to locate \"%s\"\n",Title);
               success = False;
            } else {
               if ( PostDelay )  suspend(PostDelay);
               AdjustWindow(WinHandle,SwitchHandle);
            }
         }
      }

      if ( Background )
         SetActiveWindow(RememberActiveWindow);

      if ( success && MustWait ) {
         // hang around until WinHandle is no longer valid
         do {
            suspend(WAIT_INTERVAL);
         } while ( IsWindow(WinHandle) );
      }

   }
   return success ? EXIT_SUCCESS : EXIT_FAILURE ;
}

ForeGround, BackGround;
PreDelay, PostDelay;
Title; TitleSupplied;
LocateTitle;
ObjectID; ObjectSupplied;
InheritConfigSysEnvironment;
FullScreen, Windowed, PresentationManager, DOSApplication;
Windows, Enhanced, Separate;
IconFile;
Hidden, Maximized, Minimized, Restored, WantBig, Keep, MustWait;
WantSetPosition, PosX, XFromRightEdge, PosY, YFromTopEdge;
WantSetSize, SizeX, SizeY;
SetFont, FontX, FontY;
UseDosSettings;
ProgramName, ProgramInputs;
#define ERROR_BUFFER_SIZE  300
ErrorBuffer[0] = ErrorBuffer[ERROR_BUFFER_SIZE+1] = '\0';

ParseInputParameters(argc,argv)
{
   ForeGround = OptionalParameter(argc,argv,"F");
   BackGround = OptionalParameter(argc,argv,"B");
   Title = NULL; TitleSupplied = OptionalParameter(argc,argv,"TITLE",Title);
   if ( !OptionalParameter(argc,argv,"LOCATE",LocateTitle) ) LocateTitle = NULL;
   if ( (ObjectSupplied = OptionalParameter(argc,argv,"OBJ",ObjectID)) && !Title )
      strcpy(Title,ObjectID);
   PreDelay = OptionalParameter(argc,argv,"PREDELAY",lTemp)
            ? atoi(lTemp) : 0 ;
   PostDelay = OptionalParameter(argc,argv,"POSTDELAY",lTemp)
             ? atoi(lTemp) : 0 ;
   InheritConfigSysEnvironment = OptionalParameter(argc,argv,"I");
   FullScreen = OptionalParameter(argc,argv,"FS");
   Windowed = OptionalParameter(argc,argv,"WIN");
   PresentationManager = OptionalParameter(argc,argv,"PM");
   DosApplication = OptionalParameter(argc,argv,"DOS");
   Enhanced = OptionalParameter(argc,argv,"ENH");
   Separate = OptionalParameter(argc,argv,"SEP");
   Windows = OptionalParameter(argc,argv,"W")
          || Separate || Enhanced ;
   IconFile = NULL; OptionalParameter(argc,argv,"ICON",IconFile);
   Hidden = OptionalParameter(argc,argv,"HID");
   Maximized = OptionalParameter(argc,argv,"MAX");
   Minimized = OptionalParameter(argc,argv,"MIN");
   Restored = OptionalParameter(argc,argv,"RESTORE");
   WantBig = OptionalParameter(argc,argv,"BIG");
   Keep = OptionalParameter(argc,argv,"K");
   MustWait = OptionalParameter(argc,argv,"WAIT");
   XFromRightEdge = YFromTopEdge = False;
   if ( WantSetPosition = OptionalParameter(argc,argv,"POS",string) ) {
      // Check for XFromRightEdge
      if ( 'r' == tolower(string[0]) ) {
         XFromRightEdge = True;
         string++;
      }
      // Check for YFromTopEdge
      lTopCharOff = strcspn(string,"Xx,") + 1;
      if ( 't' == tolower(string[lTopCharOff]) ) {
         YFromTopEdge = True;
         strcpy(string+lTopCharOff,string+lTopCharOff+1);
      }
      WantSetPosition = ScanfRowCol(string,PosX,PosY);
   }
   WantSetSize = ( OptionalParameter(argc,argv,"SIZE",string)
                && ScanfRowCol(string,SizeX,SizeY) );
   SetFont = ( OptionalParameter(argc,argv,"FONT",string)
            && ScanfRowCol(string,FontY,FontX) );
   UseDosSettings = DosApplication || Windows;
   while ( OptionalParameter(argc,argv,"SET",string) ) {
      UseDosSettings = True;
      switch ( string[0] ) {
         case '@':
            GetSettingsFromFile(string+1);
            break;
         case '#':
            GetSettingsFromEnvironmentVariable(string+1);
            break;
         default:
            AddNewSetting(string);
            break;
      }
   }

   // any further arguments are the ProgramName and ProgramInputs
   ProgramName = (argc == 1) ? NULL : argv[1] ;
   if ( argc < 3 ) {
      ProgramInputs = NULL;
   } else {
      // build program input string of all further arguments together
      strcpy(ProgramInputs,argv[2]);
      for ( i = 3; i < argc; i++ ) {
         strcat(ProgramInputs," ");
         strcat(ProgramInputs,argv[i]);
      }
   }

   if ( Windows ) {
      // Windows needs a default program, so use Program Manager
      if ( NULL == ProgramName )
         ProgramName = DEFAULT_WINDOWS_PROG;
   }

   if ( !Title ) {
      // YUCK!!! No one likes a session with no title. So give it one.
      // Title will be all but path of ProgramName.  But if no program
      // name then will match the sesion type.
      if ( ProgramName != NULL ) {
         strcpy(Title,ProgramName + strlen(SplitFileName(ProgramName).dir));
      }
      if ( !Title || !Title[0] ) {
         // Get name from session type
         if ( UseDosSettings ) Title = "DOS Session";
         else if ( Windows ) Title = "Windows Session";
         else if ( PresentationManager ) Title = "PM Session";
         else Title = "Session";
      }
   }

}

ScanfRowCol(string,Row,Col)  // scan ROWxCOL or ROWXCOL or ROW,COL, or return FALSE
{
   return( 2 == sscanf(string,"%dx%d",Row,Col)
        || 2 == sscanf(string,"%dX%d",Row,Col)
        || 2 == sscanf(string,"%d,%d",Row,Col) );
}

MyDefaultDOSSettings;

AddNewSetting(setting)
   // add setting string to MyDefaultDOSSettings, or replace one that is
   // already there if it has the same "NAME=VALUE" name
{
   // Find the length of variable name: all characters before '='
   VarLen = strcspn(setting,"=");
   if ( 0 == VarLen  ||  strlen(setting) == VarLen ) {
      printf("\n\aInvalid setting \"%s\" ignored.",setting);
      printf("\nPress any key to continue...");
      getch();
      printf("\n");
   } else {
      SettingIndex = 0;
      if ( defined(MyDefaultDOSSettings) ) {
         // check existing settings if this is already in the list
         MaxSettingIndex = GetArraySpan(MyDefaultDOSSettings);
         for( ; SettingIndex <= MaxSettingIndex; SettingIndex++ ) {
            if ( !memicmp(MyDefaultDOSSettings[SettingIndex],setting,
                          VarLen+1) )
               break;
         }
      }
      strcpy(MyDefaultDOSSettings[SettingIndex],setting);
   }
}

GetSettingsFromFile(FileName)
   // read in each setting line from file, and add to DOS settings
{
   fp = fopen(FileName,"r");
   if ( NULL == fp ) {
      printf("\n\aUnable to open settings file \"%s\"",FileName);
      printf("\nPress any key to continue...");
      getch();
      printf("\n");
   } else {
      while ( NULL != (setting = fgets(fp)) ) {
         if ( '\n' == setting[len = strlen(setting) - 1] )
            setting[len] = 0;
         if ( ';' != setting[0]  &  '\0' != setting[0] )
            AddNewSetting(setting);
      }
      fclose(fp);
   }
}

GetSettingsFromEnvironmentVariable(evar)
   // get settings from environment variable, if there is one.  Individual
   // setting statements are separated by semi-colons
{
   if ( NULL != (string = getenv(evar)) ) {
      for ( NextString = strtok(string,";");
            NULL != NextString; NextString = strtok(NULL,";") ) {
         if ( NULL != (EqualPosition = strchr(NextString,',')) ) {
            EqualPosition[0] = '=';
            AddNewSetting(NextString);
         }
      }
   }
}

DetermineSessionType()
   // return integer representing the TYPE of session to start
{
   #define SESSION_DEFAULT             0
   #define SESSION_OS2_FULLSCREEN      1
   #define SESSION_WINDOWABLEVIO       2
   #define SESSION_PM                  3
   #define SESSION_DOS_FULLSCREEN      4
   #define SESSION_DOS_WINDOWED        7
   #define SESSION_WIN_STD_SEPARATE    15
   #define SESSION_WIN_STD             16
   #define SESSION_WIN_ENH_SEPARATE    17
   #define SESSION_WIN_ENH             18
   #define SESSION_WIN_ENH_FULLSCREEN  19
   #define SESSION_WIN_STD_FULLSCREEN  20

   if ( PresentationManager ) return SESSION_PM;
   if ( Windows ) {
      if ( Separate )
         return Enhanced ? SESSION_WIN_ENH_SEPARATE : SESSION_WIN_STD_SEPARATE;
      if ( FullScreen )
         // return Enhanced ? SESSION_WIN_ENH_FULLSCREEN : SESSION_WIN_STD_FULLSCREEN;
         return SESSION_DOS_FULLSCREEN;
      return Enhanced ? SESSION_WIN_ENH : SESSION_WIN_STD;
   }
   if ( UseDosSettings ) {
      return ( Windowed && !FullScreen )
           ? SESSION_DOS_WINDOWED : SESSION_DOS_FULLSCREEN ;
   }
   if ( FullScreen ) return SESSION_OS2_FULLSCREEN;
   if ( Windowed ) return SESSION_WINDOWABLEVIO;
   return SESSION_DEFAULT;
}

GetDOSSettingsString()
   // return MyDefaultDOSSettings() array as a large string where each
   // element is separaterd by a NULL byte
{
   string = SettingString = "";
   count = GetArraySpan(setting = MyDefaultDOSSettings);
   while( 0 <= count-- ) {
      strcpy(string,setting[0]);
      string += strlen(string) + 1;
      setting++;
   }
   string[0] = '\0';
   return SettingString;
}


PgmName, PgmInputs, env; // globals used in following function
BuildStartData()
   // Build the StartData structure (BLOb) based on the global data already
   // retrieved.  Return the blob
{
   BLObPut(data,0,UWORD16); // size of block; we'll get back to this
      #define SSF_RELATED_INDEPENDENT 0
      #define SSF_RELATED_CHILD       1
   BLObPut(data,SSF_RELATED_INDEPENDENT,UWORD16);
      #define SSF_FGBG_FORE   0
      #define SSF_FGBG_BACK   1
   BLObPut(data,ForeGround || (Windows && FullScreen && BackGround) ? SSF_FGBG_FORE : SSF_FGBG_BACK,UWORD16);
      #define SSF_TRACEOPT_NONE       0
      #define SSF_TRACEOPT_TRACE      1
      #define SSF_TRACEOPT_TRACEALL   2
   BLObPut(data,SSF_TRACEOPT_NONE,UWORD16);
   if ( Windows  &&  NULL != Title && !Fullscreen ) {
      sprintf(Title-8,"Session:%s",Title);
      BLObPut(data,pointer(Title)-8,UWORD32);
   }
   else
      BLObPut(data,Title ? pointer(Title) : NULL,UWORD32);

   // Preform a cheat here with the ProgramName and inputs so that
   // windows programs will be started by WINOS2.COM and be set
   // to enhanced mode if that is wanted
   if ( Windows ) {
      PgmName = WINDOWS_EXECUTABLE;
      if ( NULL == ProgramInputs )
         PgmInputs = ProgramName;
      else
         sprintf(PgmInputs,"%s %s",ProgramName,ProgramInputs);
      if ( Enhanced ) {
         // Add /3 to parameters to start in enhanced mode
         if ( NULL == PgmInputs )
            PgmInputs = "/3";
         else
            sprintf(PgmInputs,"/3 %s",PgmInputs);
      }
   } else {
      PgmName = ProgramName;
      PgmInputs = ProgramInputs;
   }

   BLObPut(data,PgmName ? pointer(PgmName) : NULL,UWORD32);
   BLObPut(data,PgmInputs ? pointer(PgmInputs) : NULL,UWORD32);

   BLObPut(data,NULL,UWORD32);  // no termination queue
   if ( UseDosSettings  &&  defined(MyDefaultDOSSettings) ) {
      env = GetDOSSettingsString();
      BLObPut(data,pointer(env),UWORD32);
   } else {
      BLObPut(data,NULL,UWORD32);  // no environment setting
   }
      #define SSF_INHERTOPT_SHELL     0
      #define SSF_INHERTOPT_PARENT    1   // for DOS session, inherit drive and directory
   BLObPut( data,
            InheritConfigSysEnvironment ? SSF_INHERTOPT_SHELL : SSF_INHERTOPT_PARENT,
            UWORD16 );
   BLObPut(data,DetermineSessionType(),UWORD16);
   BLObPut(data,IconFile ? pointer(IconFile) : NULL,UWORD32);
   BLObPut(data,NULL,UWORD32);  // no program handle

   #define SSF_CONTROL_VISIBLE     0x0000
   #define SSF_CONTROL_INVISIBLE   0x0001
   #define SSF_CONTROL_MAXIMIZE    0x0002
   #define SSF_CONTROL_MINIMIZE    0x0004
   #define SSF_CONTROL_NOAUTOCLOSE 0x0008
   #define SSF_CONTROL_SETPOS      0x8000
   PgmControl = 0;
   if ( Hidden ) PgmControl |= SSF_CONTROL_INVISIBLE;
   if ( Maximized ) PgmControl |= SSF_CONTROL_MAXIMIZE;
   if ( Minimized ) PgmControl |= SSF_CONTROL_MINIMIZE;
   if ( Keep ) PgmControl |= SSF_CONTROL_NOAUTOCLOSE;
   if ( (WantSetPosition || WantSetSize) && !Windowed )
      PgmControl |= SSF_CONTROL_SETPOS;
   BLObPut(data,PgmControl,UWORD16);

   if ( !WantSetPosition ) PosX = PosY = 0;
   if ( !WantSetSize ) SizeX = SizeY = 0;
   if ( Windowed ) {
      for ( lNoSet = 0; lNoSet < 4; lNoSet++ )
         BLObPut(data,0,SWORD16);
   } else {
      BLObPut(data,PosX,SWORD16);
      BLObPut(data,PosY,SWORD16);
      BLObPut(data,SizeX,SWORD16);
      BLObPut(data,SizeY,SWORD16);
   }
   BLObPut(data,0,SWORD16);      // reserved byte; required

   BLObPut(data,pointer(ErrorBuffer),UWORD32);
   BLObPut(data,ERROR_BUFFER_SIZE,UWORD32);

   BLObPut(data,0,BLObSize(data),UWORD16); // size of block
   return data;
}

StartSession(StartData)
   // call OS/2 start session functions
{
   #define ORD_DOS32STARTSESSION 37
   rc = DynamicLink("SESMGR",ORD_DOS32STARTSESSION,BIT32,CDECL,
                    StartData,DummySessionID,DummyProcessID);

   #define ERROR_SMG_START_IN_BACKGROUND   457
   if ( rc  &&  ERROR_SMG_START_IN_BACKGROUND != rc ) {
      printf("Error %d starting session\a\a\n",rc);
      if ( 0 < strlen(ErrorBuffer) )
         printf("Error in object: %s\n",ErrorBuffer);
      return(False);
   }
   return(True);
}

StartObject()
{
   lSetupString = "OPEN=DEFAULT;";
   if ( ( !(lObject = WinQueryObject(ObjectID))
       && !(lObject = FindWPSProgramObject(ObjectID)) )
     || !WinSetObjectData(lObject,lSetupString) ) {
      printf("Error: could not locate or start object \"%s\"\a\a\n",ObjectID);
      return(False);
   }
   return(True);
}

FindWPSProgramObject(pObjectSpec)
   // assume this is an object in a folder, but not a real object, and
   // so search the OS2.INI file for information to get this object
{
   // separate folder from object, if no folder then assume desktop
   lFileParts = SplitFileName(pObjectSpec);
   lFolderName = lFileParts.dir;
   if ( !lFolderName[0] ) {
      // no folder spec, so use desktop
      lFolderID = 0xFFFF & WinQueryObject("<WP_DESKTOP>");
   } else {
      if ( '\\' == lFolderName[(lLen = strlen(lFolderName))-1] )
         lFolderName[--lLen] = 0;
      lFolderID = 0xFFFF & WinQueryObject(lFolderName);
   }
   if ( lFolderID ) {

      // create buffer that is the string to search objects for
      sprintf(lObjectName,"%s%s",lFileParts.name,lFileParts.ext);
      lMatchBufLen = 2 + strlen(lObjectName) + 1;
      BLObPut(lMatchBuf,0,lMatchBufLen-2,UWORD16);
      BLObPut(lMatchBuf,2,lObjectName,lMatchBufLen-2);

      // Find this folder in OS2.INI under PM_Abstract:FldrContent
      sprintf(lKey,"%X",lFolderID);
      BLObSize(lData,lDataSize=4000);
      if ( PrfQueryProfileData(HINI_USERPROFILE,"PM_Abstract:FldrContent",lKey,
                               lData,lDataSize) ) {
         // try on each object within this folder
         for ( lOffset = 0; lOffset < lDataSize; lOffset += 4 ) {
            lObjectID = BLObGet(lData,lOffset,UWORD32);
            // try to find this object ID within PM_Abstract:Objects
            sprintf(lKey,"%X",lObjectID);
            BLObSize(lObjData,lObjDataSize=4000);
            if ( PrfQueryProfileData(HINI_USERPROFILE,"PM_Abstract:Objects",lKey,
                                     lObjData,lObjDataSize) ) {
               while ( 0 < lObjDataSize
                    && NULL != (lFindData=memchr(lObjData,lMatchBuf[0],lObjDataSize)) ) {
                  if ( !memicmp(lFindData,lMatchBuf,lMatchBufLen) )
                     // YEA! FINALLY THE OBJECT WAS FOUND
                     return( 0x20000 | lObjectID );
                  lDataSkip = lFindData - lObjData + 1;
                  lObjDataSize -= lDataSkip;
                  lObjData += lDataSkip;
               }
            }
         }
      }
   }
   return(NULL);
}

GetCharacterFont(FontWidth,FontHeight)
{
   // Get current size
   BLObSize(current,2);
   PrfQueryProfileData(HINI_USERPROFILE,"Shield","~Font Size...",current,2);
   FontHeight = BLObGet(current,1,UWORD8);
   FontWidth = BLObGet(current,0,UWORD8);
}

SetCharacterFont(FontWidth,FontHeight)
{
   BLObPut(new,0,FontWidth,UWORD8);
   BLObPut(new,1,FontHeight,UWORD8);
   PrfWriteProfileData(HINI_USERPROFILE,"Shield","~Font Size...",new,2);
}

FindNewSwitchWindowHandle(pOldSwitchList,pSwitchHandle)
{
   lOldSwitchCount = 1 + GetArraySpan(pOldSwitchList);

   // keep trying until window has been found
   for ( retry = MAXIMUM_LOOKS_FOR_WINDOW; retry; retry--, suspend(INTERVAL_BETWEEN_LOOKS) ) {

      lNewSwitchCount = 1 + GetArraySpan(lNewSwitchList = WinQuerySwitchList(Info().hab));

      for ( lSwitchIdx = 0; lSwitchIdx < lNewSwitchCount; lSwitchIdx++ ) {
         lSwitchHandle = lNewSwitchList[lSwitchIdx];
         for ( lIdx = 0; lIdx < lOldSwitchCount; lIdx++ ) {
            if ( pOldSwitchList[lIdx] == lSwitchHandle )
               // this entry was already in our list, so ignore it
               break;
         }
         if ( lIdx == lOldSwitchCount
           && !WinQuerySwitchEntry(lSwitchHandle,lSwitchData) ) {

            // This is new entry.  If it is not the false seamless windows
            // entry then use it.
            if ( Windows && !FullScreen && !strcmp(Title-8,lSwitchData.title) )
               continue;

            // if null window handle then try to find window with this process
            if ( !lSwitchData.hwnd ) {
               lSwitchData.hwnd = FindWindowForProcess(lSwitchData.process);
            }

            if ( lSwitchData.hwnd ) {
               pSwitchHandle = lSwitchHandle;
               return( lSwitchData.hwnd );
            }
         }
      }
   }
   return(NULL);
}

FindWindowForProcess(pID)  // return window with this process ID
{
   lEnum = WinBeginEnumWindows(HWND_DESKTOP);
   while ( lHwnd = WinGetNextWindow(lEnum) ) {
      #define ORD_WIN32QUERYWINDOWPROCESS  838
      undefine(lProcessID); undefine(lThreadID);
      if ( DynamicLink( "PMWIN", ORD_WIN32QUERYWINDOWPROCESS, BIT32, CDECL,
                        lHwnd, lProcessID, lThreadID )
        && pID == lProcessID )
         break;
   }
   WinEndEnumWindows(lEnum);
   return ( lHwnd );
}

FindNewWindowTitle(pOldWindowList)
{
   lOldWindowCount = 1 + GetArraySpan(pOldWindowList);
   lTitleLen = strlen(LocateTitle);

   // keep trying until window has been found
   for ( retry = MAXIMUM_LOOKS_FOR_WINDOW; retry; retry--, suspend(INTERVAL_BETWEEN_LOOKS) ) {

      lNewWindowCount = 1 + GetArraySpan(lNewWindowList = BuildWindowList());

      for ( lWinIdx = 0; lWinIdx < lNewWindowCount; lWinIdx++ ) {
         lWinHandle = lNewWindowList[lWinIdx];
         for ( lIdx = 0; lIdx < lOldWindowCount; lIdx++ ) {
            if ( pOldWindowList[lIdx] == lWinHandle )
               // this entry was already in our list, so ignore it
               break;
         }
         if ( lIdx == lOldWindowCount
           && (lTitle = GetWindowTitle(lWinHandle))
           && !strnicmp(lTitle,LocateTitle,lTitleLen) ) {
            return( lWinHandle );
         }
      }
   }
   return(NULL);
}

BuildWindowList() // return array of top-level windows
{
   lEnum = WinBeginEnumWindows(HWND_DESKTOP);
   for ( lIdx = 0; lHwnd = WinGetNextWindow(lEnum); lIdx++ )
      lList[lIdx] = lHwnd;
   WinEndEnumWindows(lEnum);
   return lList;
}

AdjustWindow(pHwnd,pSwitchHandle)
{
   if ( WantBig || Maximized ) {
      ShowWindow(pHwnd,ForeGround ? SW_SHOWMAXIMIZED : SW_SHOWMAXNOACTIVE);
      if ( WantBig ) {
         // get maximized size, then restore but at maximum size
         GetWindowRect(pHwnd,rect);
         ShowWindow(pHwnd,ForeGround ? SW_RESTORE : SW_RESTORENOACTIVE);
         SetWindowRect(pHwnd,rect);
      }
   }
   if ( Restored )
      ShowWindow(pHwnd,ForeGround ? SW_RESTORE : SW_RESTORENOACTIVE);
   if ( ForeGround ) {
      SetActiveWindow(pHwnd);
      WinSwitchToProgram(pSwitchHandle);
   }
   if ( WantSetPosition && (XFromRightEdge || YFromTopEdge) ) {
      // determine position relative to different edges of screen
      GetScreenSize(lScreenWidth,lScreenHeight);
      if ( !WantSetSize )
         GetSize(pHwnd,SizeX,SizeY);
      if ( XFromRightEdge )
         PosX = lScreenWidth - PosX - SizeX;
      if ( YFromTopEdge )
         PosY = lScreenHeight - PosY - SizeY;
   }
   if ( WantSetSize ) {
      if ( WantSetPosition )
         SetWindowPos(pHwnd,0,PosX,PosY,SizeX,SizeY,SWP_SIZE | SWP_MOVE);
      else
         SetSize(pHwnd,SizeX,SizeY);
   } else if ( WantSetPosition )
      SetPosition(pHwnd,PosX,PosY);
   if ( Minimized )
      ShowWindow(pHwnd,ForeGround ? SW_SHOWMINIMIZED : SW_SHOWMINNOACTIVE);
   if ( Hidden )
      ShowWindow(pHwnd,SW_HIDE);
   if ( TitleSupplied )
      SetWindowTitle(pHwnd,Title);
}

BuildCEnviForWindowsCode()
{
   // Build file to run this command via CEnvi for Windows so that
   // full-screen background windows can start that program.
   if ( !defined(CENVI_FOR_WINDOWS) || !defined(CENVIW_COMMAND_FILE) ) {
      printf("\aERROR! For Background Full-Screen windows sessions, must edit SESSION.CMD\n"
             "and #define CENVI_FOR_WINDOWS and CENVIW_COMMAND_FILE.\n");
      exit(EXIT_FAILURE);
   }
   if ( fp = fopen(CENVIW_COMMAND_FILE,"wt") ) {
      fprintf(fp,"#include <WinTools.lib>\n");
      fprintf(fp,"spawn(P_NOWAIT,`%s %s`);\n",ProgramName,ProgramInputs?ProgramInputs:"");
      fprintf(fp,"ShowWindow(`Desktop`,SW_RESTORE);\n");
      fprintf(fp,"remove(`%s`);",CENVIW_COMMAND_FILE);
      fclose(fp);
      ProgramName = CENVI_FOR_WINDOWS;
      ProgramInputs = CENVIW_COMMAND_FILE;
   }
}

WaitForCEnviForWindowsToEnd()
{
   for ( retry = MAXIMUM_LOOKS_FOR_WINDOW; retry; retry--, suspend(INTERVAL_BETWEEN_LOOKS) ) {
      if ( !Directory(CENVIW_COMMAND_FILE) )
         break;
   }
}

Instructions()
{
   puts(``)
   puts(`Session - Start a session`)
   puts(``)
   puts(`SYNTAX: Session [Options] [Command] [Command arguments...]`)
   puts(``)
   puts(`Options: /F - Start session in the foreground`)
   puts(`         /B - Start session in the background`)
   puts(`         /TITLE "Program Title" - Set Session Window Title`)
   puts(`            For Windows sessions this does not set window title`)
   puts(`         /I - Inherit environment of CONFIG.SYS, not current settings`)
   puts(`         /FS - Full-Screen DOS, OS/2, or Windows session`)
   puts(`         /WIN - Windowed DOS, OS/2, or Windows session`)
   puts(`         /PM - Presentation Manager application`)
   puts(`         /DOS - DOS application`)
   puts(`         /W - Windows application`)
   puts(`         /SEP - Separate Windows session (for /W)`)
   puts(`                Always Separate sessions in this version (unless /OBJ)`)
   puts(`         /ENH - Enhanced-mode Windows session`)
   puts(`         /ICON FileSpec - Full name of an Icon file`)
   puts(`         /HID - Window initially hidden`)
   puts(`         /MAX - Initially maximized`)
   puts(`         /MIN - Initially minimized`)
   puts(`         /RESTORE - Initially in restored state`)
   puts(`         /BIG - Not maximized, but at maximum size`)
   puts(`         /LOCATE "Title" - Find new title (partial, case-insensitive) to adjust`)
   puts(`         /PREDELAY time - Time (milliseconds) to delay before finding window`)
   puts(`         /POSTDELAY time - Delay time (milliseconds) after finding window`)
   puts(`         /K - Keep Windowed session open after program completes`)
   puts(`         /WAIT - Wait until session ends`)
   puts(`         /POS [r]X,[t]Y - Set the X and Y position (0,0 is lower-left corner);`)
   puts(`                          r-relative to right edges; t-relative to tops`)
   puts(`         /SIZE X,Y - Set the width (X) and height (Y) of session`)
   puts(`         /FONT YxX - Set Height (Y) and Width (X) of DOS or OS/2 windowed font`)
   puts(`         /SET SET=VALUE - Dos Settings, any number of these allowed`)
   puts(`         /SET @FileSpec - Get DOS settings from FileSpec; ignore blank and ';'`)
   puts(`         /SET #ENVVAR - Get DOS settings from environment variable <ENVVAR>`)
   puts(`              where values in NAME,VAL;NAME,VAL format`)
   puts(`         /OBJ ObjectID - Object ID of an existing program object or fully-`)
   puts(`                         qualified filename or directory; these settings`)
   puts(`                         override SESSION settings. ( e.g., /OBJ <WP_DESKTOP>,`)
   puts(`                         /OBJ E:\Utl\MyProg.exe, /OBJ "C:\Desktop\DOS Window" )`)
   puts(``)
   puts(`NOTE: SESSION.CMD contains a list of default DOS settings.  You may want to`)
   puts(`      alter these by editing SESSION.CMD and change MyDefaultDOSSettings`)
   puts(`      DOS settings are only specified for session if the /DOS, /W, or /SET`)
   puts(``)
   puts(`      If command arguments take any of the same flags as SESSION.CMD then you`)
   puts(`      May want to include those in quotes and with spaces.  For example:`)
   puts(`          SESSION /WIN CMD.EXE "/K mode 80,50"`)
}

