EXTPROC CEnvi
// ********************************************************
// *** OnTop.cmd - Keep a window always on top of other ***
// *** ver.1       windows. Specify window name and     ***
// ***             frequency.                           ***
// ********************************************************

#include <WinTools.lib>

main(argc,argv)
{
   if ( argc != 3 )
      Instructions();
   else {
      Frequency = atoi(argv[2]);
      if ( Frequency < 1 ) {
         printf("\aFrequncy must be an integer greater than 0\n");
         Instructions();
      } else {
         WindowTitle = argv[1];
         WindowHandle = GetWindowHandle(WindowTitle);
         if ( !WindowHandle ) {
            printf("\aCould not locate window title \"%s\"\n",WindowTitle);
            Instructions();
         } else {
            // install the resident version of this program
            system("detach CEnvi #include 'OnTop.cmd,,,/*RESIDENT*/' Forever(%d,%d)",
                   WindowHandle,Frequency);
         }
      }
   }
}

Instructions()
{
   printf("\n")
   printf("OnTop - Keep any window always on top of other windows\n")
   printf("\n")
   printf("SYNTAX: OnTop <WindowTitle> <Frequency>\n")
   printf("\n")
   printf("Where: WindowTitle - Current title of window to keep on top (partial name)\n")
   printf("       Frequncy - How often to push window to top (in milliseconds)\n")
   printf("\n")
   printf("Example: The following command would put the Clock window up every 5 seconds\n")
   printf("            OnTop \"Clock\" 5000\n")
   printf("\n")
}

/*RESIDENT*/
// All code below this is part of the resident program

Forever(WindowHandle,Frequency)
{
   while ( IsWindow(WindowHandle) ) {
      PutWindowOnTop(WindowHandle);
      suspend(Frequency);
   }
}

PutWindowOnTop(pHwnd)
{
   #define HWND_TOP     3
   #define SWP_ZORDER   4
   #define ORD_WIN32SETWINDOWPOS 875
   DynamicLink("PMWIN",ORD_WIN32SETWINDOWPOS,BIT32,CDECL,
               pHwnd,HWND_TOP,0,0,0,0,SWP_ZORDER);
}

IsWindow(pHwnd)
{
   #define ORD_WIN32ISWINDOW  772
   return DynamicLink("PMWIN",ORD_WIN32ISWINDOW,BIT32,CDECL,
                      Info().hab,pHwnd);
}

