EXTPROC CEnvi
//***************************************************************
//*** ObjSet.cmd - Set value for an object, such as making an ***
//*** ver.1        object non-deletable                       ***
//***************************************************************

#include <PMdll.lib>
#include <Profile.lib>

main(argc,argv)
{
   if ( 2 == argc  &&  !stricmp(argv[1],"MANUAL") ) {
      Manual();
      return EXIT_FAILURE;
   }
   if ( 3 != argc ) {
      Instructions();
      return EXIT_FAILURE;
   }

   ObjectName = argv[1];
   ObjectSetting = argv[2];

   ObjectID = GetObjectID(ObjectName);
   if ( !ObjectID ) {
      printf("Could not locate object \"%s\".\a\n",ObjectName);
      return EXIT_FAILURE;
   }

   strcat(ObjectSetting,";");
   if ( !WinSetObjectData(ObjectID,ObjectSetting) ) {
      printf("Setting \"%s\" failed for object.\n",ObjectSetting);
      return EXIT_FAILURE;
   }

   return EXIT_SUCCESS;
}

GetObjectID(pObjectName) // return Object ID, or 0 if not found
{
   if ( !(lObjectID = WinQueryObject(pObjectName)) )
      lObjectID = FindWPSProgramObject(pObjectName);
   return lObjectID;
}

FindWPSProgramObject(pObjectSpec)
   // assume this is an object in a folder, but not a real object, and
   // so search the OS2.INI file for information to get this object
{
   // separate folder from object, if no folder then assume desktop
   lFileParts = SplitFileName(pObjectSpec);
   lFolderName = lFileParts.dir;
   if ( !lFolderName[0] ) {
      // no folder spec, so use desktop
      lFolderID = 0xFFFF & WinQueryObject("<WP_DESKTOP>");
   } else {
      if ( '\\' == lFolderName[(lLen = strlen(lFolderName))-1] )
         lFolderName[--lLen] = 0;
      lFolderID = 0xFFFF & WinQueryObject(lFolderName);
   }
   if ( lFolderID ) {

      // create buffer that is the string to search objects for
      sprintf(lObjectName,"%s%s",lFileParts.name,lFileParts.ext);
      lMatchBufLen = 2 + strlen(lObjectName) + 1;
      BLObPut(lMatchBuf,0,lMatchBufLen-2,UWORD16);
      BLObPut(lMatchBuf,2,lObjectName,lMatchBufLen-2);

      // Find this folder in OS2.INI under PM_Abstract:FldrContent
      sprintf(lKey,"%X",lFolderID);
      BLObSize(lData,lDataSize=4000);
      if ( PrfQueryProfileData(HINI_USERPROFILE,"PM_Abstract:FldrContent",lKey,
                               lData,lDataSize) ) {
         // try on each object within this folder
         for ( lOffset = 0; lOffset < lDataSize; lOffset += 4 ) {
            lObjectID = BLObGet(lData,lOffset,UWORD32);
            // try to find this object ID within PM_Abstract:Objects
            sprintf(lKey,"%X",lObjectID);
            BLObSize(lObjData,lObjDataSize=4000);
            if ( PrfQueryProfileData(HINI_USERPROFILE,"PM_Abstract:Objects",lKey,
                                     lObjData,lObjDataSize) ) {
               while ( 0 < lObjDataSize
                    && NULL != (lFindData=memchr(lObjData,lMatchBuf[0],lObjDataSize)) ) {
                  if ( !memicmp(lFindData,lMatchBuf,lMatchBufLen) )
                     // YEA! FINALLY THE OBJECT WAS FOUND
                     return( 0x20000 | lObjectID );
                  lDataSkip = lFindData - lObjData + 1;
                  lObjDataSize -= lDataSkip;
                  lObjData += lDataSkip;
               }
            }
         }
      }
   }
   return(NULL);
}

Instructions()
{
   puts("\a")
   puts(`ObjSet - Alter settings for WPS objects`)
   puts(``)
   puts(`USAGE: ObjSet [<ObjectID> <Setting>] | [MANUAL]`)
   puts(``)
   puts(`WHERE: ObjectID - Object ID of an existing program object or fully qualified`)
   puts(`                  filename or directory ( e.g., <WP_DESKTOP>,`)
   puts(`                  E:\Utl\MyProg.exe, "C:\Desktop\DOS Window"`)
   puts(`       Setting - String containing the setting to apply to this object`)
   puts(`       MANUAL - Enter this option for a longer manual describing some of the`)
   puts(`                objects and settings.`)
   puts(``)
}

Manual()
{
 Instructions();
 puts(``)
 puts(`ObjectID may be the exact location (directory and object or file/folder`)
 puts(`specification).  If no folder (directory) is supplied then the desktop is`)
 puts(`assumed.  Keep in mind that the true name of directories is not always the`)
 puts(`name you seen in the WPS.`)
 puts(``)
 puts(`There are many predifined object ID's.  These all begin with '<' and end with`)
 puts(`'>'.  Some examples are "<WP_DESKTOP>", "<WP_START>", and "<WP_NOWHERE>".  For`)
 puts(`a full list of predefined object ID's, enter the following command:`)
 puts(`   DumpIni OS2 PM_Workplace:Location`)
 puts(``)
 puts(``)
 puts(`There are very many settings strings that can be applied to objects.  Not all`)
 puts(`objects understand all settings types.  Here are usefule settings to know:`)
 puts(``)
 puts(`   NOCOPY=YES           this and following NOxxx can be set to NO`)
 puts(`   NODELETE=YES`)
 puts(`   NODRAG=YES`)
 puts(`   NOLINK=YES`)
 puts(`   NOMOVE=YES`)
 puts(`   NOPRINT=YES`)
 puts(`   NORENAME=YES`)
 puts(`   NOSHADOW=YES`)
 puts(`   NOTVISIBLE=YES`)
 puts(``)
 puts(`   OBJECTID=<NAME>      Give object object name alias`)
 puts(``)
 puts(`   OPEN=DEFAULT         open default view; open now`)
 puts(`   OPEN=SETTINGS        open settings notebook`)
 puts(``)
 puts(`   OPEN=DETAILS`)
 puts(`   OPEN=ICON`)
 puts(`   OPEN=TREE`)
 puts(``)
 puts(` folder views can have the following settings`)
 puts(`   DETAILSVIEW=setteng1,setting2,setting3...`)
 puts(`   ICONVIEW=setteng1,setting2,setting3...`)
 puts(`   TREEVIEW=setteng1,setting2,setting3...`)
 puts(` where the settings may be any of the following:`)
 puts(`   FLOWED`)
 puts(`   NONFLOWED`)
 puts(`   NONGRID`)
 puts(`   NORMAL`)
 puts(`   MINI`)
 puts(`   INVISIBLE`)
 puts(`   LINES`)
 puts(`   NOLINES`)
 puts(``)
 puts(`   BACKGROUND=FileSpec  specify file name for background image`)
 puts(`   WORKAREA=YES         can set NO`)
 puts(`   MINWIN=HIDE          minimized view, may also be VIEWER or DESKTOP`)
 puts(`   VIEWBUTTON=HIDE      hide button, may also be MINIMIZE`)
 puts(`   CONCURRENTVIEW=YES   create new views when opened; may also be NO`)
 puts(`   TEMPLATE=YES         object is template; else NO`)
 puts(``)
 puts(`   ICONFILE=FileSpec`)
 puts(`   ICONRESOURCE=id,module`)
 puts(`   ICONPOS=x,y          Initial icon position in folder`)
 puts(``)
 puts(` program object settings; in addition to DOS settings`)
 puts(`   PROGTYPE=FULLSCREEN  sesion type, may also be PM, SEPARATEWIN, VDM, WIN`)
 puts(`                        WINDOWABLEVIO, WINDOWEDVDM, WINDOWEDWIN`)
 puts(`   MINIMIZED=YES        may be NO`)
 puts(`   MAXIMIZED=YES        may be NO`)
 puts(`   NOAUTOCLOSE=YES      may be NO`)
 puts(``)
 puts(`   ASSOCFILTER=filter1,filter2,filter3,...`)
 puts(`   ASSOCTYPE=type1,type2,type3,...`)
 puts(``)
 puts(` EXAMPLES:`)
 puts(`   ObjSet C:\OS2 ICONVIEW=NONFLOWED,NORMAL;OPEN=ICON`)
 puts(`   ObjSet "<WP_SYSTEM>" MINWIN=HIDE;OPEN=DEFAULT`)
 puts(`   ObjSet "C:\Desktop\OS/2 Window" NODELETE=YES`)
 puts(`   ObjSet "D:\MyDir\MyProgram" "OBJECTID=<MY_PROGRAM>"`)
}

