EXTPROC CEnvi
/**************************************************************
 *** IDLE - CEnvi program to demonstrate altering the       ***
 *** ver.1  priority of this process to only execute during ***
 ***        system idletime.                                ***
 **************************************************************/

// RUN LOOP TEST BEFORE REDUCING THE PROCESS PRIORITY
printf("Looping at standard priority %d...\n",GetCurrentPriority());
BigLoop();

// REDUCE PRIORITY OF THIS PROCESS TO IDLETIME
#define ORD_DOS32SETPRIORITY     236
#define PRTYC_IDLETIME     1  // set to idletime priority
DynamicLink("doscalls",ORD_DOS32SETPRIORITY,BIT32,CDECL,
            0/*all threads*/,PRTYC_IDLETIME/*idletime*/,
            0/*no process change at new level*/,0/*current process*/)

printf("\nPriority has been set to idle; priority = %d.  Now this loop process\n",GetCurrentPriority());
printf("runs only when the system is idle.  Will now run the loop test again\n");
printf("but now the loops run only in idle time\n");
BigLoop();


// ROUTINES CALLED IN THE ABOVE CODE

#include <DosCalls.lib>

BigLoop()
{
   for ( i = 1000; i; i-- )
      printf("\r%4d",i);
}

GetCurrentPriority()
{
   MyID = GetMyID();
   // find the priority of the first thread in this process
   PList = ProcessList(TRUE);
   assert( NULL != PList );
   for ( pcount = 0; pcount <= GetArraySpan(PList); pcount++ ) {
      if ( PList[pcount].id == MyID ) {
         TList = PList[pcount].Threads;
         assert( NULL != PList );
         return( TList[0].Priority );
      }
   }
   abort(); // should never get to this point
}
   
GetMyID()   // get current process ID. Current ID is first UWORD32 in Process Info Block
{
   DosGetInfoBlocks(tid,pid);
   return( peek(pid,UWORD32) );
}
