EXTPROC CEnvi
/*****************************************************************
 *** HideTask.cmd - CEnvi program to hide a task from the task ***
 *** ver.1          list based on task-list name.              ***
 *****************************************************************/

#include <PMdll.lib>

main(argc,argv)
{
   if ( argc != 2 ) {
      Instructions();
   } else {
      TaskListName = argv[1];
      NameLen = strlen(TaskListName);
      // build list of all window switch titles
      SwitchList = WinQuerySwitchList(Info().hab);

      // for each entry, if it matches TaskListName then remove
      // it from the switch list
      assert( SwitchList != NULL );
      SwitchCount = 1 + GetArraySpan(SwitchList);
      HideCount = 0;
      for ( i = 0; i < SwitchCount; i++ ) {
         if ( 0 == WinQuerySwitchEntry(SwitchList[i],SwEntry)
           && !strncmpi(SwEntry.title,TaskListName,NameLen) ) {
            // this task matches input, so remove it
            printf("Remove entry \"%s\"\n",SwEntry.title);
            WinRemoveSwitchEntry(SwitchList[i]);
            HideCount++;
         }
      }
      if ( 0 == HideCount )
         printf("\n\aNo entries for \"%s\" to hide\n",TaskListName);
   }
}

WinRemoveSwitchEntry(pSwitchSwitch)
{
   #define ORD_WIN32REMOVESWITCHENTRY  129
   PMDynamicLink("PMSHAPI",ORD_WIN32REMOVESWITCHENTRY,BIT32,CDECL,
                 pSwitchSwitch);
}

Instructions()
{
   puts(``)
   puts(`HideTask - Hide task from the task list.`)
   puts(``)
   puts(`SYNTAX: HideTask <TaskName>`)
   puts(``)
   puts(`Where:  <TaskName> - Partial Name from switch list`)
   puts(``)
   puts(`Example: HideTask "MyApp - C:\Goober`)
   puts(``)
   puts(`Note: TaskName matches any switch entry for the`)
   puts(`      length of TaskName and is case-insensitive.`)
   puts(`      Switch entries, if not the same as in the`)
   puts(`      Task List window, are found with WINLIST.CMD`)
   puts(``)
}

