EXTPROC CEnvi
/*******************************************************************
 *** FileFind - Use CEnvi to search this disk, or all disks, for ***
 *** ver.1      files matching any given file spec.  Print names ***
 ***            off all files found, and return find count.      ***
 *******************************************************************/

main(argc,argv)
{
   if ( 2 != argc  ||  !strcmp("/?",argv[1])  ||  !stricmp("/help",argv[1])  ||  0 == argv[1][0] ) {
      FindCount = 0;
      Instructions();
   } else {
      FindCount = FindFiles(argv[1]);
   }
   return(FindCount);
}

FindFiles(spec) // find files matching spec, and return number found
{
   // determine spec searching for to see if search all drives, all of one
   // drive, or specified subbdirectories
   NameParts = SplitFileName(spec);
   if ( NameParts.dir[0] == 0 ) {
      count = SearchAllDrives(spec);
   } else if ( 2 == strlen(NameParts.dir)  &&  NameParts.dir[1] == ':' )
      count = SearchOneDrive(NameParts.dir[0],spec+2);
   else {
      count = SearchSubdir(spec);
   }
   return(count);
}

SearchSubdir(SearchSpec) // search from SearchSpec for all matching files
{
   List = Directory(SearchSpec,TRUE,FATTR_RDONLY|FATTR_HIDDEN|FATTR_SYSTEM|FATTR_SUBDIR|FATTR_ARCHIVE);
   if ( NULL == List )
      return(0);
   DisplayFoundList(List);
   return(1 + GetArraySpan(List));
}

SearchOneDrive(DriveLetter,SearchSpec)
{
   sprintf(FullSearchSpec,"%c:\\%s",DriveLetter,SearchSpec);
   return SearchSubDir(FullSearchSpec);
}

SearchAllDrives(SearchSpec) // look on all valid drives
{
   TotalFound = 0;
   for ( DriveLetter = 'C'; DriveLetter <= 'Z'; DriveLetter++ ) {
      sprintf(DriveCurdir,"%c:.",DriveLetter);
      if ( NULL != FullPath(DriveCurdir) ) {
         TotalFound += SearchOneDrive(DriveLetter,SearchSpec);
      }
   }
   return(TotalFound);
}

DisplayFoundList(list)
{
   count = 1 + GetArraySpan(list);
   for ( i = 0; i < count; i++ ) {
      printf("%-45s  %-8d  %s",list[i].name,list[i].size,ctime(list[i].Write)+4);
   }
}

Instructions()
{
   printf("\a\n")
   printf("FileFind.cmd - Find File in directory tree or on any drive.\n")
   printf("\n")
   printf("SYNTAX: FileFind FileSpec\n")
   printf("\n")
   printf("Where:  FileSpec Specification to match in finding file\n")
   printf("\n")
   printf("Examples: FileFind q*.bak        Find all *.bak files on all hard drives\n")
   printf("          FileFind E:q*.bak      Find all *.bak files on drive E:\n")
   printf("          FileFind foo\\q*.bak    Find all *.bak in subdirectory foo and below\n")
   printf("          FileFind E:\\foo\\q*.bak Find all *.bak in subdirectory E:\\foo and below\n")
}

