EXTPROC CEnvi
//*************************************************************
//*** DoList.cmd - perform some action on every element     ***
//*** ver.1        in a list.  The list is taken from       ***
//***              standard input or if a file is specified ***
//***              then from that file.                     ***
//*************************************************************

#include <OptParms.lib>

#define INSERT_SEQUENCE  "$$$"

main(argc,argv)
{
   Skip = OptionalParameter(argc,argv,"SKIP",Temp) ? atoi(Temp) : 0 ;
   Truncate = OptionalParameter(argc,argv,"TRUNC",Temp) ? atoi(Temp) : 0 ;
   if ( argc < 2  ||  3 < argc
     || OptionalParameter(argc,argv,"?")
     || OptionalParameter(argc,argv,"help")
     || OptionalParameter(argc,argv,"h") ) {
      Instructions();
      exit(EXIT_FAILURE);
   }

   Action = argv[1];

   if ( argc == 2 ) {
      // take input from stdin
      fp = stdin;
   } else {
      fp = fopen(argv[2],"rt");
      if ( !fp ) {
         printf("\aUnable to open \"%s\" for reading.\n",argv[2]);
         exit(EXIT_FAILURE);
      }
   }

   ActOnEachLine(Action,fp,Skip,Truncate);

   if ( argc != 2 )
      fclose(fp);
}

ActOnEachLine(Action,fp,Skip,Truncate)
{
   while( (line = fgets(fp)) ) {

      // get rid of neline at end
      LineLen = strlen(line);
      if ( line[LineLen-1] == '\n' )
         line[--LineLen] == '\0';

      // remove Skip and Truncate text if applicable
      if ( Skip <= LineLen ) {
         line += Skip;
         LineLen -= Skip;
         if ( Truncate <= LineLen ) {
            line[LineLen -= Truncate] = '\0';
            if ( LineLen ) {

               ActOnLine(Action,line);
            }
         }
      }
   }
}

ActOnLine(Action,Line)  // act on line, including INSERT_SEQUENCE
{
   // create statement replacing INSERT_SEQUENCE with line, or putting
   // line at end if no INSERT_SEQUENCE
   strcpy(lCmd,Action);

   // If insert sequence then replace with Line, else concatenate line
   if ( insert = strstr(lCmd,INSERT_SEQUENCE) ) {
      strcpy(insert + strlen(Line),insert+strlen(INSERT_SEQUENCE));
      memcpy(insert,Line,strlen(Line));
   } else {
      strcat(lCmd," ");
      strcat(lCmd,Line);
   }

   // show and execute the command
   printf("%s\n",lCmd);
   system(lCmd);
}
               // finally, line is text to act upon


Instructions()
{
   puts("\a")
   puts(`DoList - Perform command on every element in a list`)
   puts(``)
   puts(`SYNTAX DoList <Command> [ListFile] [/SKIP skip] [/TRUNC trunc]`)
   puts(``)
   puts(`WHERE: Command - Command to perform on each element in list, this may contain`)
   puts(`                 the insert sequence ` INSERT_SEQUENCE ` for list element`)
   puts(`       ListFile - File specification where each line is list element`)
   puts(`       skip - skip this many characters from each line in list`)
   puts(`       trunc - trancate this many character off the end of each item`)
   puts(``)
   puts(`EXAMPLES: DoList PRINT MyList.lst`)
   puts(`          DIR /b *.TXT | DoList "type ` INSERT_SEQUENCE ` >> ALL.TXT"`)
   puts(`          GREP -li NOMBAS * | DoList "attrib +r" /SKIP 5 /TRUNC 1`)
}
