@echo OFF
REM *****************************************************************
REM *** CDfind - Use CEnvi to search this disk, or all disks, for ***
REM *** ver.2    directory matching any given file spec.  Then    ***
REM ***          change to that directory                         ***
REM *****************************************************************

SET CDF_DRV=
SET CDF_DIR=
CALL CEnviSet %0.cmd %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO CENVI_EXIT

main(argc,argv)
{
   if ( 2 != argc  ||  !strcmp("/?",argv[1])  ||  !stricmp("/help",argv[1])  ||  0 == argv[1][0] ) {
      Instructions();
   } else {
      DirCount = FindDirs(argv[1],Dirs);
      if ( !DirCount ) {
         printf("No directory matching \"%s\"!\a\n",argv[1]);
         exit(EXIT_FAILURE);
      }
      if ( 1 == DirCount ) {
         printf("1 directory found.\n");
         ChangeToDirectory(Dirs[0]);
      } else {
         printf("%d directories found.\n",DirCount);
         for ( choice = 0; choice < DirCount; choice++ ) {
            printf("cd %s (Y/N) ? ",Dirs[choice]);
            GetResponse:
            Response = toupper(getch());
            if ( !strchr("YN",Response) ) {
                  printf("\a");
                  goto GetResponse;
            }
            printf("%c\n",Response);
            if ( 'Y' == Response ) {
               ChangeToDirectory(Dirs[choice]);
               break;
            }
         }
      }
   }
}

FindDirs(pSpec,pDirList) // find a directories matching spec and return
{
   // determine spec searching for to see if search all drives, all of one
   // drive, or specified subbdirectories
   NameParts = SplitFileName(pSpec);
   if ( NameParts.dir[0] == 0 ) {
      lDirCount = SearchAllDrives(pSpec,pDirList);
   } else if ( 2 == strlen(NameParts.dir)  &&  NameParts.dir[1] == ':' )
      lDirCount = SearchOneDrive(NameParts.dir[0],pSpec+2,pDirList,0);
   else {
      lDirCount = SearchSubdir(pSpec,pDirList,0);
   }
   return lDirCount;
}

SearchSubdir(pSpec,pDirList,pDirCount) // search from SearchSpec for all matching files
{
   lDirCount = pDirCount;
   List = Directory(pSpec,TRUE,FATTR_RDONLY|FATTR_SUBDIR|FATTR_ARCHIVE,FATTR_SUBDIR);
   if ( NULL != List ) {
      lCount = 1 + GetArraySpan(List);
      for ( i = 0; i < lCount; i++ )
         pDirList[lDirCount++] = List[i].name;
   }
   return lDirCount;
}

SearchOneDrive(DriveLetter,SearchSpec,pDirList,pDirCount)
{
   sprintf(FullSearchSpec,"%c:\\%s",DriveLetter,SearchSpec);
   return SearchSubDir(FullSearchSpec,pDirList,pDirCount);
}

SearchAllDrives(pSearchSpec,pDirList) // look on all valid drives
{
   lDirCount = 0;
   for ( DriveLetter = 'C'; DriveLetter <= 'Z'; DriveLetter++ ) {
      sprintf(DriveCurdir,"%c:.",DriveLetter);
      if ( NULL != FullPath(DriveCurdir) ) {
         lDirCount = SearchOneDrive(DriveLetter,pSearchSpec,pDirList,lDirCount);
      }
   }
   return lDirCount;
}

ChangeToDirectory(pDirname)
{
   strcpy(CDF_DRV,pDirname);
   CDF_DRV[2] = '\0';
   strcpy(CDF_DIR,pDirname+2);
}

Instructions()
{
   printf("\a\n")
   printf("CDfind.cmd - Find directory and change to that directory.\n")
   printf("\n")
   printf("SYNTAX: CDfind <DirSpec>\n")
   printf("\n")
   printf("Where:  DirSpec - Directory specification to match in finding file\n")
   printf("\n")
   printf("Examples: CDfind C:MDOS       Find a MDOS directory on C:\n")
   printf("          CDfind E:UT*        Find directory starting with UT on E:\n")
   printf("          CDfind TOOLS        Find TOOLS directory on any drive\n")
   printf("          CDfind D:\\UTL\\BOZ?  Find BOZ? directory below D:\\UTL\n")
}

:CENVI_EXIT
IF "%CDF_DRV%" == "" GOTO ALL_DONE
%CDF_DRV%
CD %CDF_DIR%
:ALL_DONE
SET CDF_DRV=
SET CDF_DIR=
