/* Version control information for "info" command display */
/* Definition for processor type added */
/* Cleanup of information display - K2MF 4/93 */

#include "global.h"
#include "mbuf.h"
#include "socket.h"
#include "version.h"

char shortversion[] = "JNOS1.10h";

#if (defined(MAILBOX) || defined(MBFWD))
#ifdef FBBFWD
// I think that FBB like's it options in descending order.
char MboxIdF[]  = "[JNOS-1.10h-FHIM$]\n";
#endif /* FBBFWD */
char MboxId[]   = "[JNOS-1.10h-IHM$]\n";
#endif /* MAILBOX || MBFWD */

char Version2[] = "by Johan. K. Reinalda, WG7J/PA3DIS\n";
extern int Numrows,Numcols;

char Version[] = "1.10h ("
#if defined LINUX
    "Linux"
#elif defined CPU86
    "8088"
#elif defined CPU186
    "80186"
#elif defined CPU286
    "80286"
#elif defined CPU386
    "80386"
#elif defined CPU486
    "80486"
#elif defined CPU586
    "PENTIUM"
#else
    "cpu unknown"
#endif
    ")";

#ifdef ALLCMD
static char *
compilerver(void)
{
	static char result[24];

#if defined(__GNUC__)
	sprintf(result, "GCC %d", __GNUC__);
#elif defined(__BORLANDC__)
	sprintf(result, "BC %04X", __BORLANDC__);
#elif defined(__TURBOC__)
	sprintf(result, "TC %04X", __TURBOC__);
#else
	strcpy(result,"unknown compiler");
#endif
	return(result);
}

int
doinfo(argc,argv,p)
int argc;
char *argv[];
void *p;
{
    tprintf("JNOS %s, compiled %s %s by %s",
             Version,__DATE__,__TIME__,compilerver());
#ifdef WHOFOR
    tprintf("\nfor %s,", WHOFOR);
#endif
    tprintf(" containing:\n\n");

#ifndef SERVERS
    tputs("TCP Servers:  None !\n");
#else

    tputs("TCP Servers:"
#ifdef SMTPSERVER
    "  SMTP"
#endif
#ifdef FINGERSERVER
    "  FINGER"
#endif
#ifdef FTPSERVER
    "  FTP"
#endif
#ifdef TELNETSERVER
    "  TELNET"
#endif
#ifdef RLOGINSERVER
    " RLOGIN"
#endif
#ifdef TTYLINKSERVER
    "  TTYLINK"
#endif
#ifdef DISCARDSERVER
    "  DISCARD"
#endif
#ifdef ECHOSERVER
    "  ECHO"
#endif
    "\n");

#if (defined(CALLSERVER) || defined(SAMCALLB) || defined(QRZCALLB) || defined(CONVERS) || defined(NNTPS) || defined(POP2SERVER) || defined(POP3SERVER) || defined(RDATE))
    tputs("            "

#ifdef CALLSERVER
    " CALLBOOK (CD-ROM)"
#endif

#ifdef SAMCALLB
    "  CALLBOOK (SAM)"
#endif /* SAMCALLB */

#ifdef QRZCALLB
    " CALLBOOK (QRZ)"
#endif /* QRZCALLB */

#ifdef CONVERS
    " CONVERS"
#endif

#ifdef NNTPS
    " NNTP"
#endif

#ifdef POP2SERVER
    " POP2"
#endif

#ifdef POP3SERVER
    " POP3"
#endif

#ifdef RDATE
    " TIME"
#endif

    "\n");
#endif /* CALLSERVER || CONVERS || NNTPS || POP2SERVER || POP3SERVER || RDATE */

#endif /* SERVERS */

    tputs("TCP Clients: SMTP"

#ifdef FINGERSESSION
    " FINGER"
#endif

#ifdef FTPSESSION
    " FTP"
#endif

#ifdef TELNETSESSION
    " TELNET"
#endif

#ifdef TTYLINKSESSION
    " TTYLINK"
#endif

    "\n");

#if (defined(CALLCLI) || defined(CONVERS) || defined(NNTP) || defined(NNTPS) || defined(POP2CLIENT) || defined(POP3CLIENT) || defined(RLOGINCLI) || defined(RDATE))
    tputs ("           "

#ifdef CALLCLI
    " CALLBOOK (CD-ROM)"
#endif

#ifdef CONVERS
    " CONVERS"
#endif

#if (defined(NNTP) || defined(NNTPS))
    " NNTP"
#endif

#ifdef POP2CLIENT
    " POP2"
#endif

#ifdef POP3CLIENT
    " POP3"
#endif

#ifdef RLOGINCLI
    " RLOGIN"
#endif

#ifdef RDATE
    " TIME"
#endif

#ifdef LOOKSESSION
    " LOOK"
#endif

    "\n");
#endif /* CALLCLI || CONVERS || NNTP || NNTPS || POP2CLIENT || POP3CLIENT || RLOGINCLI || RDATE */

#ifdef LZW
    tputs("    with LZW compression for TCP sockets\n");
#endif /* LZW */

#if (defined(TCPACCESS) || defined(IPACCESS))
    tputs("    with "

#ifdef TCPACCESS
    "TCP"
#endif

#if (defined(TCPACCESS) && defined(IPACCESS))
    "/"
#endif

#ifdef IPACCESS
    "IP"
#endif

    " access controls\n");
#endif /* TCPACCESS || IPACCESS */


#if (defined(DOMAINSERVER) || defined(REMOTESERVER))
    tputs("UDP Servers:"
#endif /* DOMAINSERVER || REMOTESERVER */

#ifdef DOMAINSERVER
    "  DOMAIN NAMESERVER"
#endif /* DOMAINSERVER */

#ifdef REMOTESERVER
    "  REMOTE"
#endif /* SERVERS */

#if (defined(DOMAINSERVER) || defined(REMOTESERVER))
    "\n");
#endif /* DOMAINSERVER || REMOTESERVER */

#ifdef MAILBOX

#ifdef TIPSERVER
	tputs("TIP ");
#endif

    tputs("Mailbox Server"

#ifdef XMODEM
    " with Xmodem file transfer"
#endif /* XMODEM */

    "\n");

#ifdef MAILCMDS
    tputs("Full Service BBS"

#if (defined(EXPIRY) || defined(MAILFOR) || defined(MBFWD) || defined(RLINE))
    " with:"
#endif

#ifdef EXPIRY
    "\n     Message and BID expiry"
#endif

#ifdef MAILFOR
    "\n     'Mail For' beaconing"
#endif

#ifdef MBFWD
    "\n     AX.25 mail forwarding"
#ifdef FBBFWD
    "\n           with FBB Style Forwarding"
#endif /* FBBFWD */
#endif /* MBFWD */

#ifdef RLINE
    "\n     BBS 'R:-line' compatibility"
#endif /* RLINE */

    "\n");
#endif /* MAILCMDS */

#endif /* MAILBOX */

#if (defined(AXIP) || defined(ENCAP))
    tputs("Internet Services:"

#ifdef AXIP
    "  AX.25 Digipeating"
#endif /* AXIP */

#ifdef ENCAP
    "  IP Encapsulation"
#endif /* ENCAP */

    "\n");
#endif /* AXIP || ENCAP */

#ifdef HOPCHECKSESSION
	tputs("Hopcheck IP path tracing\n");
#endif /* HOPCHECKSESSION */

#ifdef RIP
    tputs("RIP-2 Routing Protocol\n");
#endif /* RIP */

#ifdef RSPF
	tputs("Radio Shortest Path First Protocol (RSPF)\n");
#endif /* RSPF */

#ifdef RARP
	tputs("Reverse Address Resolution Protocol (RARP)\n");
#endif /* RARP */

    tprintf("%d interrupt buffers of %d bytes\n",Nibufs,Ibufsize);

#ifdef ASY
#ifdef LINUX
    tputs("Generic async (cua*) interface driver\n");
#else
    tputs("Generic async (8250/16450/16550) interface driver\n");
#endif

#if (defined(KISS) || defined(AX25) || defined(NRS))
    tputs("Async interface drivers:"

#ifdef KISS
    "  KISS-TNC"
#endif /* KISS */

#ifdef POLLEDKISS
    "  POLLED-KISS"
#endif /* POLLEDKISS */

#ifdef AX25
    "  AX.25"
#endif /* AX25 */

#ifdef NRS
    "  NET/ROM-TNC"
#endif /* NRS */

    "\n");
#endif /* KISS || AX25 || NRS */

#endif /* ASY */

#ifdef BPQ
    tputs("Bpq Host driver\n");
#endif

#ifdef NETROM
	tputs("NET/ROM network interface\n");
#endif /* NETROM */

#if (defined(PPP) || defined(SLIP))
    tputs("Async IP drivers:"

#ifdef PPP
    "  Point-to-Point (PPP)"
#endif /* PPP */

#ifdef SLIP
    "  Serial Line (SLIP)"
#endif /* SLIP */

    "\n");

#ifdef DIALER
    tputs("      with dialer code for SLIP\n");
#endif /* DIALER */

#ifdef VJCOMPRESS
    tputs("      with Van Jacobson compression for PPP/SLIP\n");
#endif /* VJCOMPRESS */

#endif /* PPP || SLIP */

#ifdef PACKET
	tputs("FTP Software's PACKET driver interface\n");
#endif /* PACKET */

#ifdef APPLETALK
	tputs("Appletalk interface for MacIntosh\n");
#endif /* APPLETALK */

#ifdef ARCNET
	tputs("ARCnet via PACKET driver\n");
#endif /* ARCNET */

#ifdef DRSI
	tputs("DRSI PCPA low-speed driver\n");
#endif /* DRSI */

#ifdef EAGLE
    tputs("Eagle card 8530 driver\n");
#endif /* EAGLE */

#ifdef ETHER
    tputs("Generic ethernet driver\n");
#endif /* ETHER */

#ifdef HAPN
	tputs("Hamilton Area Packet Network driver\n");
#endif /* HAPN */

#ifdef HS
	tputs("High speed (56 kbps) modem driver\n");
#endif /* HS */

#ifdef PACKETWIN
	tputs("Gracilis PackeTwin driver\n");
#endif /* PACKETWIN */

#ifdef PC_EC
	tputs("3-Com 3C501 Ethernet controller driver\n");
#endif /* PC_EC */

#ifdef PC100
	tputs("PAC-COM PC-100 driver\n");
#endif /* PC100 */

#ifdef PI
	tputs("PI SCC card with DMA driver (VE3IFB)\n");
#endif /* PI */

#ifdef SCC
    tputs("Generic SCC (8530) driver (PE1CHL)\n");
#endif /* SCC */

#ifdef SLFP
	tputs("SLFP via PACKET driver\n");
#endif /* SLFP */
    
#ifdef TRACE
	tputs("Hardware interface packet tracing code\n");
#endif /* TRACE */

#ifdef PRINTEROK
        tputs("Parallel printer\n");
#endif

#ifdef STKTRACE
	tputs("Stack tracing code\n");
#endif /* STKTRACE */

#ifdef MULTITASK
/*      tputs("The Russell Nelson modsets\n"); */
	tputs("Multitasking capability when shelling out to MS-DOS\n");
#endif /* MULTITASK */

#ifdef LINUX
    tputs("Linux modifications by Brandon S. Allbery\n");
#endif

#ifdef MONITOR
    tputs("User port monitor trace mode\n");
#endif

	return 0;
}

#endif /* ALLCMD */
