/*
 * File......: USERLOCK.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_USERLOCK()
 *  $CATEGORY$
 *      Network
 *  $ONELINER$
 *      Apply/release a software semaphore
 *  $SYNTAX$
 *      GT_UserLock( cMaster , lLock )
 *  $ARGUMENTS$
 *      cMaster - Master table to be locked/unlocked
 *      lLock   - If .T., lock the record, otherwise unlock the record
 *  $RETURNS$
 *      The lock status - .T. if locked, .F. if not locked
 *  $DESCRIPTION$
 *      Locking : The userid of the current user is placed in the field
 *      "LOCKEDBY" in the given table.  If the record is locked, or another
 *      user has set the semaphore, .F. is returned.  If the name is applied
 *      .T. is returned
 *
 *      Unlocking : If the userid in the "LOCKEDBY" field matches the userid
 *      of the current user the lock is released, otherwise an error is
 *      flagged and .F. returned
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_UserLock( cMaster , lLock )

/*****************************************************************************
 Purpose - Place or release a user semaphore lock on a master table
 Returns - .T. if lock applied, .F. otherwise
 Author  - Log
 Created - 26/11/92
******************************************************************************
 Parameters - cMaster - Master table to be locked/unlocked
              lLock   - If .T., lock the record
                        If .F., unlock the record
 Privates   - None
 Locals     - None
 PUBLICS    - cUserName - Name of user applying lock
*****************************************************************************/

LOCAL nCurDB  := SELECT()
LOCAL nField  := 0
LOCAL lLocked := .F.

* Select the master table and calculate the ordinal position of the
* "lockedby" field
SELECT ( cMaster )
SET ORDER TO 1
nField := FIELDPOS( "lockedby" )

* Are we locking or unlocking ?
IF lLock
    * Locking record, so see if we already have a lock
    IF FIELDGET( nField ) == cUserName
        RLOCK()
        lLocked := .T.
    ENDIF

    * See if nobody has a lock
    IF ALLTRIM( FIELDGET( nField ) ) == "" .AND. .NOT. lLocked
        IF .NOT. ( GT_RecLock( LOCKWAITTIME ) )
            lLocked := .F.
        ELSE
            * We can now lock the record
            FIELDPUT( nField , cUserName )
            DBCOMMITALL()
            lLocked := .T.
        ENDIF
    ENDIF
ELSE
    * Unlock the record
    RLOCK()
    FIELDPUT( nField , "" )
    DBCOMMITALL()
    UNLOCK
ENDIF

* Go back to the original area
DBSELECTAREA( nCurDB )

* Return the lock status
RETURN( lLocked )
*
