/*
 * File......: STOD1.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_STOD1()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Convert a date in the format DDMMYY to a Date type
 *  $SYNTAX$
 *      GT_STOD1( cDate )
 *  $ARGUMENTS$
 *      cDate - A date in the format DDMMYY
 *  $RETURNS$
 *      cDate as a date
 *  $DESCRIPTION$
 *      Convert a date in the format DDMMYY to a Date type
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION GT_StoD1( cDate )

/*****************************************************************************
 Purpose - Convert a date in the format DDMMYY to a Date type
 Returns - None
 Author  - Log
 Created - 08/12/92
******************************************************************************
 Parameters - None
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

RETURN CTOD( SUBSTR( cDate , 1 , 2 ) + "/" + SUBSTR( cDate , 3 , 2 ) + "/" + SUBSTR( cDate , 5 , 2 ) )
*
