/*
 * File......: PHEADER.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_PAGEHEADER()
 *  $CATEGORY$
 *      Printer
 *  $ONELINER$
 *      Output a standard page header
 *  $SYNTAX$
 *      GT_PageHeader( cRepName, lPageReset, nLeftMgn, nRightMgn, ;
 *                     nPageWidth , nHeader )
 *  $ARGUMENTS$
 *      cRepName    - Report name
 *      lPageReset  - If .T., reset the page number count
 *      nLeftMgn    - Left margin of page
 *      nRightMgn   - Right margin of page
 *      nPageWidth  - Width of page
 *      nHeader     - Row on which to start header
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Outputs a double lined box structure containing the name of the
 *      system, report and user, the date and time, and the page number.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */
*
#include "GT_LIB.CH"

FUNCTION GT_PageHeader( cRepName, lPageReset, nLeftMgn, nRightMgn, ;
                        nPageWidth , nHeader )

/*****************************************************************************
 Purpose - Output a page header consisting of the System Name , Report Name ,
           User Name , Date and Time
 Returns - None
 Author  - Martin Colloby
 Created - March 1992
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - cRepName    - Report name
              lPageReset  - If .T., reset the page number count
              nLeftMgn    - Left margin of page
              nRightMgn   - Right margin of page
              nPageWidth  - Width of page
              nHeader     - Row on which to start header
 Privates   - None
 Locals     - None
 PUBLICS    - cSystemName - Name of system
              cUserName   - Name of user
 Statics    - nPageNum    - Page number
              nConfMess   - "Private and Confidential" message
*****************************************************************************/

STATIC nPageNum := 0
STATIC cConfMess := "P R I V A T E   A N D   C O N F I D E N T I A L"

DEFAULT lPageReset TO .F.

IF lPageReset
    nPageNum := 1
ELSE
    EJECT
    SETPRC( 0, 0 )
    nPageNum++
ENDIF

GT_NextRow( nHeader , "" + REPLICATE( "", nPageWidth -;
                        nLeftMgn - nRightMgn - 2 ) + "" , nLeftMgn )
GT_NextRow( 1 , " " + cSystemName , nLeftMgn )
GT_SameRow( nPageWidth - nRightMgn - LEN( cRepName ) - 2 , cRepName + " " , 0 )
GT_NextRow( 1, "" + REPLICATE( "",nPageWidth - nLeftMgn - nRightMgn - 2 ) + "", nLeftMgn )
GT_NextRow( 1, " Printed By : " + cUserName , nLeftMgn )
GT_SameRow( nPageWidth - nRightMgn - 36 , "Date " + DTOC( DATE() ) , 0 )
GT_SameRow( PCOL() + 1 , "Time " + LEFT( TIME(), 5 ) , 0 )
GT_SameRow( PCOL() + 1 , "Page " + TRANSFORM( STR( nPageNum, 4 ), "9999" ) + " " , 0 )
GT_NextRow( 1 , "" + REPLICATE( "",nPageWidth - nLeftMgn - nRightMgn - 2 ) + "" , nLeftMgn )
GT_NextRow( 1 )
GT_SameRow( nLeftMgn + ( nPageWidth - nRightMgn - LEN( cConfMess ) ) / 2 , cConfMess , 0 )

RETURN NIL
*
