;  File......: ISDESQ.ASM
;  Author....: David Pearson
;  BBS.......: The Dark Knight Returns
;  Net/Node..: 050/069
;  User Name.: Dave Pearson
;  Date......: 23/03/93
;  Revision..: 1.0
;
;  This is an original work by Dave Pearson and is placed in the public
;  domain.
;
;  Modification history:
;  ---------------------
;
;  $Log$
;
;
;
;   $DOC$
;   $FUNCNAME$
;       GT_ISDESQ()
;   $CATEGORY$
;       Environment
;   $ONELINER$
;       Check if application is running under DesqView
;   $SYNTAX$
;       GT_IsDesq() --> lIsDesqView
;   $ARGUMENTS$
;       None
;   $RETURNS$
;       A Logical value.
;   $DESCRIPTION$
;       GT_IsDesq() can be used to see if your application is running
;       under DesqView.
;   $EXAMPLES$
;       if GT_IsDesq()
;          ? "Running under DesqView"
;       endif
;   $END$
;
        IDEAL

Public  GT_ISDESQ

Extrn   __RetL:Far

Segment GtLibrary       Word    "CODE"
        Assume          CS:GtLibrary

Proc    GT_ISDESQ       Far

        Push    BP              ; Save registers.
        Mov     BP,SP
        Push    DS
        Push    ES
        Push    SI
        Push    DI

        Mov     AX,2B01h        ; DOS Set Time Service.
        Mov     CX,'DE'         ; We check for DesqView by trying to set the
        Mov     DX,'SQ'         ; time to `DESQ'.
        Int     21h             ; Call DOS.
        And     AX,0FFh         ; Mask AX for the FFh that DOS would return.
        Sub     AX,0FFh         ; Swap the value of AX ready for __RetL.
        Push    AX              ; Push AX onto stack for return.
        Call    __RetL          ; Return logical value back to Clipper.
        Add     SP,2            ; Reset the stack pointer.

        Pop     DI              ; Restore registers.
        Pop     SI
        Pop     ES
        Pop     DS
        Pop     BP

        Ret

EndP    GT_ISDESQ

EndS    GtLibrary

End
