/*
 * File......: GT_Derr.prg
 * Author....: Niall Scott
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Niall Scott
 * Date......: 29/06/93
 * Revision..: 1.0
 * Log file..: $Logfile$
 *
 * This is an original work by Niall R Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * Rev 1.0  29/06/93
 * Initial Revision
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ERRDISC()
 *  $CATEGORY$
 *      Error System
 *  $ONELINER$
 *      Check a disc read/write error and recover from it.
 *  $SYNTAX$
 *  	bNewHandler := {|e| GT_ErrDisc(e, bOldHandler)}
 *  $ARGUMENTS$
 *      e - Error object
 *		bOldHandler - Previous Error Handler
 *  $RETURNS$
 *		An array of three elements
 *		Elem[1] := Error Message
 *		Elem[2] := User Action
 *		Elem[3] := Error number - useful if you want to
 *		           divert to another routine e.g. for formatting
 *  $DESCRIPTION$
 *      Error handler for use with disc read/writes
 *		to enable recovery from disc problems.
 *		MUST Be Used within BEGIN SEQUENCE/END SEQUENCE construct
 *  $EXAMPLES$
 *		FUNCTION DiscErr()
 *			Local oOldHandler
 *			Local nTries := 0
 *			Local nAns
 *			local aArrErr
 *
 *		   // Set up the New handler and pass old handler as a parameter
 *		   bNewHandler := {|e| ErrDisc(e, bOldHandler)}
 *		   bOldHandler := ErrorBlock(bNewHandler)
 *
 *			WHILE (.t.)
 *				BEGIN SEQUENCE
 *
 *					// Floppy disc access here
 *					fopen('a:\missing.zxy')
 *
 *					//For low Level functions that don't normally use the
 *					// error system
 *					 GT_LOWERR()
 *
 *					// This is the recovery section of the Begin/End Sequence
 *					// construct.  A BREAK statement got us to this point.
 *				RECOVER USING aErrArr
 *
 *					// Allow the user three attempts
 *					if nTries++ < 3
 *						...
 *						...
 *						...
 *						// Your recovery code
 *						...
 *						...
 *						...
 *						Do Case
 *						Case nAns == 2
 *							EXIT
 *						Case nAns == 3
 *							QUIT
 *						EndCase
 *					ENDIF
 *				END SEQUENCE
 *			ENDDO
 *		RETURN NIL
 *  $SEEALSO$
 *  	GT_LOWERR()
 *  $INCLUDE$
 *      GT_Lower.ch
 *  $END$
 */

#include "GT_LIB.ch"
#include "GT_Lower.ch"

FUNCTION ErrDisc( oErr, bOld )
	LOCAL nDiskStat
	LOCAL aErrors := {19,21,23,25,26,27,29,30,31,34}
	LOCAL aErrMsg := {  ;
					   {"Disc Drive Write Protected","Please unprotect and retry."    ,1  } ,;
					   {"Drive not ready",      "Please insert disc and try again. "  ,2  } ,;
					   {"Data Error",           "Please insert new disc and try again",3  } ,;
					   {"Seek Error",           "Please insert new disc and try again",4  } ,;
					   {"Unknown Media Type",   "Please insert new disc and try again",5  } ,;
					   {"Sector Not Found",     "Please insert new disc and try again",6  } ,;
					   {"Error Writing to disc","Please insert new disc and try again",7  } ,;
					   {"Error reading Disc",   "Please insert new disc and try again",8  } ,;
					   {"Disc not Formatted",   "Please insert new disc and try again",9  } ,;
					   {"Invalid Disc Change",  "Please insert old disc and try again",10 } ;
					  }

	LOCAL oOldErr

	nDiskStat := ASCAN(aErrors, oErr:OsCode)

	if oErr:GenCode == 21 .and. nDiskStat > 0
		//A noise to attract the user's attention
		TONE( 500,  3)
		TONE( 750,  5)
		TONE(2000, 12)

		BREAK aErrMsg[nDiskStat]
	ENDIF

RETURN (EVAL(bOld, oErr))
