/*
    File......: GT_Alias.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 11/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 11/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_ALIAS()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Find the workarea of an alias
 *  $SYNTAX$
 *      GT_Alias(<cAlias>) -> nArea
 *  $ARGUMENTS$
 *      <cAlias> is the alias to find.
 *  $RETURNS$
 *      nArea
 *  $DESCRIPTION$
 *      Find the workarea of an alias
 *  $EXAMPLES$
 *      // Which area contains the invoices file ?
 *      nArea := GT_Alias('INVOICES')
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_Alias(cAlias)

LOCAL nArea := 1

//  Upper case
cAlias := UPPER(cAlias)

//  Find
DO WHILE (UPPER(ALIAS(nArea)) != cAlias) .AND. .NOT. EMPTY(ALIAS(nArea))
    nArea ++
ENDDO

//  Errors ?
IF ALIAS(nArea) != cAlias
    nArea := 0
ENDIF

/*
    End of GT_Alias()
*/
RETURN(nArea)
