/*
 * File......: DBSTRU.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

// Length of the database file header.

#define DBF_HEADER_LEN     32

// Length if a field definition record in the field array.

#define DBF_FIELD_LEN      32

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DBSTRUCT()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Create an array containing the struct of a DBF file.
 *  $SYNTAX$
 *      GT_DBStruct(<cFileName>) --> aStructure
 *  $ARGUMENTS$
 *      <cFileName> is the name of the DBF file. If the name has no
 *      extension it defaults to DBF.
 *  $RETURNS$
 *      An array holding the structure of the DBF file. For more information
 *      on the structure of this array see the documention for the Clipper
 *      function DBStruct().
 *  $DESCRIPTION$
 *      GT_DBStruct() is designed to be the same as the Clipper function
 *      DBStruct(). The main change is that it works on un-opened database
 *      files.
 *  $EXAMPLES$
 *      // Create a new database file using the structure of an existing
 *      // file.
 *
 *      dbcreate("Universe",GT_DBStruct("Life"))
 *  $END$
 */

function GT_DBStruct(cFile)
local aStructure := {}       ,;
      nDbfFile   := 0        ,;
      cHeader    := space(32),;
      nFldArSize := 0        ,;
      cFields    := NULL
if valtype(cFile) == TYPE_CHAR
   cFile := GT_DefExt(cFile,"Dbf")
   if GT_IsDbf(cFile)
      if (nDbfFile := fopen(cFile)) != F_ERROR
         if fread(nDbfFile,@cHeader,DBF_HEADER_LEN) == DBF_HEADER_LEN
            cFields := space(nFldArSize := DBF_FIELD_LEN * (((bin2i(substr(cHeader,9,2))-1)/32)-1))
            if fread(nDbfFile,@cFields,nFldArSize) == nFldArSize
               aStructure := BuildStructure(cFields)
            endif
         endif
         fclose(nDbfFile)
      endif
   endif
endif
return(aStructure)

/*****************************************************************************
* Function: BuildStructure()                                                 *
* Syntax..: DuildStructure(<cFieldArray>) --> aStructure                     *
* Usage...: Internal function to take the field array string and turn it into*
* ........: a Clipper array.                                                 *
* By......: David A Pearson                                                  *
*****************************************************************************/

static function BuildStructure(cFieldArray)
local aStructure := {}  ,;
      nField     := 0   ,;
      nMaxField  := len(cFieldArray)/DBF_FIELD_LEN
for nField := 1 to nMaxField
   aadd(aStructure,MakeField(substr(cFieldArray,((nField-1)*DBF_FIELD_LEN)+1,DBF_FIELD_LEN)))
next
return(aStructure)

/*****************************************************************************
* Function: MakeField()                                                      *
* Syntax..: MakeField(<cField>) --> aField                                   *
* Usage...: Internal function to take field record from the string array and *
* ........: turn it into a structure element.                                *
* By......: David A Pearson                                                  *
*****************************************************************************/

static function MakeField(cField)
local cName     := NULL,;
      cType     := NULL,;
      nLength   := 0   ,;
      nDecimals := 0
cName     := left(cField,at(chr(0),cField)-1)
cType     := substr(cField,12,1)
nLength   := if(cType == TYPE_CHAR,bin2i(substr(cField,17,2)),asc(substr(cField,17,1)))
nDecimals := if(cType == TYPE_CHAR,0,asc(substr(cField,18,1)))
return({ cName , cType , nLength , nDecimals })
