#include "hardware.h"	/***/
/* Stuff heavily dependent on the configuration info in config.h */
#define OS2

#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <conio.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "cmdparse.h"
#include "config.h"
#include "daemon.h"
#include "timer.h"
#include "iface.h"
#include "pktdrvr.h"
#include "slip.h"
#include "usock.h"
#include "kiss.h"
#ifdef ETHER
#include "enet.h"
#endif
#include "ax25.h"
#ifdef NETROM
#include "netrom.h"
#include "nr4.h"
#endif
#include "arp.h"
#include "ip.h"
#include "icmp.h"
#include "tcp.h"
#include "udp.h"
#include "commands.h"
#ifdef ARCNET
#include "arcnet.h"
#endif

static int dostart __ARGS((int argc,char *argv[],void *p));
static int dostop __ARGS((int argc,char *argv[],void *p));
static int dowrite __ARGS((int argc,char *argv[],void *p));

#ifdef MDEBUG
extern int domdump __ARGS((int argc,char *argv[],void *p));
#endif

#ifdef OS2
static int domtask __ARGS((int argc,char *argv[],void *p));
#endif

struct mbuf *Hopper;
unsigned Nsessions = NSESSIONS;

/* Free memory threshold, below which things start to happen to conserve
 * memory, like garbage collection, source quenches and refusing connects
 */
int32 Memthresh = (long)MTHRESH;		/* to be sure - db3fl */

/* Transport protocols atop IP */
struct iplink Iplink[] = {
	TCP_PTCL,	tcp_input,
	UDP_PTCL,	udp_input,
	ICMP_PTCL,	icmp_input,
#if (defined (AX25) && defined (AXIP))
	AX25_PTCL,	axip_input,
#endif
	IP_PTCL,	ipip_recv,
	0,		0
};

/* Transport protocols atop ICMP */
struct icmplink Icmplink[] = {
	TCP_PTCL,	tcp_icmp,
	0,		0
};

/* ARP protocol linkages */
struct arp_type Arp_type[NHWTYPES] = {
#ifdef	NETROM
	AXALEN, 0, 0, 0, NULLCHAR, pax25, setcall,	/* ARP_NETROM */
#else
	0, 0, 0, 0, NULLCHAR,0,0,
#endif

#ifdef	ETHER
	EADDR_LEN,IP_TYPE,ARP_TYPE,1,Ether_bdcst,pether,gether, /* ARP_ETHER */
#else
	0, 0, 0, 0, NULLCHAR,0,0,
#endif

	0, 0, 0, 0, NULLCHAR,0,0,		/* ARP_EETHER */

#ifdef	AX25
	AXALEN, PID_IP, PID_ARP, PENDTIME, Ax25multi[0], pax25, setcall,
#else
	0, 0, 0, 0, NULLCHAR,0,0,		/* ARP_AX25 */
#endif

	0, 0, 0, 0, NULLCHAR,0,0,		/* ARP_PRONET */

	0, 0, 0, 0, NULLCHAR,0,0,		/* ARP_CHAOS */

	0, 0, 0, 0, NULLCHAR,0,0,		/* ARP_IEEE802 */

#ifdef	ARCNET
	AADDR_LEN, ARC_IP, ARC_ARP, 1, ARC_bdcst, parc, garc, /* ARP_ARCNET */
#else
	0, 0, 0, 0, NULLCHAR,0,0,
#endif

	0, 0, 0, 0, NULLCHAR,0,0,		/* ARP_APPLETALK */
};

extern void garbage __ARGS((int i, void *v1, void *v2));

/* daemons to be run at startup time */
struct daemon Daemons[] = {
	"killer",	512,	killer,
	"timer",	2048,	timerproc,
	"network",	4096,	network,
	"keyboard",	512,	keyboard,
	"status",	512,	statusline,
	NULLCHAR,	0,		NULLVFP
};

struct iftype Iftypes[] = {
	/* This entry must be first, since Loopback refers to it */
	"None", 0, 0, 0, 0,	CL_NONE, 0,

#ifdef	AX25
	"AX25",ax_send,ax_output,pax25,setcall,CL_AX25,AXALEN,
#endif

#ifdef	SLIP
	"SLIP",slip_send,0,0,0,CL_NONE,0,
#endif

#ifdef	ETHER
	/* Note: NULL is specified for the scan function even though
	 * gether() exists because the packet drivers don't support
	 * address setting.
	 */
	"Ethernet",enet_send,enet_output,pether,0,CL_ETHERNET,EADDR_LEN,
#endif

#ifdef	NETROM
	"NETROM",nr_send,0,pax25,setcall,CL_NETROM,AXALEN,
#endif

#ifdef	SLFP
	"SLFP",pk_send,NULL,NULL,NULL,CL_NONE,0,
#endif
	NULLCHAR
};

/* Command lookup and branch tables */
struct cmds Cmds[] = {
	/* The "go" command must be first */
	"",			go,			0, 0, NULLCHAR,
#ifdef MDEBUG
	".",	    domdump,	0, 0, NULLCHAR,
#endif
#ifndef	AMIGA
	"!",		doshell,	0, 0, NULLCHAR,
#endif
	"abort",	doabort,	0, 0, NULLCHAR,
#ifdef	AMIGA
	"amiga",	doamiga,	0, 0, NULLCHAR,
#endif
#if	(defined(MAC) && defined(APPLETALK))
	"applestat",	doatstat,	0,	0, NULLCHAR,
#endif
#if	(defined(AX25) || defined(ETHER) || defined(APPLETALK))
	"arp",		doarp,		0, 0, NULLCHAR,
#endif
#ifdef	ASY
	"asystat",	doasystat,	0, 0, NULLCHAR,
#endif
	"attach",	doattach,	0, 2, "attach <hardware> <hw specific options>",
	"attended",	doattended,	0, 0, NULLCHAR,
	"attribute",doattribute,0, 2, "attribute <color|mono>",
#ifdef	AX25
	"ax25",		doax25,		0, 0, NULLCHAR,
#endif
#ifdef	MAILBOX
	"bbs",		dobbs,		1024, 0, NULLCHAR,
#endif
	"bell",		dobell,		0, 0, NULLCHAR,
/* This one is out of alpabetical order to allow abbreviation to "c" */
#ifdef	AX25
	"connect",  doconnect,  1024, 2, "connect [<iface>] <call>",
#endif
	"chat",		dochat,		1024, 2, "chat <host>",
#if	!defined(UNIX) && !defined(AMIGA)
	"cd",		docd,		0, 0, NULLCHAR,
#endif
	"close",	doclose,	0, 0, NULLCHAR,
/*
	"dial",		dodial,		0, 3,"dial <iface> <dial-string>",
*/
#ifndef	AMIGA
	"dir",		dodir,		1024, 0, NULLCHAR, /* note sequence */
#endif
	"delete",	dodelete,	0, 2, "delete <file>",
	"detach",	dodetach,	0, 2, "detach <iface>",
	"domain",	dodomain,	0, 0, NULLCHAR,
#ifdef	DRSI
	"drsistat",	dodrstat,	0, 0, NULLCHAR,
#endif
#ifdef MDEBUG
	"dump",		domdump,	0, 0, NULLCHAR,
#endif
	"echo",		doecho,		0, 0, NULLCHAR,
	"eol",		doeol,		0, 0, NULLCHAR,
	"escape",	doescape,	0, 0, NULLCHAR,
#ifdef	PC_EC
	"etherstat",	doetherstat,	0, 0, NULLCHAR,
#endif
	"exit",		doexit,		0, 0, NULLCHAR,
	"finger",	dofinger,	1024, 2, "finger <name|[@<host>]>",
	"ftp",		doftp,		1536, 2, "ftp <host>",
	"help",		dohelp,		0, 0, NULLCHAR,
	"hostname",	dohostname,	0, 0, NULLCHAR,
	"icmp",		doicmp,		0, 0, NULLCHAR,
	"ifconfig",	doifconfig,	0, 0, NULLCHAR,
	"ip",		doip,		0, 0, NULLCHAR,
	"kick",		dokick,		0, 0, NULLCHAR,
	"log",		dolog,		0, 0, NULLCHAR,
#ifdef LZW
	"lzw",		dolzw,		0, 2, "lzw <bits|mode>",
#endif
	"mail",		dobmail,	0, 0, NULLCHAR,
#ifdef	MAILBOX
	"mbox",		dombox,		0, 0, NULLCHAR,
#endif
	"mem",		domem,		0, 0, NULLCHAR,
	"mkdir",	domkd,		0, 2, "mkdir <dir>",
#ifdef	AX25
	"mode",		domode,		0, 2, "mode <host> [mode]",
#endif
	"more",		domore,		768, 2, "more <file>",
	"motd",		domotd,		0, 0, NULLCHAR,
#ifdef OS2
	"mtask",	domtask,	0, 0, NULLCHAR,
#endif
#ifdef	NETROM
	"netrom",	donetrom,	0, 0, NULLCHAR,
#endif
#ifdef	NNTP
	"nntp",		donntp,		0, 0, NULLCHAR,
/*	"nntpview",	donntpview,	0, 0, NULLCHAR, */
#endif
#ifdef	NRS
	"nrstat",	donrstat,	0, 0, NULLCHAR,
#endif
	"param",	doparam,	0, 2, "param <iface>",
	"ping",		doping,		1024, 2, "ping <host> <length> <interval> <incflag>",
#ifdef POP
	"pop",		dopop,		0, 0, NULLCHAR,
#endif
	"ps",		ps,			0, 0, NULLCHAR,
#if	!defined(UNIX) && !defined(AMIGA)
	"pwd",		docd,		0, 0, NULLCHAR,
#endif
#ifdef RARP
#if	(defined(AX25) || defined(ETHER))
	"rarp",		dorarp,		0, 0, NULLCHAR,
#endif
#endif /* RARP */
	"record",	dorecord,	0, 0, NULLCHAR,
	"remote",	doremote,	0, 3, "remote [-p port] [-k key] [-a kickaddr] <host> exit|reset|kick",
	"rename",	dorename,	0, 3, "rename <oldfile> <newfile>",
	"reset",	doreset,	0, 0, NULLCHAR,
	"resetping",    doresetping,    0, 2, "resetping <target>",
	"rmdir",	dormd,		0, 2, "rmdir <dir>",
	"route",	doroute,	0, 0, NULLCHAR,
	"session",	dosession,	0, 0, NULLCHAR,
	"save",		dosavefile,     0, 0, NULLCHAR,
	"setping",	dosetping,	0, 0, NULLCHAR,
#ifdef RLOGINCLI
        "rlogin",       dorlogin,       2048,   2,  "rlogin <address>",
        "rloguserid",   dorloguser,     0, 0,   NULLCHAR,
#endif
#ifdef	SCC
	"sccstat",	dosccstat,	0, 0, NULLCHAR,
#endif
#if	!defined(AMIGA)
	"shell",	doshell,	0, 0, NULLCHAR,
#endif
	"smtp",		dosmtp,		0, 0, NULLCHAR,
	"socket",	dosock,		0, 0, NULLCHAR,
	"source",	dosource,	0, 2, "source <file>",
#ifdef	SERVERS
	"start",	dostart,	0, 2, "start <server>",
#endif
	"status",	dostatus,	0, 0, NULLCHAR,
#ifdef  SERVERS
	"stop",		dostop,		0, 2, "stop <server>",
#endif
	"swap",		doswap,		0, 0, NULLCHAR,
#ifdef MAILBOX
	"setsysop",	dosysopset, 0, 2, "<secret number>",
	"sysop",	dormncsys,	0, 2, "<number>",
#endif
	"tcp",		dotcp,		0, 0, NULLCHAR,
	"tail",		dotail,		0, 2, "tail <file>",
	"telnet",	dotelnet,	1024, 2, "telnet <host>",
#ifdef	MAILBOX
	"thirdparty",	dothirdparty,	0, 0, NULLCHAR,
#endif
#ifdef ASY
	"tip",		dotip,		1024, 2, "tip <iface>",
#endif
#ifdef	TRACE
	"trace",	dotrace,	0, 0, NULLCHAR,
#endif
	"udp",		doudp,		0, 0, NULLCHAR,
	"upload",	doupload,	0, 0, NULLCHAR,
#if defined(MSDOS) && defined (XXX)
	"watch",	doswatch,	0, 0, NULLCHAR,
#endif
	"wrap",		dowrap,		0, 0, NULLCHAR,
	"write",	dowrite,	0, 2, "write <socket> <msg>",
	"?",		dohelp,		0, 0, NULLCHAR,
	NULLCHAR,	NULLFP,		0, 0, "Invalid command. Try HELP.",
};

/* Functions to be called on each clock tick */
void (*Cfunc[])() = {
	pctick,		/* Call PC-specific stuff to keep time */
	kbint,		/* Necessary because there's no hardware keyboard interrupt */
	refiq,		/* Replenish interrupt pool */
#ifdef	ASY
	asytimer,
#endif
#ifdef	SCC
	scctimer,
#endif
	0,
};

/* Packet tracing stuff */
#ifdef	TRACE
#include "trace.h"

/* Protocol tracing function pointers. Matches list of class definitions
 * in pktdrvr.h.
 */
struct trace Tracef[] = {
	NULLFP,			ip_dump,		/* CL_NONE */
#ifdef	ETHER
	ether_forus,	ether_dump,		/* CL_ETHERNET */
#else
	NULLFP,		NULLVFP,
#endif
	NULLFP,			NULLVFP,		/* CL_PRONET_10 */
	NULLFP,			NULLVFP,		/* CL_IEEE8025 */
	NULLFP,			NULLVFP,		/* CL_OMNINET */
#ifdef	APPLETALK
	at_forus,		at_dump,		/* CL_APPLETALK */
#else
	NULLFP,			NULLVFP,
#endif
	NULLFP,			ip_dump,		/* CL_SERIAL_LINE */
	NULLFP,			NULLVFP,		/* CL_STARLAN */
#ifdef	ARCNET
	arc_forus,		arc_dump,		/* CL_ARCNET */
#else
	NULLFP,			NULLVFP,
#endif
#ifdef	AX25
	ax_forus,		ax25_dump,		/* CL_AX25 */
#else
	NULLFP,			NULLVFP,
#endif
#ifdef	KISS				
	ki_forus,		ki_dump,		/* CL_KISS */
#else
	NULLFP,			NULLVFP,
#endif
	NULLFP,			NULLVFP,		/* CL_IEEE8023 */
	NULLFP,			NULLVFP,		/* CL_FDDI */
	NULLFP,			NULLVFP,		/* CL_INTERNET_X25 */
	NULLFP,			NULLVFP,		/* CL_LANSTAR */
	NULLFP,			ip_dump,		/* CL_SLFP */
#ifdef	NETROM
	NULLFP,			ip_dump,        /* CL_NETROM */
#else
	NULLFP,			NULLVFP,
#endif

};
#else	/* TRACE */
/* Stub for packet dump function */
void
dump(iface,direction,type,bp)
struct iface *iface;
int direction;
unsigned type;
struct mbuf *bp;
{
}
void
raw_dump(iface,direction,bp)
struct iface *iface;
int direction;
struct mbuf *bp;
{
}
#endif	/* TRACE */

/* Stub for routing timeout when RIP is not configured -- just remove entry */
void
rt_timeout(s)
void *s;
{
	struct route *stale = (struct route *)s;

	rt_drop(stale->target,stale->bits);
}

#ifdef	SERVERS

extern int xconv0 __ARGS((int argc,char *argv[],void *p));
extern int xconv1 __ARGS((int argc,char *argv[],void *p));


/* "start" and "stop" subcommands */
static int
dostart(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct cmds Startcmds[] = {
#if	defined(AX25) && defined(MAILBOX)
		"ax25",		ax25start,	256, 0, NULLCHAR,
#endif
		"chat",		ttylstart,	256, 0, NULLCHAR,
#ifdef CONVERS
		"convers",	conv1,		512, 0,	NULLCHAR,
#endif
		"discard",	dis1,		256, 0, NULLCHAR,
		"domain",	dom1,		768, 0, NULLCHAR,
		"echo",		echo1,		256, 0, NULLCHAR,
		"finger",	finstart,	256, 0, NULLCHAR,
		"ftp",		ftpstart,	256, 0, NULLCHAR,
#if	defined(NETROM) && defined(MAILBOX)
		"netrom",	nr4start,	256, 0, NULLCHAR,
#endif
#ifdef	NNTP
		"nntp",     nntp1,		768, 0, NULLCHAR,
#endif
#ifdef POP
		"pop",		pop1,		256, 0, NULLCHAR,
#endif
		"smtp",		smtp1,		256, 0, NULLCHAR,
#if	defined(MAILBOX)
		"telnet",	telnet1,	256, 0, NULLCHAR,
#endif
		"ttylink",	ttylstart,	256, 0, NULLCHAR,
		"remote",	rem1,		1024, 0, NULLCHAR,
#if (defined(LZW) && defined(CONVERS))
		"xconvers", xconv1,		512, 0, NULLCHAR,
#endif
		NULLCHAR,
	};
	return subcmd(Startcmds,argc,argv,p);
}

static int
dostop(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct cmds Stopcmds[] = {
#if	defined(AX25) && defined(MAILBOX)
		"ax25",		ax250,		0, 0, NULLCHAR,
#endif
		"chat",		ttyl0,		0, 0, NULLCHAR,
#ifdef CONVERS
		"convers",	conv0,		0, 0, NULLCHAR,
#endif
		"discard",	dis0,		0, 0, NULLCHAR,
		"domain",	dom0,		0, 0, NULLCHAR,
		"echo",		echo0,		0, 0, NULLCHAR,
		"finger",	fin0,		0, 0, NULLCHAR,
		"ftp",		ftp0,		0, 0, NULLCHAR,
#if	defined(NETROM) && defined(MAILBOX)
		"netrom",	nr40,		0, 0, NULLCHAR,
#endif
#ifdef NNTP
		"nntp",		nntp0,		0, 0, NULLCHAR,
#endif
#ifdef POP
		"pop",		pop0,		0, 0, NULLCHAR,
#endif
		"smtp",		smtp0,		0, 0, NULLCHAR,
#ifdef	MAILBOX
		"telnet",	telnet0,	0, 0, NULLCHAR,
#endif
		"ttylink",	ttyl0,		0, 0, NULLCHAR,
		"remote",	rem0,		0, 0, NULLCHAR,
#if (defined(LZW) && defined(CONVERS))
		"xconvers", xconv0,		0, 0, NULLCHAR,
#endif
		NULLCHAR,
	};
	return subcmd(Stopcmds,argc,argv,p);
}
#endif	/* SERVERS */

/* Various configuration-dependent functions */
/* Process packets in the Hopper */
static void
network(i,v1,v2)
int i;
void *v1;
void *v2;
{
	struct mbuf *bp;
	struct phdr phdr;
	int i_state;

	for(;;) {
		refiq();	/* Replenish interrupt buffer pool */

		i_state = dirps();
		while(Hopper == NULLBUF)
			pwait(&Hopper);
		restore(i_state);

		/* Process the input packet */
		bp = dequeue(&Hopper);
		pullup(&bp,(char *)&phdr,sizeof(phdr));

#ifdef XXX
		now in trace.c - DB3FL.920208
		if(phdr.iface != NULLIF) {
			phdr.iface->lastrecv = secclock();
			phdr.iface->rawrecvcnt++;
		}
#endif

		dump(phdr.iface,IF_TRACE_IN,phdr.type,bp);

		switch(phdr.type){
#ifdef	KISS
		case CL_KISS:
			kiss_recv(phdr.iface,bp);
			break;
#endif
#ifdef	AX25
		case CL_AX25:
			ax_recv(phdr.iface,bp);
			break;
#endif
#ifdef	ETHER
		case CL_ETHERNET:
			eproc(phdr.iface,bp);
			break;
#endif
#ifdef ARCNET
		case CL_ARCNET:
			aproc(phdr.iface,bp);
			break;
#endif
		/* These types have no link layer protocol at the point when they're
		 * put in the hopper, so they can be handed directly to IP. The
		 * separate types are just for user convenience when running the
		 * "iface" command.
		 */
		case CL_NONE:
		case CL_SERIAL_LINE:
		case CL_SLFP:
			ip_route(phdr.iface,phdr.iface,bp,0);
			break;
		default:
			free_p(bp);
			break;
		}
		/* Let everything else run - this keeps the system from wedging
		 * when we're hit by a big burst of packets
		 */
		pwait(NULL);
	}
}

static int
dowrite(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char msg[256];
	int count, i, sock[DEFNSOCK];

	count = (argc < DEFNSOCK - 1) ? argc : DEFNSOCK -1;

	/* get socket args */
	for (i = 1; i < count; i++)
		if((sock[i] = atoi(argv[i])) == 0)
			break;

	count = i;
	msg[0] = '\0';

	/* collect rest of args as message */
	for (; i < argc; i++) {
		strcat(msg,argv[i]);
		strcat(msg," ");
	}

	/* output to all sockets */
	for (i = 1; i < count; i++)	{
		usprintf(sock[i],"\n*** message from %s:\n%s\n",Hostname,msg);
		usflush(sock[i]);
	}
	return 0;
}

/* Attach an interface
 * Syntax: attach <hw type> <I/O address> <vector> <mode> <label> <bufsize> [<speed>]
 */
static int
doattach(argc,argv,p)
int argc;
char *argv[];
void *p;
{
  /* List of supported hardware devices */
  struct cmds Attab[] = {
#ifdef  PC_EC
    /* 3-Com Ethernet interface */
    "3c500", ec_attach, 0, 7,
    "attach 3c500 <address> <vector> arpa <label> <bufsize> <mtu> [<ip_address>]",
#endif
#ifdef  ASY
    /* Ordinary PC asynchronous adaptor */
    "asy", asy_attach, 0, 8,
#ifndef AMIGA
    "attach asy <address> <vector> slip|ax25|nrs <label> <bufsize> <mtu> <speed> <c|v>",
#else
    "attach asy <driver> <unit> slip|ax25|nrs <label> <bufsize> <mtu> <speed> <c|v>",
#endif  /* AMIGA */
#endif  /* ASY */
#if defined(KISS) && (defined(ASY) || defined(SCC))
    /* Multi-port KISS interface piggy-backing on ASY interface. */
    "kiss", kiss_attach, 0, 4,
	"attach kiss <asy_iface_label> <port> <label> [mtu]",
#endif  /* KISS */
#ifdef  DRSI
    /* DRSI PCPA card in low speed mode */
    "drsi", dr_attach, 0, 8,
	"attach drsi <address> <vector> ax25 <label> <bufsize> <mtu> <speed_A>"
	" [<speed_B> [<ip_address_A> [<ip_address_B>]]]",
#endif
#ifdef NETROM
    /* fake netrom interface */
    "netrom", nr_attach, 0, 1,
	"attach netrom",
#endif
#ifdef  PACKET
    /* FTP Software's packet driver spec */
    "packet", pk_attach, 0, 4,
    "attach packet <int#> <label> <bufsize> <mtu> [<ip_address>]",
#endif
#ifdef SCC
    "scc", scc_attach, 0, 7,
    "attach scc <devices> init <address> <spacing> <Aoff> <Boff> <Dataoff>\n"
    "   <intack> <vector> [p|r]<clock> [hdwe] [param]\n"
	"attach scc <channel> slip|ax25|nrs|kiss <label> <mtu> <speed> <bufsize>",
  #endif
#if (defined (AX25) && defined (AXIP))
    "axip", axip_attach, 0, 3,
    "attach axip <label> <mtu> <remote_host>",
#endif
#ifdef  VANESSA
    "vanessa", van_attach, 0, 3,
    "attach vanessa <label> <port#> [<mtu>]",
#endif
    NULLCHAR,
  };

  return subcmd(Attab,argc,argv,p);
}

#ifdef OS2
static int
domtask (int argc,char *argv[],void *p)
{
	if(argc > 1)
		Mtasker = 4;
	else
		chktasker();
	return 0;
}
#endif
