/*----------------------------------------------------------------------*
* changed to include PID into link quality Packet                       *
*-----------------------------------------------------------------------*/

#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "ax25.h"
#include "ip.h"
#include "timer.h"

static int MHwait = 0;          /* Semaphore to serialize access to heardlist*/

void
init_maxheard(struct iface *ifp)
{
	ifp->Hmax = MAXDEFAULT;
	ifp->Hcurrent = 0;
	ifp->lq = cxallocw(MAXDEFAULT,sizeof(struct lq));
}

int
maxheard(struct iface *ifp,int num)
{
struct lq *lnew,*lold;

   /*-------------------------------------------------------------------*
   * Don't blow the list away while somebody is writing a entry
   *--------------------------------------------------------------------*/
   if(num == 0)
	  num = 1;
   lnew = cxallocw(num,sizeof(struct lq));
   semwait(&MHwait,1);                  /* request/wait                 */
   lold = ifp->lq;
   ifp->lq = lnew;
   ifp->Hcurrent = 0;
   ifp->Hmax = num;
   semrel(&MHwait);
   xfree(lold);
   return(0);
}

static struct lq * near
al_lookup(struct iface *ifp,char *addr)
{
register struct lq *lp;
int i;

   semwait(&MHwait,0);

   lp = ifp->lq;
   for(i = 0; i < ifp->Hmax; i++){
      if(addreq(lp->addr,addr)){
         return lp;
      }
	  if (lp->time == 0)
         break;
      lp++;
   }
   return NULLLQ;
}

/*----------------------------------------------------------------------*
* Create a new entry in the AX.25 link table                            *
*-----------------------------------------------------------------------*/
static struct lq * near
al_create(register struct iface *ifp,char *addr,char pid)
{
register struct lq *lp;
register struct lq *lo = NULLLQ;
int16 i;
int32 time = currtime;

   semwait(&MHwait,1);

   if (ifp->Hcurrent < ifp->Hmax)   {
      lp = &ifp->lq[ifp->Hcurrent];
      ifp->Hcurrent++;
   } else   {                           /* look for the oldest one      */
      lp = ifp->lq;
	  for (i = 0; i < ifp->Hcurrent; i++)   {
         if (lp->time < time)  {
            time = lp->time;
            lo = lp;
         }
         lp++;
      }
      lp = lo;
   }
   lp->pid = pid;
   lp->currxcnt = 1;
   memcpy(lp->addr,addr,AXALEN);
   semrel(&MHwait);
   return lp;
}

/*----------------------------------------------------------------------*
* Log the address of an incoming packet                                 *
*-----------------------------------------------------------------------*/
void
logaddr(struct iface *ifp,char *addr,char pid)
{
   register struct lq *lp;

   if (MHwait)
      return;
   if(addreq(addr,ifp->hwaddr))
      return;               /* Don't log our own packets if we hear them*/

   if((lp = al_lookup(ifp,addr)) == NULLLQ &&
	(lp = al_create(ifp,addr,pid)) == NULLLQ)
      return;
   lp->pid = pid;
   lp->currxcnt++;
   lp->time = currtime;
}

/*----------------------------------------------------------------------*
*-----------------------------------------------------------------------*/
void
axflush(ifp)
struct iface *ifp;
{
   semwait(&MHwait,1);
   ifp->rawsndcnt = ifp->Hcurrent = 0;
   memset(ifp->lq,0,ifp->Hmax * sizeof(struct lq));  /* brute force */
   semrel(&MHwait);
}
