/*****************************************************************************
  MODELESS.CPP

  Purpose:  
  	Implements CModelessDialog, a reusable class for creating modeless
  	dialogs.

  Functions:
  	CModelessDialog::CModelessDialog()		-- constructor
  	CModelessDialog::~CModelessDialog()		-- destructor
  	CModelessDialog::Create()				-- creates dialog window
  	CModelessDialog::OnCancel()				-- WM_COMMAND IDCANCEL handler
  	CModelessDialog::OnOK()					-- WM_COMMAND IDOK handler
  	CModelessDialog::PostNcDestroy()		-- called after WM_NCDESTROY

  Development Team:
  	Mary Kirtland

  Written by Microsoft Product Support Services, Premier ISV Support
  Copyright (c) 1994 Microsoft Corporation. All rights reserved.
\****************************************************************************/

#include "stdafx.h"
#include "modeless.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog 

IMPLEMENT_DYNAMIC(CModelessDialog, CDialog)

BEGIN_MESSAGE_MAP(CModelessDialog, CDialog)
	//{{AFX_MSG_MAP(CModelessDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog Construction/Destruction

CModelessDialog::CModelessDialog() 
{
}
        
CModelessDialog::~CModelessDialog()
{
}
  
void CModelessDialog::PostNcDestroy()
{
	delete this;
}

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog::Create
//		CDialog::Create is a protected function, so we derive our own
//		public function to allow creation of CModelessDialog objects
//		without deriving a new class.
        
BOOL CModelessDialog::Create(UINT nIDTemplate, CWnd* pParentWnd) 
{  
	BOOL bSuccess = CDialog::Create(nIDTemplate, pParentWnd);
	if (!bSuccess)
		TRACE("Unable to create dialog using template ID %d\n", nIDTemplate);
	return bSuccess;
}

BOOL CModelessDialog::Create(LPCSTR lpszTemplateName, CWnd* pParentWnd) 
{
	ASSERT(lpszTemplateName != NULL);
	
	BOOL bSuccess = CDialog::Create(lpszTemplateName, pParentWnd);
	if (!bSuccess)
		TRACE("Unable to create dialog using template %s\n", lpszTemplateName);
	return bSuccess;
}       

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog::OnCancel
//		Modeless dialogs must not call EndDialog(), as CDialog::OnCancel()
//		does.  All we need to do is destroy the window.

void CModelessDialog::OnCancel() 
{
	DestroyWindow();
}

/////////////////////////////////////////////////////////////////////////////
// CModelessDialog::OnOK
//		Modeless dialogs must not call EndDialog(), as CDialog::OnOK() does
//		We retrieve data from the controls using DDX, then destroy the 
//		window.

void CModelessDialog::OnOK() 
{
	if (!UpdateData(TRUE)) 
	{
		TRACE0("UpdateData failed -- modeless dialog terminate\n");
		return;
	}
	DestroyWindow();
}




