/***************************************************************
 *                                                             *
 *          $VER: CheckCid 0.10 (12.10.94)                     *
 *                                                             *
 *          $author  Santosh K. Bungay                         *
 *                                                             *
 ***************************************************************/

#define NOTDLG

#include <proto/dlg.h>
#include <stdio.h>
#include <cid.h>
#include <proto/exec.h>
#include <exec/types.h>
#include <libraries/dos.h>
#include <dialog/dlg.h>
#include <dialog/user.h>

struct CallerID CID;
struct USER_DATA User;
struct Ram_File Ram;

struct Library *DLGBase=NULL;

FILE *input, *output, *fopen();

char *ver = "$VER: CheckCid 0.10 (12.10.94)";

/* Clean up our resources */

void CleanUp(char *s)
{
    if(s) printf("\n%s\n",s);

    if(DLGBase)
        CloseLibrary(DLGBase);

    printf("\n");

    exit(s?5:0);
}

void breakin(void)
{
    CleanUp(NULL);
    exit(0);
}

void main(int argc,char *argv[])
{
    char string[81], usernumber[15], cidnumber[15], port[4];
    int i, j;

    onbreak(breakin);                               /* Set up ^C handling */


    DLGBase = OpenLibrary(DLGNAME,0);               /* Open dlg.library   */
    if(!DLGBase)
        CleanUp("Unable to open DLG.library");


    if(GetDevName(port) == -1)                      /* Find out what port we're running on */
        CleanUp("Unable To Identify Port");


    if(!ReadUser(&Ram,&User,port))                  /* Read the user data */
        CleanUp("Unable To Read User Data");


    sprintf(string,"T:%s.cid",port);                /* Read the CID Info  */
    if(!(input = fopen(string,"r")))
        CleanUp("Unable To Read CID Information");
    fread(&CID,sizeof(CID),1,input);
    fclose(input);


    for(i = 0, j = 0; i <= strlen(User.Phone); i++) /* Strip non-digits   */
        if(User.Phone[i] >= '0' && User.Phone[i] <= '9')
            usernumber[j++] = User.Phone[i];
    
    usernumber[j] = '\0';                           /* NULL TERMINATE     */

    if(strlen(usernumber) < 10)                     /* (nnn) nnn-nnnn     */
    {
        printf("\nYour Phone number is not complete, please edit your user setting!\n");
        CleanUp("Make sure you include your Area Code!");
    }

    strrev(usernumber);                             /* Reverse the string */
    strcpy(cidnumber,CID.Call_Nmbr);                /* to compare length  */
    strrev(cidnumber);                              /* of CID.Call_Nmbr   */
                                                    /* in case its local  */
                                                    /* (same Area Code)   */

    if(strncmp(usernumber,cidnumber,strlen(cidnumber)) != NULL)
    {
        if(User.Ansi_Flag & 1)
            sprintf(string,"nac:text/CheckCid/NoMatch.ANS");
        else
            sprintf(string,"nac:text/CheckCid/NoMatch.TXT");
        DispForm(string,&User,&User,&Ram,port);
        sprintf(string,"(CheckCID) %s called from %s",Ram.Name,CID.Call_Nmbr);
        Inform("SYSOP",string,port,1);
        printf("  Number on file: %s\nCaller ID Number: %s\n\n(Press Any Key)",User.Phone,CID.Call_Nmbr);
        getchar();
    }

    CleanUp(NULL);                                  /* All Done! */
}


