;-----------------------------------------------------------------------
;                 
;                            JRoute Sample Control File
;
;     The following are sample lines and explainations of JRoute control
; file commands.
;
;  NOTE:  JROUTE IS ONLY INTENDED FOR USE ON BINKLEY-STYLE SYSTEMS AND
;  IS ONLY PACKAGED WITH ZMAIL RELEASE ARCHIVES FOR BINKLEY VERSIONS!!
;
;-----------------------------------------------------------------------

;-----------------------------------------------------------------------
;  The SCHEDULE or SCHED line marks the beginning of a segment of routing
;  commands.  Commands listed before the first SCHED line in the control
;  file are "global" commands which will execute on all JRoute runs.
;
;  Individual schedules are executed either by name or according to the
;  current date and time.  If a schedule name is specified via a
;  SCHEDULENAME in the JMail control file or by a -S specifier on the
;  JRoute command line, the commands within that schedule will be
;  executed.  If no schedule is specified in the JMail control file or
;  on the JRoute command line, then JRoute will execute the first SCHED
;  that it finds which includes the current day of the week (or ALL) and 
;  in which the current time is within the bounds specified in the 
;  schedule's start and stop times.
;------------------------------------------------------------------------

; SCHED Daily All 00:00 23:59

;  The above line would execute either when DAILY is specified in the
;  JMail control file or on the JMail command line.  If no schedule name
;  were specifed, the above schedule would execute on any day of the week
;  or at any time of the day.

; SCHED Midweek Wed 17:00 18:00

;  The above line would execute when MIDWEEK was specified in the JMail
;  control file or on the JMail command line.  If no schedule name were
;  specified, the above schedule would only execute on Wednesdays between
;  5pm and 6pm local system time.

;--------------------------------------------------------------------------
;  ROUTING COMMAND LINES
;
;  The following lines are listed in the order in which they will be
;  processed.  JMail will scan the JMail control file followed by the
;  routing control file and gather the global command lines and the command
;  lines from any SCHED section which is active.
;
;  JMail will then execute any CHANGE1 flavor change lines on the *.?LO
;  file attach and *.?UT message text files in the outbound area(s).
;
;  It will then scan the NETMAILPATH for outbound messages.  These messages
;  will be processed or not processed according to the ROUTETO and ROUTEFROM
;  lines.  If processed, they will be processed through any DOMAINGATE and
;  ZONEGATE lines and then written to outbound .OUT files.
;
;  Outbound *.FLO file attach files will then be routed according to any
;  active ROUTEFILES statements and outbound *.OUT files will be routed
;  according to any active ROUTE statements.
;
;  Next, JMail will process any active POLL lines.  Finally, JMail will
;  execute any CHANGE2 flavor change lines on the *.?LO file attach and
;  *.?UT message text files in the outbound area(s).
;--------------------------------------------------------------------------

;  LEAVE 1:104/424@FIDONET

;  The above line would cause all *.?UT and *.?LO files currently queued
;  for 1:104/424@FIDONET to be exempt from any and all ROUTE, ROUTEFILES,
;  CHANGE1, or CHANGE2 commands which might otherwise affect them.

;  CHANGE1 CRASH NORMAL all:all/all@all EXCEPT 1:104/424@FIDONET
;  CHANGE2 CRASH NORMAL all:all/all@all EXCEPT 1:104/424@FIDONET

;  The above line would change all outbound *.CLO and *.CUT crash outbound
;  files to *.FLO and *.OUT normal flavor outbound files.  Only crash
;  files to 1:104/424@FidoNet would be exempt.  The CHANGE1 line would
;  execute prior to all other commands while the CHANGE2 line would
;  execute after all other commands.

;  ROUTEFROM 1:104/all@fidonet EXCEPT 1:104/424@FIDONET

;  The above line would accept netmail routed thru the local system from
;  all nodes in zone 1, net 104 of FidoNet except 1:104/424@Fidonet.  Any
;  messages not from zone 1, net 104 of FidoNet would not be processed and
;  would be left in the NETMAILPATH. If no ROUTEFROM lines are active on a
;  particular run, messages from any addresses would be processed.  In all
;  cases, messages from the local system addresses will be processed.

;  ROUTETO 1:all/all@fidonet EXCEPT 1:107/all@FIDONET

;  The above line would accept netmail routed thru the local system to
;  all nodes in zone 1 of FidoNet except in net 107.  Any messages not
;  to zone 1 of FidoNet would not be processed and would be left
;  in the NETMAILPATH. If no ROUTETO lines are active on a particular
;  run, messages to any addresses would be processed.  In all
;  cases, messages to the local system addresses will not be processed.

;  DOMAINGATE 1:104/438@FIDONET all:all/all@METRONET

;  The above line would domain-gate messages destined for MetroNet to
;  1:104/438@FidoNet.  Refer to the documentation for the details of
;  what is involved in domain-gating netmail messages.

;  ZONEGATE 1:1/2@FIDONET 2:all/all@FIDONET

;  The above line would zone-gate messages destined for zone 2 of FidoNet
;  to 1:1/2@Fidonet.  Refer to the documentation for the details of
;  what is involved in zone-gating netmail messages.

;  ROUTE NORMAL 1:104/0@FIDONET 1:all/all@FIDONET EXCEPT 1:104/all@FIDONET

;  The above line would route all *.OUT message files destined for a zone
;  1 FidoNet address to 1:104/0@FIDONET except those to a net 104 address.
;  The word ARC could be inserted before NORMAL in the above to archive
;  and file-attach the outbound message packet.

;  ROUTEFILES NORMAL 1:104/800@FIDONET 1:104/801@FIDONET

;  The above line would route all *.FLO file-attach files destined for
;  1:104/801@FIDONET to 1;104/800@FIDONET.

;  POLL 1:104/512@FIDONET

;  The above line would output an empty *.FLO file-attach file to
;  1:104/512@FIDONET if no outbound *.FLO file already exists for that
;  address.

;  DIRECTPOINT 1:104/424.all@FIDONET

;  By default, all ROUTE/ROUTEFILE commands which take effect on a particular
;  node also route messages and/or file-attaches to all point systems which
;  belong to that node.  If, however, the point system is listed in a
;  DIRECTPOINT line, it will be left alone unless specifically listed on a
;  ROUTE command.

;--------------------------------------------------------------------------
;  SAMPLE SCHEDULE
;
;  The following schedule is an example of a common situation for JRoute --
;  a once-per-day fix to send mail to non-domain-aware systems which reside
;  in domains other than the primary local domain.  The schedule takes the
;  example of address 200:5000/401@MetroNet.  Since 200:5000/401@MetroNet
;  is not domain aware and since the local system's primary address (for
;  example) lies in FidoNet, it will identify itself to Binkley (wrongly)
;  as 200:5000/401@FIDONET.  This would cause Binkley to be unable to send
;  mail destined for that system since that system's lack of domain
;  awareness causes it to mis-identify its domain.  This schedule will
;  route the mail destined for 200:5000/401@MetroNet to
;  200:5000/401@FIDONET once per day, thus ensuring the non-domain-aware
;  remote system is able to properly pick up mail which is held for it.
;
;  The following schedule is designed to run only when called by
;  specification of the schedule name either in the JMail control file or
;  on the command line.  A Binkley event would be set up to call this once
;  per day.
;
;  SCHED DmnFix ALL 06:00 05:00  ; this time entry forces it to never run
;                                ; unless specified.  The stop time is
;                                ; actually BEFORE the start time.
;
;  CHANGE1 CRASH NORMAL 200:5000/401@METRONET ; routing commands only
;  CHANGE1 HOLD NORMAL 200:5000/401@METRONET  ; work on NORMAL flavors
;                                             ; so we do this to make
;                                             ; all the files for that
;                                             ; system into NORMAL
;              ; The next line routes the mail packets (*.OUT)
;              ; to the faked FIDONET address in a HOLD flavor
;  ROUTE HOLD 200:5000/401@FIDONET 200:5000/401@METRONET
;              ; The next line routes the file attaches (*.FLO)
;              ; to the faked FIDONET address in a HOLD flavor
   ROUTEFILES 200:5000/401@FIDONET 200:5000/401@METRONET
;
;  Calling the above schedule once per day would resolve the problems
;  incurred by the lack of domain awareness on the remote system.


