@ECHO OFF

rem RBBS/CDor Upload Tester and Converter
rem Paramters passed to this file:

rem  %1 = Path/FileName of file to be tested
rem  %2 = Path of file to be tested without "\"
rem  %3 = FileName
rem  %4 = Extension
rem  %5 = Node Number
rem  %6 = Path/FileName of RBBS error flag file
rem  %7 = Communications Port (COMx)
rem  %8 = RBBS Default Extension as set in CONFIG #168

rem This batch file must have the following subdirectories to work:

rem C:\RBBS\TEMP\%node% - where files are unarchived to
rem C:\RBBS\BADFILES    - where bad uploads are placed
rem C:\RBBS\OLDFILES    - where old files are placed
rem C:\RBBS\UPLOAD      - Upload Subdirectory
rem C:\RBBS\NODE\%node% - NodeWork subdirectory

rem This batch file will recurse itself if the upload to be tested does
rem not have the default upload extension as set in CONFIG #168


IF %4 == %8 proecho %node% ~Testing upload, please wait...~

IF NOT %4 == %8 proecho %node% ~Converting upload to %8, please wait...~

IF %4 == ZIP goto ZIP
IF %4 == ARJ goto ARJ
IF %4 == EXE goto EXE

GOTO VIRUSTEST

rem For any upload filename extension, the basic setup should be:
:EXT             - the FileName Extension to convert and test
arctest %1       - command to test the archive integrity
IF ERRORLEVEL 1 GOTO BADUPLOAD   - Abort if archive is bad
unarc %1 C:\RBBS\TEMP\%node%     - command to unarchive file to work area
IF NOT %4 == %8 GOTO %8CONVERT   - check to see if file needs to be converted

rem For any upload to be converted, the basic setup should be:
:EXTCONVERT
makearc a C:\RBBS\UPLOAD\%3 C:\RBBS\TEMP\%node%\*.*  - make new archive
del %1                                               - delete old archive
%0 %2\%3.%8 %2 %3 %8 %5 %6 %7 %8       - This looks scary, but all it is doing
                                       - is running this batch file again with
                                       - the default extension as the upload
                                       - filename extension

:ZIP
seterror 0
pkunzip -t %1
IF ERRORLEVEL 1 GOTO BADUPLOAD
pkunzip -o %1 C:\RBBS\TEMP\%node%
IF NOT %4 == %8 GOTO %8CONVERT
rem recom -s c:\rbbs\dir\add.txt %1
IF EXIST C:\RBBS\TEMP\%node%\FILE_ID.DIZ COPY C:\RBBS\TEMP\%node%\FILE_ID.DIZ C:\RBBS\NODE%node%
IF EXIST C:\RBBS\TEMP\%node%\FILE_ID.DIZ DEL C:\RBBS\TEMP\%node%\FILE_ID.DIZ
IF NOT EXIST C:\RBBS\TEMP\%node%\*.DIZ GOTO VIRUSTEST
IF NOT EXIST C:\RBBS\TEMP\%node%\VENDINFO.DIZ REN C:\RBBS\TEMP\%node%\*.DIZ FILE_ID.DIZ
IF EXIST C:\RBBS\TEMP\%node%\FILE_ID.DIZ COPY C:\RBBS\TEMP\%node%\FILE_ID.DIZ C:\RBBS\NODE%node%
IF EXIST C:\RBBS\TEMP\%node%\FILE_ID.DIZ DEL C:\RBBS\TEMP\%node%\FILE_ID.DIZ
IF NOT EXIST C:\RBBS\TEMP\%node%\VENDINFO.DIZ GOTO VIRUSTEST

rem Import Description 4 from VENDINFO.DIZ
:VENDINFO
proecho %node% ~Converting VENDINFO.DIZ to FILE_ID.DIZ~
VEND2FI C:\RBBS\TEMP\%node%\VENDINFO.DIZ C:\RBBS\NODE%NODE%\FILE_ID.DIZ

GOTO VIRUSTEST

:ARJ
arj t %1
IF ERRORLEVEL 1 ECHO ERROR > %6
arj e %1 C:\RBBS\TEMP\%node%\ -y
IF NOT %4 == %8 GOTO %8CONVERT
IF EXIST C:\RBBS\TEMP\%node%\FILE_ID.DIZ COPY C:\RBBS\TEMP\%node%\FILE_ID.DIZ C:\RBBS\NODE%node%

GOTO VIRUSTEST

:EXE
pkunzip %1 FILE_ID.DIZ C:\RBBS\NODE%node%

:VIRUSTEST
proecho %node% ~Testing %3.%4 for viruses...~
scan /noexpire /nomem /nopause /A C:\RBBS\TEMP\%node%\*.*
rem for SCAN 2.0 or higher-
rem scan /nomem C:\RBBS\TEMP\%node%\*.*

IF ERRORLEVEL 2 GOTO VIRUSPROG
IF ERRORLEVEL 1 GOTO VIRUSFOUND

rem for SCAN 2.0 or higher-
rem IF ERRORLEVEL 19 GOTO VIRUSPROG
rem IF ERRORLEVEL 18 GOTO VIRUSPROG
rem IF ERRORLEVEL 17 GOTO VIRUSPROG
rem IF ERRORLEVEL 16 GOTO VIRUSPROG
rem IF ERRORLEVEL 15 GOTO VIRUSFOUND
rem IF ERRORLEVEL 14 GOTO VIRUSPROG
rem IF ERRORLEVEL 13 GOTO VIRUSFOUND
rem IF ERRORLEVEL 12 GOTO VIRUSFOUND
rem IF ERRORLEVEL 11 GOTO VIRUSPROG
rem IF ERRORLEVEL 10 GOTO VIRUSFOUND
rem IF ERRORLEVEL  9 GOTO VIRUSPROG
rem IF ERRORLEVEL  8 GOTO VIRUSPROG
rem IF ERRORLEVEL  7 GOTO VIRUSPROG
rem IF ERRORLEVEL  6 GOTO VIRUSPROG
rem IF ERRORLEVEL  5 GOTO VIRUSPROG
rem IF ERRORLEVEL  4 GOTO VIRUSPROG
rem IF ERRORLEVEL  3 GOTO VIRUSPROG
rem IF ERRORLEVEL  2 GOTO VIRUSPROG
rem IF ERRORLEVEL  1 GOTO VIRUSPROG

proecho %node% ~No Viruses have been found!~
GOTO DATECHECK

:VIRUSPROG
seterror 0
proecho %node% ~Program error occured!~
proecho %node% ~Your UpLoad was NOT Scanned!~
proecho %node% ~Please tell SysOp!~
echo %1 failed virus check due to program error >> c:\rbbs\node%node%\virus.log
GOTO DATECHECK

:VIRUSFOUND
seterror 0
copy %1 c:\rbbs\badfiles
del %1
proecho %node% ~  The file you uploaded may contain a Virus!~
proecho %node% ~  It will be placed off line for the SysOp's Examination.~
echo VIRUS > %6
echo %1 MAY CONTAIN A VIRUS! >> c:\rbbs\node%node%\VIRUS.LOG
goto exit

:DATECHECK
seterror 0
IF NOT %4==ZIP GOTO THANKS
proecho %node% ~Checking the date(s) of file(s) in %3.%4...~
copy %1 C:\RBBS\TEMP\%node%
zipds C:\RBBS\TEMP\%node%\%3.%4
testdate C:\RBBS\TEMP\%node%\%3.%4 1992 c:\rbbs\oldfiles
if exist c:\rbbs\oldfiles\%3.%4 goto baddates
GOTO THANKS

:BADDATES
proecho %node% ~At least one of the programs you uploaded is~
proecho %node% ~more than 2 years old.  I will move any old~
proecho %node% ~programs offline for evaluation to determine~
proecho %node% ~if they are worth their 'bytes'.
proecho %node% ~PLEASE DO NOT UPLOAD FILES DATED BEFORE 1992!~
proecho %node% ~Your Upload:Download ratio remains unchanged.~
proecho %node% ~If this upload is placed on line, you will be credited.~
del %1
echo %1 OLDIE! >> c:\rbbs\node%node%\OLDIE.LOG
goto exit

:BADUPLOAD
proecho %node% ~Looks like one or more of your uploads failed~
proecho %node% ~Archive Integrity tests...~
proecho %node% ~I will move all file(s) you just uploaded~
proecho %node% ~offline for manual evaluation.~
proecho %node% ~Your Upload:Download ratio remains unchanged.~
proecho %node% ~If this upload is placed on line, you will be credited.~
copy %1 c:\rbbs\badfiles
del %1
ECHO ERROR > %6
ECHO %1 BAD UPLOAD >> c:\rbbs\node%node%\badfiles.log
goto exit

:ZIPCONVERT
PKZIP -a -ex C:\RBBS\UPLOAD\%3 C:\RBBS\TEMP\%node%\*.*
del %1
proecho ~Converting Upload to %8...~
%0 %2\%3.%8 %2 %3 %8 %5 %6 %7 %8

:ARJCONVERT
ARJ a C:\RBBS\UPLOAD\%3 C:\RBBS\TEMP\%node%\*.*
del %1
proecho ~Converting Upload to %8...~
%0 %2\%3.%8 %2 %3 %8 %5 %6 %7 %8

:THANKS
proecho %node% ~No Errors Found.  Tests Complete!~~
IF EXIST %6 DEL %6

:EXIT
DELDIR C:\RBBS\TEMP\%node%\*.*

SETERROR 0

