' $segment
' $linesize:132
' $title: 'RBBSSUB8.BAS 17.4/CDor, Copyright 1994 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'
'  Name ...............: RBBSSUB8.BAS
'  First Released .....: August 1994
'  Subsequent Releases.: 
'  Copyright ..........: 1993,1994
'  Purpose.............: Subroutines for RBBS-PC/CDor
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
100'  $title: 'SYSOP8.BAS 17.4'
'
'  Copyright (c) 1993,1994 Daniel T. Drinnon
'
'  $SUBTITLE: 'Sysop8 -- PERSONAL/FMS/FFS/RFM OnLine File Maintenance'
'
'  SUBROUTINE NAME    -- SYSOP8
'
'  INPUT PARAMETERS   -- None
'
'  OUTPUT PARAMETERS  -- None
'
'  SUBROUTINE PURPOSE -- Manipulation of the FMS/FFS/Personal Files Systems
'
   SUB Sysop8 STATIC
'
' =============================================================================
' * Return from Extended Description on ADD Action
' =============================================================================
'
    IF ZGetExtDesc THEN
       ZMaxMsgLines = ZMaxMsgLinesDef
       ZRightMargin = WasLL
       CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZMaxExtendedLines,3)
       ZGetExtDesc = ZFalse
    END IF
'
' =============================================================================
' * Main entry prompt
' =============================================================================
'
    IF ZExpertUser THEN _
       GOTO 110
101 CALL GraphicDisplayFile (ZWelcomeFileDrvPath$ + "SYSOP8.MNU")
110 CALL Line25
    '* "ADEFLVMHQ"
    LineNum = 894
    GOSUB 11200
    DO
       '* "{CRA)dd, D)elete, E)dit, F)ind, L)ist, M)ove, V)iew, H)elp, [Q]uit"
       LineNum = 893
       GOSUB 11210
       GOSUB 11100
    LOOP UNTIL ZWasQ = 0 OR INSTR(Strng$,ZWasZ$) <> 0
    IF ZWasQ = 0 OR ZWasZ$ = "Q" THEN
       ZFileSysParm = 0
       EXIT SUB
    END IF
    WasX = INSTR(Strng$,ZWasZ$)
    ON WasX GOSUB 200,300,400,500,550,800,600,101
    GOTO 110
'
' * ===========================================================================
' * Add a file to the FMS, Upload, or Personal Areas
' * ===========================================================================
'
200 '* "ADD"
    LineNum = 1087
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700
205 '* "{CBEnter {CASOURCE {CBPath/Filename of new file to ADD{RC{EX"
    LineNum = 895
    GOSUB 11210
'
' * Get Source File Name
'
    GOSUB 11000
    IF ZWasQ = 0 THEN
       RETURN
    END IF
'
' * Check for wildcards
'
206 IF INSTR(ZUserInAra$(ZAnsIndex),"*") > 0 THEN
       CALL CmdStackPushPop (1)
       GOSUB 555
       CALL CmdStackPushPop (2)
       REDIM WildList$(100)
       MatchCount = 1
       MatchFile$ = ""
       FILESPEC$ = UCASE$(ZUserInAra$(ZAnsIndex))
       CALL BreakFileName (FILESPEC$,WildDrive$, _
                         WildBody$,WildExt$,ZTrue)
       MatchFile$ = GetFirstMatchingFile$(FILESPEC$)
       IF MatchFile$ <> "" THEN
          WildList$(MatchCount) = WildDrive$ + MatchFile$
          MatchFile$ = GetNextMatchingFile$
          DO WHILE MatchFile$ <> ""
             MatchCount = MatchCount + 1
             IF MatchCount > 100 THEN
                '* "{CE{G4Too Many Matches!{RC"
                LineNum = 896
                CRCount = 1
                GOSUB 11220
                EXIT DO
             END IF
             WildList$(MatchCount) = WildDrive$ + MatchFile$
             MatchFile$ = GetNextMatchingFile$
          LOOP
       ELSE
          GOTO 205
       END IF
       FOR wildcount = 1 TO MatchCount
          SourceFileName$ = WildList$(wildcount)
          GOSUB 8002
          GOSUB 210
          IF ZAbort THEN
             ZWasQ = 0
             ZAnsIndex = 0
             REDIM WildList$(0)
             RETURN
          END IF
       NEXT wildcount
       REDIM WildList$(0)
       GOTO 220
    ELSE
       GOSUB 8001
    END IF
'
' * nothing to do check
'
    IF NOT ZOK THEN _
       GOTO 205
    IF ZWasQ = 0 THEN _
       RETURN
'
' * option to change target filename
'
210 TargetFileName$ = SourceBody$ + SourceExt$
    '* "{CBEnter {CATARGET {CBfilename: {RC["
    LineNum = 897
    GOSUB 11200
    Strng1$ = Strng$
    '* "]{RC"
    LineNum = 898
    GOSUB 11200
    Strng2$ = Strng$
    ZOutTxt$ = Strng1$ + TargetFileName$ + Strng$
    GOSUB 11000
    IF ZWasQ <> 0 THEN
       TargetFileName$ = UCASE$(ZUserInAra$(ZAnsIndex))
    END IF
'
' * Allow for Personal Uploads
'
    GOSUB 610
    IF WhoTo$ = "" THEN
       RETURN
    END IF
'
' * Setup to select target subdirectory
'
    GOSUB 620
    IF ZAnsIndex = 0 THEN
       ZWasQ = 0
       ZWasZ$ = ""
       RETURN
    END IF
'
' * Make sure copy was successful
'
    CALL FindIt (TargetDir$ + TargetFileName$)
    IF NOT ZOK THEN
       '* "{CF{C4ERROR! "
       LineNum = 899
       GOSUB 11200
       Strng1$ = Strng$
       '* "{SPnot found after COPY!{RC"
       LineNum = 900
       GOSUB 11200
       Strng2$ = Strng$
       CALL QuickTPut1 (Strng1$ + TargetFileName$ + Strng2$)
       GOTO 205
    END IF
'
' * option to delete original file
'
    GOSUB 3000
'
' * get description for directory listing
'
    GOSUB 4000
'
' * if aborted, then delete the copied file
'
    IF ZAbort THEN
       CALL DelFile (TargetDir$ + TargetFileName$,ErrCode)
       GOTO 205
    END IF
'
' * log it to the Caller's Log
'
    '* "Added{SP"
    LineNum = 901
    GOSUB 11200
    Strng1$ = Strng$
    '* "{SPto File System"
    LineNum = 902
    GOSUB 11200
    Strng2$ = Strng$
    CALL UpdtCalr (Strng1$ + TargetFileName$ + Strng2$,2)
'
' * set filename for FIDX
'
    ZFileName$ = TargetFileName$
'
' * if file was in FIDX/LIDX, then update the FIDX file
'
215 GOSUB 6000
' *
' * All Done
' *
220 RETURN
'
' * ===========================================================================
' * Delete an entry from the Upload, FMS, or Personal Areas
' * ===========================================================================
'
300 '* "DELETE"
    LineNum = 1088
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700
    WasA1$ = ZActiveMessageFile$
    ZActiveMessageFile$ = ZOrigMsgFile$
    CALL OpenMsg
    FIELD 1, 128 AS ZMsgRec$
    GET 1,1
    NumNodes = VAL(MID$(ZMsgRec$,127))
    FOR NodeIndex = 2 TO NumNodes + 1
       GET 1,NodeIndex
       IF MID$(ZMsgRec$,55,2) <> "-1" THEN
          CALL SaveUserActivity(WhatTheyDoin$,Nodeindex,ZTrue)
          IF WhatTheyDoin$ = CHR$(70) AND _
             MID$(ZMsgRec$,57,1) = CHR$(65) AND _
             VAL(ZNodeID$) <> NodeIndex - 1 THEN
             '* "{CR{CF{G4WARNING! Node"
             LineNum = 903
             GOSUB 11200
             Strng1$ = Strng$
             '* "{SPis using the File System!{RC"
             LineNum = 904
             GOSUB 11200
             Strng2$ = Strng$
             CALL QuickTPut (Strng1$ + STR$(NodeIndex-1) + Strng2$,2)
             EXIT FOR
          END IF
       END IF
    NEXT NodeIndex
    ZActiveMessageFile$ = WasA1$
305 '* "{CBEnter Filename to {CADELETE{RC{EX"
    LineNum = 905
    GOSUB 11210
'
' * Get SourceFileName$
'
    GOSUB 8000

    IF ZWasQ = 0 THEN _
       RETURN
'
' *  if couldn't find file to delete, ask to remove it from file list
'
    CALL FindIt (SourceFileName$)
    IF NOT ZOK THEN
       DO
          '* "{CBRemove Entry from File List?{RC (Y,[N])"
          LineNum = 906
          GOSUB 11210
          GOSUB 11100
       LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
       IF ZWasZ$ = "N" OR ZWasQ = 0 THEN
          GOTO 305
       ELSE
          GOSUB 1000
          GOTO 310
       END IF
    END IF

    IF ZWasQ = 0 THEN
       RETURN
    END IF
'
' * find out if file to delete is in the Personal Files
'
    GOSUB 1000
'
' * delete it
'
    GOSUB 3000
'
' * if the file was not deleted then go no further
'
    CALL FindIt (SourceFileName$)
    IF ZOK OR ZWasQ = 0 OR ZWasZ$ = "N" THEN
       GOTO 305
    END IF
'
' * remove the entry from the respective file system (private/FMS)
'
310 IF InPers THEN
       GOSUB 7000
       GOTO 320
    END IF
    InFMS = ZTrue
    CALL BreakFileName (SourceFileName$,SourceDrive$, _
                        SourceBody$,SourceExt$,ZTrue)
    ZFileName$ = SourceBody$ + SourceExt$
    IF ZFastFileSearch THEN
       GOSUB 6000
    END IF
    GOSUB 7000
'
' * option to add entry to offline file list
'
320 CALL BreakFileName (SourceFileName$, Drive$, Body$, Ext$, ZTrue)
    DelFileName$ = Body$ + Ext$
    '* "{CBAdd {C2"
    LineNum = 907
    GOSUB 11200
    Strng1$ = Strng$
    '* "{CB to {C2OFFLINE {CBlist?{RC (Y,[N])"
    LineNum = 908
    GOSUB 11200
    Strng2$ = Strng$
    DO
       ZOutTxt$ = Strng1$ + DelFileName$ + Strng2$
       GOSUB 11100
    LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
    IF ZWasZ$ = "N" OR ZWasQ = 0 THEN
       GOTO 330
    ELSE
       CALL FindFile (ZDirPath$ + "OFFLINE.DEF",ZOK)
       IF ZOK THEN
          '* "{CBAdd {C2"
          LineNum = 907
          GOSUB 11200
          Strng1$ = Strng$
          '* "{CB to {C2"
          LineNum = 927
          GOSUB 11200
          Strng2$ = Strng$
          '* "OFFLINE.DEF{RC ([Y],N)"
          LineNum = 959
          GOSUB 11200
          Strng3$ = Strng$
          DO
             ZOutTxt$ = Strng1$ + DelFileName$ + Strng2$ + ZDirPath$ + Strng3$
             GOSUB 11100
          LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
          IF ZWasQ = 0 OR ZWasZ$ = "Y" THEN
             OfflineFileName$ = ZDirPath$ + "OFFLINE.DEF"
             GOTO 322
          END IF
       END IF
       '* "{CBEnter Filename of {CAOFFLINE List{RC{EX"
       LineNum = 909
       GOSUB 11210
       GOSUB 11000
       IF ZWasQ = 0 THEN
          GOTO 330
       END IF
       OfflineFileName$ = UCASE$(ZUserInAra$(ZAnsIndex))
       CALL FindIt (OfflineFileName$)
       IF NOT ZOK THEN
          '* "{CE{Z1 does not exist! Create?{RC (Y,[N])"
          LineNum = 910
          GOSUB 11210
          GOSUB 11100
          IF ZWasZ$ = "N" OR ZWasQ = 0 THEN
             GOTO 320
          END IF
       END IF
322    CALL OpenWorkA (2,OfflineFileName$)
       CALL PrintWorkA (2, DelFileName$)
       CLOSE 2
    END IF
'
' * log it to the Caller's Log
'
330 '* "Deleted{SP"
    LineNum = 911
    GOSUB 11200
    Strng1$ = Strng$
    '* "{SPfrom File System"
    LineNum = 912
    GOSUB 11200
    Strng2$ = Strng$
    CALL UpdtCalr (Strng1$ + SourceFileName$ + Strng2$,2)
'
' All done
'
    RETURN
'
' * ===========================================================================
' * Edit an entry in the Upload, FMS, or Personal Areas
' * ===========================================================================
'
400 '* "EDIT"
    LineNum = 1089
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700
    RETURN
'
' * ===========================================================================
' * Find an entry in the Upload, FMS, or Personal Areas
' * ===========================================================================
'
500 '* "FIND"
    LineNum = 1090
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700

    '* "{CBEnter Filename to {CAFIND{RC{EX"
    LineNum = 913
    GOSUB 11210
'
' * get filename to find
'
    GOSUB 8000
'
    IF ZWasQ = 0 THEN _
       RETURN
'
' * give location
'
    IF ZOK THEN
       CALL BreakFileName (SourceFileName$,SourceDrive$, _
                           SourceBody$,SourceExt$,ZTrue)
       '* "{CB"
       LineNum = 914
       GOSUB 11200
       Strng1$ = Strng$
       '* "{C2 is located in {CB"
       LineNum = 915
       GOSUB 11200
       Strng2$ = Strng$
       CALL QuickTPut1 (Strng1$ + SourceBody$ + SourceExt$ + _
                        Strng2$ + SourceDrive$ + ZEmphasizeOff$)
       RETURN
    END IF
'
' All done
'
    RETURN
'
' * ===========================================================================
' * List a filespec
' * ===========================================================================
'
550 '* "LIST"
    LineNum = 1091
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700

    '* "{CBEnter Filespec to {CALIST{RC{EX"
    LineNum = 916
    GOSUB 11210
'
' * get filespec to list
'
    GOSUB 11000
    IF ZWasQ = 0 THEN
       RETURN
    END IF

555 FILESPEC$ = UCASE$(ZUserInAra$(ZAnsIndex))
    MatchFile$ = GetFirstMatchingFile$(FILESPEC$)
    IF MatchFile$ <> "" THEN
       filecount = 0
       '* "{CEDirectory of {CA"
       LineNum = 917
       GOSUB 11200
       CALL QuickTPut1 (Strng$ + FILESPEC$ + ZEmphasizeOff$)
       CALL QuickTPut (MatchFile$ + SPACE$(15 - LEN(MatchFile$)),0)
       MatchFile$ = GetNextMatchingFile$
       DO WHILE MatchFile$ <> ""
          filecount = filecount + 1
          IF filecount MOD 5 = 0 THEN
             CALL SkipLine (1)
             CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
             filecount = 0
          END IF
          CALL QuickTPut (MatchFile$ + SPACE$(15 - LEN(MatchFile$)),0)
          MatchFile$ = GetNextMatchingFile$
       LOOP
       CALL SkipLine (2)
    ELSE
       '* "{CF{G4ERROR! Could not find any matches to{SP"
       LineNum = 918
       GOSUB 11200
       CALL QuickTPut1 (Strng$ + FILESPEC$ + ZEmphasizeOff$)
    END IF
'
'
' All done
'
    RETURN
'
' * ===========================================================================
' * Move an entry from/to the Upload, FMS, or Personal Areas
' * ===========================================================================
'
600 '* "MOVE"
    LineNum = 1092
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700

605 '* "{CBEnter Filename to MOVE{RC{EX"
    LineNum = 919
    GOSUB 11210
'
' * get filename to find
'
    GOSUB 8000
'
    IF ZWasQ = 0 THEN _
       RETURN

    IF ZOK THEN
       CALL BreakFileName (SourceFileName$,SourceDrive$, _
                           SourceBody$,SourceExt$,ZTrue)

       TargetFileName$ = SourceFileName$
       CALL BreakFileName (TargetFileName$,TargetDir$, _
                           TargetBody$,TargetExt$,ZTrue)
       TargetFileName$ = TargetBody$ + TargetExt$
    END IF
'
' * Allow for Personal Uploads
'
    GOSUB 610
    IF WhoTo$ = "" THEN
       RETURN
    END IF
'
' * Setup to select target subdirectory
'
    GOSUB 620
    IF ZAnsIndex = 0 THEN
       ZWasQ = 0
       ZWasZ$ = ""
       RETURN
    END IF
'
' * Make sure copy was successful
'
    CALL FindIt (TargetDir$ + TargetFileName$)
    IF NOT ZOK THEN
       '* "{CF{G4ERROR!{SP"
       LineNum = 920
       GOSUB 11200
       Strng1$ = Strng$
       '* "{SPnot found after COPY!{RC"
       LineNum = 921
       GOSUB 11200
       Strng2$ = Strng$
       CALL QuickTPut1 (Strng1$ + TargetFileName$ + Strng2$)
       GOTO 605
    END IF
'
' * delete the original
'
    GOSUB 3000
'
' * set filename for FIDX
'
    ZFileName$ = TargetFileName$
'
' * if file was in FIDX/LIDX, then update the FIDX file
'
    GOSUB 6000
' *
' * All Done
' *
    RETURN
'
' * Allow for Personal Uploads
'
610 '* "ALL"
    LineNum = 450
    GOSUB 11200
    ALLStr$ = Strng$
    IF ZUserSecLevel >= ZMinSecPersUpld THEN
       WhoTo$ = ""
       ZFileSysParm = 7
       CALL SetWhoTo (ZTrue,WhoTo$,"",RcvrRecNum,Found,ZTrue)
       IF WhoTo$ = "" THEN
          RETURN
       END IF
    ELSE
       WhoTo$ = ALLStr$
    END IF
    TargetDir$ = ""
    RETURN
'
' * Setup to select target subdirectory
'
620 IF WhoTo$ = ALLStr$ THEN
       InPers = ZFalse
       GOSUB 2000
    ELSE
        InPers = ZTrue
        InFMS = ZFalse
        TargetDir$ = ZPersonalDrvPath$
        GOSUB 5000
    END IF
    RETURN
'
' * Lock the file system
'
630 IF ZNetWorkType <> 0 THEN
       ZWasEN$ = ZActiveFMSDir$
       ZSubParm = 9
       CALL FileLock
       ZErrCode = 0
    END IF
    RETURN
'
' * Unlock the file system
'
640 IF ZNetWorkType <> 0 THEN
       ZSubParm = 10
       CALL FileLock
    END IF
    RETURN
'
' * ===========================================================================
' * Build and display an Action prompt
' * ===========================================================================
'
700 '* "{CR{CE"
    LineNum = 922
    GOSUB 11200
    Strng1$ = Strng$
    '* "{SPan FMS Entry{RC"
    LineNum = 923
    GOSUB 11200
    Strng2$ = Strng$
    CALL QuickTPut1 (Strng1$ + Action$ + Strng2$)
    RETURN
'
' * ===========================================================================
' * View any file
' * ===========================================================================
'
800 '* "VIEW"
    LineNum = 1093
    GOSUB 11200
    Action$ = Strng$
    GOSUB 700

    '* "{CBEnter Filename to {CAVIEW{RC{EX"
    LineNum = 924
    GOSUB 11210
'
' * get filename to find
'
    GOSUB 8000
'
    IF ZWasQ = 0 THEN _
       RETURN
'
' * view file
'
    ZFileName$ = SourceFileName$
    CALL FindFIle (ZFileName$,ZOK)
    IF ZOK THEN
       CALL GetArc (ZTrue)
    END IF
'
' All done
'
    RETURN
'
' =============================================================================
' * determine if the file is in Personals or FMS
' =============================================================================
'
1000 CALL WordInFile (ZPersonalDir$,SourceBody$ + SourceExt$,ZOK,ZFalse)
     IF ZOK THEN
        InFMS = ZFalse
        InPers = ZTrue
     ELSE
        InFMS = ZTrue
        InPers = ZFalse
     END IF
     RETURN
'
' =============================================================================
' * Pick Subdirectory to copy file to.  Look in subdirectories listed
' * in CONFIG first.  If FIDX/LIDX is used, use them too.
' *
' * Check the directories listed in CONFIG
' * The FIRST Subdirectory ZSubDir$(1) is always the UPLOAD sub
' * any other subdirectories listed in CONFIG should
' * not be in the FFS
' =============================================================================
'
2000 '* "{CB"
     LineNum = 925
     GOSUB 11200
     Strng1$ = Strng$
     '* "{SP{C2"
     LineNum = 926
     GOSUB 11200
     Strng2$ = Strng$
     '* "{CB to {C2"
     LineNum = 927
     GOSUB 11200
     Strng3$ = Strng$
     '* "{RC (Y)es,[N]o,A)bort)"
     LineNum = 928
     GOSUB 11200
     Strng4$ = Strng$
     FOR WasX = 1 TO ZSubDirCount - 1
        DO
           ZOutTxt$ = Strng1$ + Action$ + Strng2$ + SourceFileName$ + _
                      Strng3$ + ZSubDir$(WasX) + Strng4$
           GOSUB 11100
        LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
        IF ZWasZ$ = "A" THEN
           ZAbort = ZTrue
           ZAnsIndex = 0
           RETURN
        END IF
        IF ZWasZ$ = "Y" THEN
           InPers = ZFalse
           InFMS = ZFalse
           TargetDir$ = ZSubDir$(WasX)
           CALL BreakFileName (ZFMSDirectory$,TDirPath$, _
                               TMainFMSDir$,TMainDirExtension$,ZFalse)
           GOSUB 5000
           RETURN
        END IF
     NEXT WasX
' *
' * Search through the FIDX
' * Look for the FIDX.LST first
' *
     IF ZFastFileSearch THEN
        TFastFileLocator$ = ZFastFileLocator$
        CALL BreakFileName (ZFastFileList$,Drive$,Body$,Ext$,ZTrue)
        CALL FindIt (Drive$ + "SYSOP8.CFG")
        IF ZOK THEN
           CALL OpenWork (7, Drive$ + "SYSOP8.CFG")
        END IF
        LineToRead = 1
        IF ZOK THEN
           IF ZErrCode <> 0 THEN
              GOSUB 2010
              CLOSE 7
              GOTO 2020
           END IF
2005       CALL ReadParmsX (7,ZOutTxtAra$(),4,LineToRead)
           IF ZErrCode <> 0 AND ZOutTxtAra$(2) = "" THEN
              CLOSE 7
              GOTO 2020
           END IF
           TFastFileList$ = UCASE$(ZOutTxtAra$(1))
           TFastFileLocator$ = UCASE$(ZOutTxtAra$(2))
           CALL FindFile (TFastFileList$,ZOK)
           CALL FindFile (TFastFileLocator$,ZOK)
           CALL FindFile (ZOutTxtAra$(3),ZOK)
           IF NOT ZOK THEN
              '* "File not found in SYSOP8 .LST file"
              LineNum = 1106
              GOSUB 11200
              CALL UpdtCalr (Strng$,2)
              GOSUB 11220
              GOTO 2007
           END IF
           CALL BreakFileName (UCASE$(ZOutTxtAra$(3)),TDirPath$,TMainFMSDir$, _
                              TMainDirExtension$,ZFalse)
           TMaxDescLen = VAL(ZOutTxtAra$(4))
           GOSUB 2010
           IF ZWasZ$ = "Y" THEN
              InPers = ZFalse
              InFMS = ZTrue
              CLOSE 7
              GOTO 2020
           END IF
2007       LineToRead = LineToRead + 1
           ZOutTxtAra$(2) = ""
           GOTO 2005
        ELSE
           GOSUB 2010
           CLOSE 7
           GOTO 2020
        END IF
2010    CALL OpenRSeq (2,TFastFileLocator$,HighRec&,WasX,66)
        FIELD 2, 66 AS Location$
        FOR WasX& = 1 TO HighRec&
           GET 2, WasX&
           SelectLocation$ = LEFT$(Location$,63)
           CALL Trim (SelectLocation$)
           FOR WasL = 1 TO ZSubDirCount - 1
              Found = ZFalse
              CALL BreakFileName (SelectLocation$,SDrive$,Body$,Ext$,ZFalse)
              CALL BreakFileName (ZSubDir$(WasL),RDrive$,Body$,Ext$,ZFalse)
              IF SDrive$ = RDrive$ THEN
                 Found = ZTrue
                 EXIT FOR
              END IF
           NEXT WasL
           IF LEFT$(SelectLocation$,2) <> "M!" AND NOT Found THEN
              '* "{CB"
              LineNum = 925
              GOSUB 11200
              Strng1$ = Strng$
              '* "{SP{C2"
              LineNum = 926
              GOSUB 11200
              Strng2$ = Strng$
              '* "{CB to {C2"
              LineNum = 927
              GOSUB 11200
              Strng3$ = Strng$
              '* "{RC (Y)es,[N]o,A)bort)"
              LineNum = 928
              GOSUB 11200
              Strng4$ = Strng$
              DO
                 ZOutTxt$ = Strng1$ + Action$ + Strng2$ + _
                            SourceFileName$ + _
                            Strng3$ + SelectLocation$ + Strng4$
                 GOSUB 11100
              LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
              IF ZWasZ$ = "A" THEN
                 ZAnsIndex = 0
                 RETURN
              END IF
              IF ZWasZ$ = "Y" THEN
                 InPers = ZFalse
                 InFMS = ZTrue
                 LidxPos& = WasX&
                 TargetDir$ = SelectLocation$
                 CLOSE 2
                 CLOSE 7
                 GOSUB 5000
                 RETURN
              END IF
           END IF
        NEXT WasX&
        CLOSE 2
        RETURN
     END IF
2020 IF TargetDir$ = "" THEN _
        GOTO 2000
     RETURN
'
' =============================================================================
' * option to delete original file
' =============================================================================
'
3000 '* "{CCDelete {CE"
     LineNum = 929
     GOSUB 11200
     Strng1$ = Strng$
     '* "{CC?{RC (Y,[N])"
     LineNum = 930
     GOSUB 11200
     Strng2$ = Strng$
     DO
        ZOutTxt$ = Strng1$ + SourceFileName$ + Strng2$
        GOSUB 11100
     LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
     IF ZWasQ > 0 AND ZWasZ$ = "Y" THEN
        CALL DelFile (SourceFileName$,ErrCode)
     END IF
     RETURN
'
' =============================================================================
' * get description for directory listing
' =============================================================================
'
4000 ZWasFT$ = "Sysop8"
     HoldUpldDir$ = ZUpldDir$
     HoldFMSDirectory$ = ZFMSDirectory$
     GOSUB 4010
     CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),0,1)
     GOSUB 4010
     CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),0,2)
     ZFMSDirectory$ = HoldFMSDirectory$
     GOSUB 4020
     CALL FindFile (ZFileName$,ZOK)
     IF NOT ZOK THEN
        CALL BreakFileName (ZFileName$,Drive$,Body$,Ext$,ZTrue)
        CALL FindFile (Drive$ + Body$ + CHR$(46) + ZDefaultExtension$,ZOK)
        IF NOT ZOK THEN
           '* "Upload Aborted"
           LineNum = 601
           GOSUB 11220
        END IF
     END IF
     IF ZGetExtDesc THEN
        '* "Extended Description of {FH"
        LineNum = 600
        GOSUB 11200
        ZMsgHeader$ = Strng$
        ZSysopComment = ZTrue
        ZMaxMsgLines = ZMaxExtendedLines
        WasLL = ZRightMargin
        ZRightMargin = 30 + ZMaxDescLen + (5 * ZShowTimesDownloaded)
        IF ZRightMargin > 74 THEN _
           ZRightMargin = 74
        EXIT SUB
     END IF
     RETURN
'==============================================================================
' * set up FMSDirectory for upload processing
'==============================================================================
'==============================================================================
' * some rbbs configurations seem to leave off the trailing "\"
'==============================================================================
4010 IF RIGHT$(TDirPath$,1) <> "\" THEN
        ZFMSDirectory$ = TDirPath$ + "\" + _
                         TMainFMSDir$ + "." + _
                         TMainDirExtension$
     ELSE
        ZFMSDirectory$ = TDirPath$ + _
                         TMainFMSDir$ + "." + _
                         TMainDirExtension$
     END IF
     ZUpldDir$ = ZFMSDirectory$
4020 ZFileName$ = TargetDir$ + TargetFileName$
     ZFileNameHold$ = TargetFileName$
     RETURN
'
' =============================================================================
' * copy file from source to target
' =============================================================================
'
5000 IF SourceFileName$ = TargetDir$ + TargetFileName$ THEN
        '* "{C9SOURCE and TARGET are the SAME!{RC"
        LineNum = 931
        GOSUB 11220
        RETURN
     END IF
     '* "{C9Copying {CB"
     LineNum = 932
     GOSUB 11200
     Strng1$ = Strng$
     '* "{C9 as {CB"
     LineNum = 933
     GOSUB 11200
     Strng2$ = Strng$
     '* "{C9 to {CB"
     LineNum = 934
     GOSUB 11200
     Strng3$ = Strng$
     CALL QuickTPut1 (Strng1$ + SourceFileName$ + _
                      Strng2$ + TargetFileName$ + _
                      Strng3$ + TargetDir$ + ZEmphasizeOff$)
     CALL CopyFile (SourceFileName$, TargetDir$ + TargetFileName$,ErrCode)
     RETURN
'
' =============================================================================
' * if file was in FIDX/LIDX, then update the FIDX file
' =============================================================================
'
6000 IF InFMS = ZFalse OR InPers = ZTrue OR NOT ZFastFileSearch THEN _
         RETURN

     DO
        '* "Update the FFS (Y,[N])"
        LineNum = 1104
        GOSUB 11210
        GOSUB 11100
     LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
     IF ZWasQ = 0 OR ZWasZ$ = "N" THEN
        RETURN
     END IF

     '
     ' * Lock the file system
     '
     GOSUB 630

     '* "{C2Rebuilding {CB"
     LineNum = 935
     GOSUB 11200
     CALL QuickTPut1(Strng$ + TFastFileList$ + ZEmphasizeOff$)

     GOSUB 630

     CALL OpenRSeq (2,TFastFileList$,HighRec&,WasX,ZFIDXLEN)

     FIELD #2, 12 AS SearchFile$, _
                4 AS SearchPath$, _
      ZFIDXRFMLEN AS SearchDate$, _
    ZFIDXCDROMLEN AS SearchOnCD$, _
                2 AS SearchCrLf$

     SearchFile$ = ZFileName$
     WasX$ = MID$(STR$(LidxPos&),2)
     WasX$ = SPACE$(4 - LEN(WasX$)) + WasX$
     SearchPath$ = WasX$

     IF ZFIDXRFMLEN THEN
        WasDX$ = DATE$
        SearchDate$ = CHR$ (VAL (MID$ (WasDX$, 9, 2)) - 48) + _
                      CHR$ (VAL (MID$ (WasDX$, 1, 2)) + 31) + _
                      CHR$ (VAL (MID$ (WasDX$, 4, 2)) + 31)
     END IF
     SearchCrLf$ = ZCRLf$
     Template$ = SPACE$(ZFIDXLEN)
     MID$(Template$,1,12) = SearchFile$
     MID$(Template$,13,4) = SearchPath$
     IF ZFIDXRFMLEN THEN
        MID$(Template$,17,3) = SearchDate$
     END IF
     IF ZFIDXCDROMLEN THEN
        MID$(Template$,17+ZFIDXRFMLEN,1) = CHR$(70)   'F
     END IF
     MID$(Template$,17+ZFIDXRFMLEN+ZFIDXCDROMLEN,2) = SearchCrLf$
'
' * Rebuild the FIDX file
'
6010 CALL OpenRSeq (2,TFastFileList$,HighRec&,WasX,ZFIDXLEN)
     FIELD #2, ZFIDXLEN AS OldFidx$
     FIDXFileName$ = TDirPath$ + "FIDX.$$$"
     CALL OpenRSeq (7,FIDXFileName$,XX&,XX,ZFIDXLEN)
     FIELD #7, ZFIDXLEN AS WorkFidx$
     NumRecs& = LOF(2) / ZFIDXLEN
     Flag = ZFalse
     '* "ADD"
     LineNum = 1087
     GOSUB 11200
     Strng1$ = Strng$
     '* "DELETE"
     LineNum = 1088
     GOSUB 11200
     Strng2$ = Strng$
     '* "MOVE"
     LineNum = 1092
     GOSUB 11200
     Strng3$ = Strng$
     FOR Count& = 1 TO NumRecs&
        GET 2
        IF Action$ = Strng1$ THEN      ' ADD
           IF OldFidx$ > Template$ AND Flag = ZFalse THEN
              LSET WorkFidx$ = Template$
              PUT 7
              Flag = ZTrue
           END IF
           LSET WorkFidx$ = OldFidx$
           PUT 7
        ELSEIF Action$ = Strng2$ THEN  ' DELETE
           IF OldFidx$ < Template$ THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
           IF OldFidx$ > Template$ THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
        ELSEIF Action$ = Strng3$ THEN  ' MOVE
           IF OldFidx$ < Template$ THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
           IF OldFidx$ = Template$ THEN
              LSET WorkFidx$ = Template$
              PUT 7
           END IF
           IF OldFidx$ > Template$ THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
        END IF
     NEXT Count&
     CLOSE 2
     CLOSE 7
     '
     ' * Unlock the file system
     '
     GOSUB 640

     CALL CopyFile (FIDXFileName$, TFastFileList$, ErrCode)
     CALL DelFile (FIDXFileName$,ErrCode)
'
' * make a new FIDXT tab file
'
6020 IF TFastFileList$ = "" THEN
        TFastFileList$ = ZFastFileList$
     END IF
     DIM StartPos(36)
     '* "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
     LineNum = 632
     GOSUB 11200
     CharsCounted$ = Strng$
     CLOSE 2
     CALL OpenWork (2,TFastFileList$)
     FOR i = 1 TO 36
        StartPos(i) = 0
     NEXT
     IndexPos = 1
     LinesRead = 0
     WHILE NOT EOF(2)
        LINE INPUT #2, A$
        LinesRead = LinesRead + 1
        IndexChar$ = MID$(A$, IndexPos, 1)
        Position = INSTR(CharsCounted$, IndexChar$)
        IF Position > 0 THEN
           IF StartPos(Position) = 0 THEN
              StartPos(Position) = LinesRead
           END IF
        END IF
     WEND
     CLOSE 2
     CALL BreakFileName (TFastFileList$,Pre$,Body$,Ext$,ZTrue)
     FastTabFile$ = Pre$ + Body$ + "T" + Ext$
     CALL OpenRSeq (2,FastTabFile$,HighRec&,WasX,72)
     '* "{C2Re-Indexing {CB"
     LineNum = 936
     GOSUB 11200
     CALL QuickTPut1(Strng$ + FastTabFile$ + ZEmphasizeOff$)
     FIELD #2, 72 AS OutRec$
     PrevValue = 0
     i = 1
     WHILE i < 37 AND StartPos (i) = 0
        StartPos (i) = 1
        i = i + 1
     WEND
     i = 36
     WHILE i > 0 AND StartPos(i) = 0
        i = i - 1
     WEND
     StartPos(36) = StartPos(i)
     FOR i = 36 TO 1 STEP -1
        IF StartPos(i) = 0 THEN
           CurrentValue = 1
           IF PrevValue > CurrentValue THEN
              CurrentValue = PrevValue
           END IF
        ELSE
           CurrentValue = StartPos(i)
        END IF
        StartPos(i) = CurrentValue
        PrevValue = CurrentValue
     NEXT
     FOR i = 1 TO 36
        MID$(OutRec$, 1 + 2 * (i - 1), 2) = MKI$(StartPos(i))
     NEXT
     PUT 2, 1
     CLOSE 2
     RETURN
'
' =============================================================================
' * Update the MASTER.DIR or PERSONAL DIR file
' =============================================================================
'
7000 DO
        '* "Update the FMS (Y,[N])"
        LineNum = 1105
        GOSUB 11210
        GOSUB 11100
     LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
     IF ZWasQ = 0 OR ZWasZ$ = "N" THEN
        RETURN
     END IF
     '
     ' * Lock the file system
     '
     GOSUB 630

     CALL BreakFileName (SourceFileName$,SourceDrive$, _
                         SourceBody$,SourceExt$,ZTrue)
     CALL BreakFileName (ZPersonalDir$,PerPre$,PerBody$,PerExt$,ZFalse)
     DeleteFile$ = SourceBody$ + SourceExt$
     '* "{C2Rebuilding {CB"
     LineNum = 935
     GOSUB 11200
     IF InPers THEN
        CALL QuickTPut1(Strng$ + ZPersonalDir$ + ZEmphasizeOff$)
        FSize = 12 + 21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) + ZPersonalLen + 1 + 2
        CALL OpenRSeq (2,ZPersonalDir$,HighRec&,WasX,FSize)
        FIELD #2, 12 AS FileName$, _
                  21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) AS FileDesc$, _
                  ZPersonalLen + 1 AS FilePers$, _
                   2 AS FileChar$
        CALL OpenRSeq (7,PerPre$ + "\" + PerBody$ + ".$$$",XX&,XX,FSize)
        FIELD #7, 12 AS WorkFileName$, _
                  21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) AS WorkFileDesc$, _
                  ZPersonalLen + 1 AS WorkFilePers$, _
                   2 AS WorkFileChar$
     ELSE
        CALL QuickTPut1(Strng$ + TDirPath$ + TMainFMSDir$ + "." + _
                        TMainDirExtension$ + ZEmphasizeOff$)
        FSize = 12 + 10 + 11 + TMaxDescLen + 3 + 2
        CALL OpenRSeq (2,TDirPath$ + TMainFMSDir$ + "." + _
                       TMainDirExtension$,HighRec&,WasX,Fsize)
        FIELD #2, 12 AS FileName$, _
                  10 AS FileSize$, _
                  11 AS FileDate$, _
                  TMaxDescLen + 1 AS FileDesc$, _
                   4 AS FileCat$
        CALL OpenRSeq (7,TDirPath$ + TMainFMSDir$ + ".$$$",XX&,XX,FSize)
        FIELD #7, 12 AS WorkFileName$, _
                  10 AS WorkFileSize$, _
                  11 AS WorkFileDate$, _
                  TMaxDescLen + 1 AS WorkFileDesc$, _
                   4 AS WorkFileCat$
     END IF
     '*
     '* Parse the list to look for possible extended descriptions
     '*
     SourceCount& = HighRec&
     LastWasIt = ZFalse
     FOR InCount& = HighRec& TO 1 STEP -1
        GET 2, InCount&
        IF DeleteFile$ + SPACE$(12-LEN(DeleteFile$)) <> FileName$ THEN
           IF LastWasIt = ZTrue THEN
              IF LEFT$(FileName$,1) = SPACE$(1) THEN
                 SourceCount& = SourceCount& - 1
              ELSE
                 LastWasIt = ZFalse
              END IF
           END IF
        ELSE
           LastWasIt = ZTrue
           SourceCount& = SourceCount& - 1
        END IF
     NEXT InCount&
     '*
     '* rebuild the file list
     '*
     OutCount& = SourceCount&
     LastWasIt = ZFalse
     FOR InCount& = HighRec& TO 1 STEP -1
        GET 2, InCount&
        '*
        '* check for extended on the deleted file
        '*
        IF LastWasIt = ZTrue THEN
           IF LEFT$(FileName$,1) = SPACE$(1) THEN
              LastWasIt = ZTrue
           ELSE
              LastWasIt = ZFalse
           END IF
        END IF
        IF DeleteFile$ + SPACE$(12-LEN(DeleteFile$)) <> FileName$ THEN
           IF LastWasIt = ZFalse THEN
              IF InPers THEN
                 LSET WorkFileName$ = FileName$
                 LSET WorkFileDesc$ = FileDesc$
                 LSET WorkFilePers$ = FilePers$
                 LSET WorkFileChar$ = FileChar$
              ELSE
                 LSET WorkFileName$ = FileName$
                 LSET WorkFileSize$ = FileSize$
                 LSET WorkFileDate$ = FileDate$
                 LSET WorkFileDesc$ = FileDesc$
                 LSET WorkFileCat$ = FileCat$
              END IF
              PUT 7, OutCount&
              OutCount& = OutCount& - 1
           ELSE
              '* "{C2Removing Extended Description{RC{CR"
              LineNum = 937
              GOSUB 11220
           END IF
        ELSE
           LastWasIt = ZTrue
           '* "{C2Found {CB"
           LineNum = 938
           GOSUB 11200
           Strng1$ = Strng$
           '* "{C2 - Removing Entry{RC"
           LineNum = 939
           GOSUB 11200
           Strng2$ = Strng$
           CALL QuickTPut1 (Strng1$ + DeleteFile$ + Strng2$)
        END IF
     NEXT InCount&
     CLOSE 2
     CLOSE 7
     '
     ' * Unlock the file system
     '
     GOSUB 640
     '*
     '* kill the old listing and rename the new one
     '*
     IF InPers THEN
        CALL CopyFile (PerPre$ + "\" + PerBody$ + ".$$$", _
                       ZPersonalDir$, ErrCode)
        CALL DelFile (PerPre$ + "\" + PerBody$ + ".$$$",ErrCode)
     END IF
     IF InFMS THEN
        CALL CopyFile (TDirPath$ + TMainFMSDir$ + ".$$$", _
                       TDirPath$ + TMainFMSDir$ + "." + _
                       TMainDirExtension$, ErrCode)
        CALL DelFile (TDirPath$ + TMainFMSDir$ + ".$$$",ErrCode)
     END IF
     RETURN
'
' =============================================================================
' * Input SourceFileName for Action
' =============================================================================
'
8000 GOSUB 11000
     IF ZWasQ = 0 THEN
        RETURN
     END IF
8001 SourceFileName$ = ZUserInAra$(ZAnsIndex)
8002 CALL AllCaps (SourceFileName$)
     CALL BreakFileName (SourceFileName$,SourceDrive$, _
                         SourceBody$,SourceExt$,ZTrue)
     Found = ZFalse
     '* "ADD"
     LineNum = 1087
     GOSUB 11200
     Strng1$ = Strng$
     '* "VIEW"
     LineNum = 1093
     GOSUB 11200
     Strng2$ = Strng$
     IF Action$ = Strng1$ OR Action$ = Strng2$ THEN
        CALL FindIt (SourceFileName$)
        IF ZOK THEN
           Found = ZTrue
           RETURN
        END IF
     ELSE
        SourceFileName$ = SourceBody$ + SourceExt$
        CALL FindIt (ZPersonalDrvPath$ + SourceBody$ + SourceExt$)
        IF ZOK THEN
           Found = ZTrue
           '* "FIND"
           LineNum = 1090
           GOSUB 11200
           Strng1$ = Strng$
           '* "MOVE"
           LineNum = 1092
           GOSUB 11200
           Strng2$ = Strng$
           IF Action$ = Strng1$ OR Action$ = Strng2$ THEN
              SourceFileName$ = ZPersonalDrvPath$ + SourceBody$ + SourceExt$
              RETURN
           END IF
           '* "{CB"
           LineNum = 940
           GOSUB 11200
           Strng1$ = Strng$
           '* "{SP{C2"
           LineNum = 941
           GOSUB 11200
           Strng2$ = Strng$
           '* "{CB from {C2"
           LineNum = 942
           GOSUB 11200
           Strng3$ = Strng$
           '* "{RC (Y)es,[N]o,A)bort)"
           LineNum = 943
           GOSUB 11200
           Strng4$ = Strng$
           DO
              ZOutTxt$ = Strng1$ + Action$ + Strng2$ + _
                         SourceBody$ + SourceExt$ + _
                         Strng3$ + ZPersonalDrvPath$ + Strng4$
              GOSUB 11100
           LOOP Until ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
           IF ZWasZ$ = "A" THEN
              Found = ZFalse
              ZAnsIndex = 0
              RETURN
           END IF
           IF ZWasZ$ = "Y" THEN
              InPers = ZTrue
              InFMS = ZFalse
              SourceFileName$ = ZPersonalDrvPath$ + SourceBody$ + SourceExt$
              RETURN
           END IF
           Found = ZFalse
        END IF
        FOR WasX = 1 TO ZSubDirCount - 1
           CALL FindIt (ZSubDir$(WasX) + SourceBody$ + SourceExt$)
           IF ZOK THEN
              Found = ZTrue
              '* "FIND"
              LineNum = 1090
              GOSUB 11200
              Strng1$ = Strng$
              '* "MOVE"
              LineNum = 1092
              GOSUB 11200
              Strng2$ = Strng$
              IF Action$ = Strng1$ OR Action$ = Strng2$ THEN
                 SourceFileName$ = ZSubDir$(WasX) + SourceBody$ + SourceExt$
                 RETURN
              END IF
              '* "{CB"
              LineNum = 940
              GOSUB 11200
              Strng1$ = Strng$
              '* "{SP{C2"
              LineNum = 941
              GOSUB 11200
              Strng2$ = Strng$
              '* "{CB from {C2"
              LineNum = 942
              GOSUB 11200
              Strng3$ = Strng$
              '* "{RC (Y)es,[N]o,A)bort)"
              LineNum = 943
              GOSUB 11200
              Strng4$ = Strng$
              DO
                 ZOutTxt$ = Strng1$ + Action$ + Strng2$ + _
                            SourceBody$ + SourceExt$ + _
                            Strng3$ + ZSubDir$(WasX) + Strng4$
                 GOSUB 11100
              LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
              IF ZWasZ$ = "A" THEN
                 Found = ZFalse
                 ZAnsIndex = 0
                 RETURN
              END IF
              IF ZWasZ$ = "Y" THEN
                 SourceFileName$ = ZSubDir$(WasX) + _
                                   SourceBody$ + SourceExt$
                 TDirPath$ = ZDirPath$
                 TMainFMSDir$ = ZMainFMSDir$
                 TMainDirExtension$ = ZMainDirExtension$
                 TMaxDescLen = ZMaxDescLen
                 TFastFileList$ = ZFastFileList$
                 TFastFileLocator$ = ZFastFileLocator$
                 RETURN
              END IF
              Found = ZFalse
           END IF
        NEXT WasX
        IF ZFastFileSearch THEN
           TFastFileLocator$ = ZFastFileLocator$
           CALL BreakFileName (ZFastFileList$,Drive$,Body$,Ext$,ZTrue)
           CALL FindIt (Drive$ + "SYSOP8.CFG")
           IF ZOK THEN
              CALL OpenWork (7, Drive$ + "SYSOP8.CFG")
           ELSE
              CALL FindIt (Drive$ + Body$ + ".LST")
              IF ZOK THEN
                 CALL OpenWork (7,Drive$ + Body$ + ".LST")
              END IF
           END IF
           LineToRead = 1
           IF ZOK THEN
              IF ZErrCode <> 0 THEN
                 GOSUB 8010
                 GOTO 8020
              END IF
8005          CALL ReadParmsX (7,ZOutTxtAra$(),4,LineToRead)
              IF ZErrCode <> 0 AND ZOutTxtAra$(1) = "" THEN
                 CLOSE 7
                 GOTO 8020
              END IF
              TFastFileList$ = UCASE$(ZOutTxtAra$(1))
              TFastFileLocator$ = UCASE$(ZOutTxtAra$(2))
              CALL FindFile (TFastFileList$,ZOK)
              CALL FindFile (TFastFileLocator$,ZOK)
              CALL FindFile (ZOutTxtAra$(3),ZOK)
              IF NOT ZOK THEN
                 '* "File not found in SYSOP8 .LST file"
                 LineNum = 1106
                 GOSUB 11200
                 CALL UpdtCalr (Strng$,2)
                 GOSUB 11220
                 GOTO 8007
              END IF
              CALL BreakFileName (UCASE$(ZOutTxtAra$(3)),TDirPath$, _
                                  TMainFMSDir$,TMainDirExtension$,ZFalse)
              TMaxDescLen = VAL(ZOutTxtAra$(4))
              GOSUB 8010
              IF ZWasZ$ = "Y" THEN
                 GOTO 8020
              END IF
8007          LineToRead = LineToRead + 1
              ZOutTxtAra$(1) = ""
              GOTO 8005
           ELSE
              GOSUB 8010
              GOTO 8020
           END IF
8010       CALL OpenRSeq (14,TFastFileLocator$,HighRec&,WasX,66)
           FIELD 14, 66 AS Location$
           FOR LidxCount& = 1 TO HighRec&
              GET 14, LidxCount&
              SelectLocation$ = LEFT$(Location$,63)
              CALL Trim (SelectLocation$)
              FOR WasL = 1 TO ZSubDirCount - 1
                 Found = ZFalse
                 CALL BreakFileName (SelectLocation$,SDrive$,Body$,Ext$,ZFalse)
                 CALL BreakFileName (ZSubDir$(WasL),RDrive$,Body$,Ext$,ZFalse)
                 IF SDrive$ = RDrive$ THEN
                    Found = ZTrue
                    EXIT FOR
                 END IF
              NEXT WasL
              IF LEFT$(SelectLocation$,2) <> "M!" AND NOT Found THEN
                 CALL FindIt (SelectLocation$ + SourceBody$ + SourceExt$)
                 IF ZOK THEN
                    Found = ZTrue
                    '* "FIND"
                    LineNum = 1090
                    GOSUB 11200
                    Strng1$ = Strng$
                    '* "MOVE"
                    LineNum = 1092
                    GOSUB 11200
                    Strng2$ = Strng$
                    IF Action$ = Strng1$ OR Action$ = Strng2$ THEN
                       SourceFileName$ = SelectLocation$ + SourceBody$ + SourceExt$
                       RETURN
                    END IF
                    '* "{CB"
                    LineNum = 940
                    GOSUB 11200
                    Strng1$ = Strng$
                    '* "{SP{C2"
                    LineNum = 941
                    GOSUB 11200
                    Strng2$ = Strng$
                    '* "{CB from {C2"
                    LineNum = 942
                    GOSUB 11200
                    Strng3$ = Strng$
                    '* "{RC (Y)es,[N]o,A)bort)"
                    LineNum = 943
                    GOSUB 11200
                    Strng4$ = Strng$
                    DO
                       ZOutTxt$ = Strng1$ + Action$ + Strng2$ + _
                                  SourceBody$ + SourceExt$ + _
                                  Strng3$ + SelectLocation$ + Strng4$
                       GOSUB 11100
                    LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",UCASE$(ZWasZ$)) <> 0
                    IF ZWasZ$ = "A" THEN
                       Found = ZFalse
                       ZAnsIndex = 0
                       RETURN
                    END IF
                    IF ZWasZ$ = "Y" THEN
                       InFMS = ZTrue
                       LidxPos& = LidxCount&
                       SourceFileName$ = SelectLocation$ + SourceBody$ + SourceExt$
                       CLOSE 14
                       RETURN
                    END IF
                    Found = ZFalse
                 END IF
              END IF
           NEXT LidxCount&
           CLOSE 14
           RETURN
        END IF
     END IF
8020 IF NOT Found THEN
        '* "{CF{G4ERROR! Could not find{SP"
        LineNum = 944
        GOSUB 11200
        CALL QuickTPut1 (Strng$ + SourceBody$ + SourceExt$ + ZEmphasizeOff$)
     END IF
     RETURN
'
' =============================================================================
' * common input routine - single char
' =============================================================================
'
11000 ZSubParm = 1
      CALL TGet
      IF ZSubParm < 0 THEN _
         EXIT SUB
      RETURN
'
' =============================================================================
' * common input routine - string
' =============================================================================
'
11100 ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      ZWasZ$ = UCASE$(ZUserInAra$(ZAnsIndex))
      RETURN
'
' =============================================================================
' * External Text Display
' =============================================================================
'
11200 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
11210 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      RETURN
11220 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,CRCount,"")
      RETURN
'
' =============================================================================
' * End of SYSOP8
' =============================================================================
'
      END SUB
11300 '$SUBTITLE: ' FILSECCHK - New FILESEC SubRoutine for VIEW and DOWNLOADED '
' $PAGE
'
'  NAME    -- FilSecChk
'
'  INPUTS  -- PARAMETER                      MEANING
'             ZViolation$                String for type of action
'                                        "Download" or "View"
'             ZWasZ$                     Path/Filename of File being checked
'
'
'  OUTPUTS -- NoViolation                Passed or Failed FILESEC Check
'                                        (True)    (False)
'
'  PURPOSE -- To enable FILESEC to be check for downloads and
'             file viewing
'
      SUB FilSecChk (ZViolation$, ZWasZ$, NoViolation) STATIC
      NoViolation = ZTrue
      CALL OpenWork (2,ZFileSecFile$)
      IF ZErrCode = 53 THEN _
         EXIT SUB
11340 IF EOF(2) THEN _
         EXIT SUB
      CALL ReadParms (ZWorkAra$(),3,1)
      IF ZErrCode <> 0 THEN _
         EXIT SUB
      CALL WildFile (ZWorkAra$(1),ZWasZ$,ZOK)
      IF NOT ZOK THEN _
         NoViolation = ZTrue : _
         GOTO 11340
      IF ZUserSecLevel < VAL(ZWorkAra$(2)) THEN _
         GOTO 11370
      FilePswd$ = ZWorkAra$(3)
      IF FilePswd$ = "" THEN _
         EXIT SUB
      CALL AllCaps (FilePswd$)
      IF FilePswd$ = ZPswd$ THEN _
         EXIT SUB
      ZAttemptsAllowed = 4
      FOR Attempts = 1 TO ZAttemptsAllowed
         '* "Enter PASSWORD to download {FI{EX"
         CALL FormatString (628,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
         ZSubParm = 1
         CALL TGet
         IF ZFileSysParm > 1 OR (ZSysop AND ZWasQ = 0) THEN
            EXIT SUB
         END IF
         CALL AraAllCaps (ZUserInAra$(),1)
         IF ZUserInAra$(1) = FilePswd$ THEN
            NoViolation = ZTrue
            EXIT SUB
         ELSEIF ZWasQ = 0 THEN
            NoViolation = ZFalse
            EXIT SUB
         END IF
         '* "{CF{G4Passwords Don't Match!{RC"
         CALL FormatString (23,ZFalse,ZFalse,0,ZTrue,1,"")
      NEXT Attempts
11370 NoViolation = ZFalse
      '* "View ARC"
      CALL FormatString (373,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      IF ZViolation$ = Strng$ THEN
         ZViolation$ = ZViolation$ + SPACE$(1) + ZFileName$
         '* "{CE{G4 Protected File! {RC"
         CALL FormatString (629,ZFalse,ZFalse,0,ZTrue,1,"")
      END IF
      EXIT SUB
      END SUB
'
11380 SUB PersFilSecChk (ZViolation$, SearchFile$, NoViolation) STATIC
      CALL BreakFileName (SearchFile$,Pre$,Body$,Ext$,ZTrue)
      NoViolation = ZTrue
      FSize = 12 + 21 + ZMaxDescLen + ZPersonalLen + 1 + 2
      CALL OpenRSeq (2,ZPersonalDir$,HighRec&,WasX,FSize)
      FIELD 2, 12 AS FileName$, _
               21 + ZMaxDescLen AS FileDesc$, _
               ZPersonalLen + 1 AS FilePers$, _
                2 AS FileChar$
      Match = ZFalse
      Count& = 1
      WHILE NOT EOF(2)
         GET 2, Count&
         IF LEFT$(FileName$,LEN(Body$+Ext$)) = Body$ + Ext$ THEN
            Match = ZTrue
            CALL CheckInt (FilePers$)
            IF (ZTestedIntValue > 0 AND _
               ZUserSecLevel >= ZTestedIntValue) OR _
               LEFT$(FilePers$,LEN(ZActiveUserName$)) = _
               ZActiveUserName$ THEN
                  NoViolation = ZTrue
                  EXIT SUB
            END IF
         END IF
         Count& = Count& + 1
      WEND
      IF Match = ZTrue THEN
         NoViolation = ZFalse
         '* "View ARC"
         CALL FormatString (373,ZFalse,ZFalse,0,ZFalse,0,Strng$)
         IF ZViolation$ = Strng$ THEN
            ZViolation$ = ZViolation$ + SPACE$(1) + ZFileName$
            '* "{CE{G4 Protected File! {RC"
            CALL FormatString (629,ZFalse,ZFalse,0,ZTrue,1,"")
         END IF
      END IF
      END SUB
'
11400 ' $SUBTITLE: 'WildCard -- Matches string to a pattern'
' $PAGE
'  NAME    -- WildCard
'
'  INPUTS  -- PARAMETER             MEANING
'             Pattern$           PATTERN TO CHECK
'             Strng$             STRING TO FIE
'
'  OUTPUTS -- ZOK                True IF MATCH Found
'                                False IF No MATCH WAS Found
'
'  PURPOSE  Determine whether a string is an instance in a pattern
'           supported patterns are only "?" which requires a
'           character but can be any, and "*" which matches any-
'           thing, including a null string.  Anything else in a
'           sting must be an exact match.  Supports reverse
'           wildcards.
'
'
      SUB WildCard (Pattern$,Strng$) STATIC
      ZOK = ZTrue
      PatPos = 0
      StrPos = 0
      Inc = 1
      WasKT = 0
      WasP = LEN(Pattern$)
      WasL = LEN(Strng$)
11486 PatPos = PatPos + Inc
      StrPos = StrPos + Inc
      WasKT = WasKT + 1
      IF WasKT > WasL THEN _
         GOTO 11488
      ZUserIn$ = MID$(Pattern$,PatPos,1)
      IF ZUserIn$ = CHR$(42) THEN _                             '*
         GOTO 11489
      IF MID$(Strng$,StrPos,1) <> ZUserIn$ THEN _
         ZOK = ZFalse : _
         EXIT SUB
      GOTO 11486
11488 IF PatPos >= LEN(Pattern$) OR PatPos < 1 THEN _
         EXIT SUB
      IF MID$(Pattern$,PatPos,1) <> CHR$(42) THEN _             '*
         ZOK = ZFalse : _
         EXIT SUB
11489 IF PatPos <> WasP THEN _   ' Reverse search
         Inc = -1 : _
         WasP = PatPos : _
         PatPos = LEN(Pattern$) + 1 : _
         StrPos = LEN(Strng$) + 1 : _
         WasKT = 0 : _
         GOTO 11486
      END SUB
'
11500 ' $SUBTITLE: 'BinSearch - binary search a file'
' $PAGE
'
'  NAME    -- BinSearch
'                                  MEANING
'  INPUTS  -- PassedSearchFor$  Value you are looking for
'             StartPos          Starting position of sort key
'             NumChars          # of characters in sort key
'             LenRec            Length of record of data file searching
'             High&             Record # of last record
'             ZFastTabs$        In a binary integer subfield (2 bytes)
'                                  holds 1st record when might find
'                                  a key beginning with a particular
'                                  character (0-9,A-Z).   Empty if
'                                  no Fast Tab exists for the file.
'             FileNum           FileNumber
'
'  OUTPUTS -- RecFoundAt&       Record # value found at (0 if none)
'             RecFound$         Full data record when found
'
'  PURPOSE -- Binary searches work file #2 for a key value in a
'             data file that is sorted on a key field
'
      SUB BinSearch (FileNum, PassedSearchFor$,StartPos, NumChars, LenRec, High&, RecFoundAt&, RecFound$) STATIC
      SearchFor$ = LEFT$(PassedSearchFor$,NumChars)
      SearchFor$ = SearchFor$ + SPACE$(NumChars-LEN(SearchFor$))
      FIELD #FileNum, LenRec AS SearchRec$
      Low& = 0
      IF LEN(ZFastTabs$) < 72 THEN
         GOTO 11502
      END IF
      WasX$ = LEFT$(SearchFor$,1)
      '* "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
      CALL FormatString (632,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      WasX = INSTR(Strng$,WasX$)
      IF WasX > 0 THEN
         Low& = CVI(MID$(ZFastTabs$,1+2*(WasX-1),2)) - 1
         IF WasX < 36 THEN
            High& = CVI(MID$(ZFastTabs$,1+2*WasX,2))
         END IF
      END IF
11502 RecFoundAt& = 0
      IF High& < 1 THEN _
         EXIT SUB
      WasX$ = SPACE$ (NumChars)
      Done = ZFalse
      WHILE NOT Done
         WasI& = INT(((High&/2) + (Low&/2)) + .5)
         GET FileNum, WasI&
         LSET WasX$ = MID$(SearchRec$, StartPos, NumChars)
         IF WasX$ = SearchFor$ THEN
            RecFound$ = SearchRec$
            RecFoundAt& = WasI&
            Done = ZTrue
         ELSEIF (High& - Low&) < 2 THEN
            Done = ZTrue
         ELSEIF WasX$ < SearchFor$ THEN
            Low& = WasI&
         ELSEIF WasX$ > SearchFor$ THEN
            High& = WasI&
         END IF
      WEND
      END SUB
'
11600 SUB BatchUpload (ZDesc$,ZUCat$,WasFF) STATIC
      ON WasFF GOTO 11620, 11625
11620 CALL OpenWorkA (2,ZNodeWorkDrvPath$ + "BTUP" +ZNodeID$ +".LST")
      Call PrintWorkA (2,ZFileName$)
      CALL PrintWorkA (2,ZFileNameHold$)
      CALL PrintWorkA (2,ZDesc$)
      CALL PrintWorkA (2,ZUcat$)
      CALL OpenWorkA (2,ZBatchWorkFile$)
      CALL PrintWorkA (2,ZFileName$)
      CLOSE 2
      IF ZAnsindex = ZLastIndex THEN
         ZUpBatchTransfer = ZFalse
         ZWasBatchTransfer = ZTrue
      END IF
      EXIT SUB
'
11625 CALL KillWork (ZBatchWorkFile$)
      ZErrCode = 0
      Temp$ = ZNodeWorkDrvPath$ + "BTUP" + ZNodeid$ + ".LST"
      CALL OpenWork (8,Temp$)
      WHILE NOT EOF(8)
         LINE INPUT #8,ZFileName$
         LINE INPUT #8,ZFileNameHold$
         LINE INPUT #8,ZDesc$
         LINE INPUT #8,ZUCat$
         CALL Findit (ZFileName$)
         IF ZOK THEN
            CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(), ZLinesInMsg,2)
         ELSE
            '* "{FH ABORTED during BatchUL"
            CALL FormatString (695,ZFalse,ZTrue,2,ZFalse,0,"")
         END IF
         ZWasBatchTransfer = ZFalse
         ZAlreadyGiven = ZTrue
      WEND
      CLOSE 8
      END SUB
'
11630 ' $SUBTITLE: 'BATCHIT - subroutine to list files for batch uploading'
' $PAGE
'
      SUB BATCHIT STATIC
      '* "{C2Enter filenames on Separate Lines! {CB(EMPTY LINE ENDS){RC"
      CALL FormatString (696,ZFalse,ZFalse,0,ZTrue,1,"")
      ZWasB=1
      '* "{CEName of file #"
      CALL FormatString (697,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      FOR BatchF = 2 TO 25
         ZOutTxt$ = Strng$ + LTRIM$(STR$(Batchf-1)) + _
              ZFG2$
         Call TGet
         IF ZUserIn$ = "" THEN GOTO 11632
         ZUserIn$ = UCASE$(ZUserIn$)
         FileName$ = ZUserIn$
         GOSUB 11634
         IF NOT ZOK OR ZUserSecLevel >= ZOverwriteSecLevel THEN
            ZUserInAra$(BatchF) = ZUserIn$
            ZAnsIndex = BatchF+1
         ELSE
            '* "Thanks, but we already have {ZU"
            CALL FormatString (957,ZFalse,ZFalse,0,ZTrue,1,"")
            BatchF = BatchF - 1
         END IF
      NEXT BatchF
11632 BatchF =  BatchF-1
      ZLastIndex = BatchF
      EXIT SUB
11634 CALL BreakFileName (FileName$,Drive$,Body$,Ext$,ZFalse)
      SearchFile$ = Body$
      GOSUB 11636
      IF NOT ZOK THEN
         WasI = 1
         DO
            WasJ = INSTR(MID$(ZCompressedExt$+". ",WasI),CHR$(46))
            IF WasJ = 0 THEN
               EXIT DO
            END IF
            Ext$ = MID$(ZCompressedExt$,WasI,WasJ-1)
            WasI = WasI + WasJ
            SearchFile$ = Body$ + "." + Ext$
            GOSUB 11636
            IF ZOK THEN
               EXIT DO
            END IF
         LOOP WHILE WasJ > 0
      END IF
      RETURN
11636 CALL RotorsDir (SearchFile$,ZSubDir$(),ZSubDirCount,ZFalse,CHR$(85))
      RETURN
      END SUB
'
' $SUBTITLE: 'TStat --- Display Transfer Stats from Xfer-? file'
' $PAGE
'
      SUB TStats STATIC
      CALL OpenWork (2,"XFER-" + ZNodeID$ + ".DEF")
      IF ZErrCode <> 0 THEN _
         EXIT SUB
      IF ZTransferFunction = 1 AND ZShowTimesDownloaded AND _
         NOT ZPersonalDnld THEN
         CALL OpenWorkA (7,ZNodeWorkDrvPath$ + "DOWNLIST.DAT")
      END IF
      '* "{CCFile Transfer Statistics are as follows:"
      LineNum = 698
      GOSUB 11742
      '* "{CR{CEFileName         Bytes  DTR Rate  CPS       Errors"
      LineNum = 699
      GOSUB 11742
      '* "{C2----------------------------------------------------{RC"
      LineNum = 700
      GOSUB 11743
      IF ZWasGR > 0 THEN
         CALL GlobalSrchRepl (Strng$,"-",CHR$(196),ZTrue)
      END IF
      CALL QuickTPut1 (Strng$)
      '* "{CB"
      CALL FormatString (701,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      TempCount = 0
      WHILE NOT EOF(2)
         TempCount = TempCount + 1
         LINE INPUT #2,Stat$
         WasS = INSTR(Stat$,"rs ")
         IF WasS > 0 THEN _
            WasX$ = MID$(Stat$, 2, WasS)
         Match = INSTR(Stat$, CHR$(46))
         IF Match > 0 THEN
            WasZyX$ = MID$(Stat$, Match - 8, 12)
            IF ZTransferFunction = 1 AND ZShowTimesDownloaded AND _
               NOT ZPersonalDnld THEN
               CALL BreakFileName (WasZyX$,Drive$,Body$,Ext$,ZTrue)
               IF NOT ZUpdateOnLine THEN
                  PRINT #7, Body$ + Ext$ + ",1"
               ELSE
                  PRINT #7, Body$ + Ext$
               END IF
            END IF
         END IF
         Match = 0
         Start = 1
         IF INSTR(WasZyX$,CHR$(92)) THEN
            Divider$ = CHR$(92)
         ELSEIF INSTR(WasZyX$,CHR$(47)) THEN
            Divider$ = CHR$(47)
         ELSE
            Divider$ = CHR$(92)
         END IF
         DO
            Match = INSTR(Start, WasZyX$, Divider$)
            IF Match > 0 THEN
               WasZyX$ = RIGHT$(WasZyX$, LEN(WasZyX$) - Match)
            END IF
         LOOP WHILE Match
         Match = 0
         Start = 1
         DO
            Match = INSTR(Start, WasZyX$, SPACE$(1))
            IF Match > 0 THEN _
               WasZyX$ = RIGHT$(WasZyX$, LEN(WasZyX$) - Match)
         LOOP WHILE Match
         WasXy = LEN(WasZyX$)
         IF ZErrCode <> 0 THEN _
           Exit Sub
         IF ZAdvanceProtoWrite THEN _
            IF TempCount = 1 THEN _
               GOTO 11740
         CALL QuickTPut1 (Strng$ + WasZyX$ + SPACE$(15-WasXy) + _
              WasX$ + ZEmphasizeOff$)
11740 WEND
      CLOSE 2
      CLOSE 7
      EXIT SUB
11742 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,1,"")
      RETURN
11743 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
      END SUB
'
' * Update Downloads Field in FMS directory
'
11750 SUB UpdateDnlds
      IF ZShowTimesDownloaded AND ZUpdateOnLine AND NOT ZPersonalDnld THEN
         ZActiveFMSDir$ = ""
         PrevTi! = TIMER
         AlreadyPrinted = ZFalse
         NumDots = 0
         CALL OpenFMS (LastRec&,CatLen)
         CLOSE 2
         ZActiveFMSDir$ = ZFMSDirectory$
         GOSUB 11754
         CALL OpenWork (18,ZNodeWorkDrvPath$ + "DOWNLIST.DAT")
         WHILE NOT EOF(18)
            CALL ReadDir (18,1)
            FileToMatch$ = ZOutTxt$
            Found = ZFalse
11752       IF UseIDX THEN
               CALL BinSearch (14,FileToMatch$,1,12,20,IDXHighRec&,RecFoundAt&,RecFound$)
               AlreadyFound = ZFalse
               IF RecFoundAt& > 0 THEN
                  GET 14, RecFoundAt&
                  OffSet& = VAL(IdxRec$)
                  IF OffSet& > 0 AND OffSet& <= HighRec& THEN
                     AlreadyFound = ZTrue
                  END IF
               END IF
            END IF
            FOR search& = HighRec& TO 1 STEP -1
               IF NOT AlreadyPrinted THEN
                  TimeNow! = TIMER
                  IF TimeNow! - PrevTi! > 3.0 THEN
                     '* "{CR{C2Updating File System, Please Wait{RC"
                     CALL FormatString (702,ZFalse,ZFalse,0,ZTrue,0,"")
                     AlreadyPrinted = ZTrue
                  END IF
               END IF
               IF AlreadyPrinted THEN
                  CALL MarkTime (NumDots)
               END IF
               IF NOT AlreadyFound THEN
                  GET 9, search&
               ELSE
                  GET 9, OffSet&
               END IF
               IF LEFT$(SearchFileName$,LEN(FileToMatch$)) = FileToMatch$ THEN
                  DLTimes = VAL(SearchFileExtra$) + 1
                  IF DLTimes > 10000 THEN
                     DLTimes = 9999
                  END IF
                  DLTimes$ = LTRIM$(STR$(DLTimes))
                  DLTimes$ = STRING$(5 - LEN(DLTimes$),CHR$(48)) + DLTimes$
                  LSET SearchFileExtra$ = DLTimes$
                  IF ZNetWorkType <> 0 THEN
                     ZWasEN$ = ZActiveFMSDir$
                     ZSubParm = 9
                     CALL FileLock
                     ZErrCode = 0
                  END IF
                  IF AlreadyFound THEN
                     PUT 9, OffSet&
                  ELSE
                     PUT 9, search&
                  END IF
                  IF ZNetWorkType <> 0 THEN
                     ZSubParm = 10
                     CALL FileLock
                  END IF
                  Found = ZTrue
                  EXIT FOR
               END IF
               IF AlreadyFound THEN
                  AlreadyFound = ZFalse
                  search& = HighRec&
               END IF
            NEXT search&
            IF NOT Found AND ZChainedDir$ <> "" THEN
               ZActiveFMSDir$ = ZChainedDir$
               CALL OpenFMS (LastRec&,CatLen)
               CLOSE 2
               GOSUB 11754
               GOTO 11752
            END IF
         WEND
         CLOSE 18
         CLOSE 14
         CLOSE 9
         CALL KillWork (ZNodeWorkDrvPath$ + "DOWNLIST.DAT")
         CALL QuickTPut (ZBackSpace$,0)
         CALL SkipLine (1)
      END IF
      EXIT SUB
11754 CALL OpenRSeq (9,ZActiveFMSDir$,HighRec&,X,ZFMSFileLength)
      FIELD #9, 13 AS SearchFileName$, _
                 9 AS SearchFileSize$, _
                11 AS SearchFileDate$, _
                ZMaxDescLen - 5 AS SearchFileDesc$, _
                 5 AS SearchFileExtra$, _
                 3 AS SearchFileCat$, _
                 2 AS SearchCRLf$
      CALL BreakFileName (ZActiveFMSDir$,Drive$,Body$,Ext$,ZTrue)
      FMSIdx$ = Drive$ + Body$ + ".IDX"
      CALL FindFile (FMSIdx$,UseIDX)
      IF UseIDX THEN
         CALL OpenRSeq (14,FMSIdx$,IDXHighRec&,X,20)
         FIELD #14, 12 AS IdxFile$, _
                     6 AS IdxRec$, _
                     2 AS IdxCrLf$
      END IF
      RETURN
      END SUB
'
11800 SUB SetupTransferInfo
'
      Temp$ = STR$(ZUserSecLevel)
      CALL Trim (Temp$)
      '* "{C${CE{SL {C2{NO {CB{CT {C2At {CE{BP{RC{CR"
      LineNum = 731
      GOSUB 11810
      ZOutTxt$ = Strng$
      IF ZTransferFunction = 1 THEN
         '* "{CADownloading{CE"
         LineNum = 732
         GOSUB 11810
         ZOutTxt$ = ZOutTxt$ + Strng$
         IF ZBlockSize > 0 THEN
            '* "{C2 blocks {CE"
            LineNum = 733
            GOSUB 11810
            ZOutTxt$ = ZOutTxt$ + _
                 ZFGE$ + STR$(CINT(ZBytesInFile#/ZBlockSize)) + Strng$
         END IF
         '* "{C2 bytes{CR"
         LineNum = 734
         GOSUB 11810
         ZOutTxt$ = ZOutTxt$ + _
              STR$(ZBytesInFile#) + Strng$
         '* "{CBEstimated Transfer Time:{CD"
         LineNum = 735
         GOSUB 11810
         ZOutTxt$ = ZOutTxt$ + Strng$ + STR$(INT(ZBlocksInFile# / 60))
         '* "{C3 min,{CD"
         LineNum = 736
         GOSUB 11810
         Strng1$ = Strng$
         '* "{C3 sec{C7{RC"
         LineNum = 737
         GOSUB 11810
         Strng2$ = Strng$
         ZoutTxt$ = ZOutTxt$ + Strng1$ + _
              STR$(INT(ZBlocksInFile# - _
              (INT(ZBlocksInFile# / 60) * 60))) + Strng2$
      ELSE
         '* "{CAUploading file At {CE{BP{RC{CR"
         LineNum = 738
         GOSUB 11810
         ZOutTxt$ = ZOutTxt$ + Strng$
      END IF
      EXIT SUB
11810 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
      END SUB
'
11900 SUB UploadMessage
'
      IF ZSysop THEN _
         EXIT SUB
      CALL BreakFileName (ZMainMsgFile$,Drive$,FileName$,ZWasY$,ZFalse)
      IF RIGHT$(FileName$,1) = CHR$(77) THEN _
         FileName$ = LEFT$(FileName$,LEN(FileName$)-1)
      ZFileName$ = ZHelpPath$ + FileName$ + "U" + ZHelpExtension$
      CALL Findit(ZFileName$)
      IF ZOK THEN _
         GOTO 11910
      ZFileName$ = ZHelpPath$ + "UPMSG" + ZHelpExtension$
11910 CALL GraphicDisplayFile (ZFileName$)
      END SUB
'
22100 ' $SUBTITLE: 'WildFile -- Matches file to a filespec'
' $PAGE
'  NAME    -- WildFile
'
'  INPUTS  -- PARAMETER             MEANING
'             Pattern$           PATTERN TO CHECK AGAINST
'             ItemToMatch$       FILE NAME TO MATCH
'
'  OUTPUTS -- DoesMatch         WHETHER MATCHES
'
'  PURPOSE  Determine whether a file name is an instance of
'    a file specification.  Exactly like DOS except that ? must have a
'    character.
'
      SUB WildFile (Pattern$,ItemToMatch$,DoesMatch) STATIC
      IF Pattern$ <> PrevPattern$ THEN _
         CALL BreakFileName (Pattern$,PDrive$,PPrefix$,PExt$,ZFalse) : _
         PrevPattern$ = Pattern$
      CALL BreakFileName (ItemToMatch$,IDrive$,IPrefix$,IExt$,ZFalse)
      DoesMatch = ZFalse
      IF PDrive$ <> "" AND PDrive$ <> IDrive$ THEN _
         EXIT SUB
      CALL WildCard (PPrefix$,IPrefix$)
      IF NOT ZOK THEN _
         EXIT SUB
      CALL WildCard (PExt$,IExt$)
      DoesMatch = ZOK
      END SUB
'
'
22140 ' $SUBTITLE: 'GetArc - sub to get what files to verbose list'
' $PAGE
'
'  NAME    -- GetArc
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZWasQ                       NUMBER OF ENTRIES TYPED
'                 ZUserInAra$()                  ENTRIES TYPED
'
'  OUTPUTS --
'
'  PURPOSE --  Process the V)erbose list command.
'              Takes what user types and tries to list it.
'
      SUB GetArc (FromSysop8) STATIC
      IF FromSysop8 THEN
         ZFileNameHold$ = ZFileName$
         CALL BreakFileName (ZFileName$,Drive$,Prefix$,Ext$,ZFalse)
         GOSUB 22148
         EXIT SUB
      END IF
22141 IF ZAnsIndex >= ZLastIndex AND LEN(ZDefaultExtension$) > 0 THEN
         '* "{CEDefault extension is {CB{DE{RC"
         CALL FormatString (372,ZFalse,ZFalse,0,ZTrue,1,"")
      END IF
      WasZ$ = CHR$(86)                                      'V
      '* "file"
      LineNum = 1025
      GOSUB 22160
      CALL AskItems (CHR$(86),WasZ$,ZFalse,Strng$,ZMarkedFiles$)
      IF ZSubParm = -1 OR ZWasQ = 0 THEN
         EXIT SUB
      END IF
      '* "View ARC"
      CALL FormatString (373,ZFalse,ZFalse,0,ZFalse,0,ZViolation$)
      WasX = ZAnsIndex
      ZAnsIndex = WasX
22142 IF ZAnsIndex > ZLastIndex THEN _
         IF ZLastIndex > 1 OR Drive$ <> "" THEN _
            EXIT SUB _
         ELSE GOTO 22141
      GOSUB 22143
      IF ZSubParm < 0 THEN _
         EXIT SUB
      ZAnsIndex = ZAnsIndex + 1
      GOTO 22142
22143 ZWasZ$ = ZUserInAra$(ZAnsIndex)
      CALL UnMarkItems (ZMarkedFiles$,ZAnsIndex, ZLastIndex,Temp,ZFalse)
      ZWasZ$ = ZUserInAra$(ZAnsIndex)
      WasZ$ = ZWasZ$
      ZWasZ$ = UCASE$(ZWasZ$)
      CALL BreakFileName (ZWasZ$,Drive$,Prefix$,Ext$,ZFalse)
      IF Ext$ = "" THEN _
         Ext$ = ZDefaultExtension$ : _
         ZWasZ$ = ZWasZ$ + CHR$(46) + ZDefaultExtension$
      ZLastExt$ = Ext$
      ZFileNameHold$ = ZWasZ$
      ZFileName$ = ZWasZ$
      WasI = 1
      CALL BadFile (Prefix$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 22144,22146,22147
22144 CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 22145,22146,22147
22145 IF Drive$ <> "" THEN
         ZFileNameHold$ = Prefix$ + CHR$(46) + Ext$
         CALL FindFile (ZFileName$,ZOK)
      ELSE
         CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount + (NOT ZSysop),ZTrue,CHR$(86))
      END IF
      IF ZOK THEN _
         GOTO 22148
      IF ZPersonalDnld THEN _
         ZFileName$ = ZPersonalDrvPath$ + ZWasZ$ : _
         CALL FindFile (ZFileName$,ZOK)
      IF ZOK THEN _
         GOTO 22148
      ZWasZ$ = ZFileName$
      CALL BreakFileName (ZFileName$,DR$,Prefix$,Ext$,ZFalse)
      WasJ = INSTR(MID$(ZCompressedExt$+". ",WasI),CHR$(46))
      IF WasJ = 0 THEN _
         GOTO 22146
      Check$ = MID$(ZCompressedExt$,WasI,WasJ-1)
      WasI = WasI + WasJ
      ZFileName$ = Prefix$ + CHR$(46) + Check$
      ZLastExt$ = Check$
      ZFileNameHold$ = ZFileName$
      GOTO 22145
22146 '* "{SPnot found!"
      LineNum = 374
      GOSUB 22160
      ZWasZ$ = WasZ$ + Strng$
      CALL UpdtCalr (ZWasZ$,2)
      '* "{ZZ Type correct filename{EX"
      CALL FormatString (375,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      ZSubParm = 1
      CALL TGet
      IF ZSubParm = -1 OR ZWasQ = 0 THEN _
         RETURN
      ZUserInAra$(ZAnsIndex) = ZUserInAra$(1)
      GOTO 22143
22147 CALL SecViolation
      IF ZDenyAccess THEN _
         EXIT SUB
      IF DGSViewVio THEN _
         EXIT SUB
      GOTO 22146
22148 WasX$ = ZDiskForDos$ + "VIEWFILE.BAT"
      CALL FindIt (WasX$)
      IF NOT ZOK THEN _
         GOTO 22150
      ZGSRAra$(3) = MID$(RIGHT$(ZComPort$,1)+"0",1-ZLocalUser, 1)
      CALL TimeRemain(MinsRemaining)
      TimeStr$ = MID$(STR$(INT(MinsRemaining)),2)
      ZWasZ$ = WasX$ + SPACE$(1) + ZFileName$ + _
             SPACE$(1) + ZArcWork$ + _
             SPACE$(1) + Ext$ + _
             SPACE$(1) + ZNodeID$ + _
             SPACE$(1) + ZGSRAra$(3) + _
             SPACE$(1) + TimeStr$ + SPACE$(1) + _
             LTRIM$(STR$(ZWaitBeforeDisconnect)) + SPACE$(1) + _
             LTRIM$(STR$(ZPageLength))
      IF NOT FromSysop8 THEN
         CALL FilSecChk (ZViolation$, ZFileName$, ZOK)
         IF NOT ZOK THEN
            DGSViewVio = ZTrue
            GOTO 22147
         END IF
         IF ZPersonalDnld THEN
            CALL PersFilSecChk (ZViolation$,ZFileName$,ZOK)
            IF NOT ZOK THEN
               GOTO 22147
            END IF
         END IF
         IF ZErrCode = 53 THEN
            '* "Missing file{SP"
            LineNum = 376
            GOSUB 22160
            CALL UpdtCalr (Strng$ + ZFileSecFile$,2)
         END IF
         IF ZErrCode = 62 THEN
            '* "{SPBad format!"
            LineNum = 377
            GOSUB 22160
            CALL UpdtCalr (ZFileSecFile$ + Strng$,2)
         END IF
      END IF
      '* "{CAViewing {CE{FH{RC"
      CALL FormatString (378,ZFalse,ZFalse,0,ZTrue,1,"")
      IF ZViewDropFile$ <> "N" THEN
         ZDoorDropFile$ = ZViewDropFile$
         CALL DoorInfo
      END IF
      CALL DelayTime (2)
      CALL ShellExit (ZWasZ$)
      CALL DelayTime(2)
      CALL Line25
      SetUpDn = ZFalse
      IF ZViewDropFile$ = CHR$(82) THEN                         'R
         SetUpDn = ZTrue
         CALL ReadDoorSys
      END IF
      IF ZViewDropFile$ = CHR$(85) THEN                         'U
         SetUpDn = ZTrue
         CALL ReadUserInfo
      END IF
      IF SetUpDn THEN
         CALL SetUserUpDn
         ZGlobalsSet = ZFalse
         CALL SetGlobalUpDn
      END IF
      RETURN
22150 '* "View not implemented"
      CALL FormatString (960,ZFalse,ZFalse,0,ZTrue,0,"")
      RETURN
22160 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
      END SUB
'
22598 ' $SUBTITLE: 'XferType - sub to identify file xfer protocol'
' $PAGE
'
'  NAME    -- XferType
'
'  INPUTS  --     PARAMETER                    MEANING
'               Index            = 1       Manual select for up/download
'                                = 2       Default select
'                                = 3       Set transfer default
'               ZOutTxt$
'               ZUserInAra$(1)
'               ZWasQ
'               ZReliableMode
'               ZTransferOption$
'               ZUserXferDefault$
'               ZXferSupport
'
'  OUTPUTS   -- ZFLen
'               ZWasFT$
'
'  PURPOSE -- To identify the file transfer protocol (either
'             from the user's default or via explicit selection)
'
      SUB XferType (Index,SkipHelp) STATIC
      IF ZTransferOption$ = "" OR ZUserSecLevel <> PrevUSL OR PrevDef$ <> ZProtoDef$ THEN
         CALL Protocol
         PrevDef$ = ZProtoDef$
         PrevUSL = ZUserSecLevel
      END IF
      '* "{CEProtocols Available:{RC"
      CALL FormatString (408,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      WasX$ = ZOutTxt$ + Strng$
      ON Index GOTO 22600,22620,22600
'
'
' *  MANUAL SELECT OF Transfer Protocol
'
'
22600 IF SkipHelp THEN _
         GOTO 22604
22602 CALL BufFile (ZHelpPath$ + "UF" + ZHelpExtension$,WasX)
      IF ZSubParm = -1 THEN _
         EXIT SUB
      CALL SmartPause (ZFalse)
22604 ZStopInterrupts = ZTrue
      IF Index = 3 THEN _
         IF ZAnsIndex < ZLastIndex THEN _
            GOTO 22605
      ProtoMenu$ = ZWelcomeFileDrvPath$ + "PROTO.MNU"
      CALL Graphic (ProtoMenu$)
      CALL FindIt (ProtoMenu$)
      IF ZOK THEN
         ZDeleteInvalid = ZTrue
         HoldOpts$ = ZInvalidOpts$
         ZInvalidOpts$ = ""
         FOR i = 33 TO 126
            IF INSTR(ZDefaultXfer$,CHR$(i)) = 0 THEN
               ZInvalidOpts$ = ZInvalidOpts$ + CHR$(i)
            END IF
         NEXT i
         CALL BufFile (ProtoMenu$,WasX)
         ZInvalidOpts$ = HoldOpts$
         ZDeleteinvalid = ZFalse
         ProtoStr$ = ZDefaultXfer$
         CALL Remove (ProtoStr$,SPACE$(1))
         CALL SortString (ProtoStr$)
         CALL AddCommas (ProtoStr$)
         '* "{CBSelect Protocol{RC"
         CALL FormatString (1037,ZFalse,ZFalse,0,ZFalse,0,Strng$)
         promptstr$ = Strng$ + ProtoStr$ + ZPressEnterExpert$
         CALL ColorPrompt (promptstr$)
         CALL QuickTPut (promptstr$ + ZEmphasizeOff$,0)
      ELSE
         CALL QuickTPut (WasX$,0)
         CALL BufString (ZTransferOption$,4096,WasX)
      END IF
      CALL QuickTPut (MID$("?!",1-ZTurboKeyUser,1)+SPACE$(1),0)
22605 ZOutTxt$ = ""
      ZTurboKey = -ZTurboKeyUser
      ZMacroMin = 2
      ZSubParm = 1
      ZSuspendAutoLogoff = ZTrue
      ZStackC = ZTrue
      IF Index = 3 THEN
         CALL PopCmdStack
         WasX = ZAnsIndex
      ELSE
         ZSubParm = 1
         CALL TGet
         WasX = 1
      END IF
      ZSuspendAutoLogoff = ZFalse
      IF ZSubParm = -1 THEN _
         EXIT SUB
'
' * USE [ENTER] to Cancel as well as "N"one
'
      IF ZWasQ = 0 THEN
         ZAnsIndex = 1
         WasX = 1
         ZWasZ$ = ZUserXferDefault$
         ZUserInAra$(WasX) = "N"
         GOTO 22610
      ELSEIF (ZFileSysParm AND UCASE$(ZUserIn$) = "N") THEN
         ZProtoPrompt$ = "N"
         ZWasQ = 0
         ZFF = 0
         GOTO 22625
      END IF
22606 ZWasZ$ = ZUserInAra$(WasX)
'
'
' *  DEFAULT SELECT OF Transfer Protocol
'
'
22610 CALL AllCaps (ZWasZ$)
      ZFF = INSTR(ZDefaultXfer$,ZWasZ$)
      IF ZFF > 0 THEN _
         GOTO 22612
      IF INSTR("H?",ZWasZ$) > 0 THEN _
         GOTO 22602
      GOTO 22600
22612 ZWasFT$ = MID$(ZDefaultXfer$,ZFF,1)
      GOTO 22621
22620 ZFF = -1
      IF ZCmdTransfer$ <> "" THEN _
         ZWasZ$ = ZCmdTransfer$ : _
         GOTO 22610
      WasX = INSTR(ZDefaultXfer$,ZUserXferDefault$)
      IF WasX > 0 THEN _
         IF MID$(ZDefaultXfer$,WasX,1) <> "N" THEN _
            ZWasZ$ = ZUserXferDefault$ : _
            GOTO 22610
      '* "None"
      CALL FormatString (410,ZFalse,ZFalse,0,ZFalse,0,ZProtoPrompt$)
      ZFF = 0
      EXIT SUB
22621 IF ZFF = PrevFF AND PrevProtoDef$ = ZProtoDef$ THEN _
         ZProtoPrompt$ = PrevProtoPrompt$ : _
         EXIT SUB
      PrevFF = ZFF
      PrevProtoDef$ = ZProtoDef$
      CALL FindIt (ZProtoDef$)
      IF ZOK THEN _
         GOTO 22623
      ZProtoPrompt$ = "N"
      GOTO 22625
22623 CALL ReadParms (ZWorkAra$(),13,ZFF)
      IF ZErrCode > 0 THEN
         ZFF = LEN(ZDefaultXfer$)
         '* "None"
         CALL FormatString (410,ZFalse,ZFalse,0,ZFalse,0,ZProtoPrompt$)
         GOTO 22625
      END IF
      ZProtoPrompt$ = ZWorkAra$(1)
      IF LEN(ZProtoPrompt$) > 2 THEN _
         IF MID$(ZProtoPrompt$,2,1) = CHR$(41) THEN _         ')
            ZProtoPrompt$ = LEFT$(ZProtoPrompt$,1) + MID$(ZProtoPrompt$,3)
      WasX = INSTR(ZProtoPrompt$+ZCrLf$,ZCrLf$)
      ZProtoPrompt$ = LEFT$(ZProtoPrompt$,WasX-1)
      CALL Trim (ZProtoPrompt$)
      ZProtoMethod$ = LEFT$(ZWorkAra$(3),2)
      CALL AllCaps (ZProtoMethod$)
      ZReq8Bit = (LEFT$(ZWorkAra$(4),1) = CHR$(56))           '8
      ZDownTemplate$ = ZWorkAra$(12)
      ZUpTemplate$ = ZWorkAra$(13)
      WasX$ = ZWorkAra$(11)
      WasX = INSTR(WasX$,CHR$(61))                            '=
      ZAdvanceProtoWrite = ZFalse
      IF WasX < 2 OR WasX >= LEN(WasX$) THEN _
         ZFailureParm = 4 : _
         ZFailureString$ = CHR$(70) _                         'F
      ELSE ZFailureParm = VAL(LEFT$(WasX$,WasX-1)) : _
           ZFailureString$ = MID$(WasX$,WasX+1) : _
           WasX = INSTR(ZFailureString$,CHR$(61)) : _
           IF WasX > 0 THEN _
              ZAdvanceProtoWrite = (MID$(ZFailureString$,WasX) = "=A") : _
              ZFailureString$ = LEFT$(ZFailureString$,WasX-1)
      ZProtoMacro$ = ZWorkAra$(10)
      ZFakeXRpt = (LEFT$(ZWorkAra$(8),1) = CHR$(70))
      ZBatchProto = (LEFT$(ZWorkAra$(6),1) = CHR$(66))        'B
      ZSpeedFactor! = VAL(ZWorkAra$(9))
      IF ZSpeedFactor! < 0.1 THEN _
         ZSpeedFactor! = 0.87
      ZBlockSize = VAL(ZWorkAra$(7))
      ZFLen = ZBlockSize
      IF ZFLen < 1 THEN _
         ZFLen = 128
22625 PrevProtoPrompt$ = ZProtoPrompt$
      END SUB
'
22740 ' $SUBTITLE: 'LoadNew - subroutine to get latest uploads'
' $PAGE
'
'  NAME    -- LoadNew
'
'  INPUTS  --     PARAMETER           MEANING
'               ZUpldDir$             LIST OF FILES UPLOADED
'
'  OUTPUTS --   ZOutTxt$              LATEST UPLOADS
'
'  PURPOSE -- Loads table of most recent number of uploads by date
'
      SUB LoadNew (Ara(2)) STATIC
      IF ZFMSDirectory$ = "" THEN _
         EXIT SUB
      ZPrevBase$ = ""
      FirstWarning = ZTrue
      IF PrevLoadNew$ = ZFMSDirectory$ THEN _
         Ara(1,1) = 0 : _
         EXIT SUB
      Lmonth$ = RIGHT$(STR$(ASC(MID$(ZListNewDate$,2))),2)
      Lday$ = RIGHT$(STR$(ASC(MID$(ZListNewDate$,3))),2)
      Lyear$ = RIGHT$(STR$(ASC(ZListNewDate$)),2)
      StopSearchingDate! = 372! * (VAL(Lyear$) - 80!) + 31! * VAL(Lmonth$) + VAL (Lday$)
      '* "{C9Checking new files{RC"
      CALL FormatString (1040,ZFalse,ZFalse,0,Ztrue,0,"")
22741 PrevLoadNew$ = ZFMSDirectory$
      CALL OpenFMS (LastRec&,WasL)
      FIELD 2, 23 AS PreDate$, _
                2 AS WasMM$, _
                1 AS Fill1$, _
                2 AS WasDD$, _
                1 AS Fill2$, _
                2 AS Year$, _
                (2 + ZMaxDescLen) AS ZDesc$, _
                3 AS Category$, _
                2 AS Fill4$
      MaxRecs = UBOUND(Ara,1)
      IF MaxRecs < 1 THEN _
         MaxRecs = 1 _
      ELSE IF MaxRecs > 999 THEN _
              MaxRecs = 999
      WasL = 0
      WasK& = LastRec&
      numdots = 0
      WHILE WasK& > 0 AND WasL < MaxRecs
         CALL MarkTime (NumDots)
         GET #2,WasK&
         IF INSTR("*\ ",LEFT$(PreDate$,1)) > 0 THEN
            GOTO 22742
         END IF
         IF (ZCanDnldFromUp OR Category$ <> ZDefaultCatCode$) THEN
            IF VAL(Year$) > 79 THEN
               WasL = WasL + 1
               Ara(WasL,1) = 372! * (VAL(Year$) - 80!) + 31! * VAL(WasMM$) + VAL(WasDD$)
               IF ZDateOrderedFMS AND StopSearchingDate! > Ara(WasL,1) THEN
                  Ara(WasL,1) = 0
                  WasL = WasL - 1
                  GOTO 22743
               END IF
            ELSEIF FirstWarning THEN
               FirstWarning = ZFalse
               '* "Invaild FMS format{SP"
               CALL FormatString (447,ZFalse,ZFalse,0,ZFalse,0,Strng$)
               ZWasZ$ = Strng$ + ZFMSDirectory$
               ZSnoop = ZTrue
               CALL LPrnt (ZWasZ$,1)
               CALL UpdtCalr (ZWasZ$,2)
            END IF
         END IF
         IF NOT ZCanDnldFromUp THEN _
            WasX = ZMinSecToView _
         ELSE IF Category$ = STRING$(3,42) THEN _
                 WasX = ZSysopSecLevel _
              ELSE IF Category$ = ZDefaultCatCode$ THEN _
                      WasX = ZMinSecToView _
              ELSE IF LEFT$(PreDate$,1) = CHR$(61) THEN _     '=
                      CALL CheckInt (ZDesc$) : _
                      WasX = ZTestedIntValue _
              ELSE WasX = ZOptSec(19)
         Ara(WasL,2) = WasX
22742    WasK& = WasK& - 1
      WEND
22743 CALL QuickTPut1 (ZBackSpace$)
      CLOSE 2
      IF ZUpInc > 0 AND ZChainedDir$ <> "" THEN _
         ZActiveFMSDir$ = ZChainedDir$ : _
         GOTO 22741
      END SUB
'
22750 ' $SUBTITLE: 'CountNewFiles - sub to count how many files new'
' $PAGE
'
'  NAME    -- CountNewFiles
'
'  INPUTS  --     PARAMETER           MEANING
'                  LastOn$          Date to start search
'                  UPLDS$            Latest uploads
'
'  OUTPUTS --    NumNewFiles       How many after last logon
'                RptPrefix$         Set to "At least " if
'                                    above is a minimum
'                ListSearchDate$   Date to search FMS for
'
'  PURPOSE -- Checks how many files in UPLDS$ were uploaded on or
'             after date of last dir search that the user can
'             download
'
      SUB CountNewFiles (LastOn$,Upld(2),NumUserFiles,ReturnDate$) STATIC
      ReturnDate$ = MID$(LastOn$,3,2) + MID$(LastOn$,5,2) + _
                    MID$(LastOn$,1,2)
      BaseDate! = 372! * (VAL(MID$(LastOn$,1,2)) - 80!) + _
                  31! * (VAL(MID$(LastOn$,3,2))) + _
                  VAL(MID$(LastOn$,5,2))
      NumNewFiles = 1
      NumUserFiles = 0
      WHILE (BaseDate! <= Upld(NumNewFiles,1) AND _
                Upld(NumNewFiles,1) > 0 AND _
                NumNewFiles < UBOUND(Upld,1))
         IF ZUserSecLevel => Upld(NumNewFiles,2) THEN _
            NumUserFiles = NumUserFiles + 1
         NumNewFiles = NumNewFiles + 1
      WEND
      IF Upld(NumNewFiles,1) < 1 THEN _
         NumNewFiles = NumNewFiles - 1
      ZTotalNewFiles = NumUserFiles
      END SUB
22760 ' $SUBTITLE: 'CountLines - sub to determine file categories '
' $PAGE
'
'  NAME    -- CountLines
'
'  INPUTS  -- PARAMETER             MEANING
'             ZDirCatFile$          NAME OF THE FILE THAT HAS THE
'                                   NUMBER OF CATEGORIES IN IT.
'
'  OUTPUTS -- MaxEntries           NUMBER OF FILE CATEGORIES
'
'  PURPOSE -- Subroutine to count the number of categories that a
'             file can be classified into.
'
      SUB CountLines (MaxEntries) STATIC
      CALL LinesInFile (ZDirCatFile$,MaxEntries)
      MaxEntries = MaxEntries + 4
      IF MaxEntries < 10 THEN _
         MaxEntries = 10
      END SUB
'
22762 ' $SUBTITLE: 'InitFMS - sub to initialize file management system'
' $PAGE
'
'  NAME    -- InitFMS
'
'  INPUTS  -- PARAMETER             MEANING
'             ZFMSDirectory$
'
'  OUTPUTS -- ZCategoryName$()  ELEMENTS 1,2, POSSIBLY MORE
'             ZCategoryCode$()  ELEMENTS 1,2, POSSIBLY MORE
'             ZCategoryDesc$()  ELEMENTS 1,2, POSSIBLY MORE
'             CategoryIndex     COUNT OF # ELEMENTS IN THE FILE
'                               MANAGMENT SYSTEM
'
'  PURPOSE -- Subroutine to initialize the RBBS-PC File Management System
'
      SUB InitFMS (CategoryIndex) STATIC
      Blank$ = SPACE$(1)
      CategoryIndex = 1
      ZCategoryName$(1) = CHR$(80)                       'P
      ZCategoryCode$(1) = CHR$(80)                       'P
      '* "Personals"
      LineNum = 448
      GOSUB 22763
      ZCategoryDesc$(1) = Strng$
      IF ZFMSDirectory$ <> "" THEN
         CategoryIndex = CategoryIndex + 1
         CatN$ = ZCategoryName$(CategoryIndex)
         CALL BreakFileName (ZFMSDirectory$,DrvPath$,CatN$,Extension$,ZFalse)
         ZCategoryName$(CategoryIndex) = CatN$
         ZCategoryCode$(CategoryIndex) = ""
         '* "All uploads"
         LineNum = 449
         GOSUB 22763
         ZCategoryDesc$(CategoryIndex) = Strng$
      ELSE
         ZLimitSearchToFMS = ZFalse : _
         EXIT SUB
      END IF
      IF ZLimitSearchToFMS OR ZMasterDirName$ = ZMainFMSDir$ THEN
         CategoryIndex = CategoryIndex + 1
         '* "ALL"
         LineNum = 450
         GOSUB 22763
         ZCategoryName$(CategoryIndex) = Strng$
         ZCategoryCode$(CategoryIndex) = ""
         '* "All files"
         LineNum = 451
         GOSUB 22763
         ZCategoryDesc$(CategoryIndex) = Strng$
      END IF
      CALL FindIt (ZDirCatFile$)
      IF NOT ZOK THEN _
         EXIT SUB
      WHILE NOT EOF(2)
         CALL ReadParms (ZWorkAra$(),3,1)
         IF ZErrCode > 0 THEN
            ZErrCode = 0
            '* "{SP invalid.  Line"
            LineNum = 452
            GOSUB 22763
            Strng1$ = Strng$
            '* "{SPneeds 3 parms"
            LineNum = 453
            GOSUB 22763
            Strng2$ = Strng$
            CALL PScrn (ZDirCatFile$ + Strng1$ + STR$(CategoryIndex) + Strng2$)
            CALL DelayTime (4)
         ELSE
            CategoryIndex = CategoryIndex + 1
            ZCategoryName$(CategoryIndex) = ZWorkAra$(1)
            CALL AraAllCaps (ZCategoryName$(),CategoryIndex)
            ZCategoryCode$(CategoryIndex) = ZWorkAra$(2)
            ZCategoryDesc$(CategoryIndex) = ZWorkAra$(3)
            CatR$ = ZCategoryCode$(CategoryIndex)
            CALL Remove (CatR$,Blank$)
            ZCategoryCode$(CategoryIndex) = CatR$
         END IF
      WEND
      CLOSE 2
      EXIT SUB
22763 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
      END SUB
'
22765 ' $SUBTITLE: 'DispUpDir - sub to display FMS directory'
' $PAGE
'
'  NAME    -- DispUpDir
'
'  INPUTS  -- PARAMETER             MEANING
'             PassedCats$         FILE "CATEGORIES" TO BE INCLUDED IN
'                                 THE SEARCH.
'             SearchString$       STRING TO SEARCH ON WITHIN THE
'                                 FILE "CATEGORIES" SELECTED
'             SearchDate$         DATE EQUAL TO OR GREATER THAN TO BE
'                                 SEARCHED FOR WITH THE "CATEGORIES"
'                                 AND THE STRING TO SEARCH.
'             DnldFlag            SET TO RECORD # OF LINE TO BEGIN
'                                 VIEWING - 0 IF AT END
'
'  OUTPUTS -- DnldFlag            WHENEVER DOWNLOAD REQUESTED, SETS
'                                 TO 1.  OTHERWISE LEAVES AT ZERO
'  PURPOSE -- Display the files that meet the criteria selected in
'             RBBS-PC upload management system on the users screen.
'
      SUB DispUpDir (PassedCats$,SearchString$, _
                    SearchDate$,DnldFlag,AbortIndex) STATIC
      NumDots = 0
      WipedLine = ZTrue
      ListFileCount = 0
      StartHold& = 0
      IF AtEndList THEN _
         AtEndList = ZFalse : _
         IF DnldFlag > 0 THEN _
            GOSUB 22785 : _
            GOTO 22784
      CALL AllCaps (SearchString$)
      Blank$ = SPACE$(1)
      ZStopInterrupts = ZFalse
      Categories$ = CHR$(44) + _                         ',
                    PassedCats$ + _
                    CHR$(44)
      CanDnld = (ZUserSecLevel => ZOptSec(19))
      CanView = (ZUserSecLevel => ZOptSec(26))
      ZJumpSupported = ZTrue
      ZJumpSearching = ZFalse
      GOSUB 22785
      OrigDir$ = ZActiveFMSDir$
      InList = (RelistAt& > 0 AND ReListAt& <= LastRec&)
      IF InList AND DnldFlag > 0 THEN
         ZLinesPrinted = ZPageLength - 1
         UpldIndex& = RelistAt&
         DnldFlag = 0
         GOTO 22779
      END IF
      ZJumpLast$ = ""
      SearchFor$ = SearchString$
      '* ",V)iew"
      LineNum = 1041
      GOSUB 22810
      ExtraPrompt$ = LEFT$(Strng$,6+4*ZExpertUser)
      IF ZPersonalDnld THEN
         '* "*)new"
         LineNum = 1042
         GOSUB 22810
         ExtraPrompt$ = ExtraPrompt$ + Strng$
      END IF
      IF CanDnld THEN
         IF ZExpertUser THEN
            '* ",E,M,D"
            LineNum = 1043
         ELSE
            '* ",E)xtended,M)ark,D)nld"
            LineNum = 1044
         END IF
         GOSUB 22810
         ExtraPrompt$ = ExtraPrompt$ + Strng$
      END IF
      '* "{CCTransfer Time: {C4"
      LineNum = 1055
      GOSUB 22810
      TransferTimeStr$ = Strng$
      '* "{C7:{C4"
      LineNum = 1056
      GOSUB 22810
      TransferTimeSep$ = Strng$
      '* "{CDDownloaded{CE"
      LineNum = 1057
      GOSUB 22810
      DownloadStr1$ = Strng$
      '* "{CD time"
      LineNum = 1058
      GOSUB 22810
      DownloadStr2$ = Strng$
      '* "s"
      LineNum = 1059
      GOSUB 22810
      DownloadStr3$ = Strng$
      MaxPrint = ZPageLength - 3
      BelowMinSec = (ZUserSecLevel < ZMinSecToView)
      ZNonStop = ZNonStop OR (ZPageLength < 1)
      FMSCheckPoint& = 0
      FMSPausePoint = 0
      WildSearch = (INSTR(SearchString$,CHR$(63)) > 0) _      '?
                     OR (INSTR(SearchString$,CHR$(42)) > 0)   '*
      CALL AraAllCaps (ZUserInAra$(),ZAnsIndex)
      IF ZAnsIndex > 0 THEN _
         IF ZLastCommand$ = "FP" AND INSTR("Ll",ZUserInAra$(ZLastIndex)) = 0 THEN _
            ZUserInAra$(ZAnsIndex) = CHR$(68) : _                'D
            IF (UpldIndex& > 0 AND UpldIndex& <= LastRec&) THEN _
               GOTO 22780 _
            ELSE Temp$ = "" : _
                 GOTO 22796
22768 UpldIndex& = UpldIndex& + ZUpInc
      CALL CheckKBStop
      IF ZRet THEN _
         ZLinesPrinted = 999 : _
         GOTO 22778
      IF UpldIndex& = CutoffRec& THEN _
         GOTO 22784
'
' * setup parmaters to format the display of files based of config options
' * serious drain bamage may occur if you look too close!
'
      IF ListFileCount = 0 THEN
         StartHold& = UpldIndex&
         MaxPrint = ZPageLength - 3
         IF NOT ZExtendedOff AND SearchString$ = "" AND _
            PassedCats$ = "" AND _
            LastRec& - FMSCheckPoint& > MaxPrint + 5 THEN
            Offset = 0
            IF ZWasGR > 1 THEN
               Offset = -3 + (-6 * ZDateOrderedFMS)
            END IF
            IF ((NOT ZShowXferTime) OR (NOT ZShowTimesDownloaded)) THEN
               IF (NOT ZDateOrderedFMS) OR ZPersonalDnld THEN
                  GET #2, UpldIndex& + MaxPrint + Offset
               ELSE
                  GET #2, UpldIndex& - MaxPrint + Offset
               END IF
               IF LEFT$(PartToPrint$,1) <> SPACE$(1) THEN
                  IF (NOT ZDateOrderedFMS) OR ZPersonalDnld THEN
                     GET #2,UpldIndex& + MaxPrint + 1 + Offset
                  ELSE
                     GET #2,UpldIndex& - MaxPrint - 1 + Offset
                  END IF
                  IF LEFT$(PartToPrint$,1) = SPACE$(1) THEN
                     MaxPrint = MaxPrint - 1
                  END IF
               ELSE
                  icount = 0
                  DO
                     icount = icount + 1
                     IF (NOT ZDateOrderedFMS) OR ZPersonalDnld THEN
                        GET #2,UpldIndex& + MaxPrint - icount + Offset
                     ELSE
                        GET #2,UpldIndex& - MaxPrint + icount + Offset
                     END IF
                  LOOP UNTIL LEFT$(PartToPrint$,1) <> SPACE$(1) OR _
                             icount >= ZPageLength - 3
                  IF icount >= ZPageLength - 7 THEN
                     MaxPrint = ZPageLength - 7
                  ELSE
                     MaxPrint = Maxprint - icount - 1
                  END IF
               END IF

            ELSE
               lcount = 0
               dcount = 0
               fcount = 0
               IF ((ZDisplayOptions AND 2) = 0 OR ZWasGR < 1) AND _
                  FMSCheckPoint& > 0 THEN
                  Offset = 3
               ELSE
                  Offset = 0
               END IF
               FOR icount = 0 TO MaxPrint - 1 + Offset
                  IF ZDateOrderedFMS THEN
                     GET #2, UpldIndex& - icount
                  ELSE
                     GET #2, UpldIndex& + icount
                  END IF
                  IF lcount + 2 - Offset <= MaxPrint THEN
                     IF LEFT$(PartToPrint$,1) <> SPACE$(1) THEN
                        fcount = fcount + 1
                        lcount = lcount + 2
                     ELSE
                        dcount = dcount + 1
                        lcount = lcount + 1
                     END IF
                  ELSE
                     dcount = dcount + 1
                     jcount = 0
                     DO
                        jcount = jcount + 1
                        dcount = dcount - 1
                        IF ZDateOrderedFMS THEN
                           GET #2, UpldIndex& - icount + jcount
                        ELSE
                           GET #2, UpldIndex& + icount - jcount
                        END IF
                     LOOP UNTIL LEFT$(PartToPrint$,1) <> SPACE$(1) OR _
                                icount + jcount >= ZPageLength - 3
                     EXIT FOR
                  END IF
               NEXT icount
               MaxPrint = fcount * 2 + dcount - Offset
            END IF
         END IF
      END IF
'
      GET #2,UpldIndex&
      FreeTextLine = ZFalse
      FMSCheckPoint& = FMSCheckPoint& + 1
      ON INSTR("\* =",LEFT$(PartToPrint$,1)) GOTO 22768,22771,22770,22769
      FMSPausePoint = FMSPausePoint + 1
      IF SearchString$ <> "" OR PassedCats$ <> "" THEN
         IF NOT WipedLine THEN
            CALL MarkTime (NumDots)
         END IF
         TimeNow! = TIMER
         IF TimeNow! < PrevTI! THEN
            PrevTI! = TIMER
            GOTO 22772
         END IF
         IF TimeNow! - PrevTI! < 0.5 THEN
            GOTO 22772
         END IF
         PrevTI! = TimeNow!
         IF WipedLine THEN
            '* "{CESearching {CF{G1(<Ctrl-X> aborts){RC"
            LineNum = 967
            CRCount = 0
            GOSUB 22820
            WipedLine = ZFalse
            NumDots = 0
         END IF
      END IF
      GOTO 22772
22769 CALL CheckInt (MID$(PartToPrint$,34))
      IF ZUserSecLevel < ZTestedIntValue THEN _
         LastOK = ZFalse : _
         FailedSearch = ZFalse : _
         GOTO 22768
      MID$(PartToPrint$,1,13) = MID$(PartToPrint$,2,12) + SPACE$(1)
      ZWasA = LEN(STR$(ZTestedIntValue))
      MID$(PartToPrint$,34) = MID$(PartToPrint$,34 + ZWasA) + SPACE$(ZWasA)
      GOTO 22772
22770 IF ZExtendedOff THEN _      ' Extended description
         GOTO 22768 _
      ELSE IF LastOK THEN _
         GOTO 22775 _
      ELSE IF ZJumpSearching THEN _
         GOTO 22787 _
      ELSE IF SearchString$ <> "" AND (NOT WildSearch) AND FailedSearch THEN _
         GOTO 22787 _
      ELSE GOTO 22768
22771 IF Category$ = STRING$(3,42) THEN     ' display line
         FreeTextLine = ZTrue
         GOTO 22776
      ELSE
         HoldCat$ = CHR$(44) + Category$ + CHR$(44)      ',
         IF INSTR(Categories$,HoldCat$) > 0 THEN
            FreeTextLine = ZTrue
            GOTO 22776
         ELSE
            GOTO 22768
         END IF
      END IF
22772 LastOK = ZFalse           ' normal file entry display
      FailedSearch = ZFalse
      LastFName& = UpldIndex&
      IF Category$ = STRING$(3,42) THEN _
         IF ZUserSecLevel < ZSysopSecLevel THEN _
            GOTO 22778
      IF Category$ = ZDefaultCatCode$ THEN _
         IF BelowMinSec THEN _
            GOTO 22778
22773 IF LEN(Categories$) > 2 THEN _
         GOSUB 22791 : _
         IF NOT CanGet THEN _
            IF CatLen < 4 OR ZUserSecLevel < ZSysopSecLevel THEN _
               GOTO 22778
      IF ZJumpSearching OR SearchString$ <> "" THEN _
         ZOutTxt$ = PartToPrint$ : _
         IF WildSearch THEN _
            Temp$ = LEFT$(PartToPrint$,INSTR(PartToPrint$,SPACE$(1))-1) : _
            Temp$ = MID$(Temp$,1-(LEFT$(Temp$,1)=CHR$(61))) : _  '=
            CALL WildFile (SearchString$,Temp$,ZOK) : _
            IF ZOK THEN _
               CALL QuickTPut (ZBackSpace$,0) : _
               CALL WipeLine (79) : _
               WipedLine = ZTrue : _
               FoundString$ = SearchString$ : _
               GOTO 22775 _
            ELSE GOTO 22778 _
         ELSE CALL AllCaps (ZOutTxt$) : _
              HiLitePos = INSTR(ZOutTxt$,SearchFor$) : _
              IF HiLitePos = 0 THEN _
                 FailedSearch = ZTrue : _
                 GOTO 22778 _
              ELSE HiLiteRec& = UpldIndex& : _
                   FoundString$ = SearchFor$ : _
                   IF ZJumpSearching THEN _
                      ZJumpSearching = ZFalse : _
                      SearchFor$ = PrevSearch$
22774 IF SearchDate$ <> "" THEN _
         HoldCat$ = MID$(PartToPrint$,30,2) + _
                MID$(PartToPrint$,24,2) + _
                MID$(PartToPrint$,27,2) : _
         IF HoldCat$ < SearchDate$ THEN _
            IF ZDateOrderedFMS THEN _
               GOTO 22784 _
            ELSE GOTO 22768
'
'
' * Allow the FMS to be both fast and interruptable if a local
' * user or there is nothing in the input buffer by using QuickTPut.
'
'
22775 LastOK = ZTrue
22776 ZWasA = EndDesc
      TimeNow! = TIMER
      PrevTI! = TimeNow!
      IF LEFT$(PartToPrint$,5) = SPACE$(5) THEN _
         GOTO 22778
      IF SearchString$ <> "" OR PassedCats$ <> "" THEN
         CALL WipeLine (79)
         WipedLine = ZTrue
      END IF
      IF ZShowTimesDownloaded AND NOT ZPersonalDnld THEN
         ZOutTxt$ = LEFT$(PartToPrint$,LEN(PartToPrint$)-5)
         TimesDL$ = STR$(VAL(RIGHT$(PartToPrint$,5)))
      ELSE
         ZOutTxt$ = PartToPrint$
      END IF
      IF PersonalStatus$ = CHR$(42) AND LEFT$(ZOutTxt$,1) <> SPACE$(1) THEN _
         MID$(ZOutTxt$, INSTR(ZOutTxt$,SPACE$(1))) = CHR$(42)
      ZOutTxt$ = RTRIM$(ZOutTxt$)
      XferTime$ = ""
      IF LEFT$(ZOutTxt$,1) <> SPACE$(1) _
         AND NOT ZNonStop AND NOT FreeTextLine THEN
         ListFileCount = ListFileCount + 1
         IF ListFileCount = 256 THEN
            ListFileCount = 1
         END IF
         ZListFile$(ListFileCount) = RTRIM$(LEFT$(ZOutTxt$,14))
         IF RIGHT$(ZListFile$(ListFileCount),1) = CHR$(42) THEN
            CALL Remove (ZListFile$(ListFileCount),CHR$(42))
         END IF
         IF ListFileCount < 10 THEN
            numstr$ = SPACE$(1) + LTRIM$(STR$(ListFileCount))
         ELSE
            numstr$ = LTRIM$(STR$(ListFileCount))
         END IF
         IF NOT ZNonStop THEN
            ZOutTxt$ = "[" + numstr$ + "] " + ZOutTxt$
         END IF
      END IF
      IF INSTR("\ *",LEFT$(ZOutTxt$,1)) = 0 AND _
         NOT ZExtendedOff AND _
         (ZShowXferTime OR ZShowTimesDownloaded) THEN
         IF NOT ZNonStop THEN
            Description$ = SPACE$(2) + MID$(ZOutTxt$,39,ZMaxDescLen)
            ZOutTxt$ = LEFT$(ZOutTxt$,38)
         ELSE
            Description$ = SPACE$(2) + MID$(ZOutTxt$,34,ZMaxDescLen)
            ZOutTxt$ = LEFT$(ZOutTxt$,33)
         END IF
         FileSize# = VAL(MID$(ZOutTxt$,19,9))
         FLen = ZFlen
         IF FLen < 1 THEN
            FLen = 1024
         END IF
         Blocks# = FIX(FileSize#/Flen)
         Blocks# = Blocks# / _
         VAL(MID$(ZBaudRateVals$, -4 * ZCBPS, 4))
         Speed! = ZSpeedFactor!
         IF Speed! < 1 THEN
            Speed! = 0.95
         END IF
         Blocks# = Blocks# * Flen / Speed!
         mins$ = STR$(INT(Blocks# / 60))
         CALL Trim (mins$)
         IF VAL(mins$) < 10 THEN
            mins$ = "0" + mins$
         END IF
         secs$ = STR$(INT(Blocks# - (INT(Blocks# / 60) * 60)))
         CALL Trim (secs$)
         IF VAL(secs$) < 10 THEN
            secs$ = "0" + secs$
         END IF
         IF ZShowXferTime THEN
            IF INSTR("DELETEDOFFLINE",MID$(ZOutTxt$,20,7)) THEN
               '* "N/A"
               LineNum = 1141
               GOSUB 22810
               XferTime$ = TransferTimeStr$ + Strng$
            ELSE
               XFerTime$ = TransferTimeStr$ + mins$ + _
                           TransferTimeSep$ + Secs$
            END IF
            XferTime$ = XferTime$ + SPACE$(1)
         END IF
         IF ZShowTimesDownloaded AND NOT ZPersonalDnld THEN
            XferTime$ = XferTime$ + _
                        DownloadStr1$ + _
                        TimesDL$ + _
                        DownloadStr2$
            IF VAL(TimesDL$) <> 1 THEN
               XferTime$ = XferTime$ + DownloadStr3$
            END IF
         END IF
         XferTime$ = XferTime$ + ZEmphasizeOff$
      ELSE
         XferTime$ = ""
      END IF
      IF LEFT$(ZOutTxt$,1) = "[" OR _
         (LEFT$(ZOutTxt$,1) = "*" AND NOT FreeTextLine) THEN
         FileSize# = VAL(MID$(ZOutTxt$,19,8))
         IF FileSize# > 999 THEN
            WasK# = CDBL(FileSize# / 1000!)
            IF WasK# > 9999 THEN
               WasK# = 9999
            END IF
            FileSizeK$ = STR$(WasK#)
            IF INSTR(FileSizeK$,CHR$(46)) <> 0 THEN
               FileSizeK$ = LEFT$(FileSizeK$,INSTR(FileSizeK$,CHR$(46)) - 1)
            END IF
            FileSizeK$ = FileSizeK$ + CHR$(75)

            IF LEN(FileSizeK$) < 6 THEN
               FileSizeK$ = SPACE$(6-LEN(FileSizeK$)) + FileSizeK$
            END IF
            ZOutTxt$ = LEFT$(ZOutTxt$,17) + _
                       FileSizeK$ + _
                       SPACE$(1) + _
                       MID$(ZOutTxt$,29,10+ZMaxDescLen)
         ELSE
            IF INSTR("DELETEDOFFLINE",MID$(ZOutTxt$,20,7)) THEN
               ZOutTxt$ = LEFT$(ZOutTxt$,17) + _
                          MID$(ZOutTxt$,20,7) + _
                          SPACE$(1) + _
                          MID$(ZOutTxt$,29,10+ZMaxDescLen)
            ELSE
               ZOutTxt$ = LEFT$(ZOutTxt$,17) + _
                          SPACE$(3) + _
                          MID$(ZOutTxt$,24,3) + _
                          SPACE$(1) + _
                          MID$(ZOutTxt$,29,10+ZMaxDescLen)
            END IF
         END IF
      END IF
      CALL ColorDir (ZOutTxt$,CHR$(89))    'Y
      CALL CheckColor (ZOutTxt$,FoundString$,"")
      CALL CheckColor (Description$,FoundString$,ZDR4$)
      IF ZLocalUser THEN
         IF XferTime$ <> "" THEN
            CALL QuickTPut1 (ZOutTxt$ + XferTime$)
            CALL QuickTPut1 (ZDR4$ + Description$ + ZEmphasizeOff$)
         ELSE
            CALL QuickTPut1 (ZOutTxt$)
         END IF
         GOTO 22778
      END IF
      CALL EofComm (Char)
      IF Char = -1 THEN
         IF XferTime$ <> "" THEN
            CALL QuickTPut1 (ZOutTxt$ + XferTime$)
            CALL QuickTPut1 (ZDR4$ + Description$ + ZEmphasizeOff$)
         ELSE
            CALL QuickTPut1 (ZOutTxt$)
         END IF
      ELSE
         ZSubParm = 5
         CALL TPut
         IF ZRet THEN
            GOTO 22798
         END IF
      END IF
22778 IF ZFMSBreakPoint = 0 AND ZLinesPrinted <= MaxPrint OR _
         ZLinesPrinted <= MaxPrint AND (ZFMSBreakPoint > 0 AND (FMSPausePoint MOD ZFMSBreakPoint <> 0)) THEN _
         GOTO 22768
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         GOTO 22798
      CALL TimeRemain (MinsRemaining)
      IF MinsRemaining <= 0 THEN _
         ZSubParm = -1 : _
         GOTO 22798
      IF ZNonStop THEN _
         GOTO 22768
      IF ZLinesPrinted <= MaxPrint THEN
         ZLinesPrinted = ZPageLength - 1
         IF ZDateOrderedFMS THEN
            WipedLine = ZTrue
             CALL WipeLine (79)
             CALL SkipLine (1)
            '* "{CBFiles checked thru {C9"
            LineNum = 1045
            GOSUB 22810
            CALL QuickTPut1 (Strng$ + MID$(PartToPrint$,24,8) + ZEmphasizeOff$)
         ELSE
            '* "{C2"
            LineNum = 1046
            GOSUB 22810
            Strng1$ = Strng$
            '* "{CA files checked{RC"
            LineNum = 1047
            GOSUB 22810
            Strng2$ = Strng$
            CALL QuickTPut1 (Strng1$ + STR$(FMSPausePoint) + Strng2$)
         END IF
      END IF
22779 InList = (UpldIndex& > 0 AND UpldIndex& <= LastRec&)
22780 WasX$ = ZUserInAra$(ZAnsIndex)
      CALL AllCaps (WasX$)
      IF InList AND (ZAnsIndex >= ZLastIndex OR WasX$ <> CHR$(68)) THEN
         ZTurboKey = -ZTurboKeyUser
         ZStackC = ZTrue
         IF SearchString$ <> "" OR PassedCats$ <> "" THEN
            WipedLine = ZTrue
            CALL WipeLine (79)
         END IF
         CALL SkipLine (ZPageLength-ZLinesPrinted)
         HoldLine = ZLinesPrinted
         CALL Line25
         CALL AskMore (ExtraPrompt$, ZTrue, ZFalse,AbortIndex,ZFalse)
         FOR icount = ListFileCount + 1 TO 255
            ZListFile$(icount) = STR$(icount)
         NEXT icount
         ListFileCount = 0
         IF ZSubParm = -1 THEN
            EXIT SUB
         ELSE
            ZLastIndex = ZWasQ
            IF NOT ZNo THEN
               ZAnsIndex = 1
            END IF
         END IF
      END IF
      IF ZSubParm = -1 THEN _
         GOTO 22798
      IF ZNo THEN _
         ZLastIndex = 0 : _
         GOTO 22798
      WasX$ = ZUserInAra$(ZAnsIndex)
      CALL AllCaps (WasX$)
      IF WasX$ = CHR$(86) THEN IF CanView THEN _          'V
         CALL GetArc (ZFalse) : _
         ZJumpSupported = ZTrue : _
         HoldIndex& = UpldIndex& : _
         GOSUB 22785 : _
         UpldIndex& = HoldIndex& : _
         ZLinesPrinted = ZPageLength : _
         GOTO 22780
      IF WasX$ = CHR$(69) THEN                            'E
         ZExtendedOff=NOT ZExtendedOff
         IF ZWasGR < 2 AND _
         (ZDisplayOptions AND 2) = 0 THEN
            '* "{CEExtended directory display {CB"
            LineNum = 454
            GOSUB 22810
            CALL QuickTPut1(Strng$ + _
                            FNOffOn$(NOT ZExtendedOff) + ZEmphasizeOff$)
         END IF
         UpldIndex& = StartHold& - (1 * ZDateOrderedFMS)
         IF NOT ZDateOrderedFMS THEN
            UpldIndex& = UpldIndex& - 1
         END IF
         GOSUB 22800
         GOTO 22768
      END IF
22781 MarkingFiles = ZFalse
      IF ((WasX$ = CHR$(68) OR WasX$ = CHR$(77)) AND CanDnld) OR (WasX$ = CHR$(86) AND CanView) THEN
         MarkingFiles = (WasX$ = CHR$(77))                'M
         AtEndList = ZFalse
         HoldMarkLen = LEN(ZMarkedFiles$)
         '* "file"
         LineNum = 1025
         GOSUB 22810
         CALL AskItems ("DMV",WasX$,ZTrue,Strng$,ZMarkedFiles$)
         IF LEN(ZMarkedFiles$) > ZHoldMarkLen THEN
            UpldIndex& = StartHold& - (1 * ZDateOrderedFMS)
            IF NOT ZDateOrderedFMS THEN
               UpldIndex& = UpldIndex& - 1
            END IF
         END IF
         IF ZWasQ = 0 THEN
            GOTO 22783
         END IF
      END IF
      IF WasX$ = CHR$(42) THEN IF ZPersonalDnld THEN _    '*
         GOTO 22793
      CALL CheckInt (ZUserInAra$(ZAnsIndex))
      IF ZTestedIntValue AND INSTR(ZUserInAra$(ZAnsIndex),CHR$(46)) = 0 THEN
         ZUserInAra$(ZAnsIndex) = ZListFile$(ZTestedIntValue)
      END IF
22783 IF ZJumpSearching THEN _
         PrevSearch$ = SearchFor$ : _
         SearchFor$ = ZJumpTo$ _
      ELSE SearchFor$ = SearchString$ : _
           IF NOT ZYes AND CanDnld THEN _
              GOSUB 22788 : _
              IF WasX$ = CHR$(86) AND CanView AND ZLastIndex >= ZAnsIndex THEN _
                 ZAnsIndex = ZAnsIndex - 1 : _
                 CALL GetArc (ZFalse) : _
                 ZJumpSupported = ZTrue : _
                 ZWasA = UpldIndex& : _
                 GOSUB 22785 : _
                 UpldIndex& = ZWasA : _
                 GOTO 22780 _
              ELSE IF WasX$ <> CHR$(76) AND ZLastIndex >= ZAnsIndex AND _
                   NOT MarkingFiles AND NOT AtEndList THEN _
                 CALL SkipLine (1) : _
                 DnldFlag = 1 : _
                 ReListAt& = UpldIndex& : _
                 EXIT SUB _      ' exit for downloading
              ELSE IF UpldIndex& = CutoffRec& THEN _
                      GOTO 22784
      IF ZNonStop AND UpldIndex& > 999 THEN
         IF (SearchDate$ = "" OR NOT ZExpertUser) THEN
            NumStr$ = STR$(UpldIndex&)
            '* "{SPlines left to search.  Really go non-stop? (Y,[N])"
            LineNum = 455
            GOSUB 22810
            ZOutTxt$ = NumStr$ + Strng$
            ZNoAdvance = ZTrue
            ZTurboKey = -ZTurboKeyUser
            ZSubParm = 1
            CALL TGet
            CALL WipeLine (79)
            ZNonStop = ZYes
         END IF
      END IF
      GOSUB 22800
      GOTO 22768
22784 IF ZChainedDir$ <> "" THEN _
         ZActiveFMSDir$ = ZChainedDir$ : _
         GOSUB 22785 : _
         LastFName& = 0 : _
         GOTO 22768
      IF ZNo THEN _
         GOTO 22798
      '* "{CR{C2-{C3={CEEnd list{C3={C2-{RC{CR"
      LineNum = 456
      GOSUB 22810
      Temp$ = Strng$
      FOR icount = ListFileCount + 1 TO 255
         ZListFile$(icount) = STR$(icount)
      NEXT icount
      ListFileCount = 0
      AtEndList = ZTrue
      UpldIndex& = CutOffRec& - ZUpInc
      ZLastIndex = 0
      GOTO 22796
22785 IF PassedCats$ = CHR$(80) THEN                        'P
         ZActiveFMSDir$ = ZPersonalDir$
         ZFMSHeaderDisplay$ = "P"
      END IF
      CALL OpenFMS (UpldIndex&,CatLen)
      LastRec& = UpldIndex&
      EndDesc = 33 + ZMaxDescLen
      IF ZPersonalDnld THEN
         EndDesc = EndDesc + (5 * ZShowTimesDownloaded)
      END IF
      IF CatLen > 3 THEN
         Categories$ = ZActiveUserName$
         CALL Trim (Categories$)
         '* "SYSOP"
         LineNum = 131
         GOSUB 22810
         Categories$ = CHR$(44) + Categories$ + CHR$(44) + _
                       LEFT$("," + Strng$ + ",",-7*ZSysOp)
         CanDnld = ZTrue
         StatLen = 1
      ELSE
         StatLen = 0
      END IF
      FIELD 2, EndDesc AS PartToPrint$, _
               CatLen AS Category$, _
               StatLen AS PersonalStatus$, _
               2 AS Filler$
      PrevFMS$ = ZActiveFMSDir$
22786 IF ZUpInc = -1 THEN _
         CutoffRec& = 0 : _
         UpldIndex& = LastRec& + 1 _
      ELSE CutoffRec& = LastRec& + 1 : _
           UpldIndex& = 0
      RETURN
22787 ZOutTxt$ = PartToPrint$
      CALL AllCaps (ZOutTxt$)
      HiLitePos = INSTR(ZOutTxt$,SearchFor$)
      IF HiLitePos < 1 THEN _
         GOTO 22768
      HiLiteRec& = UpldIndex&
      IF LastFName& > 0 THEN _
         UpldIndex& = LastFName&
      GET 2,UpldIndex&
      FoundString$ = SearchFor$
      IF ZJumpSearching THEN _
         SearchFor$ = PrevSearch$
      GOTO 22775
22788 IF ProcessedNew OR MarkingFiles OR NOT ZListOnly THEN _
         ProcessedNew = ZFalse : _
         RETURN
      ZUserInAra$(0) = ""
      WasI = ZAnsIndex              ' check whether in dir
      WHILE WasI <= ZLastIndex
         CALL AraAllCaps (ZUserInAra$(),WasI)
         ZWasZ$ = ZUserInAra$(WasI)
         CALL UnMarkItems (ZMarkedFiles$,WasI,ZLastIndex,WasX,ZTrue)
         Temp$ = ZUserInAra$(WasI)
         CALL AllCaps (Temp$)
         IsProto = (LEN(Temp$) = 1 AND _
                    INSTR(ZDefaultXfer$,Temp$) > 0)
         ZOK = IsProto
         WasJ& = LastRec& + 1
         WasX = INSTR(Temp$,CHR$(46))
         AltTemp$ = ""
         IF NOT IsProto THEN _
            IF WasX = 0 THEN _
               AltTemp$ = Temp$ + CHR$(46) + ZDefaultExtension$ _
            ELSE IF WasX = LEN(Temp$) THEN _
                    AltTemp$ = LEFT$(Temp$,WasX-1)
         WHILE WasJ& > 1 AND NOT ZOK
            WasJ& = WasJ& - 1
            GET #2,WasJ&
            GOSUB 22791
            IF CanGet THEN _
               MID$(PartToPrint$,13,1) = SPACE$(1) : _
               ZWasY$ = LEFT$(PartToPrint$,INSTR(PartToPrint$,SPACE$(1)) - 1) : _
               ZOK = (Temp$ = ZWasY$) : _
               IF NOT ZOK THEN _
                  IF AltTemp$ <> "" THEN _
                     ZOK = (AltTemp$ = ZWasY$)
         WEND
         IF ZOK THEN _
            GOSUB 22789 : _
            IF ZOK OR IsProto THEN _
               ZWasY$ = MID$(STR$(WasJ&),2) : _
               ZUserInAra$(0) = ZUserInAra$(0) + _
                       ZWasY$ + _
                       SPACE$(5 - LEN(ZWasY$))
         IF NOT ZOK AND NOT IsProto THEN
            '* "{ZZ not found - omitted"
            LineNum = 457
            CRCount = 1
            GOSUB 22820
            FOR WasK = WasI + 1 TO ZLastIndex
               ZUserInAra$(WasK - 1) = ZUserInAra$(WasK)
            NEXT
            ZLastIndex = ZLastIndex - 1
            WasI = WasI - 1
         END IF
         WasI = WasI + 1
      WEND
      ZWasQ = ZLastIndex
      RETURN
22789 IF IsProto THEN _
         RETURN
      ZUserInAra$(WasI) = LEFT$(PartToPrint$,INSTR(PartToPrint$,SPACE$(1)) - 1)
      CALL FindFile (ZPersonalDrvPath$ + ZUserInAra$(WasI),ZOK)
      IF ZOK THEN _
         ZUserInAra$(WasI) = ZPersonalDrvPath$ + ZUserInAra$(WasI) _
      ELSE CALL RotorsDir (ZUserInAra$(WasI),ZSubDir$(),ZSubDirCount + _
                      ((ZUserSecLevel < ZMinSecToView) OR _
                       NOT ZCanDnldFromUp),ZTrue,CHR$(68)) : _
           GOSUB 22785
      RETURN
22791 IF LEN(Categories$) < 3 THEN _
         CanGet = ZTrue : _
         RETURN
      HoldCat$ = RTRIM$(Category$)
      CALL AllCaps (HoldCat$)
      HoldCat$ = CHR$(44) + HoldCat$ + CHR$(44)
      CanGet = (INSTR(Categories$,HoldCat$) > 0)
      IF NOT CanGet THEN _
         IF ZPersonalDnld AND ZUserSecLevel >= ZSysopSecLevel THEN _
            CanGet = ZTrue
      IF NOT CanGet THEN _
         IF ASC(Category$) = 32 THEN _
            IF LEN(HoldCat$) > 2 THEN _
               CALL CheckInt (Category$) : _
               CanGet = (ZUserSecLevel >= ZTestedIntValue)
      RETURN
22793 GOSUB 22785                ' handle new files
      PersIndex& = LastRec&
      ProcessedNew = ZTrue
      ZLastIndex = 0
      ZUserInAra$(0) = ""
      WHILE PersIndex& > 0 AND ZLastIndex < UBOUND(ZUserInAra$)
         GET 2,PersIndex&
         GOSUB 22791
         IF NOT CanGet THEN _
            GOTO 22794
         IF PersonalStatus$ <> CHR$(42) THEN _           '*
            GOTO 22794
         ZLastIndex = ZLastIndex + 1
         WasI = ZLastIndex
         GOSUB 22789
         IF ZOK THEN _
            WasX$ = MID$(STR$(PersIndex&),2) : _
            ZUserInAra$(0) = ZUserInAra$(0) + _
                    WasX$ + _
                    SPACE$(5 - LEN(WasX$)) _
         ELSE ZLastIndex = ZLastIndex - 1
22794    PersIndex& = PersIndex& - 1
      WEND
      IF ZLastIndex = 0 THEN
         '* "No new files for you"
         CALL FormatString (458,ZFalse,ZFalse,0,ZTrue,1,ZOutTxt$)
         GOTO 22783
      END IF
      ZAnsIndex = 1
      GOTO 22783
22796 IF SearchString$ <> "" OR PassedCats$ <> "" THEN
         CALL WipeLine (79)
      END IF
      CALL QuickTPut (ZEmphasizeOff$,0)
      '* "L)ist,A)bort,"
      LineNum = 1048
      GOSUB 22810
      Strng1$ = Strng$
      '* "*)new"
      LineNum = 1042
      GOSUB 22810
      Strng2$ = Strng$
      '* ",M)ark"
      LineNum = 1049
      GOSUB 22810
      Strng3$ = Strng$
      '* ",D)nld"
      LineNum = 1050
      GOSUB 22810
      Strng4$ = Strng$
      '* ",V)iew"
      LineNum = 1041
      GOSUB 22810
      Strng5$ = Strng$
      '* ",E)xtended,H)elp"
      LineNum = 1051
      GOSUB 22810
      Strng6$ = Strng$
      ZOutTxt$ = Temp$ + Strng1$ + _
                 LEFT$(Strng2$,-6*ZPersonalDnld) + _
                 Strng3$ + LEFT$(Strng4$,-6*CanDnld) + _
                  LEFT$(Strng5$,-6*CanView) + _
                  Strng6$ + _
                  ZEmphasizeOff$ + _
                  ZPressEnterExpert$
      ZTurboKey = -ZTurboKeyUser
      IF ZDnldCompleted and ZAutoEnd = 1 THEN _
         ZNonStop = ZTrue : _
         ZStopInterrupts = ZTrue : _
         ZAutoLogOffReq = ZTrue : _
         GOTO 22799
      CALL PopCmdStack
      WasX$ = ZUserInAra$(ZAnsIndex)
      CALL AllCaps (WasX$)
      IF WasX$ = CHR$(65) THEN _                            'A
         ZLastIndex = 0 : _
         ZRet = ZTrue
      IF ZWasQ = 0 OR ZRet OR ZSubParm < 0 THEN _
         GOTO 22798
      IF WasX$ = CHR$(69) THEN                              'E
         ZExtendedOff = NOT ZExtendedOff
         GOTO 22796
      END IF
      IF WasX$ = CHR$(76) THEN                              'L
         IF ZPersonalDnld AND ZWasGR = 4 THEN
            CALL BufFile (ZWelcomeFileDrvPath$ + "RIPWINF.RIP",WasX)
         END IF
         GOSUB 22800
         ZActiveFMSDir$ = OrigDir$
         GOSUB 22785
         AtEndList = ZFalse
         GOTO 22768
      END IF
      IF WasX$ = "H" THEN
         IF ZPersonalDnld THEN
            temp$ = "FP"
         ELSE
            temp$ = "FILE"
         END IF
         CALL BufFile (ZHelpPath$ + temp$ + ZHelpExtension$,WasX) : _
         ZLastIndex = 0 : _
         GOSUB 22785 : _
         ZYes = ZFalse : _
         GOTO 22796
      END IF
      IF WasX$ = CHR$(86) THEN IF CanView THEN _            'V
         CALL GetArc (ZFalse) : _
         ZJumpSupported = ZTrue : _
         HoldIndex& = UpldIndex& : _
         GOSUB 22785 : _
         UpldIndex& = HoldIndex& : _
         GOTO 22780
      ZYes = ZFalse
      GOTO 22781
22798 CLOSE 2
      ZNonStop = (ZPageLength < 1)
      ZStopInterrupts = ZFalse
22799 ZOutTxt$ = ""
      ZActiveFMSDir$ = ""
      FoundString$ = ""
      ZJumpSupported = ZFalse
      DnldFlag = 0
      EXIT SUB
22800 IF (ZWasGR > 1) AND _
         (ZDisplayOptions AND 2) > 0 THEN
         CALL QuickTPut (ZEscape$ + "[2J",0)
         WipedLine = ZTrue
         CALL FMS (ZFMSHeaderDisplay$,SearchString$,SearchDate$,InFMS, _
                   ZCategoryName$(),ZCategoryCode$(),ZCategoryDesc$(),_
                   DnldFlag,CatFound,ZAnsIndex,ZTrue)
         CALL Line25
      END IF
      RETURN
22810 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
22820 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,CRCount,"")
      RETURN
      END SUB
'
22900 ' $SUBTITLE: 'FMS - subroutine to search the upload management system'
' $PAGE
'
'  NAME    -- FMS
'
'  INPUTS  -- PARAMETER                      MEANING
'             DirToSearch$          RBBS-PC "DIR" CATEGORY TO LOOK
'                                     FOR
'             SearchString$          STRING TO SEARCH FOR
'             SearchDate$            DATE TO SEARCH FOR
'             ZCategoryName$()
'             ZCategoryCode$()
'             ZCategoryDesc$()
'             CatFound
'             ZNumCategories
'
'  OUTPUTS -- ProcessedInFMS
'             DnldFlag
'
'  PURPOSE -- To search the file management system and display the
'             files being searched for as well as the catetory descriptions
'
      SUB FMS (DirToSearch$,SearchString$,SearchDate$, _
               ProcessedInFMS,ZCategoryName$(1),ZCategoryCode$(1), _
               ZCategoryDesc$(1),DnldFlag,CatFound,AbortIndex,DisplayOnly) STATIC
      IF DirToSearch$ = "P" THEN
         IF NOT ZExpertUser AND NOT DisplayOnly THEN
            FileName$ = ZWelcomeFileDrvPath$ + "P.MNU"
            CALL GraphicDisplayFile (FileName$)
            CALL SmartPause (ZFalse)
         END IF
      END IF
      DnldFlag = 0
      CALL SearchArray (DirToSearch$,ZCategoryName$(),ZNumCategories,CatFound)
      ProcessedInFMS = ProcessedInFMS OR (CatFound > 0)
      IF ZCategoryDesc$(CatFound) = "" THEN
         MidStr$ = ZCategoryDesc$(2)
      ELSE
         MidStr$ = ZCategoryDesc$(CatFound)
      END IF
      IF ZWasGR > 0 THEN
         horzline$ = CHR$(205)
         vertline$ = CHR$(186)
         topleft$ = CHR$(201)
         topright$ = CHR$(187)
         bottomleft$ = CHR$(200)
         bottomright$ = CHR$(188)
         endpiece$ = CHR$(175)
      ELSE
         horzline$ = CHR$(061)
         vertline$ = CHR$(124)
         topleft$ = CHR$(061)
         topright$ = CHR$(061)
         bottomleft$ = CHR$(061)
         bottomright$ = CHR$(061)
         endpiece$ = CHR$(062)
      END IF
      IF ProcessedInFMS OR DisplayOnly THEN
         IF (NOT DisplayOnly) AND ZWasGR = 4 THEN
            CALL BufFile (ZWelcomeFileDrvPath$ + "RIPWINF.RIP",WasX)
         END IF
         ZSubParm = 5
         GOSUB 22902
         CALL QuickTPut(ZFG9$ + topleft$ + horzline$ + ZFGF$ + _
                        ZBG4$ + SPACE$(1) + _
                        DirToSearch$ + SPACE$(1) + ZFG9$ + ZBG0$ + _
                        STRING$(3,horzline$),0)
         CALL QuickTPut(ZFGF$ + ZBG4$ + SPACE$(1) + _
                        MidStr$ + SPACE$(1) + _
                        ZFG9$ + ZBG0$ + STRING$(4,horzline$) + _
                        ZFGC$ + endpiece$ + _
                        SPACE$(1) + SrchDir$,1)
         CALL QuickTPut(ZFG9$ + vertline$,1)
         CALL QuickTPut(bottomleft$ + STRING$(-3*(NOT ZNonStop)+1,horzline$) + ZFGF$ + _
                        ZBG1$ + " File Name " + _
                        ZFG9$ + ZBG0$ + STRING$(-1*(ZNonStop)+1,horzline$) + _
                        ZFGF$ + ZBG1$ + " Size " + _
                        ZFG9$ + ZBG0$ + STRING$(-1*(ZNonStop)+2,horzline$),0)
         IF (ZShowXferTime OR ZShowTimesDownloaded) AND _
            NOT ZExtendedOff THEN
            tempstr$ = " Info "
         ELSE
            tempstr$ = " Description "
         END IF
         IF ZShowTimesDownloaded THEN
            templen = 0
         ELSE
            templen = 7
         END IF
         CALL QuickTPut1 (ZFGF$ + ZBG1$ + " Date " + ZFG9$ + _
                        ZBG0$ + STRING$(16+3*(NOT ZNonStop),horzline$) + _
                        ZFGF$ + ZBG1$ + _
                        tempstr$ + _
                        ZFG9$ + ZBG0$ + _
                        STRING$(ZMaxDescLen-LEN(tempstr$)-19+templen,horzline$) + _
                        ZFGC$ + endpiece$ + _
                        ZEmphasizeOff$)
         IF NOT DisplayOnly THEN
            Cat$ = ZCategoryCode$(CatFound)
            CALL DispUpDir (Cat$,SearchString$,SearchDate$,DnldFlag,AbortIndex)
         END IF
      END IF
      EXIT SUB
22902 ZOutTxt$ = SearchDate$
      IF LEN(ZOutTxt$) > 0 THEN _
         ZOutTxt$ = MID$(ZOutTxt$,3) + LEFT$(ZOutTxt$,2)
      SrchDir$ = SearchString$ + _
             ZOutTxt$
      IF SrchDir$ <> "" THEN
         '* "{CEScanning for {CE"
         CALL FormatString (490,ZFalse,ZFalse,0,ZFalse,0,Strng$)
         SrchDir$ = Strng$ + SrchDir$
      END IF
      RETURN
      END SUB
'
23000 ' $SUBTITLE: 'RotorsDir - search thru a list of subdirs for a file'
' $PAGE
'
'  NAME    -- RotorsDir
'
'  INPUTS  --     PARAMETER                    MEANING
'             FilName$                  FILE NAME TO LOOK FOR
'             SDIR.ARA                  ARRAY OF SUBDIRECTORIES
'             MaxSearch                 MAX # OF SUBDIRECTORIES
'             MarkingTime               WHETHER TO MARK TIME
'
'  OUTPUTS -- FNAME$                    ADD SUBDIRECTORY TO THE
'                                       FILE NAME IF FOUND.  OTHER-
'                                       WISE DON'T.
'             ZOK                       TRUE IF FILE WAS Found
'
'  PURPOSE -- Hunt through a list of subdirectories to determine
'             if a file is in any of them.  If file is found, open
'             the file as file #2, add the drive/path to the file
'             name, and sets ZOK to true.  If file isn't found, set
'             file name to the last subdirectory searched -- which
'             should be the upload subdirectory.
'
      SUB RotorsDir (FilName$,SDirAra$(1),MaxSearch,MarkingTime,PassToMacro$) STATIC
      CALL CheckCarrier
      IF ZSubParm = -1 THEN
         EXIT SUB
      END IF
      ZOK = ZFalse
      IF MarkingTime THEN
         '* "{CBSearching for{SP{C2"
         CALL FormatString (491,ZFalse,ZFalse,0,ZFalse,0,Strng$)
         CALL QuickTPut (Strng$ + FilName$ + SPACE$(13-LEN(FilName$)) + ZEmphasizeOff$,0)
      END IF
      IF ZPersonalDnld THEN
         ZFreeDnld = ZTrue
         MaxSearch = MaxSearch + 1
         SDirAra$(MaxSearch) = ZPersonalDrvPath$
      END IF
      NumSearch = 1
      WasX$ = ZArkViewPath$ + FilName$
      CALL FindFile (WasX$,ZOK)
      IF ZOK THEN
         GOTO 23010
      END IF
      WHILE (NOT ZOK) AND NumSearch <= MaxSearch AND SDirAra$(NumSearch) <> ""
         WasX$ = SDirAra$(NumSearch) + FilName$
         CALL FindFile (WasX$,ZOK)
         NumSearch = NumSearch + 1
      WEND
      IF ZOK OR NOT ZFastFileSearch THEN
         GOTO 23010
      END IF
      TFastFileList$ = ZFastFileList$
      TFastFileLocator$ = ZFastFileLocator$
      TFastTabs$ = ZFastTabs$
      Tptr = 1
      CALL BreakFileName (ZFastFileList$, Drive$,TWasX$,ZWasY$,ZTrue)
      TIdxLst$ = Drive$ + TWasX$ + ".LST"
      CALL FindIt (TIdxLst$)
      IF NOT ZOK THEN
         TIdxLst$ = ""
      ELSE
         GOTO 23003
      END IF
23002 CALL SetFIDXLEN (TFastFileList$)
      CALL OpenRSeq (2,TFastFileList$,HighRec&,WasX,ZFIDXLEN)
      FIELD #2, 12 AS SearchFile$, _
                 4 AS SearchPath$, _
       ZFIDXRFMLEN AS SearchDate$, _
     ZFIDXCDROMLEN AS SearchOnCD$, _
                 2 AS SearchCrLf$
      IF ZErrCode <> 0 THEN
         ZOK = ZFalse
         GOTO 23010
      END IF
      CALL TrimTrail (FilName$,CHR$(46))
      CALL BinSearch (2,FilName$,1,12,ZFIDXLEN,HighRec&,RecFoundAt&,RecFound$)
      ZOK = (RecFoundAt& > 0)
      ZFastTabs$ = TFastTabs$
      IF ZOK THEN
         GOTO 23004
      END IF
23003 IF TIdxLst$ = "" THEN
         GOTO 23010
      END IF
      CALL OpenWork(2,TIdxLst$)
      IF ZErrCode <> 0 THEN
         ZOK = ZFalse
         GOTO 23010
      END IF
      CALL ReadParmsX(2,ZOutTxtAra$(),4,TPtr)
      IF ZErrCode <> 0 OR ZOutTxtAra$(1) = "" OR ZOutTxtAra$(2) = "" THEN
         ZOK = ZFalse
         GOTO 23010
      END IF
      TPtr = TPtr + 1
      CALL FindFile (ZOutTxtAra$(1),Found)
      IF NOT Found THEN
         ZOK = ZFalse
         GOTO 23003
      END IF
      CALL FindFile (ZOutTxtAra$(2),Found)
      IF NOT Found THEN
         ZOK = ZFalse
         GOTO 23003
      END IF
      TFastFileList$ = ZOutTxtAra$(1)
      TFastFileLocator$ = ZOutTxtAra$(2)
      CALL BreakFileName (TFastFileList$,Drive$,TWasX$,ZWasY$,ZTrue)
      TFN$ = Drive$ + TWasX$ + CHR$(84) + ZWasY$
      CALL FindIt (TFN$)
      IF ZOK THEN
         CALL OpenRSeq (2,TFN$, TWasX&, WasY, 72)
         FIELD 2, 72 AS IndexRec$
         GET 2, 1
         ZFastTabs$ = IndexRec$
         CLOSE 2
      ELSE
         ZFastTabs$ = ""
      END IF
      GOTO 23002
23004 ZOK = ZFalse
      CALL CheckInt (MID$(RecFound$,13,4))
      IF ZTestedIntValue < 1 THEN
         GOTO 23010
      END IF
      IF ZFIDXRFMLEN THEN
         WasDX$ = DATE$
         LSET SearchDate$ = CHR$ (VAL (MID$ (WasDX$, 9, 2)) - 48) + _
                            CHR$ (VAL (MID$ (WasDX$, 1, 2)) + 31) + _
                            CHR$ (VAL (MID$ (WasDX$, 4, 2)) + 31)
      END IF
      PUT 2, RecFoundAt&
      IF ZFIDXCDROMLEN AND (PassToMacro$ = CHR$(68) OR PassToMacro$ = CHR$(86)) AND SearchOnCD$ = CHR$(84) THEN
         OnCD = ZTrue
      ELSE
         OnCD = ZFalse
      END IF
      CALL OpenRSeq (2,TFastFileLocator$,HighRec&,WasX,66)
      IF ZErrCode <> 0 OR ZTestedIntValue > HighRec& THEN
         GOTO 23010
      END IF
      FIELD 2, 66 AS LocatorRec$
      GET 2, ZTestedIntValue
      Temp$ = WasX$
      WasX$ = LEFT$(LocatorRec$,63)
      CALL Trim (WasX$)
      IF LEFT$(WasX$,2) = "M!" THEN
         ZOK = ZFalse
         ZGSRAra$(1) = PassToMacro$
         WasX$ = RIGHT$(WasX$,LEN(WasX$)-2)
         CALL Trim (WasX$)
         ZFileLocation$ = ""
         CALL MacroExe (WasX$)
         IF ZFileLocation$ = "" THEN
            ZOK = ZFalse
            WasX$ = Temp$
            GOTO 23010
         ELSE
            WasX$ = ZFileLocation$
         END IF
      END IF
      WasX$ = WasX$ + FilName$
      CALL FindFile (WasX$,ZOK)
      IF NOT ZOK THEN
         WasX$ = SDirAra$(MaxSearch) + FilName$
      END IF
23010 FilName$ = WasX$
'
' *** Copy File From CDROM to ZArkViewPath
'
      IF ZOK AND OnCD THEN
         CALL BreakFileName (FilName$,Drive$,Body$,Ext$,ZTrue)
         CALL FindFile (ZArkViewPath$ + Body$ + Ext$, Found)
         IF NOT Found THEN
            '* "CE Copying File From CD-ROM to Hard Drive, please wait{RC"
            CALL FormatString (1138,ZFalse,ZFalse,0,ZTrue,0,"")
            CALL CopyFile (FilName$,ZArkViewPath$ + Body$ + Ext$, ErrCode)
         END IF
         IF Found OR ErrCode = 0 THEN
            FilName$ = ZArkViewPath$ + Body$ + Ext$
         END IF
      END IF
23011 CALL SkipLine (-MarkingTime)
      END SUB
'
23095 ' $SUBTITLE: 'GetDirs -- Prompt for directories to search'
' $PAGE
'
'  NAME    -- GetDirs
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZDirPrompt$             BASE OF DIRECTORY PROMPT
'                 ShowHelp               Whether to display help
'                                            on entry
'  OUTPUTS --     ZUserIn$
'                 ZWasQ
'
'  PURPOSE -- Prompt for directories to search
'
      SUB GetDirs (ShowHelp) STATIC
      IF ShowHelp AND (ZAnsIndex >= ZLastIndex ) THEN _
         GOTO 23102
23100 IF ZEndList = ZTrue THEN _
      EXIT SUB
23101 ZOutTxt$ = ZDirPrompt$
      ZMacroMin = 2
      CALL PopCmdStack
      IF ZWasQ = 0 OR ZSubParm = -1 THEN _
         EXIT SUB
      CALL AraAllCaps (ZUserInAra$(),ZAnsIndex)
      IF ZUserInAra$(ZAnsIndex) = CHR$(81) THEN _      'quit
         ZWasQ = 0 : _
         EXIT SUB
      IF ZUserInAra$(ZAnsIndex) = CHR$(80) AND _     'P)ers
         ZUserSecLevel < ZOptSec(23) THEN
            GOTO 23101
      END IF
      ZWasA = INSTR("E+.E-.E.L.H.?.",ZUserInAra$(ZAnsIndex)+CHR$(46))
      IF ZWasA = 0 THEN _
         EXIT SUB
      IF ZWasA > 8 THEN _
         IF ZAnsIndex < ZLastIndex THEN _
            GOTO 23100 _
         ELSE GOTO 23102
      IF ZWasA = 7 THEN _
         ZExtendedOff = NOT ZExtendedOff _
      ELSE ZExtendedOff = (ZWasA > 3)
      CALL Toggle (-12)
      GOTO 23100
23102 ZFileName$ = ZCurDirPath$ + ZDirPrefix$ + _
                    CHR$(46) + ZDirExtension$
      CALL Graphic (ZFileName$)
      CALL BufFile (ZFileName$,ZAnsIndex)
      GOTO 23100
      END SUB
'
23150 ' $SUBTITLE: 'ConvertDir -- Converts coded response to right directory'
' $PAGE
'
'  NAME    -- ConvertDir
'
'  INPUTS  --     PARAMETER                    MEANING
'                 Start               ELEMENT TO BEGIN WITH
'                 ZUserIn$            ARRAY TO CONVERT
'                 ZWasQ               Last ELEMENT TO CONVERT
'
'  OUTPUTS --     ZUserIn$            CONVERTED DIRECTORY LIST
'
'  PURPOSE -- Let the user put in a short standard string for a directory
'
'
      SUB ConvertDir (Start) STATIC
      FOR WasI=Start TO ZLastIndex
         CALL AraAllCaps (ZUserInAra$(),WasI)
         IF ZUserInAra$(WasI)=CHR$(85) THEN _             'U
            ZUserInAra$(WasI) = ZUpldDirCheck$
         IF ZUserInAra$(WasI) = CHR$(65) THEN             'A
            '* "ALL"
            CALL FormatString (450,ZFalse,ZFalse,0,ZFalse,0,ZUserInAra$(WasI))
         END IF
      NEXT
      END SUB
'
23160 ' $SUBTITLE: 'LogPDown -- subroutine to record private downloads'
' $PAGE
'
'  NAME    -- LogPDown
'
'  INPUTS  --   PARAMETER     MEANING
'
'  OUTPUTS --
'
'  PURPOSE -- Puts a "!" in place of an "*" in private directory
'             after downloaded
'
      SUB LogPDown (PrivateDnld,DwnIndex) STATIC
      IF NOT PrivateDnld THEN _
         EXIT SUB
      ZWasEN$ = ZActiveFMSDir$
      WasBX = &H4
      ZSubParm = 9
      CALL FileLock
      CALL OpenRand (2,ZWasEN$,ZFMSFileLength)
      IF ZErrCode > 0 THEN _
         GOTO 23165
      FIELD #2,ZFMSFileLength AS PersonalRec$
      L = LEN(ZUserInAra$(0))
      FOR Temp = 1 TO ZDownFiles
         X = 5 * (DwnIndex - Temp) + 1
         IF X > 0 AND X < L THEN _
            ZWasA = VAL(MID$(ZUserInAra$(0),X,5)) : _
            IF ZWasA > 0 THEN _
               GET #2,ZWasA : _
               MID$(PersonalRec$,ZFMSFileLength-2,1) = CHR$(33) : _ '!
               PUT #2,ZWasA
      NEXT
23165 CALL UnLockAppend
      IF ZWasEN$ = ZPersonalDir$ THEN _
         ZFileWaiting = ZFalse
      END SUB
'
23170 ' $SUBTITLE: 'GetAll -- subroutine to create directory list'
' $PAGE
'
'  NAME    -- GetAll
'
'  INPUTS  --   PARAMETER     MEANING
'               LookIn$       NAME OF FILE TO SEARCH
'               DIR.EXT$      MAIN DIRECTORY EXTENSION TO USE
'               StartPos      Last POSITION USED IN ARRAY
'
'  OUTPUTS      StartPos     Last ELEMENT USED IN ARRAY
'               LoadInto$    ARRAY TO LOAD ELEMENTS Found
'
'  PURPOSE -- Creates a list (LoadInto$) of all directories
'             to be listed when ZWasA)ll is selected for a directory.
'             All uses config parm, which can be either a single
'             directory or list of directories (begin with "@").
'
      SUB GetAll (LoadInto$(1), StartPos) STATIC
      IF ZMasterDirName$ <> "" AND LEFT$(ZMasterDirName$,1) <> CHR$(64) THEN _
         StartPos = StartPos + 1 : _
         LoadInto$(StartPos) = ZMasterDirName$ : _
         EXIT SUB
      ZOK = ZFalse
      IF LEN (ZMasterDirName$) > 1 AND LEFT$(ZMasterDirName$,1) = CHR$(64) THEN _
         CALL FindIt(MID$(ZMasterDirName$,2))
      IF NOT ZOK THEN
         '* "No dirs defined for A)ll"
         CALL FormatString (497,ZFalse,ZFalse,0,ZTrue,1,"")
         EXIT SUB
      END IF
      MaxLoad = UBOUND(LoadInto$, 1)
      StartSort = StartPos + 1
      WHILE NOT EOF(2) AND StartPos < MaxLoad
         LINE INPUT #2, ZOutTxt$
         StartPos = StartPos + 1
         LoadInto$(StartPos) = ZOutTxt$
      WEND
      CLOSE 2
      END SUB
'
23180 ' $SUBTITLE: 'ColorDir - builds a color FMS directory string'
' $PAGE
'
'  NAME    --  ColorDir
'
'  INPUTS  --  PARAMETER                   MEANING
'               Strng$              String to alter
'               FMSDir$            "Y" FOR FMS DIR
'                                  "N" FOR PERSONAL Download
'
      SUB ColorDir (Strng$,FMSDir$) STATIC
      IF FMSDir$ = CHR$(78) THEN _                              'N
         GOTO 23181
'
' INSERT COLOR FOR FILENAME AND FORMAT DISPLAY
'
      ON INSTR("\ *",LEFT$(Strng$,1)) GOTO 23184,23182,23183
23181 FileName$ = RTRIM$(MID$(Strng$,6,13))
      CALL Remove (FileName$,CHR$(42))
      IF ZMarkedFiles$ <> "" AND _
         NOT ZNonStop AND _
         INSTR(ZMarkedFiles$,FileName$) <> 0 THEN
         IF ZWasGR > 1 THEN
            ColorOn$ = ZFGF$ + ZBG2$
         ELSE
            Strng$ = CHR$(42) + SPACE$(1) + MID$(Strng$,2,2) + _
            MID$(Strng$,5)
         END IF
      ELSE
         ColorOn$ = ZFGF$ + ZBG1$
      END IF
      IF ZNonStop THEN
         IF ZExtendedOff OR ((NOT ZShowTimesDownloaded) OR (NOT ZShowXferTime)) THEN
            Strng$ = ZDR1$ + LEFT$(Strng$,13) + _
                     ZDR2$ + MID$(Strng$,14,10) + _
                     ZDR3$ + MID$(Strng$,24,10) + _
                     ZDR4$ + MID$(Strng$,34,ZMaxDescLen) + ZEmphasizeoff$
         ELSE
            Strng$ = ZDR1$ + LEFT$(Strng$,13) + _
                     ZDR2$ + MID$(Strng$,14,10) + _
                     ZDR3$ + MID$(Strng$,24,10) + _
                     ZDR4$ + MID$(Strng$,39,ZMaxDescLen) + ZEmphasizeoff$
         END IF
      ELSE
         IF INSTR("DELETEDOFFLINE",MID$(Strng$,18,7)) THEN
            Strng$ = ColorOn$ + MID$(Strng$,1,4) + _
                     ZEmphasizeOff$ + SPACE$(1) + _
                     ZDR1$ + MID$(Strng$,6,12) + _
                     ZDR2$ + MID$(Strng$,18,7) + _
                     ZDR3$ + MID$(Strng$,26,8) + _
                     ZDR4$ + MID$(Strng$,35,ZMaxDescLen+1) + ZEmphasizeoff$
         ELSE
            Strng$ = ColorOn$ + MID$(Strng$,1,4) + _
                     ZEmphasizeOff$ + SPACE$(1) + _
                     ZDR1$ + MID$(Strng$,6,13) + _
                     ZDR2$ + MID$(Strng$,19,5) + _
                     ZDR3$ + MID$(Strng$,24,9) + _
                     ZDR4$ + MID$(Strng$,34,ZMaxDescLen+1) + ZEmphasizeoff$
         END IF
      END IF
      EXIT SUB
23182 Strng$ = ZDR5$ + Strng$          'extended description
      EXIT SUB
23183 Strng$ = ZEmphasizeOff$ + RIGHT$(Strng$,LEN(Strng$)-1)  'display line
23184 END SUB
'
23200 ' $SUBTITLE: 'Protocol - Determine protocols available'
' $PAGE
'
'  NAME    -- Protocol
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZProtoDef$                File of installed protocols
'
'  OUTPUTS -- ZTransferOption$         Prompt for protocol choice
'             ZDefaultXfer$            Letters of protocols
'
'  PURPOSE -- TO determine what protocols are available to user
'
      SUB Protocol STATIC
      CALL FindIt (ZProtoDef$)
      IF NOT ZOK THEN
         ZDefaultXfer$ = ""
         GOTO 23204
      END IF
      ZDefaultXfer$ = ""
      ZTransferOption$ = ""
      WasL = 0
23202 IF EOF(2) THEN
         GOTO 23204
      END IF
      CALL ReadParms (ZWorkAra$(),13,1)
      IF ZErrCode > 0 THEN
         EXIT SUB
      END IF
      ZDefaultXfer$ = ZDefaultXfer$ + SPACE$(1)
      IF ZUserSecLevel < VAL(ZWorkAra$(2)) AND _
         LEFT$(UCASE$(ZWorkAra$(1)),1) <> "N"  THEN
         GOTO 23202
      END IF
      IF LEFT$(ZWorkAra$(5),1) = CHR$(82) THEN                  'R
         IF NOT ZReliableMode THEN
            GOTO 23202
         END IF
      END IF
      IF LEFT$(ZWorkAra$(3),1) = CHR$(73) THEN                  'I
         GOTO 23203
      END IF
      WasX = INSTR(ZWorkAra$(12)+SPACE$(1),SPACE$(1))
      WasX$ = LEFT$(ZWorkAra$(12),WasX-1)
      CALL FindFile (WasX$,Found)
      IF Found THEN
         WasX = INSTR(ZWorkAra$(13)+SPACE$(1),SPACE$(1))
         WasX$ = LEFT$(ZWorkAra$(13),WasX-1)
         CALL FindFile (WasX$,Found)
      END IF
      IF NOT Found THEN
         GOTO 23202
      END IF
23203 MID$(ZDefaultXfer$,LEN(ZDefaultXfer$),1) = LEFT$(ZWorkAra$(1),1)
      CALL FindLast (ZWorkAra$(1),ZCrLf$,WasX,WasI)
      IF WasX > 0 AND WasX >= LEN(ZWorkAra$(1)) - 2 THEN
         ZWorkAra$(1) = LEFT$(ZWorkAra$(1),WasX-1)
      END IF
      IF (WasL + LEN(ZWorkAra$(1)) < 62) AND WasX = 0 THEN
         ZTransferOption$ = ZTransferOption$ + CHR$(44) + ZWorkAra$(1)
         WasL = WasL + LEN(ZWorkAra$(1)) + 1
      ELSE
         WasL = LEN(ZWorkAra$(1)) : _
         ZTransferOption$ = ZTransferOption$ + _
                            ZCrLf$ + _
                            ZWorkAra$(1)
      END IF
      GOTO 23202
23204 IF WasX = 0 THEN
         ZTransferOption$ = ZTransferOption$ + ",N)one"
      ELSE
         ZTransferOption$ = ZTransferOption$ + ZCrLf$ + "N)one"
      END IF
      ZDefaultXfer$ = ZDefaultXfer$ + CHR$(78)                  'N
23205 IF LEFT$(ZTransferOption$,1) = CHR$(44) THEN              ',
         ZTransferOption$ = MID$(ZTransferOption$,2)
      END IF
      IF INSTR(ZDefaultXfer$,ZUserXferDefault$) = 0 THEN
         '* "{PR unavailable.  Default reset to None"
         CALL FormatString (525,ZFalse,ZFalse,0,ZTrue,1,"")
         ZUserXferDefault$ = "N"
      END IF
      END SUB
23220 ' $SUBTITLE: 'Transfer - Subroutine for external protocols'
' $PAGE
'
'  NAME    -- Transfer
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZTransferFunction         = 1 DOWNLOAD FILE TO USER
'                                        = 2 UPLOAD FILE TO RBBS-PC
'              ZFileName$                NAME OF FILE FOR Transfer
'              ZComPort$                 NAME OF COMMUNICATIONS PORT
'                                        TO BE USED BY KERMIT (COM1
'                                        OR COM2)
'              ZBPS                      = -1 FOR   300 BAUD
'                                        = -2 FOR   450 BAUD
'                                        = -3 FOR  1200 BAUD
'                                        = -4 FOR  2400 BAUD
'                                        = -5 FOR  4800 BAUD
'                                        = -6 FOR  9600 BAUD
'                                        = -7 FOR 14400 BAUD
'                                        = -8 FOR 19200 BAUD
'
'  OUTPUTS  -- NONE
'
'  PURPOSE -- To transfer files using external protocols
'
      SUB Transfer STATIC
      IF ZUpBatchTransfer THEN
         EXIT SUB
      END IF
      IF ZPrivateDoor THEN
         CALL PrivDoorRtn
         EXIT SUB
      END IF
      IF ZTransferFunction = 1 THEN
         ZUserIn$ = ZDownTemplate$
         '* "send"
         LineNum = 526
      ELSEIF ZTransferFunction = 2 THEN
         ZUserIn$ = ZUpTemplate$
         '* "receive"
         LineNum = 527
      END IF
      CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZWasZ$)
      CALL MetaGSR (ZUserIn$,ZFalse)
      '* "{CEProtocol: {C3"
      CALL FormatString (528,ZFalse,ZFalse,0,ZTrue,0,"")
      CALL QuickTPut1 (ZProtoPrompt$ + ZEmphasizeOff$)
      '* "{C2Ready to {ZZ:{SP"
      CALL FormatString (529,ZFalse,ZFalse,0,Ztrue,0,"")
      IF ZBatchTransfer or ZWasBatchTransfer THEN
         '* "{CF{G1(BATCH){RC"
         CALL FormatString (530,ZFalse,ZFalse,0,ZTrue,1,"")
      ELSE
         '* "{SP{CF{G1{FH{RC"
         CALL FormatString (531,ZFalse,ZFalse,0,ZTrue,1,"")
      END IF
      IF ZWasBatchTransfer THEN
         Temp$ = ZBatchWorkFile$
      ELSEIF ZBatchTransfer THEN
         Temp$ = ZNodeWorkFile$
      END IF
      IF ZBatchTransfer or ZWasBatchTransfer THEN
         CALL OpenWork (2,Temp$)
         WHILE NOT EOF(2)
           CALL ReadAny
           CALL BreakFileName (ZOutTxt$,ZWasZ$,ZWasY$,WasX$,ZTrue)
           CALL QuickTPut1 (ZFG6$+ZWasY$+WasX$+ZEmphasizeOff$)
         WEND
      END IF
      IF ZAutoEnd = 1 THEN
         '* "{C9Automatic LogOff if {CBTRANSFER {C9Successful{RC"
         CALL FormatString (532,ZFalse,ZFalse,0,ZTrue,1,"")
      END IF
      CALL PrivDoorRtn
      END SUB
23224 ' $SUBTITLE: 'PrivDoorRtn - subroutine to exit as a private door.'
' $PAGE
'
'  NAME    -- PrivDoorRtn
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZTransferFunction         = 1 DOWNLOAD FILE TO USER
'                                        = 2 UPLOAD FILE TO RBBS-PC
'                                        = 3 USER REGISTRATION PGM
'              ZUserIn$                      NAME OF FILE TO EXIT TO
'              ZComPort$                 NAME OF COMMUNICATIONS PORT
'                                        TO BE USED BY KERMIT (COM1
'                                        OR COM2)
'              ZBPS                      = -1 FOR   300 BAUD
'                                        = -2 FOR   450 BAUD
'                                        = -3 FOR  1200 BAUD
'                                        = -4 FOR  2400 BAUD
'                                        = -5 FOR  4800 BAUD
'                                        = -6 FOR  9600 BAUD
'                                        = -7 FOR 19200 BAUD
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- To transfer control to another program
'
      SUB PrivDoorRtn STATIC
      IF ZPrivateDoor THEN
         GOTO 23230
      END IF
      IF ZFakeXRpt THEN
         CALL FakeXRpt (ZWasFT$)
      END IF
      IF ZAdvanceProtoWrite THEN
         CALL OpenOutW ("XFER-"+ZNodeID$+".DEF")
         IF ZErrCode < 1 THEN
            CALL PrintWorkA (2,ZFileName$+STRING$(2,44)+ZWasFT$)
            CLOSE 2
         END IF
      END IF
      IF (ZTransferFunction = 1 AND LEFT$(ZProtoMethod$,1) = CHR$(83)) OR _
         (ZTransferFunction = 2 AND RIGHT$(ZProtoMethod$,1) = CHR$(83)) THEN
         GOTO 23229
      END IF
23228 WasX$ = LEFT$(ZUserIn$,INSTR(ZUserIn$+SPACE$(1),SPACE$(1))-1)
      IF WasX$ = "" THEN
         EXIT SUB
      END IF
      CALL FindIt (WasX$)
      IF NOT ZOK THEN
         '* "Missing door program"
         CALL FormatString (533,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
         CALL UpdtCalr (ZOutTxt$ + SPACE$(1) + WasX$,1)
         ZSnoop = ZTrue
         CALL LPrnt (ZOutTxt$,1)
         EXIT SUB
      END IF
      ZOutTxtAra$(1) = "CLS"
      GOSUB 23233
      '* "{AN From {CT"
      CALL FormatString (534,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      ZOutTxtAra$(2) = "ECHO " + ZOutTxt$
      ZOutTxtAra$(3) = ZComspec$ + _
              " /C " + _
              ZUserIn$
      ZOutTxtAra$(4) = ZRBBSBat$
      ZPrivateDoor = ZTrue
      '* "Dooring to External Program for Transfer"
      CALL FormatString (535,ZFalse,ZFalse,0,ZTrue,1,"")
      LOCATE ZLocalPageLength-1,1
      CALL LPrnt(ZLineFeed$,0)
      CALL DoorInfo
      CALL RBBSExit (ZOutTxtAra$(),4)
23229 GOSUB 23233
      CALL LPrnt (ZOutTxt$,1)
      CALL ShellExit (ZUserIn$)
23230 IF ZPrivateDoor THEN
         CALL RestoreCom
         CALL DelayTime (7 + ZBPS)
         CALL SetBaud
         '* "Reloading RBBS-PC.  Please be patient."
         CALL FormatString (536,ZFalse,ZFalse,0,ZTrue,1,"")
      END IF
23231 CALL SkipLine (2)
      LOCATE ZLocalPageLength-1,1
23232 EXIT SUB
23233 CALL SetupTransferInfo
      RETURN
      END SUB
23250 ' $SUBTITLE: 'FakeXRpt - subroutine to create fake xfer report'
' $PAGE
'
'  NAME    --  FakeXRpt
'
'  INPUTS  --  PARAMETER                   MEANING
'              ZFileNameHold$      FILE TO BE TRANSFERRED
'              ProtoUsed$          Protocol USED
'
'  OUTPUTS --  WRITES OUT Transfer FILE REPORT
'
'  PURPOSE --  External protocol drivers that do not write
'              out a standard transfer report must have one
'              provided in order for "dooring" to external
'              protocols to work properly, since this file
'              is read upon returning from an external protocol.
'
      SUB FakeXRpt (ProtoUsed$) STATIC
      CLOSE 2
      OPEN "O",2,"XFER-" + _
                 ZNodeFileID$ + _
                 ".DEF"
      PRINT #2,ZFileName$
      PRINT #2,
      PRINT #2,ProtoUsed$
      PRINT #2,CHR$(83)                                         'S
      CLOSE 2
      END SUB
