' $segment
' $linesize:132
' $title: 'DOSFUNC.BAS, Copyright 1993,1994 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'  Name ...............: DOSFUNC.BAS
'  First Released .....: August 17, 1993
'  Copyright ..........: 1993,1994
'  Purpose.............: DOS Function calls for RBBS-PC CDOR
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine or Function             Purpose
'  CheckShare                         Check/Return status of DOS SHARE
'  CheckPrinter                       Check/Return status of PRINTER
'
' $INCLUDE: 'RBBS-VAR.MOD'

   TYPE RegTypeX
      ax      AS INTEGER
      bx      AS INTEGER
      cx      AS INTEGER
      dx      AS INTEGER
      bp      AS INTEGER
      si      AS INTEGER
      di      AS INTEGER
      flags   AS INTEGER
      ds      AS INTEGER
      es      AS INTEGER
   END TYPE

' =============================================================================
' * GetFirstMatchingFile$ - DOS FindFirst
' =============================================================================
    FUNCTION GetFirstMatchingFile$ (FileSpec$)

    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.ax = &H2F00
    CALL InterruptX(&H21, InRegs, OutRegs)
    SegDTA% = OutRegs.es
    OffDTA% = OutRegs.bx
    NameFile$ = FileSpec$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.cx = 0
    InRegs.ax = &H4E00
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF OutRegs.flags AND 1 THEN
       GetFirstMatchingFile$ = ""
       EXIT FUNCTION
    END IF
    DEF SEG = SegDTA%
    OffMatch% = OffDTA% + 29
    Match$ = ""
    FOR i = 1 TO 13
       C$ = CHR$(PEEK(OffMatch% + i))
       IF C$ = CHR$(0) THEN
          EXIT FOR
       END IF
       Match$ = Match$ + C$
    NEXT i
    DEF SEG
    GetFirstMatchingFile$ = Match$
    END FUNCTION
'
' =============================================================================
' * GetNextMatchingFile$ - DOS FindNext
' =============================================================================
    FUNCTION GetNextMatchingFile$
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.ax = &H2F00
    CALL InterruptX(&H21, InRegs, OutRegs)
    SegDTA% = OutRegs.es
    OffDTA% = OutRegs.bx
    InRegs.ax = &H4F00
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF OutRegs.flags AND 1 THEN
       GetNextMatchingFile$ = ""
       EXIT FUNCTION
    END IF
    DEF SEG = SegDTA%
    OffMatch% = OffDTA% + 29
    Match$ = ""
    FOR i = 1 TO 13
       C$ = CHR$(PEEK(OffMatch% + i))
       IF C$ = CHR$(0) THEN
          EXIT FOR
       END IF
       Match$ = Match$ + C$
    NEXT i
    DEF SEG
    GetNextMatchingFile$ = Match$
    END FUNCTION

' =============================================================================
' * CheckShare - Returns ZOK = ZTrue if SHARE is loaded
' =============================================================================

    SUB CheckShare
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    CALL CheckNovell (Installed)
    IF Installed = 0 THEN
       ZOK = ZTrue
       EXIT SUB
    END IF
    ZOK = ZFalse
    InRegs.ax = &H1000
    CALL InterruptX(&H2F, InRegs, OutRegs)
    CheckShareVal = OutRegs.ax AND &HFF
    IF CheckShareVal = &HFF THEN
       ZOK = ZTrue
    ELSE
       ZSnoop = ZTrue
       '* "ERROR - SHARE NOT INSTALLED"
       CALL FormatString (848,ZTrue,ZFalse,0,ZFalse,0,"")
       CALL DelayTime (5)
    END IF
    END SUB

' =============================================================================
' * CheckPrinter - Returns ZOK = ZTrue if Printer Ready
' =============================================================================

    SUB CheckPrinter (PrinterNumber)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    ZOK = ZFalse
    IF PrinterNumber = 0 THEN
       EXIT SUB
    END IF
    InRegs.ax = &H0200
    InRegs.dx = PrinterNumber - 1
    CALL InterruptX(&H17, InRegs, OutRegs)
    PrinterAlive = (OutRegs.ax AND &HFF00) / &H100
    ZOK = (((PrinterAlive AND &H29) = 0) AND ((PrinterAlive AND &H90) = &H90))
    END SUB

' =============================================================================
' * SetFileHandles - Sets Maximum number of File Handles (not needed yet!)
' =============================================================================

'   SUB SetFileHandles (Handles)
'   DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
'   InRegs.ax = &H6700
'   InRegs.bx = Handles
'   CALL InterruptX(&H21, InRegs, OutRegs)
'   END SUB

' =============================================================================
' * DelFile - Deletes a File
' =============================================================================

    SUB DelFile (FileName$,ECODE)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H4100
    CALL InterruptX(&H21, InRegs, OutRegs)
    ECODE = (OutRegs.Flags AND 1)
    END SUB

' =============================================================================
' * GetFDateTime - Gets File Date and Time
' =============================================================================

    SUB GetFDate (FileName$,FDATE,FTIME)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H3D00
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF OutRegs.flags AND 1 THEN
       EXIT SUB
    END IF
    Handle = OutRegs.ax
    InRegs.ax = &H5700
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs, OutRegs)
    FTIME = OutRegs.cx
    FDATE = OutRegs.dx
    InRegs.ax = &H3E00
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs,OutRegs)
    END SUB

' =============================================================================
' * SetFDateTime - Sets File Date and Time
' =============================================================================

    SUB SetFDate (FileName$,FDATE,FTIME)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H3D02
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF OutRegs.flags AND 1 THEN
       EXIT SUB
    END IF
    Handle = OutRegs.ax
    InRegs.ax = &H5701
    InRegs.bx = Handle
    InRegs.cx = FTIME
    InRegs.dx = FDATE
    CALL InterruptX(&H21, InRegs, OutRegs)
    InRegs.ax = &H3E00
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs,OutRegs)
    END SUB

' =============================================================================
' * GetCurrentDir - Gets the current DOS directory
' =============================================================================
'
' * Not required for Blinker
'
    SUB GetCurrentPath (Drive$,Path$)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.ax = &H1900
    CALL InterruptX(&H21, InRegs, OutRegs)
    DriveNum = OutRegs.ax AND &HFF
    Drive$ = CHR$(65+DriveNum)
    Path$ = STRING$(64,CHR$(0))
    InRegs.ax = &H4700
    InRegs.dx = &H0000
    InRegs.ds = SSEG(WorkPath$)
    InRegs.si = SADD(WorkPath$)
    CALL InterruptX(&H21, InRegs, OutRegs)
    PathSeg% = OutRegs.ds
    PathOff% = OutRegs.si
    IF OutRegs.flags AND 1 THEN
       Path$ = ""
       EXIT SUB
    END IF
    DEF SEG = PathSeg%
    WorkPath$ = ""
    FOR i = 0 TO 63
       C$ = CHR$(PEEK(PathOff%+i))
       IF C$ = CHR$(0) THEN
          EXIT FOR
       END IF
       WorkPath$ = WorkPath$ + C$
    NEXT i
    Path$ = WorkPath$
    DEF SEG
    END SUB

' =============================================================================
' * SetCurrentDir - Sets the current DOS directory
' =============================================================================
'
' * Not required for Blinker
'
    SUB SetCurrentPath (Drive$,Path$)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.ax = &H0E00
    InRegs.dx = &H0000 + (ASC(Drive$) - 65)
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF LEFT$(Path$,1) <> "\" THEN
       Path$ = "\" + Path$
    END IF
    Path$ = Path$ + CHR$(0)
    InRegs.ax = &H3B00
    InRegs.ds = SSEG(Path$)
    InRegs.dx = SADD(Path$)
    CALL InterruptX(&H21, InRegs, OutRegs)
    END SUB
