VERSION 2.00
Begin Form frmMain 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "WinPointer"
   ClientHeight    =   3705
   ClientLeft      =   930
   ClientTop       =   1590
   ClientWidth     =   7380
   Height          =   4110
   Icon            =   WINPNTR.FRX:0000
   Left            =   870
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3705
   ScaleWidth      =   7380
   Top             =   1245
   Width           =   7500
   WindowState     =   1  'Minimized
   Begin CommandButton Command1 
      Caption         =   "&About..."
      Height          =   375
      Left            =   3120
      TabIndex        =   10
      Top             =   3120
      Width           =   1095
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   5760
      TabIndex        =   11
      Top             =   3120
      Width           =   1095
   End
   Begin Frame grpLine 
      Caption         =   "&Line Draw"
      Height          =   2415
      Left            =   3360
      TabIndex        =   5
      Top             =   240
      Width           =   3855
      Begin PictureBox picColorPal 
         Height          =   735
         Left            =   240
         ScaleHeight     =   1
         ScaleMode       =   0  'User
         ScaleWidth      =   16
         TabIndex        =   6
         Top             =   840
         Width           =   3375
      End
      Begin TextBox txtLineSize 
         Height          =   285
         Left            =   1800
         MaxLength       =   1
         TabIndex        =   8
         Text            =   "3"
         Top             =   1800
         Width           =   375
      End
      Begin PictureBox picLineFrame 
         Height          =   255
         Left            =   480
         ScaleHeight     =   225
         ScaleWidth      =   2865
         TabIndex        =   12
         TabStop         =   0   'False
         Top             =   360
         Width           =   2895
         Begin Line linSample 
            BorderWidth     =   3
            X1              =   240
            X2              =   2760
            Y1              =   120
            Y2              =   120
         End
      End
      Begin Shape shpFocus 
         BorderColor     =   &H00808080&
         BorderStyle     =   3  'Dot
         Height          =   255
         Left            =   120
         Top             =   360
         Visible         =   0   'False
         Width           =   255
      End
      Begin Label lblLineSize 
         Caption         =   "Line size (1 - 9):"
         Height          =   255
         Left            =   240
         TabIndex        =   7
         Top             =   1800
         Width           =   1455
      End
   End
   Begin Frame grpSKey 
      Caption         =   "&Hotkey"
      Height          =   2415
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   2895
      Begin ComboBox cboVK 
         Height          =   300
         Left            =   240
         TabIndex        =   1
         Top             =   360
         Width           =   2415
      End
      Begin CheckBox chkShiftKey 
         Caption         =   "Ctrl"
         Height          =   255
         Index           =   2
         Left            =   480
         TabIndex        =   2
         Top             =   840
         Width           =   615
      End
      Begin CheckBox chkShiftKey 
         Caption         =   "Shift"
         Height          =   255
         Index           =   1
         Left            =   480
         TabIndex        =   3
         Top             =   1320
         Width           =   735
      End
      Begin CheckBox chkShiftKey 
         Caption         =   "Alt"
         Height          =   255
         Index           =   4
         Left            =   480
         TabIndex        =   4
         Top             =   1800
         Width           =   615
      End
   End
   Begin CommandButton cmdOk 
      Caption         =   "&Ok"
      Default         =   -1  'True
      Height          =   375
      Left            =   600
      TabIndex        =   9
      Top             =   3120
      Width           =   1095
   End
End
Option Explicit

DefInt A-Z

Dim mbFlag

Sub cboVK_Change ()
    If mbFlag Then Exit Sub
    Select Case Len(cboVK.Text)
        Case 0
            Exit Sub
        Case 1
            giVKCode = Asc(UCase(cboVK.Text))
            cboVK.SelStart = 0
            cboVK.SelLength = 1
        Case Else
            giVKCode = cboVK.ItemData(cboVK.ListIndex)
    End Select
End Sub

Sub cboVK_Click ()
    Select Case Len(cboVK.Text)
        Case 0
            Exit Sub
        Case 1
            giVKCode = Asc(UCase(cboVK.Text))
        Case Else
            giVKCode = cboVK.ItemData(cboVK.ListIndex)
    End Select
End Sub

Sub cboVK_KeyPress (KeyAscii As Integer)
    If (Len(cboVK.Text) > 0) And (cboVK.SelLength = 0) And (KeyAscii <> 8) Then
        KeyAscii = 0
    Else
        KeyAscii = Asc(UCase(Chr(KeyAscii)))
    End If
End Sub

Sub chkShiftKey_Click (Index As Integer)
    If mbFlag Then Exit Sub
    If chkShiftKey(Index) Then
        giVKMask = giVKMask + Index
    Else
        giVKMask = giVKMask - Index
    End If
End Sub

Sub cmdExit_Click ()
    cmdOk_Click
    End
End Sub

Sub cmdOk_Click ()
    Dim zIniFile As String, zSection As String

    zIniFile = "WINPNTR.INI"
    
    zSection = "Hotkey"
    SetIniLong zIniFile, zSection, "VKCode", giVKCode
    SetIniLong zIniFile, zSection, "VKMask", giVKMask
    
    zSection = "Line Draw"
    SetIniLong zIniFile, zSection, "glLColor", glLColor
    SetIniLong zIniFile, zSection, "giLSize", giLSize

    Me.WindowState = 1
End Sub

Sub Command1_Click ()
    DisplayAboutBox Me, "WinPointer!", 1, 1994, "Jonathan Zuck", "First Published in PC Magazine", "October 11, 1994, U.S. Edition", False, True, 0, 0
End Sub

Sub Form_Load ()
    Dim iCount

    'Hotkey list initialization
    cboVK.AddItem "Backspace"
    cboVK.ItemData(cboVK.NewIndex) = &H8
    cboVK.AddItem "Tab"
    cboVK.ItemData(cboVK.NewIndex) = &H9
    cboVK.AddItem "Enter"
    cboVK.ItemData(cboVK.NewIndex) = &HD
    cboVK.AddItem "Esc"
    cboVK.ItemData(cboVK.NewIndex) = &H1B
    cboVK.AddItem "Space"
    cboVK.ItemData(cboVK.NewIndex) = &H20
    cboVK.AddItem "End"
    cboVK.ItemData(cboVK.NewIndex) = &H23
    cboVK.AddItem "Home"
    cboVK.ItemData(cboVK.NewIndex) = &H24
    cboVK.AddItem "Left"
    cboVK.ItemData(cboVK.NewIndex) = &H25
    cboVK.AddItem "Up"
    cboVK.ItemData(cboVK.NewIndex) = &H26
    cboVK.AddItem "Right"
    cboVK.ItemData(cboVK.NewIndex) = &H27
    cboVK.AddItem "Down"
    cboVK.ItemData(cboVK.NewIndex) = &H28
    cboVK.AddItem "Ins"
    cboVK.ItemData(cboVK.NewIndex) = &H2D
    cboVK.AddItem "Del"
    cboVK.ItemData(cboVK.NewIndex) = &H2E
    cboVK.AddItem "F1"
    cboVK.ItemData(cboVK.NewIndex) = &H70
    cboVK.AddItem "F2"
    cboVK.ItemData(cboVK.NewIndex) = &H71
    cboVK.AddItem "F3"
    cboVK.ItemData(cboVK.NewIndex) = &H72
    cboVK.AddItem "F4"
    cboVK.ItemData(cboVK.NewIndex) = &H73
    cboVK.AddItem "F5"
    cboVK.ItemData(cboVK.NewIndex) = &H74
    cboVK.AddItem "F6"
    cboVK.ItemData(cboVK.NewIndex) = &H75
    cboVK.AddItem "F7"
    cboVK.ItemData(cboVK.NewIndex) = &H76
    cboVK.AddItem "F8"
    cboVK.ItemData(cboVK.NewIndex) = &H77
    cboVK.AddItem "F9"
    cboVK.ItemData(cboVK.NewIndex) = &H78
    cboVK.AddItem "F10"
    cboVK.ItemData(cboVK.NewIndex) = &H79
    cboVK.AddItem "F11"
    cboVK.ItemData(cboVK.NewIndex) = &H7A
    cboVK.AddItem "F12"
    cboVK.ItemData(cboVK.NewIndex) = &H7B
    cboVK.AddItem "F13"
    cboVK.ItemData(cboVK.NewIndex) = &H7C
    cboVK.AddItem "F14"
    cboVK.ItemData(cboVK.NewIndex) = &H7D
    cboVK.AddItem "F15"
    cboVK.ItemData(cboVK.NewIndex) = &H7E
    cboVK.AddItem "F16"
    cboVK.ItemData(cboVK.NewIndex) = &H7F

    
    'Get Previous settings
    mbFlag = True
    Select Case giVKCode
        Case 65 To 90
            cboVK.Text = Chr(giVKCode)
        Case Else
            For iCount = 0 To cboVK.ListCount - 1
                If cboVK.ItemData(iCount) = giVKCode Then
                    cboVK.ListIndex = iCount
                    Exit For
                End If
            Next
    End Select
    If giVKMask And 1 Then chkShiftKey(1).Value = 1 Else chkShiftKey(1).Value = 0
    If giVKMask And 2 Then chkShiftKey(2).Value = 1 Else chkShiftKey(2).Value = 0
    If giVKMask And 4 Then chkShiftKey(4).Value = 1 Else chkShiftKey(4).Value = 0
    mbFlag = False

    'Line Draw Intitialization
    linSample.BorderColor = glLColor
    linSample.BorderWidth = giLSize
    txtLineSize = linSample.BorderWidth
End Sub

Sub Form_Unload (Cancel As Integer)
    End
End Sub

Sub picColorPal_GotFocus ()
    shpFocus.Visible = True
End Sub

Sub picColorPal_KeyDown (KeyCode As Integer, Shift As Integer)
    Dim iClr

    For iClr = 0 To 15
        If QBColor(iClr) = glLColor Then Exit For
    Next
    Select Case KeyCode
        Case 37, 40     'Left & Down
            iClr = iClr - 1
            If iClr < 0 Then iClr = 15
        Case 38, 39     'Up & Right
            iClr = iClr + 1
            If iClr > 15 Then iClr = 0
    End Select
    linSample.BorderColor = QBColor(iClr)
    glLColor = QBColor(iClr)
End Sub

Sub picColorPal_LostFocus ()
    shpFocus.Visible = False
End Sub

Sub picColorPal_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    glLColor = picColorPal.Point(X, Y)
    linSample.BorderColor = glLColor
End Sub

Sub picColorPal_Paint ()
    Dim iCount

    'populate color palette
    For iCount = 0 To 15
        picColorPal.Line (iCount, 0)-(iCount + 1, 1), QBColor(iCount), BF
    Next

    'now position the focus rectangle
    shpFocus.Move picColorPal.Left - 30, picColorPal.Top - 30, picColorPal.Width + 60, picColorPal.Height + 60
End Sub

Sub txtLineSize_Change ()
    If Val(txtLineSize) = 0 Then txtLineSize = "1"
    linSample.BorderWidth = Val(txtLineSize)
    giLSize = linSample.BorderWidth
    txtLineSize_GotFocus
End Sub

Sub txtLineSize_GotFocus ()
    txtLineSize.SelStart = 0
    txtLineSize.SelLength = 1
End Sub

