/*** line ***/

#include "windows.h"
#include "line.h"
#include "pcl4w.h"
#include "config.h"
#include "simple.h"
#include "expect.h"
#include "sioerror.h"
#include "simpl_io.h"

extern HWND hMainWnd;
extern int FatalFlag;
extern int OnLineFlag;

/* private */
static WORD RxSelector = 0;
static WORD TxSelector = 0;
static WORD LockCount = 0;
static void FreeDOSmemory(void);

void GoOnLine(void)
{DWORD dwValue;
 int RetCode;
 int Port;
 HMENU hMenu;
 if(OnLineFlag) return;
 /* allocate windows/DOS memory for receive buffer */
 dwValue = GlobalDosAlloc(2<<(3+RXBUFFERCODE));
 if(dwValue)
   {/* get selector */
    RxSelector = LOWORD(dwValue);
    LockCount = GlobalPageLock(RxSelector);
    if(LockCount==0) FatalFlag = TRUE;
   }
 else FatalFlag = TRUE;
 /* memory allocation error ? */
 if(FatalFlag)
   {RxSelector = 0;
    ErrorMessage("Cannot allocate memory");
    return;
   }
 /* pass selector to PCL4C */
 Port = GetPort();
 RetCode = SioRxBuf(Port,RxSelector,RXBUFFERCODE);
 if(RetCode<0)
   {SioError(RetCode,"SioRxBuf");
    FreeDOSmemory();
    return;
   }
 if(SioInfo('I'))
   {/* allocate windows/DOS memory for transmit buffer */
    dwValue = GlobalDosAlloc(2<<(3+TXBUFFERCODE));
    if(dwValue)
      {/* get selector */
       TxSelector = LOWORD(dwValue);
       LockCount = GlobalPageLock(TxSelector);
      if(LockCount==0) FatalFlag = TRUE;
      }
    else FatalFlag = TRUE;
    /* memory allocation error ? */
    if(FatalFlag)
      {TxSelector = 0;
       ErrorMessage("Cannot allocate memory");
       return;
      }
    /* pass selector to PCL4C */
    Port = GetPort();
    RetCode = SioTxBuf(Port,TxSelector,TXBUFFERCODE);
    if(RetCode<0)
      {SioError(RetCode,"SioTxBuf");
       FreeDOSmemory();
       return;
      }
    DisplayLine("TX interrupts enabled");
   }
 /* reset Port */
 RetCode = SioReset(Port,GetBaud());
 if(RetCode<0)
   {SioError(RetCode,"SioReset");
    FreeDOSmemory();
    return;
   }
 /* set DTR & RTS */
 SioDTR(Port,'S');
 SioRTS(Port,'S');
#if RTS_CTS_CONTROL
 /* set flow control */
 SioFlow(Port,TRUE);
 DisplayLine("Flow control enabled");
#endif
 /* Set FIFO level for 16550 */
 if( SioFIFO(Port,LEVEL_14) ) DisplayLine("16550 UART detected");
 /* clear PCL4C receive buffer */
 SioRxFlush(Port);
 OnLineFlag = TRUE;
 SetTitle();
 hMenu = GetMenu(hMainWnd);
 CheckMenuItem(hMenu,MSG_OFFLINE,MF_BYCOMMAND | MF_UNCHECKED);
 CheckMenuItem(hMenu,MSG_ONLINE,MF_BYCOMMAND | MF_CHECKED);
} /* end GoOnLine */

void GoOffLine()
{HMENU hMenu;
 FreeDOSmemory();
 if(OnLineFlag)
   {SioDone((int)GetPort());
    hMenu = GetMenu(hMainWnd);
    CheckMenuItem(hMenu,MSG_ONLINE,MF_BYCOMMAND | MF_UNCHECKED);
    CheckMenuItem(hMenu,MSG_OFFLINE,MF_BYCOMMAND | MF_CHECKED);
    OnLineFlag = FALSE;
    SetTitle();
   }
} /* end GoOffLine */

void FreeDOSmemory(void)
{
 if(RxSelector)
   {GlobalPageUnlock(RxSelector);
    GlobalDosFree(RxSelector);
    RxSelector = 0;
   }
 if(TxSelector)
   {GlobalPageUnlock(TxSelector);
    GlobalDosFree(TxSelector);
    RxSelector = 0;
   }
}
