///////////////////////////////////////////////////////////////////////////
// DIBQuant version 1.0
// Copyright (c) 1993 Edward McCreary.
// All rights reserved.
//
// Redistribution and use in source and binary forms are freely permitted
// provided that the above copyright notice and attibution and date of work
// and this paragraph are duplicated in all such forms.
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
// WARRANTIES OF MERCHANTIBILILTY AND FITNESS FOR A PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////

#ifndef _LOCAL_H
#define _LOCAL_H

#ifndef MIN
#define MIN(a,b) ((a)<(b)?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b) ((a)>(b)?(a):(b))
#endif

#define CLIP(x) ((x)>255?255:((x)<0?0:(x)))

#define COLOR_MAX 32

#define COUNT_LIMIT 0xFFFFL

typedef struct box
{
 int r0,r1,g0,g1,b0,b1;
 long rave,gave,bave;
 unsigned long count;
} Box;

typedef struct node
{
 int            index;
 unsigned long count; 
} Node, FAR *LPNode;


typedef struct tagBuffers
{
  FARPROC   lpStatus;
  int red[256],green[256],blue[256];
  Box     box[256];
  long SQR[256];
  LPNode huge *lpHisto;
  
} QUANT_BUFFER, FAR *LPQUANT_BUFFER;

#define SWAP(a, b)    { unsigned long   tmp;            \
            tmp = a; a = b; b = tmp; }

#define INDEX(r,g,b) (((DWORD)b) | (((DWORD)g)<<5) | (((DWORD)r)<<10) )

#define WIDTHBYTES(bits)    (((bits) + 31) / 32 * 4)
#define IS_WIN30_DIB(lpbi)  ((*(LPDWORD)(lpbi)) == sizeof(BITMAPINFOHEADER))

#define JITTER_TABLE_BITS   10
#define JITTER_TABLE_SIZE   (1<<JITTER_TABLE_BITS)
#define JITTER_MASK         (JITTER_TABLE_SIZE-1)

/* jitter macros */
#define jitterx(x,y,s) \
(uranx[((x+(y<<2))+irand[(x+s)&JITTER_MASK])&JITTER_MASK])
#define jittery(x,y,s) \
(urany[((y+(x<<2))+irand[(y+s)&JITTER_MASK])&JITTER_MASK])


#define STATUS_CAST void (FAR PASCAL *)(LPCSTR)


///////////////////////////////////////////////////////////////////////////
// local prototypes
void m_box(LPQUANT_BUFFER lpBuffer);
void make_box(int r, int g, int b, int index, unsigned long c,LPQUANT_BUFFER lpBuffer);
void squeeze(int b,LPQUANT_BUFFER lpBuffer);
void add_color(int r, int g, int b, unsigned long c,LPQUANT_BUFFER lpBuffer);
void force(int r, int g, int b, unsigned long c,LPQUANT_BUFFER lpBuffer);
void pop(LPQUANT_BUFFER lpBuffer);

int GetNeighbor(int r,int g,int b,LPQUANT_BUFFER lpBuffer);
void ClearLUT(LPQUANT_BUFFER lpBuffers);
LPQUANT_BUFFER InitLUT();

LPSTR Dither(LPSTR lpDIB,int nDither,LPQUANT_BUFFER lpBuffer);

LPSTR AllocNewDIB(LPSTR lpDIB,LPQUANT_BUFFER lpBuffer);

void jitter(long x, long y, int *r,int *g,int *b);

void LoadDefaultPal(LPQUANT_BUFFER lpBuffer);
WORD FAR DIBNumColors(LPSTR lpDIB);
WORD FAR PaletteSize(LPSTR lpDIB);
LPSTR FAR FindDIBBits(LPSTR lpDIB);


#endif /* _LOCAL_H */