FUNCTION CopyFile%(BYVAL InFile$, BYVAL OutFile$)
	LOCAL BytesLeft&, MaxString%

	ON LOCAL ERROR GOTO CopyFileError

	OPEN InFile$ FOR BINARY AS 3			' open source
	OPEN OutFile$ FOR BINARY AS 4     		' open destination

	MaxString% = FRE(t$)                    ' create largest buffer possible
	Buffer$ = SPACE$(MaxString%)
	BytesLeft& = LOF(3)          			' bytes to copy

	DO
  		IF BytesLeft& < MaxString% THEN    ' nearly done
    		MaxString% = BytesLeft&
    		Buffer$ = SPACE$(MaxString%)
  		END IF
  		GET 3,,Buffer$
  		PUT 4,,Buffer$
  		BytesLeft& = BytesLeft& - MaxString%
	LOOP WHILE ISTRUE(BytesLeft&)

	CLOSE 3, 4

ExitCopyFile:

	EXIT FUNCTION
CopyFileError:
	CopyFile% = ERRTEST
	Close 3
	close 4
	RESUME ExitCopyFile

END FUNCTION
'-----------------------------------------------------------------------------
FUNCTION VerifyFile%(BYVAL InFile$, BYVAL OutFile$)
	LOCAL BytesLeft&, MaxString%

	ON LOCAL ERROR GOTO VerifyFileError

	OPEN InFile$ FOR BINARY AS 3			' open source
	OPEN OutFile$ FOR BINARY AS 4     		' open destination

	MaxString% = FRE(t$)/2                  ' create largest buffer possible
	Buffer3$ = SPACE$(MaxString%)
	Buffer4$ = SPACE$(MaxString%)
	BytesLeft& = LOF(3)          			' bytes to copy

	DO
  		IF BytesLeft& < MaxString% THEN    ' nearly done
    		MaxString% = BytesLeft&
    		Buffer3$ = SPACE$(MaxString%)
    		Buffer4$ = SPACE$(MaxString%)
  		END IF
  		GET 3,,Buffer3$
  		GET 4,,Buffer4$
		If Buffer3$<>Buffer4$ then
			VerifyFile% = 9999
			CLOSE 3, 4
			EXIT FUNCTION
		End If
  		BytesLeft& = BytesLeft& - MaxString%
	LOOP WHILE ISTRUE(BytesLeft&)

	CLOSE 3, 4

ExitVerifyFile:

	EXIT FUNCTION
VerifyFileError:
	VerifyFile% = ERRTEST
	Close 3
	close 4
	RESUME ExitVerifyFile:

END FUNCTION
'-----------------------------------------------------------------------------
