/**********************************************/
/*                                            */
/* XBBS Door Skeleton -- TC 2.0/MSC 6.0a code */
/* Copyright (c) 1990/91/92/93 by M. Kimes    */
/* All Rights Reserved                        */
/* May be freely used for >>>FREE<<< programs */
/* as long as you don't try to save any souls */
/* (nasty habit)                              */
/*                                            */
/**********************************************/

typedef struct {
  char soh;           /* 0x01 or 0x02 */
  char blk;           /* block # */
  char blkcmp;        /* 1's complement of block # */
  char data[1027];    /* data and crc or csum */
} GENBLK;

#define DOORTIMEOUT       -1
#define DOORLOSTCARRIER   -2
#define DOORFILEERROR     -3
#define DOORNOSTART       -4
#define DOORBLKCRCERR     -5
#define DOORBLKMISMATCH   -6
#define DOORBLKMINUS1     -7
#define DOORBLKFATAL      -8
#define DOORBLKEOF        -9

typedef unsigned short word;

#define DRSK_MAJVER 2
#define DRSK_MINVER 0

/* DOORSKEL.H, DOORSKEL's main include file */

#ifndef OS2
 #include <dos.h>

typedef struct {
  word      strsize;       /* size of the structure in bytes     */
  char      majver;        /* FOSSIL spec driver conforms to     */
  char      minver;        /* rev level of this specific driver  */
  char far *ident;         /* FAR pointer to ASCII ID string     */
  word      ibufr;         /* size of the input buffer (bytes)   */
  word      ifree;         /* number of bytes left in buffer     */
  word      obufr;         /* size of the output buffer (bytes)  */
  word      ofree;         /* number of bytes left in the buffer */
  char      swidth;        /* width of screen on this adapter    */
  char      sheight;       /* height of screen    "      "       */
  char      speed;         /* ACTUAL speed, computer to modem    */
} FOSSILINFO;

 /* portability junk.  lots and lots of portability junk. */

 #ifdef __TURBOC__

    #include <dir.h>
    #define _fastcall pascal
    #define _pascal   pascal
    #define _cdecl    cdecl
    #define FAR       far

    /*
     * note: for increased portability with Doorskel, use DoorGetDrive and
     * DoorSetDrive macros below instead of compiler-specific counterparts
     */

    #define DoorGetDrive()  getdisk()
    #define DoorSetDrive(x) setdisk((x) - 1)

 #else
    #include <direct.h>

    #define MAXDIR        133
    #define FAR           _far

    #define DoorGetDrive()  _getdrive()
    #define DoorSetDrive(x) {int temp;_dos_setdrive(x,&temp);}

    #define SH_DENYNONE   SH_DENYNO
    #define SH_DENYWRITE  SH_DENYWR
    #define SH_DENYREAD   SH_DENYRD

    #if !defined(MK_FP)
      #define MK_FP(seg,off) ((void FAR *)(((long)(seg) << 16) | (unsigned)(off)))
    #endif

 #endif

#else

 #define  INCL_DOSERRORS
 #define  INCL_DOS
 #define  INCL_VIO
 #include "os2.h"
 #include "direct.h"

  #ifndef MAXDIR
    #define MAXDIR 257
  #endif

    int  DoorGetDrive (void);
    void DoorSetDrive (int dr);

    #if !defined(MK_FP)
      #define MK_FP(seg,off) ((void FAR *)(((long)(seg) << 16) | (unsigned)(off)))
    #endif

#endif

/*************************************************/
/* Standardizing file finding so that it can     */
/* be used transparently under MS-DOS (TC & MSC) */
/* and OS/2                                      */
/*************************************************/

#ifdef OS2
  #define DOORFINDBUF FILEFINDBUF
  #define DoorFindClose(h) DosFindClose(h)
  /* these functions in findfile.c */
  int DoorFindFirst(int *h,char *spec,DOORFINDBUF *buf,int attr);
  int DoorFindNext(int h,DOORFINDBUF *buf);
#else
  #define HDIR_SYSTEM   0x0001  /* Use system handle (1)     */
  #define HDIR_CREATE   0xFFFF  /* Allocate a new, unused handle   */
  #define FILE_NORMAL     0x0000
  #define FILE_READONLY   0x0001
  #define FILE_HIDDEN     0x0002
  #define FILE_SYSTEM     0x0004
  #define FILE_DIRECTORY  0x0010
  #define FILE_ARCHIVED   0x0020
  typedef struct {
    unsigned int twosecs : 5;
    unsigned int minutes : 6;
    unsigned int hours   : 5;
  } FTIME;
  typedef struct {
    unsigned int day     : 5;
    unsigned int month   : 4;
    unsigned int year    : 7;
  } FDATE;
  typedef struct {
    char  reserved[21];
    char  attrFile;
    FTIME ftimeLastWrite;
    FDATE fdateLastWrite;
    long  cbFile;
    char  achName[13];
  } DOORFINDBUF;
 #ifdef __TURBOC__
  #define DoorFindFirst(h,spec,buf,attr) findfirst((spec),((struct ffblk *)buf),(attr))
  #define DoorFindNext(h,buf) findnext((struct ffblk *)buf)
  #define DoorFindClose(h)
 #else        /* MSC */
  #define DoorFindFirst(h,spec,buf,attr) _dos_findfirst((spec),(attr),((struct find_t *)buf))
  #define DoorFindNext(h,buf) _dos_findnext((struct find_t *)buf)
  #define DoorFindClose(h)
 #endif
#endif

/* standard include files */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <limits.h>
#include <io.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include <process.h>
#include <share.h>
#include <stdarg.h>
#include <stddef.h>
#include <conio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <setjmp.h>

/*****************************************************/
/* some hopefully helpful shortcut macros for best   */
/* portability, use these instead of the functions   */
/* they mask (like DoorFossilFuncs)                  */
/*****************************************************/

#define BACKSPACE       "\b \b"

#ifndef OS2
 #define DoorComCSendByte(x)  if(DoorGetBaudVar())while(!DoorFossilFuncs(TRANSMIT,(x)))DoorCheckCarrier()
 #define DoorComCNSendByte(x) while(!DoorFossilFuncs(TRANSMIT,(x)))DoorCheckCarrier()
 #define DoorComSendByte(x)   while(!DoorFossilFuncs(TRANSMIT,(x)))
 #define DoorComWriteByte(x)  DoorComSendByte(x)
 #define DoorComDTROn()       DoorFossilFuncs(DTR,UP)
 #define DoorComDTROff()      DoorFossilFuncs(DTR,DOWN)
 #define DoorComLDTROff()     DosSleep(1000L);DoorFossilFuncs(DTR,DOWN)
 #define DoorComIsByte()      ((DoorFossilFuncs(GETSTAT,0) & 1) ? 1 : 0)
 #define DoorComWatchOn()     (DoorFossilFuncs(WATCHDOG,1))
 #define DoorComWatchOff()    (DoorFossilFuncs(WATCHDOG,2))
 #define DoorInitComm()       (DoorFossilFuncs(INIT,0))
 #define DoorDeinitComm()     (DoorFossilFuncs(DEINIT,0))
 #define DoorComFlushOut()    (DoorFossilFuncs(FLUSHOUT,0))
 #define DoorComPurgeIn()     (DoorFossilFuncs(PURGEIN,0))
 #define DoorComPurgeOut()    (DoorFossilFuncs(PURGEOUT,0))
#else
 #define DoorComCSendByte(x)  if(DoorGetBaudVar())DoorComWriteByte(x);DoorCheckCarrier()
 #define DoorComCNSendByte(x) DoorComWriteByte(x);DoorCheckCarrier()
 #define DoorComSendByte(x)   DoorComWriteByte(x)
 #define DoorComDTROn()       DoorComDTR(1)
 #define DoorComDTROff()      DoorComDTR(0)
 #define DoorComLDTROff()     DosSleep(1000L);DoorComDTR(0)
 #define DoorComIsByte()      ((DoorComPeekByte(0L) != -1) ? 1 : 0)
 #define DoorComWatchOn()
 #define DoorComWatchOff()
 int DoorInitComm(void);
 void DoorDeinitComm(void);
#endif

#define DoorModemPuts(x)    if(DoorGetBaudVar())DoorComWriteBlk((x),strlen(x))
#define DoorRemoteBell()    if(DoorGetBaudVar())DoorComWriteByte('\07');else putchar('\07')
#define DoorMinsLeft()      (((long)DoorGetTimeOff() - DoorGetTime()) / 60L)
#define DoorANSISetPos(x,y) DoorPrintf("\x1b[%d;%dH",(y),(x))
#define DoorANSISavePos()   DoorPuts("\x1b[s")
#define DoorANSIRstrPos()   DoorPuts("\x1b[u")
#define DoorIsANSI()        (DoorGetGraphics()!=0)
#define DoorIsLocal()       (DoorGetBaudVar()==0)
#define DoorPrintGraphics(s) if(DoorGetGraphics())DoorPuts(s)
#define DoorPurgeInLocal()  while(kbhit()) getch()
#define DoorFlushOutLocal() DoorFlushVideo()

#ifndef OS2

 /*================================================================*/
 /* FOSSIL definitions (see function DoorFossilFuncs())            */
 /*================================================================*/

 #define SETBAUD    0
 #define TRANSWAIT  1
 #define RECVWAIT   2
 #define GETSTAT    3
 #define INIT       4
 #define DEINIT     5
 #define DTR        6
   #define UP         1
   #define DOWN       0
 #define FLUSHOUT   8
 #define PURGEOUT   9
 #define PURGEIN    10
 #define TRANSMIT   11
 #define PEEK       12
 #define KEYNOWAIT  13
 #define KEYWAIT    14
 #define FLOW       15
 #define ONOFF      16
   #define ON          0
   #define OFF         2
 #define SETCRSR    17
 #define READCRSR   18
 #define ONEANSI    19
   #define CARRIER    128
   #define INITOK     0x1954
 #define WATCHDOG   20
 #define REBOOT     23
   #define COLD        0
   #define WARM        1
 #define BLOCKREAD  24
 #define BLOCKWRITE 25

#endif

/***************************************************************************/
/* Symbols for DoorGenericInput()...                                       */
/***************************************************************************/

#define ALLL     1
#define ALPHA    2
#define NUM      3
#define ALPHANUM 4
#define YESNO    5
#define FLE      6
#define FLEP     7
#define FLEW     8
#define FLEPW    9
#define NAME     10
#define NEAT     11
#define PHONE    12
#define DATE     13
#define SUBJECT  14
#define YESNOM   15
#define ARROWS   16
#define FBATCH   17
#define FBATCHW  18
#define FBATCHWP 19
#define FBATCHP  20
#define HYPER    21
#define FLENX    64
#define YESNOQ   65

/**************************************************************************/
/*  Macros for implementing simple timers.  All timers use 1000ths of     */
/*  a second, but are only 'accurate' to one clock tick.  Typical example */
/*  of use (a one second timer):                                          */
/*                                                                        */
/*   clock_t t1;                                                          */
/*                                                                        */
/*   t1 = DoorTimerSet(1000L);                                            */
/*   while(!DoorTimeUp(t1)) {                                             */
/*      ...do something...                                                */
/*      DosSleep(1L);          // give up time slice; dumb                */
/*   }                                                                    */
/**************************************************************************/

#ifdef __TURBOC__
    #define CLOCKS_PER_SEC  CLK_TCK
#endif

 #define DoorTimerSet(tmt) (clock_t)((((clock_t)(tmt) * (clock_t)CLOCKS_PER_SEC) / 1000L) + clock())
 #define DoorTimeUp(tmt) (tmt < clock())
 #define DoorTimeLeft(tmt) ((tmt<=clock())?0L:(((tmt-clock())/(clock_t)CLOCKS_PER_SEC)*1000L))


/*******************************************************/
/* multitasker-cooperation functions in setmtask.c     */
/* and mtask.c                                         */
/*******************************************************/

#ifndef OS2
  void _fastcall DoorSetMtask (void);         /* called by DoorInit() */
  void _fastcall DoorZeroMtask(void);         /* disable timeslicing */
  void _fastcall DosSleep (clock_t millisecs); /* OS/2 provides this */
#else
  #define DoorZeroMtask()
  #define DoorSetMtask()
#endif


/***********************************/
/* functions in ansi.c (low-level) */
/***********************************/

/*
 * NOTE:  all screen output except for status line should go (ultimately)
 * through DoorANSIPuts().  see also DoorANSIPrintf() function.
 */
int  _fastcall DoorANSIPuts (char *buf);
void _fastcall DoorANSIPutc (char c);
void _fastcall DoorFlushVideo(void);
void _fastcall DoorZeroVideo(void);
void _fastcall DoorSetScreensize (int reservedlines);
void _fastcall DoorPutChar (char c,char attr,int x,int y);
void _fastcall DoorPosHardcursor (int x,int y);
 #define       DoorCursor(x,y) DoorPosHardcursor((x) - 1,(y) - 1)
void _fastcall DoorHardCursorOff (void);
void _fastcall DoorHardCursorOn (int x,int y);
void _fastcall DoorScrollUp (int tx,int ty,int bx,int by,char attr);
void _fastcall DoorClearWindow (int tx,int ty,int bx,int by,char attr);
void _fastcall DoorCleartoEOL (int x,int y,int ex,char attr);


/************************************/
/* functions in misc.c              */
/************************************/

char  * _fastcall DoorStripCR(char  *a);
char  * _fastcall DoorLStrip(char  *a);
char  * _fastcall DoorRStrip(char  *a);
void    _fastcall DoorBackup (int num);
 #define          DoorBackupString(s) DoorBackup(strlen(s) + 1)


/************************************/
/* functions in optional log.c      */
/************************************/

char *_cdecl DoorAddToLog(char *text,...);


/************************************/
/* functions in int.c           */
/************************************/

int   _fastcall       DoorInit(int argc,char **argv);
void  _fastcall       DoorPrintHelp(void);
long  _fastcall       DoorGetTime(void);
void  _fastcall       DoorPrintInfo(void);
void  _cdecl          DoorDeInitialize(void);
void  _fastcall       DoorPrintStat(void);
void  _cdecl          DoorBreakHandler (int sigl);


/************************************/
/* functions in input.c             */
/************************************/

int     _fastcall  DoorInkey(long millisecs);
int     _fastcall  DoorSpecialModemKey(int wuz);
int     _fastcall  DoorSpecialLocalKey(int wuz);
char *  _fastcall  DoorGenericInput(int length,int password,int caps,
                                    int hot,int type,char *prompt,
                                    char *buffer);
int     _fastcall  DoorCheckCarrier(void);
void    _fastcall  DoorHitReturn(void);


/************************************/
/* functions in chat.c              */
/************************************/

void _fastcall DoorCheapChat(void);
int  _fastcall DoorANSIChat(void);


/************************************/
/* functions in output.c            */
/************************************/

void  _fastcall  DoorCLS(void);
int   _cdecl     DoorPrintf(char *string,...);
void  _cdecl     DoorANSIPrintf(char *string,...);
void  _cdecl     DoorDebugPrintf(char *string,...);
int   _fastcall  DoorPuts(char *text);
int   _fastcall  DoorDirectPuts(int x,int y,char attr,char *str);
int   _cdecl     DoorDirectPrintf(int x,int y,char attr,char *str,...);
/* macros to make it easy to define colors for DoorDirectPuts/DoorDirectPrintf attr */
 #define DoorMakeColor(fg,bg) ((fg & 15) | ((bg & 7) << 4))
 #define DoorClr(bg,fg,in) ((fg) | (bg << 4) | (in))


/************************************/
/* functions in optional help.c     */
/************************************/

void _fastcall DoorLoadHelp (char *helpfilename);
void _fastcall DoorSetHelp (char *topic);
void _fastcall DoorHelp (void);


/************************************/
/* functions in optional fansansi.c */
/************************************/

int _fastcall DoorANSIMenu2 (char tcolor,char color,char *title,
                              char *lineorig,char **variable,int direct);
int _fastcall DoorANSIMenu (char color, char *lineorig);


/************************************/
/* functions in optional select1.c  */
/************************************/

int _fastcall  DoorSelectOne (char **selections,int numselecs,char *prompt,
                              unsigned int flags);
int _fastcall  DoorTopMenu (char **selections,int numselects);


/************************************/
/* functions in optional reader.c   */
/************************************/

int _fastcall DoorReadText(char *,int);


/************************************/
/* functions in optional dorinfo.c  */
/************************************/

int _fastcall DoorReadDorInfo(void);


/************************************/
/* functions in optional modem.c    */
/************************************/

int    _fastcall DoorDialTrans (char *str);
char * _fastcall DoorGetModemString (clock_t timer);
int    _fastcall DoorSetBaudRate (unsigned int baud,char parity,
                                  int databits,int stopbits);
int    _fastcall DoorDetectANSI (void);


/************************************/
/* functions in fsopen.c						*/
/************************************/
FILE * _fastcall DoorFsopen (char *filename,char *mode,int sharemode);
char * _fastcall DoorStristr (char *t, char *s);


/************************************/
/* functions in makeansi.c					*/
/************************************/

char * _fastcall DoorMakeANSI (int avacode,char *buf);
 #define DoorMakeANSIIf(a,b) ((DoorGetGraphics())?DoorMakeANSI((a),(b)):"\0")


/************************************/
/* functions in system.c            */
/************************************/

long  _fastcall DoorFreeSpace (char *path);
void  _fastcall DoorSetFDate (char *name,long tim);
char* _fastcall DoorStrTime(time_t t,char *s);
char* _fastcall DoorStrDate(time_t t,char *s);
void  _fastcall DoorReadScreenLine(int x,char *s);
void  _fastcall DoorReadScreen(int *s);
void  _fastcall DoorWriteScreen(int *s);
void  _fastcall DoorCurrCursor(int  *x,int  *y);
int   _fastcall DoorWhereX(void);
int   _fastcall DoorWhereY(void);
int   _fastcall DoorSpawn(unsigned char  *strr);
int   _fastcall DoorComReadByte (long msecs);
int   _fastcall DoorComOnLine (void);
int   _fastcall DoorComWriteBlk (char *buf,int len);
int   _fastcall DoorComPeekByte (long msecs);
int   _fastcall DoorComReadBlk (char *buf,int len,long msecs);
 #define DoorComOutEmpty() (DoorComOutWaiting() == 0)
int  _fastcall DoorComOutWaiting (void);
 #define DoorComInEmpty() (DoorComInWaiting() == 0)
int  _fastcall DoorComInWaiting (void);
#ifndef OS2
 int   _fastcall DoorComReceive (char *buf,int len);
#else
 #define DoorComReceive(buf,len) DoorComReadBlk((buf),(len),0L)
#endif
char * _fastcall DoorSearchPath(char *filename);
#ifdef OS2
 /* OS/2-specific comm support */
 int  _fastcall DoorComWriteByte (char x);
 void _fastcall DoorComDTR (int which);
 void _fastcall DoorComPurgeIn (void);
 void _fastcall DoorComPurgeOut (void);
 void _fastcall DoorComFlushOut (void);
#else
 /* MS-DOS-specific comm support */
 char _fastcall DoorFossilFuncs(char function,
                                char arg);
#endif


/***************************************/
/* global variable declarations        */
/***************************************/

#ifdef DEFINEDRSKGLOBALS

  int    DoorDebugMode              = 0;
  int    DoorGraphics               = 0;
  time_t DoorTimeOff;
  word   DoorBaud                   = 0;
  int    DoorLength                 = 24;
  word   DoorSecLevel               = 5;
  int    DoorSysopIn                = 0;
  word   DoorCommHandle             = (word)-1;
  char   DoorLogFile[133]           = "XBBS.LOG";
  char   DoorUserName[36]           = "A. Ghost";
  int    DoorWidth                  = 80;
  int    DoorChatting               = 0;
  int    DoorChatted                = 0;
  int    DoorNodeNumber             = 1;
  char   DoorSystemName[64]         = "";
  char   DoorSysOp[36]              = "";
  char   DoorCurAttr                = 7;
  int    DoorCurx                   = 0,
         DoorCury                   = 0;
  int    DoorMaxx                   = 80,
         DoorMaxy                   = 25;  /* size of ansi output window */
  int    DoorRealMaxy,DoorRealMaxx;        /* real screen size */
  char   DoorUseANSI                = 1;   /* while true, interp ansi seqs */
  int    DoorTabSpaces              = 8;
  int    DoorUseBIOS                = 0;
  word  *DoorLVB;
  word   DoorLVBMin,DoorLVBMax,DoorLVBLen;
#ifdef OS2
  int    DoorVidHandle              = 0;
#endif
  char  *DoorProgramName            = "A DoorSkel Door";
  char  *DoorCopyRight              = "Door Driver Library copyright (c) 1993 by M. Kimes";
  int    DoorDorInfo                = 0;
  int    DoorNumStatLines           = 1;
#ifndef OS2
  void  (*DoorPauseMtask)(void);     /* fp -- give up time slice */
#endif
  void  (*DoorOutOfTime)(void)      = NULL;  /* fp -- called if time runs out */
  void  (*DoorTimedOut)(void)       = NULL;  /* fp -- called if idle timeout */
  void  (*DoorLostCarrier)(void)    = NULL;  /* fp -- called if carrier lost */
  void  (*DoorExtraHelp)(void)      = NULL;  /* fp -- called if cl request 4 help */
  void  (*DoorExtraStatLine)(void)  = NULL;  /* fp -- called to display more stats */
  int   (*DoorExtraArgs)(char *)    = NULL;  /* fp -- called w/ unknown cl args */
  void  (*DoorFunctionKey[10])(void) =       /* fp -- called if Fkey pressed and set */
        {NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
#else

  extern int    DoorDebugMode;
  extern int    DoorGraphics;
  extern time_t DoorTimeOff;
  extern word   DoorBaud;
  extern int    DoorLength;
  extern word   DoorSecLevel;
  extern int    DoorSysopIn;
  extern word   DoorCommHandle;
  extern char   DoorLogFile[133];
  extern char   DoorUserName[36];
  extern int    DoorWidth;
  extern int    DoorChatting;
  extern int    DoorChatted;
  extern int    DoorNodeNumber;
  extern char   DoorSystemName[64];
  extern char   DoorSysOp[36];
  extern int    DoorMaxx,DoorMaxy;
  extern int    DoorRealMaxx,DoorRealMaxy;
  extern int    DoorUseBIOS;
  extern word  *DoorLVB;
  extern word  DoorLVBMin,DoorLVBMax,DoorLVBLen;
  #ifdef OS2
   extern int   DoorVidHandle;
  #endif
  extern int    DoorUseANSI;
  extern int    DoorTabSpaces;
  extern char   DoorCurAttr;
  extern int    DoorCurx,DoorCury;
  extern int    DoorNumStatLines;
  extern char  *DoorProgramName;
  extern char  *DoorCopyRight;
  extern int    DoorDorInfo;
  extern void (*DoorPauseMtask)(void);
  extern void (*DoorOutOfTime)(void);
  extern void (*DoorTimedOut)(void);
  extern void (*DoorLostCarrier)(void);
  extern void (*DoorExtraHelp)(void);
  extern void (*DoorExtraStatLine)(void);
  extern int  (*DoorExtraArgs)(char *);
  extern void (*DoorFunctionKey[10])(int);
#endif

/*********************************************/
/* macros for providing an API-like way to   */
/* manipulate Doorskel's global variables    */
/* USE THESE MACROS.  It will allow Doorskel */
/* to change the way these variables are     */
/* used in the future without breaking your  */
/* code.                                     */
/*********************************************/

 #define DoorSetTimeOff(x)        (DoorTimeOff=(x))
 #define DoorSetProgramName(x)    if((char *)x)DoorProgramName=(x)
 #define DoorSetCopyRight(x)      if((char *)x)DoorCopyRight=(x)
 #define DoorSetNumStatLines(x)   if((x) > 0 && (x) < 7)DoorNumStatLines=(x)
 #define DoorSetOutOfTime(x)      if(x)DoorOutOfTime=(x)
 #define DoorSetTimedOut(x)       if(x)DoorTimedOut=(x)
 #define DoorSetLostCarrier(x)    if(x)DoorLostCarrier=(x)
 #define DoorSetExtraHelp(x)      if(x)DoorExtraHelp=(x)
 #define DoorSetExtraStatLine(x)  if(x)DoorExtraStatLine=(x)
 #define DoorSetExtraArgs(x)      if(x)DoorExtraArgs=(x)
 #define DoorSetFunctionKey(k,x)  if((k) > 0 && (k)<11&&(x))DoorFunctionKey[k-1]=(x)
 #define DoorSetGraphics(x)       (DoorGraphics=((x)!=0)?1:0)
 #define DoorSetBaudVar(x)        (DoorBaud=(x))
 #define DoorSetLength(x)         if((x)>15&&(x)<101)DoorLength=(x)
 #define DoorSetSecLevel(x)       (DoorSecLevel=(x))
 #define DoorSetSysopIn(x)        (DoorSysopIn=((x)!=0)?1:0)
 #define DoorSetLogFile(x)        if((char *)(x))strcpy(DoorLogFile,x)
 #define DoorSetUserName(x)       if((char *)(x))strncpy(DoorUserName,x,35);DoorUserName[35]=0
 #define DoorSetWidth(x)          if((x)>31&&(x)<133)DoorWidth=(x)
 #define DoorSetNodeNumber(x)     (DoorNodeNumber=(x))
#ifndef OS2
 #define DoorSetUseBIOS(x)        (DoorUseBIOS=((x)!=0)?1:0)
#else
 #define DoorSetUseBIOS(x)        (x)
#endif
 #define DoorSetUseANSI(x)        (DoorUseANSI=((x)!=0)?1:0)
 #define DoorSetTabSpaces(x)      (DoorTabSpaces=(x))
 #define DoorUseDorInfo()         (DoorDorInfo=1)
#ifdef OS2
 #define DoorSetVidHandle(x)      (DoorVidHandle=(x))
#else
 #define DoorSetVidHandle(x)      (x)
#endif
 #define DoorSetSystemName(x)     if((char *)(x))strncpy(DoorSystemName,x,63);DoorSystemName[63]=0
 #define DoorSetSysopName(x)      if((char *)(x))strncpy(DoorSysOp,x,35);DoorSysOp[35]=0
 #define DoorSetDebugMode(x)      (DoorDebugMode=(x))
 #define DoorSetMaxx(x)           (DoorMaxx=(x))
 #define DoorSetMaxy(x)           (DoorMaxy=(x))
 #define DoorSetRealMaxx(x)       (DoorRealMaxx=(x))
 #define DoorSetRealMaxy(x)       (DoorRealMaxy=(x))
 #define DoorSetCommHandle(x)     (DoorCommHandle=(x))
 #define DoorSetCurx(x)           (DoorCurx=(x))
 #define DoorSetCury(x)           (DoorCury=(x))
 #define DoorSetCurAttr(x)        (DoorCurAttr=(x))
 #define DoorSetLVB(x)            (DoorLVB=(x))
 #define DoorSetLVBLen(x)         (DoorLVBLen=(x))
 #define DoorSetLVBMin(x)         (DoorLVBMin=(x))
 #define DoorSetLVBMax(x)         (DoorLVBMax=(x))

 #define DoorGetProgramName()     (DoorProgramName)
 #define DoorGetCopyRight()       (DoorCopyRight)
 #define DoorGetNumStatLines()    (DoorNumStatLines)
 #define DoorGetOutOfTime()       (DoorOutOfTime)
 #define DoorGetTimedOut()        (DoorTimedOut)
 #define DoorGetLostCarrier()     (DoorLostCarrier)
 #define DoorGetExtraHelp()       (DoorExtraHelp)
 #define DoorGetExtraStatLine()   (DoorExtraStatLine)
 #define DoorGetExtraArgs()       (DoorExtraArgs)
 #define DoorGetFunctionKey(k)    (((k)>0&&(k)<11)?(DoorFunctionKey[k-1]):NULL)
 #define DoorGetGraphics()        (DoorGraphics)
 #define DoorGetBaudVar()         (DoorBaud)
 #define DoorGetLength()          (DoorLength)
 #define DoorGetSecLevel()        (DoorSecLevel)
 #define DoorGetSysopIn()         (DoorSysopIn)
 #define DoorGetLogFile()         (DoorLogFile)
 #define DoorGetUserName()        (DoorUserName)
 #define DoorGetWidth()           (DoorWidth)
 #define DoorGetNodeNumber()      (DoorNodeNumber)
#ifndef OS2
 #define DoorGetUseBIOS()         (DoorUseBIOS)
#else
 #define DoorGetUseBIOS()         (0)
#endif
 #define DoorGetUseANSI()         (DoorUseANSI)
 #define DoorGetTabSpaces()       (DoorTabSpaces)
 #define DoorDontUseDorInfo()     (DoorDorInfo=0)
#ifdef OS2
 #define DoorGetVidHandle()       (DoorVidHandle)
#else
 #define DoorGetVidHandle()       (0)
#endif
 #define DoorGetSystemName()      (DoorSystemName)
 #define DoorGetSysopName()       (DoorSysOp)
 #define DoorGetDebugMode()       (DoorDebugMode)
 #define DoorGetDorInfo()         (DoorDorInfo)
 #define DoorGetMaxx()            (DoorMaxx)
 #define DoorGetMaxy()            (DoorMaxy)
 #define DoorGetRealMaxx()        (DoorRealMaxx)
 #define DoorGetRealMaxy()        (DoorRealMaxy)
 #define DoorGetCommHandle()      (DoorCommHandle)
 #define DoorGetTimeOff()         (DoorTimeOff)
 #define DoorToggleGraphics()     (DoorGraphics=(DoorGraphics)?0:1)
 #define DoorGetCurx()            (DoorCurx)
 #define DoorGetCury()            (DoorCury)
 #define DoorGetCurAttr()         (DoorCurAttr)
 #define DoorGetLVB()             (DoorLVB)
 #define DoorGetLVBLen()          (DoorLVBLen)
 #define DoorGetLVBMin()          (DoorLVBMin)
 #define DoorGetLVBMax()          (DoorLVBMax)

/* END OF FILE: doorskel.h */
